% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manual.R
\name{remove_trim_failures}
\alias{remove_trim_failures}
\title{Remove automatic trim failures from a list of trimmed dp objects
and return only non-failed trimmed objects}
\usage{
remove_trim_failures(dp.trimmed)
}
\arguments{
\item{dp.trimmed}{A list of trimmed dp objects, a result of
calling dtriml or dtriml_s on a dp list with
"return.fail = FALSE".}
}
\value{
A dp list of trimmed objects with failures removed.
}
\description{
Returns a dp list of trimmed dp objects without the failed trim
objects. Trimmed dp list should be a result of either calling
dtriml on a list of dp objects or calling dtriml_s to remove the
starting portions of the measurement. Both functions should be
called with the option "return.fail = FALSE", which embeds a
trimming report when returning the list of trimmed dp objects.
}
\examples{
\donttest{
## load several dp files
dp.list <- dpload(dp.directory = system.file("extdata", package = "densitr"))
## trim the measurements
dp.trimmed <- dptriml(dp.list, rreport = TRUE)
## remove trimming failures
dp.nofailures <- remove_trim_failures(dp.trimmed)
}
}
\seealso{
dptriml, dptriml_s
}
