
# 
# Ingmar Visser, 11-6-2008
# 

# Changes
# - added lin.upper and lin.lower slots to these objects

# 
# MIX.FITTED CLASS
# 

setClass("mix.fitted",
	representation(message="character", # convergence information
		conMat="matrix", # constraint matrix on the parameters for general linear constraints
		lin.upper="numeric", # upper bounds for linear constraint
		lin.lower="numeric", # lower bounds for linear constraints
		posterior="data.frame" # posterior probabilities for the states
	),
	contains="mix"
)

# accessor functions

setMethod("posterior","mix.fitted",
	function(object) {
		return(object@posterior)
	}
)

setMethod("show","mix.fitted",
	function(object) {
		cat("Convergence info:",object@message,"\n")
		print(logLik(object))
		cat("AIC: ", AIC(object),"\n")
		cat("BIC: ", BIC(object),"\n")
	}
)

setMethod("summary","mix.fitted",
	function(object,which="all") {
		ans=switch(which,
			"all" = 1,
			"response" = 2,
			"prior" = 3,
			stop("Invalid 'which' argument in summary of fitted mix model")
		)
		if(ans==1|ans==3) {
			cat("Mixture probabilities model \n")
			print(object@prior)
			cat("\n")
		}
		if(ans==1|ans==2) {
			for(i in 1:object@nstates) {
				cat("Response model(s) for state", i,"\n\n")
				for(j in 1:object@nresp) {
					cat("Response model for response",j,"\n")
					print(object@response[[i]][[j]])
					cat("\n")
				}
				cat("\n")
			}
		}
	}	
)

# 
# Ingmar Visser, 23-3-2008
# 

# 
# DEPMIX.FITTED CLASS
# 

setClass("depmix.fitted",
	representation(message="character", # convergence information
		conMat="matrix", # constraint matrix on the parameters for general linear constraints
		lin.upper="numeric", # upper bounds for linear constraints
		lin.lower="numeric", # lower bounds for linear constraints
		posterior="data.frame" # posterior probabilities for the states
	),
	contains="depmix"
)

# accessor functions

setMethod("posterior","depmix.fitted",
	function(object) {
		return(object@posterior)
	}
)

setMethod("show","depmix.fitted",
	function(object) {
		cat("Convergence info:",object@message,"\n")
		print(logLik(object))
		cat("AIC: ", AIC(object),"\n")
		cat("BIC: ", BIC(object),"\n")
	}
)

setMethod("summary","depmix.fitted",
	function(object,which="all") {
		ans=switch(which,
			"all" = 1,
			"response" = 2,
			"prior" = 3,
			"transition" = 4,
			stop("Invalid 'which' argument in summary of fitted depmix model")
		)
		if(ans==1|ans==3) {
			cat("Initial state probabilties model \n")
			print(object@prior)
			cat("\n")
		}
		if(ans==1|ans==4) {
			for(i in 1:object@nstates) {
				cat("Transition model for state (component)", i,"\n")
				print(object@transition[[i]])
				cat("\n")
			}
			cat("\n")
		}
		if(ans==1|ans==2) {
			for(i in 1:object@nstates) {
				cat("Response model(s) for state", i,"\n\n")
				for(j in 1:object@nresp) {
					cat("Response model for response",j,"\n")
					print(object@response[[i]][[j]])
					cat("\n")
				}
				cat("\n")
			}
		}
	}
)


