% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist-binomial.R
\name{dist_binom_plot}
\alias{dist_binom_plot}
\alias{binom_plot}
\alias{dist_binom_prob}
\alias{binom_prob}
\alias{dist_binom_perc}
\alias{binom_perc}
\title{Visualize Binomial Distribution}
\usage{
dist_binom_plot(n, p)

dist_binom_prob(n, p, s, type = c("lower", "upper", "exact", "interval"))

dist_binom_perc(n, p, tp, type = c("lower", "upper"))
}
\arguments{
\item{n}{number of trials}

\item{p}{aggregate probability}

\item{s}{number of success}

\item{type}{lower/upper/exact/interval}

\item{tp}{the probability of success in a trial}
}
\value{
a list containing the following components:

\item{avg}{mean of the binomial distribution}
\item{stdev}{standard deviation of the binomial distribution}
\item{prob}{probability of s success}
}
\description{
Visualize how changes in number of trials and the probability of
success affect the shape of the binomial distribution. compute\/visualize
probability from a given quantile and quantiles out of given probability.
}
\section{Deprecated Functions}{

\code{binom_plot()}, \code{binom_prob()}, \code{binom_perc()} have been
deprecated. Instead use \code{dist_binom_plot()},
\code{dist_binom_prob()} and \code{dist_binom_perc()}
}

\examples{
# visualize binomial distribution
dist_binom_plot(10, 0.3)

# compute\\/visualize probability from a given quantile
dist_binom_prob(10, 0.3, 4, type = 'exact')
dist_binom_prob(10, 0.3, 4, type = 'lower')
dist_binom_prob(10, 0.3, 4, type = 'upper')
dist_binom_prob(10, 0.3, c(4, 6), type = 'interval')

# compute\\/visualize quantiles out of given probability
dist_binom_perc(10, 0.5, 0.05)
dist_binom_perc(10, 0.5, 0.05, "upper")
}
\seealso{
\code{\link[stats]{Binomial}}
}
