% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds-cross-table.R
\name{ds_cross_table}
\alias{ds_cross_table}
\alias{cross_table}
\alias{plot.ds_cross_table}
\alias{mosaicplot.ds_cross_table}
\title{Two Way Tables}
\usage{
ds_cross_table(var1, var2)

\method{plot}{ds_cross_table}(x, beside = FALSE, proportional = FALSE, ...)

\method{mosaicplot}{ds_cross_table}(x, ...)
}
\arguments{
\item{var1}{First categorical variable}

\item{var2}{Second categorical variable}

\item{x}{An object of class cross_table}

\item{beside}{a logical value. If FALSE, the columns of height are portrayed
as stacked bars, and if TRUE the columns are portrayed as juxtaposed bars.}

\item{proportional}{a logical value. If TRUE, the height of the bars is
proportional}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
\code{ds_cross_table} returns an object of class \code{"ds_cross_table"}.
An object of class \code{"ds_cross_table"} is a list containing at least the
following components:

\item{obs}{obs number of observations}
\item{var2_levels}{levels of the second categorical variable}
\item{var1_levels}{levels of the first categorical variable}
\item{varnames}{names of the variables}
\item{twowaytable}{table of the variables}
\item{percent_table}{table of percentages}
\item{row_percent}{table of row percentages}
\item{col_percent}{table of column percentages}
\item{column_totals}{total of columns}
\item{percent_column}{total of columns as a percentage}
}
\description{
\code{ds_cross_tablecross_table} creates two way tables of categorical
variables. The tables created can be visualized as barplots and mosaicplots.
}
\section{Deprecated Function}{

\code{ds_cross_table()} has been deprecated. Instead use \code{ds_cross_table()}.
}

\examples{
k <- ds_cross_table(mtcars$cyl, mtcars$am)
k

# bar plots
plot(k)
plot(k, beside = TRUE)
plot(k, proportional = TRUE)

# mosaic plots
mosaicplot(k)
}
