% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds-cross-table.R
\name{ds_cross_table}
\alias{ds_cross_table}
\alias{cross_table}
\alias{plot.ds_cross_table}
\alias{ds_twoway_table}
\title{Two way table}
\usage{
ds_cross_table(data, var1, var2)

\method{plot}{ds_cross_table}(x, stacked = FALSE, proportional = FALSE, ...)

ds_twoway_table(data, var1, var2)
}
\arguments{
\item{data}{A \code{data.frame} or a \code{tibble}.}

\item{var1}{First categorical variable.}

\item{var2}{Second categorical variable.}

\item{x}{An object of class \code{cross_table}.}

\item{stacked}{If \code{FALSE}, the columns of height are portrayed
as stacked bars, and if \code{TRUE} the columns are portrayed as juxtaposed bars.}

\item{proportional}{If \code{TRUE}, the height of the bars is proportional.}

\item{...}{Further arguments to be passed to or from methods.}
}
\description{
Creates two way tables of categorical variables. The tables created can be
visualized as barplots and mosaicplots.
}
\section{Deprecated function}{

\code{ds_cross_table()} has been deprecated. Instead use
\code{ds_cross_table()}.
}

\examples{
k <- ds_cross_table(mtcarz, cyl, gear)
k

# bar plots
plot(k)
plot(k, stacked = TRUE)
plot(k, proportional = TRUE)

# alternate
ds_twoway_table(mtcarz, cyl, gear)

}
