\name{ar1sim}
\alias{ar1sim}
\title{Simulate AR(1) Process}
\usage{
ar1sim(n = 50, rho, u0 = 0, var.e = 1, details = FALSE, seed = NULL)
}
\arguments{
\item{n}{number of observations to be simulated.}

\item{rho}{true rho value of the AR(1) process to be simulated.}

\item{u0}{start value of the process in t = 0.}

\item{var.e}{variance of the random error. If zero, no random error is added.}

\item{details}{logical value indicating whether details should be printed.}

\item{seed}{optionally set a custom random seed for reproducing results.}
}
\value{
A list object including:
\tabular{ll}{
\code{u.sim} \tab vector of simulated AR(1) values.\cr
\code{n} \tab total number of simulated AR(1) values.\cr
\code{rho} \tab true rho value of AR(1) process.\cr
\code{e.sim} \tab normal errors in AR(1) process.\cr
}
}
\description{
Simulates an autoregressive process of order 1.
}
\note{
Objects generated by \code{ar1sim()} can be plotted using the regular \code{plot()} command.

\code{plot.what = "time"} plots simulated AR(1) values over time. Available options are

\tabular{ll}{
\code{...} \tab other arguments that \code{plot()} understands.\cr
}

\code{plot.what = "lag"} plots simulated AR(1) values over its lagged values. Available options are

\tabular{ll}{
\code{true.line} \tab logical value (default: TRUE). Should the true line be plotted?\cr
\code{acc.line} \tab logical value (default: FALSE). Should the autocorrelation coefficient line be plotted?\cr
\code{ols.line} \tab logical value (default: FALSE). Should the ols regression line be plotted?\cr
\code{...} \tab other arguments that \code{plot()} understands.\cr
}
}
\examples{
## Generate 30 positively autocorrelated errors
my.ar1 <- ar1sim(n = 30, rho = 0.9, var.e = 0.1, seed = 511)
my.ar1
plot(my.ar1$u.sim, type = 'l')

## Illustrate the effect of Rho on the AR(1)
set.seed(12)
parOrg = par(c("mfrow", "mar"))
par(mfrow = c(2,4), mar = c(1,1,1,1))
rhovalues <- c(0.1, 0.5, 0.8, 0.99)
for (i in c(0, 0.3)){
  for (rho in rhovalues){
    u.data <- ar1sim(n = 20, u0 = 2, rho = rho, var.e = i)
    plot(u.data$u.sim, plot.what = "lag", cex.legend = 0.7, xlim = c(-2.5,2.5), ylim = c(-2.5,2.5),
         acc.line = TRUE, ols.line = TRUE)
  }
}
par(mfrow = parOrg$"mfrow", mar = parOrg$"mar")

## Illustrate the effect of Rho on the (non-)stationarity of the AR(1)
set.seed(1324)
parOrg = par(c("mfrow", "mar"))
par(mfrow = c(2, 4), mar = c(1,1,1,1))
for (rho in c(0.1, 0.9, 1, 1.04, -0.1, -0.9, -1, -1.04)){
  u.data <- ar1sim(n = 25, u0 = 5, rho = rho, var.e = 0)
  plot(u.data$u.sim, plot.what = "time", ylim = c(-8,8))
}
par(mfrow = parOrg$"mfrow", mar = parOrg$"mar")

}
\concept{AR1 process}
\concept{autocorrelated errors}
\concept{simulation}
