% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stats.R
\name{tableRuns}
\alias{tableRuns}
\title{Function to retrieve most common runs in the population}
\usage{
tableRuns(runs = NULL, SnpInRuns = NULL, genotypeFile, mapFile,
  threshold = 0.5)
}
\arguments{
\item{runs}{R object (dataframe) with results on detected runs}

\item{SnpInRuns}{dataframe with the proportion of times each SNP falls inside a
run in the population (output from \code{snpInsideRuns})}

\item{genotypeFile}{Plink ped file (for SNP position)}

\item{mapFile}{Plink map file (for SNP position)}

\item{threshold}{value from 0 to 1 (default 0.7) that controls the desired
proportion of individuals carrying that run (e.g. 70\%)}
}
\value{
A dataframe with the most common runs detected in the sampled individuals
(the group/population, start and end position of the run, chromosome and number of SNP
included in the run are reported in the output dataframe)
}
\description{
This function takes in input either the run results or the output from
the function \code{snpInsideRuns} (proportion of times a SNP is inside a run)
in the population/group, and returns a subset of the runs most commonly
found in the group/population. The parameter \code{threshold} controls the definition
of most common (e.g. in at least 50\%, 70\% etc. of the sampled individuals)
}
\examples{
# getting map and ped paths
genotypeFile <- system.file("extdata", "Kijas2016_Sheep_subset.ped", package = "detectRUNS")
mapFile <- system.file("extdata", "Kijas2016_Sheep_subset.map", package = "detectRUNS")

# calculating runs of Homozygosity
\dontrun{
# skipping runs calculation
runs <- slidingRUNS.run(genotypeFile, mapFile, windowSize = 15, threshold = 0.1,  minSNP = 15,
ROHet = FALSE,  maxOppositeGenotype = 1, maxMiss = 1,  minLengthBps = 100000,  minDensity = 1/10000)
}
# loading pre-calculated data
runsFile <- system.file("extdata", "Kijas2016_Sheep_subset.sliding.csv", package="detectRUNS")
runsDF = readExternalRuns(inputFile = runsFile, program = 'detectRUNS')

tableRuns(runs = runsDF, genotypeFile = genotypeFile, mapFile = mapFile, threshold = 0.5)

}
