% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{taylor_81}
\alias{taylor_81}
\title{Taylor equation of development rate as a function of temperature.}
\format{A list of eight elements describing the equation.
\describe{
  \item{eq}{The equation (formula object).}
  \item{eqAlt}{The equation (string).}
  \item{name}{The name of the equation.}
  \item{ref}{The equation reference.}
  \item{refShort}{The equation reference shortened.}
  \item{startVal}{The parameters found in the literature with their references.}
  \item{com}{An optional comment about the equation use.}
  \item{id}{An id to identify the equation.}
}}
\source{
\url{http://www.jstor.org/stable/2460694}
}
\usage{
taylor_81
}
\description{
Taylor, F. (1981) Ecology and evolution of physiological time in insects.
American Naturalist, 1-23.
Lamb, RJ. (1992) Developmental rate of Acyrthosiphon pisum (Homoptera: Aphididae) at low
temperatures: implications for estimating rate parameters for insects.
Environmental Entomology 21(1): 10-19.
}
\details{
Equation:
\deqn{rT = Rm * e^{-\frac{1}{2} * (\frac{T - Tm}{To})^{2}}}{%
      rT = Rm * exp(-1/2 * ((T - Tm)/To)^2)}

where rT is the development rate, T the temperature, Rm the maximum
development rate, Tm the optimum temperature, and To the rate at which development
rate falls away from Tm.
}
\keyword{datasets}
