% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.r
\name{check}
\alias{check}
\alias{check_built}
\title{Build and check a package, cleaning up automatically on success.}
\usage{
check(pkg = ".", document = TRUE, build_args = NULL, ...,
  manual = FALSE, cran = TRUE, check_version = FALSE,
  force_suggests = FALSE, run_dont_test = FALSE, args = NULL,
  env_vars = NULL, quiet = FALSE, check_dir = tempdir(), cleanup = TRUE)

check_built(path = NULL, cran = TRUE, check_version = FALSE,
  force_suggests = FALSE, run_dont_test = FALSE, manual = FALSE,
  args = NULL, env_vars = NULL, check_dir = tempdir(), quiet = FALSE)
}
\arguments{
\item{pkg}{package description, can be path or package name.  See
\code{\link{as.package}} for more information}

\item{document}{if \code{TRUE} (the default), will update and check
documentation before running formal check.}

\item{build_args}{Additional arguments passed to \code{R CMD build}}

\item{...}{Additional arguments passed on to \code{\link{build}()}.}

\item{manual}{If \code{FALSE}, don't build and check manual
(\code{--no-manual}).}

\item{cran}{if \code{TRUE} (the default), check using the same settings as
CRAN uses.}

\item{check_version}{Sets \code{_R_CHECK_CRAN_INCOMING_} env var.
If \code{TRUE}, performns a number of checked related
to version numbers of packages on CRAN.}

\item{force_suggests}{Sets \code{_R_CHECK_FORCE_SUGGESTS_}. If
\code{FALSE} (the default), check will proceed even if all suggested
packages aren't found.}

\item{run_dont_test}{Sets \code{--run-donttest} so that tests surrounded in
\code{\\dontest\{\}} are also tested. This is important for CRAN
submission.}

\item{args}{Additional arguments passed to \code{R CMD check}}

\item{env_vars}{Environment variables set during \code{R CMD check}}

\item{quiet}{if \code{TRUE} suppresses output from this function.}

\item{check_dir}{the directory in which the package is checked}

\item{cleanup}{Deprecated.}

\item{path}{Path to built package.}
}
\value{
An object containing errors, warnings, and notes.
}
\description{
\code{check} automatically builds and checks a source package, using all
known best practices. \code{check_built} checks an already built package.
}
\details{
Passing \code{R CMD check} is essential if you want to submit your package
to CRAN: you must not have any ERRORs or WARNINGs, and you want to ensure
that there are as few NOTEs as possible.  If you are not submitting to CRAN,
at least ensure that there are no ERRORs or WARNINGs: these typically
represent serious problems.

\code{check} automatically builds a package before calling \code{check_built}
as this is the recommended way to check packages.  Note that this process
runs in an independent realisation of R, so nothing in your current
workspace will affect the process.
}
\section{Environment variables}{


Devtools does its best to set up an environment that combines best practices
with how check works on CRAN. This includes:

\itemize{

 \item The standard environment variables set by devtools:
   \code{\link{r_env_vars}}. Of particular note for package tests is the
   \code{NOT_CRAN} env var which lets you know that your tests are not
   running on cran, and hence can take a reasonable amount of time.

 \item Debugging flags for the compiler, set by
   \code{\link{compiler_flags}(FALSE)}.

 \item If \code{aspell} is found \code{_R_CHECK_CRAN_INCOMING_USE_ASPELL_}
  is set to \code{TRUE}. If no spell checker is installed, a warning is
  issued.)

 \item env vars set by arguments \code{check_version} and
   \code{force_suggests}
}
}
\seealso{
\code{\link{release}} if you want to send the checked package to
  CRAN.
}

