% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_replace.R
\name{z_replace}
\alias{z_replace}
\title{Replaces \code{NA} values in tables}
\usage{
z_replace(data, replacement_alt = NULL, exclude_columns = NULL)
}
\arguments{
\item{data}{name of the table that you want to replace NA values in}

\item{replacement_alt}{optional - if you want the NA replacement
value to be different to "z"}

\item{exclude_columns}{optional - additional columns to exclude from
NA replacement.
Column names that match ones found in \code{dfeR::geog_time_identifiers}
will always be excluded because any missing data for these columns
need more explicit codes to explain why data is not available.}
}
\value{
table with "z" or an alternate replacement value instead of \code{NA}
values for columns that are not for time or geography.
}
\description{
Replaces \code{NA} values in tables except for ones in time and geography
columns that must be included in DfE official statistics.
\href{https://www.shorturl.at/chy76}{Guidance on our Open Data Standards.}
}
\details{
Names of geography and time columns that are used in this function can be
found in \code{dfeR::geog_time_identifiers}.
}
\examples{
# Create a table for the example

df <- data.frame(
  time_period = c(2022, 2022, 2022),
  time_identifier = c("Calendar year", "Calendar year", "Calendar year"),
  geographic_level = c("National", "Regional", "Regional"),
  country_code = c("E92000001", "E92000001", "E92000001"),
  country_name = c("England", "England", "England"),
  region_code = c(NA, "E12000001", "E12000002"),
  region_name = c(NA, "North East", "North West"),
  mystery_count = c(42, 25, NA)
)

z_replace(df)

# Use a different replacement value
z_replace(df, replacement_alt = "c")

}
\seealso{
\link{geog_time_identifiers}
}
