# estimNLR - examples at help page

    Code
      (fit_nls <- estimNLR(y = y, match = match, group = group, formula = M$M1$
      formula, method = "nls", lower = M$M1$lower, upper = M$M1$upper, start = start))
    Output
      Nonlinear regression model 
      
       Model:  y ~ c + (1 - c)/(1 + exp(-(a + aDif * g) * (x - (b + bDif * g)))) 
      
      Coefficients:
            a       b       c    aDif    bDif 
       1.1211 -0.3037  0.1106 -0.0645  0.9497 
      
       Nonlinear least squares estimation 
      Converged after 8 iterations

---

    Code
      coef(fit_nls)
    Output
                a           b           c        aDif        bDif 
       1.12111002 -0.30366987  0.11055294 -0.06452584  0.94969524 

---

    Code
      logLik(fit_nls)
    Output
      'log Lik.' -1252.515 (df=5)

---

    Code
      vcov(fit_nls)
    Output
                      a            b             c         aDif          bDif
      a     0.022431664  0.016929831  6.457960e-03 -0.007351992 -1.727466e-03
      b     0.016929831  0.029611668  1.033136e-02  0.007194420 -5.291136e-03
      c     0.006457960  0.010331355  4.384449e-03  0.003779956 -1.014112e-05
      aDif -0.007351992  0.007194420  3.779956e-03  0.029190088 -2.220439e-03
      bDif -0.001727466 -0.005291136 -1.014112e-05 -0.002220439  1.235827e-02

---

    Code
      vcov(fit_nls, sandwich = TRUE)
    Output
                      a            b            c          aDif          bDif
      a     0.018614638  0.017218187 0.0064071814 -1.145073e-03 -1.203845e-03
      b     0.017218187  0.034356847 0.0120786688  1.546893e-02 -4.325496e-03
      c     0.006407181  0.012078669 0.0050928509  7.394285e-03  5.961622e-04
      aDif -0.001145073  0.015468934 0.0073942854  3.290892e-02 -3.919505e-05
      bDif -0.001203845 -0.004325496 0.0005961622 -3.919505e-05  1.291965e-02

---

    Code
      fitted(fit_nls)
    Output
         [1] 0.4364812 0.7866565 0.8870283 0.2254449 0.7950140 0.2979030 0.5093386
         [8] 0.4258949 0.7950140 0.7866565 0.8463985 0.7267632 0.4364812 0.5025620
        [15] 0.7326843 0.3567994 0.5825445 0.7267632 0.4364812 0.3120549 0.4258949
        [22] 0.8368962 0.8870283 0.8463985 0.6607947 0.5025620 0.7866565 0.5025620
        [29] 0.7267632 0.2639710 0.5025620 0.6585474 0.7950140 0.3120549 0.4364812
        [36] 0.5093386 0.6607947 0.8463985 0.5025620 0.5847767 0.2639710 0.5025620
        [43] 0.5025620 0.7950140 0.7950140 0.4364812 0.3120549 0.5025620 0.2254449
        [50] 0.5093386 0.5093386 0.2639710 0.1726989 0.5093386 0.3120549 0.5825445
        [57] 0.3120549 0.5093386 0.5093386 0.5093386 0.9091806 0.6607947 0.3120549
        [64] 0.2254449 0.6585474 0.7326843 0.2254449 0.7326843 0.1431491 0.9412824
        [71] 0.4258949 0.2254449 0.4364812 0.5825445 0.5025620 0.2254449 0.6585474
        [78] 0.2500384 0.3120549 0.5025620 0.5093386 0.5825445 0.2254449 0.3567994
        [85] 0.5025620 0.6585474 0.2979030 0.3567994 0.4364812 0.7326843 0.2979030
        [92] 0.7267632 0.4364812 0.7267632 0.2639710 0.2254449 0.3698990 0.8463985
        [99] 0.2639710 0.8774495 0.9582385 0.5093386 0.5093386 0.6607947 0.3698990
       [106] 0.2126246 0.7950140 0.7950140 0.6607947 0.1726989 0.6585474 0.4364812
       [113] 0.3698990 0.8463985 0.3120549 0.5825445 0.3120549 0.8870283 0.2254449
       [120] 0.4364812 0.7866565 0.4364812 0.2639710 0.8463985 0.2639710 0.5025620
       [127] 0.2639710 0.2500384 0.2639710 0.2979030 0.4364812 0.4258949 0.4258949
       [134] 0.8463985 0.3698990 0.3698990 0.1842599 0.5847767 0.7326843 0.8463985
       [141] 0.3698990 0.1954772 0.2979030 0.7950140 0.5025620 0.6607947 0.9181070
       [148] 0.7326843 0.2254449 0.3120549 0.2639710 0.2254449 0.6607947 0.4364812
       [155] 0.8463985 0.3567994 0.2254449 0.9181070 0.9412824 0.3698990 0.4258949
       [162] 0.5093386 0.9181070 0.1726989 0.4258949 0.4364812 0.6607947 0.9181070
       [169] 0.2639710 0.7950140 0.2979030 0.6607947 0.5847767 0.5825445 0.7326843
       [176] 0.4258949 0.4364812 0.7866565 0.8870283 0.1954772 0.3698990 0.8870283
       [183] 0.9181070 0.8368962 0.5847767 0.5025620 0.8870283 0.3567994 0.1556874
       [190] 0.7326843 0.3120549 0.5025620 0.7326843 0.1726989 0.9181070 0.5825445
       [197] 0.5825445 0.6607947 0.7950140 0.4364812 0.3120549 0.5825445 0.2500384
       [204] 0.7950140 0.8870283 0.7326843 0.7326843 0.4364812 0.7950140 0.3698990
       [211] 0.5847767 0.3698990 0.2500384 0.5093386 0.1954772 0.2979030 0.7326843
       [218] 0.7950140 0.9412824 0.7326843 0.5847767 0.3698990 0.3698990 0.7326843
       [225] 0.3698990 0.4258949 0.7326843 0.5025620 0.5825445 0.5093386 0.3567994
       [232] 0.9181070 0.8870283 0.3567994 0.8463985 0.7326843 0.5825445 0.9412824
       [239] 0.3120549 0.9181070 0.7326843 0.6585474 0.6607947 0.4364812 0.5025620
       [246] 0.3120549 0.4364812 0.5825445 0.5847767 0.3120549 0.8463985 0.5025620
       [253] 0.7950140 0.6607947 0.5847767 0.5847767 0.6607947 0.4364812 0.7267632
       [260] 0.7950140 0.1431491 0.6585474 0.3567994 0.2639710 0.6607947 0.5825445
       [267] 0.8463985 0.4364812 0.7866565 0.1726989 0.4364812 0.6607947 0.7950140
       [274] 0.3567994 0.9181070 0.3120549 0.5093386 0.1954772 0.3567994 0.5093386
       [281] 0.2639710 0.7326843 0.5825445 0.4258949 0.5847767 0.7866565 0.5025620
       [288] 0.7950140 0.9412824 0.4258949 0.4258949 0.2639710 0.3120549 0.5825445
       [295] 0.4364812 0.8463985 0.5847767 0.5025620 0.5847767 0.8463985 0.5847767
       [302] 0.3698990 0.3567994 0.2500384 0.6607947 0.9181070 0.7950140 0.9181070
       [309] 0.4258949 0.3698990 0.6607947 0.2639710 0.4364812 0.5093386 0.8774495
       [316] 0.7950140 0.5093386 0.6585474 0.5825445 0.3120549 0.2639710 0.5093386
       [323] 0.7326843 0.1339972 0.6585474 0.7326843 0.3567994 0.7950140 0.7326843
       [330] 0.1726989 0.3120549 0.3698990 0.4364812 0.2639710 0.8870283 0.5025620
       [337] 0.5825445 0.4364812 0.6607947 0.3698990 0.6607947 0.5847767 0.7950140
       [344] 0.7326843 0.5025620 0.5025620 0.4364812 0.4258949 0.8463985 0.2639710
       [351] 0.1954772 0.8463985 0.5825445 0.6607947 0.2979030 0.8463985 0.5093386
       [358] 0.2639710 0.2979030 0.4258949 0.7866565 0.2639710 0.5093386 0.2979030
       [365] 0.8870283 0.4364812 0.3567994 0.3120549 0.2639710 0.5847767 0.3567994
       [372] 0.5093386 0.2254449 0.4258949 0.5825445 0.3120549 0.1726989 0.7326843
       [379] 0.5025620 0.7950140 0.8463985 0.5093386 0.4258949 0.5825445 0.6607947
       [386] 0.9412824 0.5025620 0.9704721 0.3567994 0.1556874 0.3120549 0.3698990
       [393] 0.7267632 0.5093386 0.5025620 0.3698990 0.4258949 0.8368962 0.8368962
       [400] 0.8463985 0.2500384 0.3120549 0.4364812 0.8463985 0.9181070 0.3698990
       [407] 0.5093386 0.5847767 0.4364812 0.8368962 0.6585474 0.4364812 0.7950140
       [414] 0.4258949 0.5825445 0.1954772 0.5093386 0.2979030 0.4258949 0.1556874
       [421] 0.3120549 0.6585474 0.4364812 0.4364812 0.5093386 0.3567994 0.6585474
       [428] 0.6585474 0.5093386 0.5025620 0.3698990 0.4364812 0.5025620 0.8463985
       [435] 0.3120549 0.7866565 0.7950140 0.2639710 0.2500384 0.5093386 0.5847767
       [442] 0.5093386 0.7326843 0.2254449 0.3120549 0.7950140 0.6585474 0.6585474
       [449] 0.1954772 0.3120549 0.5847767 0.1726989 0.8368962 0.5093386 0.5025620
       [456] 0.7267632 0.5093386 0.5847767 0.3120549 0.7326843 0.5093386 0.5847767
       [463] 0.7267632 0.7950140 0.2126246 0.2639710 0.5093386 0.7326843 0.5847767
       [470] 0.6585474 0.5825445 0.6607947 0.3120549 0.5025620 0.7950140 0.7326843
       [477] 0.3567994 0.5093386 0.5093386 0.7326843 0.8463985 0.5847767 0.7950140
       [484] 0.7326843 0.5025620 0.3120549 0.7950140 0.6607947 0.4364812 0.6585474
       [491] 0.7326843 0.2254449 0.2254449 0.3120549 0.5025620 0.1954772 0.2979030
       [498] 0.5847767 0.5025620 0.7866565 0.8463985 0.2500384 0.3698990 0.3120549
       [505] 0.5025620 0.4258949 0.3120549 0.4364812 0.3120549 0.3120549 0.3120549
       [512] 0.1842599 0.2126246 0.6607947 0.7267632 0.2979030 0.3698990 0.4258949
       [519] 0.2639710 0.5093386 0.5825445 0.5093386 0.9091806 0.7866565 0.5093386
       [526] 0.6585474 0.8870283 0.5847767 0.2639710 0.8463985 0.8463985 0.5847767
       [533] 0.3698990 0.4258949 0.3120549 0.6607947 0.6607947 0.7326843 0.5025620
       [540] 0.5093386 0.2639710 0.3698990 0.6585474 0.3567994 0.5025620 0.7326843
       [547] 0.5093386 0.4364812 0.3698990 0.2254449 0.4364812 0.2254449 0.7326843
       [554] 0.4364812 0.3567994 0.4364812 0.6585474 0.2639710 0.6607947 0.5093386
       [561] 0.8463985 0.2500384 0.5025620 0.7950140 0.4364812 0.5847767 0.2639710
       [568] 0.7326843 0.9181070 0.4258949 0.5025620 0.7267632 0.3698990 0.4364812
       [575] 0.5025620 0.5093386 0.3698990 0.7326843 0.1726989 0.3698990 0.4258949
       [582] 0.1954772 0.5025620 0.5025620 0.5093386 0.2639710 0.4364812 0.1556874
       [589] 0.7950140 0.4364812 0.8870283 0.2126246 0.3567994 0.5825445 0.5025620
       [596] 0.5025620 0.4364812 0.2254449 0.5847767 0.6607947 0.2639710 0.2500384
       [603] 0.3698990 0.2639710 0.3120549 0.7326843 0.8463985 0.7326843 0.7866565
       [610] 0.5847767 0.6607947 0.5847767 0.5825445 0.7866565 0.4364812 0.1556874
       [617] 0.5025620 0.1556874 0.7326843 0.2979030 0.4364812 0.1954772 0.4364812
       [624] 0.4364812 0.3698990 0.1954772 0.7950140 0.4258949 0.8870283 0.7326843
       [631] 0.2254449 0.6607947 0.5825445 0.7950140 0.7326843 0.8463985 0.6607947
       [638] 0.7326843 0.5825445 0.8870283 0.4258949 0.5825445 0.5825445 0.5847767
       [645] 0.2254449 0.3567994 0.3120549 0.3567994 0.4258949 0.5025620 0.8774495
       [652] 0.4258949 0.7326843 0.7326843 0.6607947 0.4364812 0.7950140 0.7326843
       [659] 0.1954772 0.7326843 0.3120549 0.7950140 0.2639710 0.3120549 0.3120549
       [666] 0.9704721 0.5825445 0.6607947 0.2979030 0.2254449 0.3698990 0.5847767
       [673] 0.4364812 0.3120549 0.7326843 0.5847767 0.1954772 0.4364812 0.3120549
       [680] 0.4364812 0.1726989 0.4258949 0.3120549 0.1556874 0.6607947 0.8870283
       [687] 0.4364812 0.8368962 0.3120549 0.3698990 0.8463985 0.5093386 0.5025620
       [694] 0.5093386 0.2500384 0.7950140 0.7950140 0.5025620 0.2639710 0.7950140
       [701] 0.2500384 0.2639710 0.9181070 0.2639710 0.3698990 0.2979030 0.7950140
       [708] 0.4258949 0.4258949 0.3120549 0.1556874 0.8870283 0.7950140 0.5825445
       [715] 0.5093386 0.5093386 0.5825445 0.1954772 0.3120549 0.5025620 0.5093386
       [722] 0.4258949 0.5025620 0.5825445 0.8463985 0.7267632 0.1954772 0.3698990
       [729] 0.5093386 0.6607947 0.3698990 0.7326843 0.5825445 0.3698990 0.6585474
       [736] 0.3698990 0.7326843 0.2254449 0.3567994 0.8368962 0.5093386 0.5847767
       [743] 0.8368962 0.7326843 0.3120549 0.5093386 0.2500384 0.8870283 0.7267632
       [750] 0.2979030 0.7267632 0.5847767 0.5847767 0.6607947 0.5025620 0.7326843
       [757] 0.4258949 0.3698990 0.6607947 0.9412824 0.2254449 0.3698990 0.6585474
       [764] 0.1726989 0.2639710 0.3120549 0.5025620 0.5825445 0.5025620 0.3567994
       [771] 0.3567994 0.8870283 0.7326843 0.5093386 0.3120549 0.3567994 0.6585474
       [778] 0.7326843 0.3698990 0.8463985 0.6607947 0.3567994 0.7950140 0.3698990
       [785] 0.4258949 0.3120549 0.2639710 0.5025620 0.5025620 0.5847767 0.2979030
       [792] 0.8463985 0.5025620 0.7326843 0.1954772 0.5025620 0.4364812 0.5825445
       [799] 0.3567994 0.2639710 0.5825445 0.5825445 0.7950140 0.8368962 0.7267632
       [806] 0.7326843 0.3120549 0.4258949 0.2639710 0.8368962 0.8463985 0.5093386
       [813] 0.7267632 0.7950140 0.2639710 0.4258949 0.2254449 0.5093386 0.4364812
       [820] 0.1954772 0.7950140 0.7326843 0.7950140 0.8870283 0.8870283 0.3698990
       [827] 0.4258949 0.1954772 0.5025620 0.4364812 0.2254449 0.2500384 0.5093386
       [834] 0.5093386 0.3120549 0.2254449 0.4364812 0.3567994 0.8463985 0.5847767
       [841] 0.6607947 0.4258949 0.7326843 0.2979030 0.5847767 0.3698990 0.2639710
       [848] 0.2639710 0.7326843 0.1726989 0.5025620 0.4258949 0.5825445 0.2500384
       [855] 0.5825445 0.3698990 0.5093386 0.5825445 0.5093386 0.7326843 0.5093386
       [862] 0.7326843 0.6585474 0.7866565 0.4364812 0.5847767 0.8368962 0.5093386
       [869] 0.5825445 0.2639710 0.5825445 0.8870283 0.6607947 0.3698990 0.9181070
       [876] 0.7326843 0.5825445 0.3567994 0.4364812 0.6585474 0.3698990 0.1954772
       [883] 0.5025620 0.8870283 0.5825445 0.4364812 0.6607947 0.5825445 0.3698990
       [890] 0.7950140 0.4258949 0.1954772 0.4258949 0.6585474 0.5847767 0.4364812
       [897] 0.3120549 0.8368962 0.6585474 0.6607947 0.5825445 0.3120549 0.7866565
       [904] 0.3120549 0.7326843 0.2639710 0.7326843 0.5847767 0.3120549 0.7950140
       [911] 0.6607947 0.3698990 0.5847767 0.5825445 0.3698990 0.7950140 0.3698990
       [918] 0.4364812 0.5847767 0.8870283 0.5847767 0.3567994 0.4258949 0.5025620
       [925] 0.6607947 0.1954772 0.5825445 0.5847767 0.5025620 0.5847767 0.7326843
       [932] 0.7866565 0.5825445 0.4258949 0.5825445 0.3698990 0.5847767 0.7267632
       [939] 0.1954772 0.7326843 0.5093386 0.4258949 0.3698990 0.8870283 0.3120549
       [946] 0.5847767 0.1954772 0.2500384 0.5825445 0.5025620 0.5847767 0.5093386
       [953] 0.3698990 0.8870283 0.6607947 0.1954772 0.5025620 0.5093386 0.2254449
       [960] 0.8463985 0.7866565 0.2639710 0.1954772 0.6607947 0.2254449 0.2254449
       [967] 0.4364812 0.6585474 0.4364812 0.2639710 0.3698990 0.1726989 0.5825445
       [974] 0.7267632 0.3698990 0.6607947 0.7267632 0.7267632 0.6607947 0.7326843
       [981] 0.6585474 0.9181070 0.5825445 0.7950140 0.2254449 0.6607947 0.5825445
       [988] 0.2639710 0.5093386 0.5847767 0.1339972 0.5847767 0.5093386 0.3698990
       [995] 0.7326843 0.3567994 0.9181070 0.3698990 0.8870283 0.6607947 0.5825445
      [1002] 0.3567994 0.2254449 0.4258949 0.7326843 0.2979030 0.9582385 0.6607947
      [1009] 0.5847767 0.5025620 0.2254449 0.6607947 0.1632499 0.4364812 0.5825445
      [1016] 0.2639710 0.1726989 0.7326843 0.3567994 0.5825445 0.7326843 0.4258949
      [1023] 0.9181070 0.4258949 0.6585474 0.4364812 0.6607947 0.2254449 0.3120549
      [1030] 0.6607947 0.4258949 0.5847767 0.5093386 0.1954772 0.7267632 0.5825445
      [1037] 0.1556874 0.4258949 0.7326843 0.1842599 0.6607947 0.3698990 0.4258949
      [1044] 0.6585474 0.6585474 0.6607947 0.3120549 0.3567994 0.3698990 0.7950140
      [1051] 0.2639710 0.3120549 0.6607947 0.4258949 0.5093386 0.4364812 0.2500384
      [1058] 0.4364812 0.3698990 0.3698990 0.2979030 0.3567994 0.5847767 0.5025620
      [1065] 0.7326843 0.7326843 0.7950140 0.8463985 0.3567994 0.6607947 0.4364812
      [1072] 0.4258949 0.4364812 0.1556874 0.7950140 0.7950140 0.1431491 0.2254449
      [1079] 0.5025620 0.2639710 0.4258949 0.2254449 0.9412824 0.1726989 0.5025620
      [1086] 0.2639710 0.2500384 0.5025620 0.2126246 0.4258949 0.5847767 0.7950140
      [1093] 0.8870283 0.7950140 0.6607947 0.5093386 0.5847767 0.1954772 0.3120549
      [1100] 0.3120549 0.9412824 0.2500384 0.7326843 0.2639710 0.7267632 0.5847767
      [1107] 0.3120549 0.4258949 0.5093386 0.4258949 0.5847767 0.4364812 0.3698990
      [1114] 0.2500384 0.7326843 0.6585474 0.5025620 0.6607947 0.5093386 0.7950140
      [1121] 0.8870283 0.7326843 0.5025620 0.6607947 0.5825445 0.5825445 0.3567994
      [1128] 0.3698990 0.4258949 0.6607947 0.1726989 0.3698990 0.8368962 0.4258949
      [1135] 0.8870283 0.4258949 0.2979030 0.5025620 0.2500384 0.5825445 0.3698990
      [1142] 0.1726989 0.3698990 0.3698990 0.5847767 0.5847767 0.7950140 0.5093386
      [1149] 0.3698990 0.4364812 0.6607947 0.2500384 0.2500384 0.2254449 0.7950140
      [1156] 0.9181070 0.8870283 0.4364812 0.9181070 0.7326843 0.2126246 0.2254449
      [1163] 0.5025620 0.7267632 0.7326843 0.2126246 0.5025620 0.2254449 0.5025620
      [1170] 0.7326843 0.4258949 0.4258949 0.2979030 0.9091806 0.9412824 0.7267632
      [1177] 0.7950140 0.5093386 0.1556874 0.5825445 0.7950140 0.5025620 0.5025620
      [1184] 0.6607947 0.4364812 0.5825445 0.3120549 0.5847767 0.5093386 0.4258949
      [1191] 0.6607947 0.8774495 0.7866565 0.5093386 0.7950140 0.3120549 0.7950140
      [1198] 0.4364812 0.2500384 0.7866565 0.6585474 0.5847767 0.3567994 0.6607947
      [1205] 0.4258949 0.8870283 0.9181070 0.2639710 0.9181070 0.3120549 0.3120549
      [1212] 0.6607947 0.3698990 0.9412824 0.3698990 0.4364812 0.6585474 0.6585474
      [1219] 0.8368962 0.1726989 0.5093386 0.7950140 0.4364812 0.5825445 0.3120549
      [1226] 0.7950140 0.3698990 0.7267632 0.7326843 0.4364812 0.5093386 0.7950140
      [1233] 0.5093386 0.7326843 0.9181070 0.3567994 0.7950140 0.4258949 0.7326843
      [1240] 0.3120549 0.5825445 0.6607947 0.5825445 0.7326843 0.7267632 0.5025620
      [1247] 0.7267632 0.5825445 0.9412824 0.3120549 0.3120549 0.3120549 0.4364812
      [1254] 0.5093386 0.3698990 0.2254449 0.5093386 0.7326843 0.5025620 0.5825445
      [1261] 0.5093386 0.1954772 0.3120549 0.6607947 0.5825445 0.1726989 0.5025620
      [1268] 0.6607947 0.5025620 0.2979030 0.2979030 0.5093386 0.7267632 0.3567994
      [1275] 0.7866565 0.7326843 0.3120549 0.8463985 0.4364812 0.6585474 0.3120549
      [1282] 0.9181070 0.1726989 0.5847767 0.5847767 0.2500384 0.5025620 0.9412824
      [1289] 0.1726989 0.5093386 0.8463985 0.1726989 0.5847767 0.6585474 0.6607947
      [1296] 0.4364812 0.6585474 0.8463985 0.3698990 0.5847767 0.7950140 0.1726989
      [1303] 0.7950140 0.3120549 0.7866565 0.6607947 0.2639710 0.5825445 0.5025620
      [1310] 0.8463985 0.8463985 0.4258949 0.3698990 0.2254449 0.5093386 0.7326843
      [1317] 0.7950140 0.8870283 0.7267632 0.6607947 0.5847767 0.3698990 0.5025620
      [1324] 0.7950140 0.6585474 0.2639710 0.3120549 0.5093386 0.8463985 0.2979030
      [1331] 0.6585474 0.5025620 0.7326843 0.3698990 0.5025620 0.7950140 0.2639710
      [1338] 0.5825445 0.7950140 0.2639710 0.3120549 0.9181070 0.5825445 0.2979030
      [1345] 0.5825445 0.4364812 0.5025620 0.2254449 0.3120549 0.5093386 0.3698990
      [1352] 0.5025620 0.8870283 0.7866565 0.3567994 0.5847767 0.5093386 0.5825445
      [1359] 0.7866565 0.8463985 0.2639710 0.6607947 0.5825445 0.2254449 0.5093386
      [1366] 0.6607947 0.9181070 0.3698990 0.6607947 0.9181070 0.6585474 0.6607947
      [1373] 0.9091806 0.3120549 0.4364812 0.5093386 0.7950140 0.4364812 0.5825445
      [1380] 0.4258949 0.2254449 0.5025620 0.5825445 0.1954772 0.7950140 0.3120549
      [1387] 0.3698990 0.1954772 0.1556874 0.7950140 0.5093386 0.5093386 0.7326843
      [1394] 0.7866565 0.7866565 0.7326843 0.4258949 0.5847767 0.4364812 0.2126246
      [1401] 0.7950140 0.9704721 0.4258949 0.7950140 0.3698990 0.3698990 0.6607947
      [1408] 0.5093386 0.8774495 0.7950140 0.2500384 0.5025620 0.2639710 0.3567994
      [1415] 0.4258949 0.9181070 0.6585474 0.7326843 0.2126246 0.5847767 0.3120549
      [1422] 0.5093386 0.4364812 0.8463985 0.6607947 0.7326843 0.6607947 0.2979030
      [1429] 0.4258949 0.1954772 0.7267632 0.3120549 0.5825445 0.5025620 0.4258949
      [1436] 0.1954772 0.7326843 0.9582385 0.7326843 0.5025620 0.1954772 0.7326843
      [1443] 0.5847767 0.5825445 0.8463985 0.2639710 0.7866565 0.3567994 0.6607947
      [1450] 0.7267632 0.8870283 0.4364812 0.3698990 0.4258949 0.5847767 0.6585474
      [1457] 0.7326843 0.3120549 0.5093386 0.2500384 0.5025620 0.5847767 0.3120549
      [1464] 0.2639710 0.7950140 0.5093386 0.5093386 0.5093386 0.6607947 0.1954772
      [1471] 0.5025620 0.8368962 0.2126246 0.7950140 0.3698990 0.2979030 0.7326843
      [1478] 0.1556874 0.8463985 0.7326843 0.3698990 0.8463985 0.3698990 0.9582385
      [1485] 0.4364812 0.5093386 0.2979030 0.7267632 0.4364812 0.6607947 0.6607947
      [1492] 0.3120549 0.5093386 0.7326843 0.5825445 0.3698990 0.4364812 0.7950140
      [1499] 0.6607947 0.5825445 0.7326843 0.5093386 0.9181070 0.1954772 0.7950140
      [1506] 0.6607947 0.2254449 0.5093386 0.1954772 0.5093386 0.2639710 0.4364812
      [1513] 0.3698990 0.2639710 0.5825445 0.4258949 0.5825445 0.5025620 0.1726989
      [1520] 0.7326843 0.4364812 0.6585474 0.5025620 0.7950140 0.5093386 0.6607947
      [1527] 0.2500384 0.6607947 0.5825445 0.6607947 0.4258949 0.7866565 0.7326843
      [1534] 0.4364812 0.3120549 0.9412824 0.2639710 0.5025620 0.6607947 0.5825445
      [1541] 0.8463985 0.6607947 0.2500384 0.3698990 0.8463985 0.8463985 0.3120549
      [1548] 0.6607947 0.6607947 0.1726989 0.2639710 0.2254449 0.2979030 0.3698990
      [1555] 0.4364812 0.3120549 0.5847767 0.2254449 0.6585474 0.3567994 0.1842599
      [1562] 0.5847767 0.9412824 0.5847767 0.6585474 0.6607947 0.5025620 0.9412824
      [1569] 0.1726989 0.4364812 0.7950140 0.6585474 0.7326843 0.4364812 0.3698990
      [1576] 0.5847767 0.3120549 0.5847767 0.5847767 0.8463985 0.2500384 0.3698990
      [1583] 0.8368962 0.1726989 0.8870283 0.7267632 0.5847767 0.2979030 0.1954772
      [1590] 0.7326843 0.7326843 0.3567994 0.5847767 0.2639710 0.5847767 0.5093386
      [1597] 0.7950140 0.2639710 0.7950140 0.5093386 0.5847767 0.9704721 0.1632499
      [1604] 0.3698990 0.6607947 0.7326843 0.3698990 0.3698990 0.2979030 0.5093386
      [1611] 0.5825445 0.3698990 0.7326843 0.2500384 0.8870283 0.5825445 0.5093386
      [1618] 0.2639710 0.4364812 0.1954772 0.5847767 0.7950140 0.5825445 0.5093386
      [1625] 0.3567994 0.2126246 0.6607947 0.7326843 0.8870283 0.7326843 0.5825445
      [1632] 0.4258949 0.5093386 0.6607947 0.2639710 0.7326843 0.7326843 0.7326843
      [1639] 0.3120549 0.5093386 0.8870283 0.6607947 0.4258949 0.6607947 0.5093386
      [1646] 0.7950140 0.2979030 0.7326843 0.5025620 0.5025620 0.3120549 0.7950140
      [1653] 0.3120549 0.5093386 0.4364812 0.5825445 0.2639710 0.4364812 0.1954772
      [1660] 0.7950140 0.6585474 0.7950140 0.9412824 0.5093386 0.2979030 0.5093386
      [1667] 0.5847767 0.8463985 0.1431491 0.6607947 0.3120549 0.3120549 0.5025620
      [1674] 0.2126246 0.4258949 0.5025620 0.7326843 0.5093386 0.5093386 0.7326843
      [1681] 0.4258949 0.2979030 0.5825445 0.7326843 0.5025620 0.4258949 0.2639710
      [1688] 0.2639710 0.2254449 0.7267632 0.3698990 0.5825445 0.5025620 0.2500384
      [1695] 0.6585474 0.3120549 0.3698990 0.6585474 0.4364812 0.4364812 0.1556874
      [1702] 0.1431491 0.5825445 0.5025620 0.3698990 0.2639710 0.7267632 0.6607947
      [1709] 0.9181070 0.5825445 0.1954772 0.3567994 0.2639710 0.5825445 0.3120549
      [1716] 0.4364812 0.9412824 0.5025620 0.2254449 0.2639710 0.6607947 0.2254449
      [1723] 0.7326843 0.3698990 0.5093386 0.6585474 0.5847767 0.2254449 0.5847767
      [1730] 0.1954772 0.3698990 0.4364812 0.8463985 0.5825445 0.6607947 0.5093386
      [1737] 0.1726989 0.6585474 0.2639710 0.5093386 0.5847767 0.2979030 0.4364812
      [1744] 0.9704721 0.5093386 0.3698990 0.2639710 0.3120549 0.8463985 0.1726989
      [1751] 0.4258949 0.7326843 0.2639710 0.9582385 0.3120549 0.6585474 0.5025620
      [1758] 0.2639710 0.3120549 0.7267632 0.8463985 0.2500384 0.3120549 0.5025620
      [1765] 0.5847767 0.8774495 0.9582385 0.6607947 0.5093386 0.8463985 0.3567994
      [1772] 0.2979030 0.7950140 0.5847767 0.1842599 0.8870283 0.6607947 0.4364812
      [1779] 0.2254449 0.3698990 0.7866565 0.2979030 0.2639710 0.5093386 0.2126246
      [1786] 0.1726989 0.3698990 0.6585474 0.7950140 0.7950140 0.4258949 0.5847767
      [1793] 0.7950140 0.5847767 0.9412824 0.6585474 0.3698990 0.7950140 0.5847767
      [1800] 0.5825445 0.3120549 0.5847767 0.7866565 0.3120549 0.5825445 0.5825445
      [1807] 0.3567994 0.5025620 0.4364812 0.5825445 0.4258949 0.8870283 0.3120549
      [1814] 0.5093386 0.2126246 0.3698990 0.8463985 0.2254449 0.6607947 0.2254449
      [1821] 0.3698990 0.9181070 0.4364812 0.3120549 0.2254449 0.2639710 0.7326843
      [1828] 0.7866565 0.1726989 0.1726989 0.5825445 0.5093386 0.6607947 0.3698990
      [1835] 0.2254449 0.2979030 0.5093386 0.3567994 0.4364812 0.5093386 0.5025620
      [1842] 0.7326843 0.7866565 0.3698990 0.5025620 0.7866565 0.6607947 0.1726989
      [1849] 0.6607947 0.1954772 0.5025620 0.2639710 0.2639710 0.6607947 0.5847767
      [1856] 0.8463985 0.2254449 0.3120549 0.5825445 0.4364812 0.4364812 0.3567994
      [1863] 0.2126246 0.2254449 0.3120549 0.7950140 0.7950140 0.4364812 0.2639710
      [1870] 0.5847767 0.6585474 0.5825445 0.8463985 0.6607947 0.6585474 0.3698990
      [1877] 0.3567994 0.6585474 0.6607947 0.7950140 0.8870283 0.5825445 0.3698990
      [1884] 0.2979030 0.7267632 0.6585474 0.7326843 0.4364812 0.6585474 0.4258949
      [1891] 0.1726989 0.5025620 0.1954772 0.5093386 0.4258949 0.5025620 0.5825445
      [1898] 0.5825445 0.8463985 0.5825445 0.4364812 0.5847767 0.6607947 0.3120549
      [1905] 0.7326843 0.7267632 0.2979030 0.7326843 0.7326843 0.3120549 0.7326843
      [1912] 0.6607947 0.3120549 0.8463985 0.3698990 0.5025620 0.7267632 0.7950140
      [1919] 0.3120549 0.7326843 0.3698990 0.3698990 0.1954772 0.1726989 0.9181070
      [1926] 0.2639710 0.5825445 0.3567994 0.6585474 0.4258949 0.2500384 0.5093386
      [1933] 0.6607947 0.2639710 0.5025620 0.5093386 0.8463985 0.2639710 0.2500384
      [1940] 0.5825445 0.4364812 0.5093386 0.6607947 0.2254449 0.4364812 0.8870283
      [1947] 0.5847767 0.7326843 0.7326843 0.3120549 0.6585474 0.9091806 0.2979030
      [1954] 0.7267632 0.5025620 0.4258949 0.6607947 0.3120549 0.7326843 0.7326843
      [1961] 0.3567994 0.8463985 0.5093386 0.5847767 0.5825445 0.3567994 0.6585474
      [1968] 0.7267632 0.4364812 0.8463985 0.5847767 0.5825445 0.5825445 0.1954772
      [1975] 0.5825445 0.7326843 0.5025620 0.4258949 0.3120549 0.1556874 0.3567994
      [1982] 0.6607947 0.5093386 0.3567994 0.2639710 0.3567994 0.4364812 0.7326843
      [1989] 0.2979030 0.8368962 0.3120549 0.6607947 0.2979030 0.7326843 0.8368962
      [1996] 0.5093386 0.4364812 0.7326843 0.7326843 0.7267632
      attr(,"label")
      [1] "Fitted values"

---

    Code
      residuals(fit_nls)
    Output
         [1] -0.43648118  0.21334351  0.11297170 -0.22544492  0.20498604 -0.29790303
         [7]  0.49066141  0.57410507  0.20498604  0.21334351  0.15360150  0.27323680
        [13] -0.43648118 -0.50256204 -0.73268430 -0.35679942  0.41745551  0.27323680
        [19] -0.43648118 -0.31205490  0.57410507  0.16310381  0.11297170  0.15360150
        [25]  0.33920535  0.49743796  0.21334351 -0.50256204  0.27323680 -0.26397097
        [31] -0.50256204 -0.65854737 -0.79501396 -0.31205490  0.56351882 -0.50933859
        [37] -0.66079465  0.15360150  0.49743796 -0.58477673 -0.26397097  0.49743796
        [43] -0.50256204  0.20498604  0.20498604 -0.43648118 -0.31205490  0.49743796
        [49]  0.77455508 -0.50933859  0.49066141 -0.26397097  0.82730110 -0.50933859
        [55]  0.68794510  0.41745551 -0.31205490  0.49066141 -0.50933859  0.49066141
        [61]  0.09081937 -0.66079465  0.68794510 -0.22544492  0.34145263 -0.73268430
        [67] -0.22544492  0.26731570 -0.14314911  0.05871756 -0.42589493 -0.22544492
        [73]  0.56351882  0.41745551 -0.50256204  0.77455508  0.34145263 -0.25003843
        [79] -0.31205490  0.49743796  0.49066141 -0.58254449 -0.22544492 -0.35679942
        [85] -0.50256204 -0.65854737  0.70209697 -0.35679942 -0.43648118 -0.73268430
        [91] -0.29790303  0.27323680 -0.43648118  0.27323680  0.73602903 -0.22544492
        [97]  0.63010098  0.15360150 -0.26397097  0.12255046  0.04176152  0.49066141
       [103]  0.49066141  0.33920535 -0.36989902 -0.21262457  0.20498604 -0.79501396
       [109]  0.33920535 -0.17269890  0.34145263 -0.43648118  0.63010098  0.15360150
       [115] -0.31205490 -0.58254449  0.68794510  0.11297170 -0.22544492  0.56351882
       [121]  0.21334351 -0.43648118 -0.26397097  0.15360150 -0.26397097  0.49743796
       [127]  0.73602903 -0.25003843 -0.26397097 -0.29790303  0.56351882 -0.42589493
       [133] -0.42589493  0.15360150 -0.36989902 -0.36989902 -0.18425986  0.41522327
       [139]  0.26731570  0.15360150 -0.36989902  0.80452281 -0.29790303  0.20498604
       [145]  0.49743796 -0.66079465  0.08189300  0.26731570 -0.22544492  0.68794510
       [151] -0.26397097 -0.22544492  0.33920535 -0.43648118  0.15360150 -0.35679942
       [157] -0.22544492  0.08189300  0.05871756  0.63010098  0.57410507  0.49066141
       [163] -0.91810700 -0.17269890  0.57410507 -0.43648118  0.33920535 -0.91810700
       [169] -0.26397097  0.20498604 -0.29790303  0.33920535 -0.58477673  0.41745551
       [175] -0.73268430  0.57410507 -0.43648118  0.21334351  0.11297170 -0.19547719
       [181]  0.63010098  0.11297170  0.08189300  0.16310381 -0.58477673 -0.50256204
       [187]  0.11297170 -0.35679942 -0.15568743  0.26731570 -0.31205490  0.49743796
       [193]  0.26731570 -0.17269890  0.08189300  0.41745551 -0.58254449 -0.66079465
       [199]  0.20498604  0.56351882 -0.31205490  0.41745551 -0.25003843  0.20498604
       [205]  0.11297170 -0.73268430  0.26731570 -0.43648118  0.20498604 -0.36989902
       [211] -0.58477673  0.63010098  0.74996157 -0.50933859 -0.19547719 -0.29790303
       [217]  0.26731570  0.20498604  0.05871756  0.26731570  0.41522327 -0.36989902
       [223] -0.36989902 -0.73268430 -0.36989902  0.57410507  0.26731570  0.49743796
       [229]  0.41745551 -0.50933859  0.64320058  0.08189300  0.11297170  0.64320058
       [235]  0.15360150 -0.73268430  0.41745551 -0.94128244 -0.31205490  0.08189300
       [241]  0.26731570 -0.65854737  0.33920535  0.56351882  0.49743796 -0.31205490
       [247] -0.43648118 -0.58254449  0.41522327 -0.31205490  0.15360150  0.49743796
       [253]  0.20498604 -0.66079465 -0.58477673 -0.58477673  0.33920535  0.56351882
       [259]  0.27323680  0.20498604 -0.14314911  0.34145263 -0.35679942 -0.26397097
       [265]  0.33920535 -0.58254449  0.15360150 -0.43648118  0.21334351 -0.17269890
       [271] -0.43648118 -0.66079465  0.20498604 -0.35679942  0.08189300 -0.31205490
       [277] -0.50933859 -0.19547719  0.64320058 -0.50933859 -0.26397097  0.26731570
       [283]  0.41745551 -0.42589493 -0.58477673 -0.78665649  0.49743796 -0.79501396
       [289]  0.05871756 -0.42589493 -0.42589493 -0.26397097  0.68794510 -0.58254449
       [295]  0.56351882  0.15360150  0.41522327 -0.50256204  0.41522327  0.15360150
       [301]  0.41522327 -0.36989902 -0.35679942 -0.25003843 -0.66079465  0.08189300
       [307]  0.20498604  0.08189300  0.57410507 -0.36989902 -0.66079465 -0.26397097
       [313] -0.43648118 -0.50933859  0.12255046  0.20498604 -0.50933859 -0.65854737
       [319]  0.41745551 -0.31205490  0.73602903  0.49066141  0.26731570 -0.13399720
       [325]  0.34145263  0.26731570 -0.35679942  0.20498604  0.26731570 -0.17269890
       [331] -0.31205490 -0.36989902 -0.43648118  0.73602903  0.11297170  0.49743796
       [337] -0.58254449  0.56351882  0.33920535 -0.36989902 -0.66079465  0.41522327
       [343]  0.20498604 -0.73268430  0.49743796  0.49743796  0.56351882  0.57410507
       [349]  0.15360150 -0.26397097 -0.19547719  0.15360150 -0.58254449  0.33920535
       [355] -0.29790303  0.15360150 -0.50933859 -0.26397097 -0.29790303  0.57410507
       [361]  0.21334351  0.73602903 -0.50933859 -0.29790303  0.11297170 -0.43648118
       [367] -0.35679942 -0.31205490 -0.26397097 -0.58477673 -0.35679942 -0.50933859
       [373]  0.77455508 -0.42589493  0.41745551  0.68794510 -0.17269890 -0.73268430
       [379]  0.49743796  0.20498604  0.15360150 -0.50933859  0.57410507 -0.58254449
       [385] -0.66079465  0.05871756 -0.50256204  0.02952789 -0.35679942 -0.15568743
       [391] -0.31205490 -0.36989902  0.27323680 -0.50933859 -0.50256204  0.63010098
       [397] -0.42589493  0.16310381 -0.83689619  0.15360150 -0.25003843 -0.31205490
       [403] -0.43648118 -0.84639850  0.08189300 -0.36989902  0.49066141  0.41522327
       [409]  0.56351882  0.16310381  0.34145263  0.56351882  0.20498604 -0.42589493
       [415] -0.58254449 -0.19547719  0.49066141 -0.29790303  0.57410507  0.84431257
       [421] -0.31205490  0.34145263 -0.43648118 -0.43648118  0.49066141 -0.35679942
       [427] -0.65854737  0.34145263 -0.50933859  0.49743796 -0.36989902  0.56351882
       [433]  0.49743796  0.15360150 -0.31205490  0.21334351  0.20498604  0.73602903
       [439]  0.74996157 -0.50933859  0.41522327  0.49066141  0.26731570 -0.22544492
       [445] -0.31205490  0.20498604 -0.65854737 -0.65854737 -0.19547719 -0.31205490
       [451]  0.41522327 -0.17269890  0.16310381  0.49066141  0.49743796  0.27323680
       [457]  0.49066141  0.41522327  0.68794510  0.26731570  0.49066141  0.41522327
       [463] -0.72676320 -0.79501396  0.78737543  0.73602903 -0.50933859  0.26731570
       [469] -0.58477673  0.34145263 -0.58254449  0.33920535 -0.31205490 -0.50256204
       [475]  0.20498604  0.26731570 -0.35679942 -0.50933859 -0.50933859  0.26731570
       [481]  0.15360150 -0.58477673  0.20498604  0.26731570  0.49743796 -0.31205490
       [487]  0.20498604 -0.66079465 -0.43648118  0.34145263 -0.73268430 -0.22544492
       [493]  0.77455508 -0.31205490 -0.50256204  0.80452281  0.70209697  0.41522327
       [499] -0.50256204  0.21334351 -0.84639850 -0.25003843 -0.36989902  0.68794510
       [505] -0.50256204  0.57410507  0.68794510 -0.43648118  0.68794510  0.68794510
       [511] -0.31205490 -0.18425986 -0.21262457  0.33920535 -0.72676320 -0.29790303
       [517] -0.36989902  0.57410507 -0.26397097  0.49066141  0.41745551  0.49066141
       [523]  0.09081937 -0.78665649  0.49066141  0.34145263  0.11297170 -0.58477673
       [529] -0.26397097 -0.84639850  0.15360150 -0.58477673 -0.36989902  0.57410507
       [535]  0.68794510  0.33920535  0.33920535  0.26731570  0.49743796  0.49066141
       [541] -0.26397097 -0.36989902  0.34145263 -0.35679942  0.49743796  0.26731570
       [547] -0.50933859 -0.43648118 -0.36989902  0.77455508 -0.43648118 -0.22544492
       [553]  0.26731570  0.56351882  0.64320058 -0.43648118  0.34145263 -0.26397097
       [559]  0.33920535  0.49066141  0.15360150 -0.25003843  0.49743796  0.20498604
       [565]  0.56351882  0.41522327 -0.26397097 -0.73268430  0.08189300  0.57410507
       [571] -0.50256204 -0.72676320 -0.36989902  0.56351882  0.49743796 -0.50933859
       [577] -0.36989902  0.26731570  0.82730110 -0.36989902  0.57410507 -0.19547719
       [583]  0.49743796 -0.50256204  0.49066141 -0.26397097 -0.43648118 -0.15568743
       [589] -0.79501396  0.56351882  0.11297170 -0.21262457  0.64320058  0.41745551
       [595] -0.50256204  0.49743796  0.56351882 -0.22544492  0.41522327 -0.66079465
       [601]  0.73602903 -0.25003843  0.63010098  0.73602903 -0.31205490  0.26731570
       [607] -0.84639850 -0.73268430  0.21334351  0.41522327  0.33920535 -0.58477673
       [613] -0.58254449  0.21334351  0.56351882 -0.15568743 -0.50256204 -0.15568743
       [619] -0.73268430 -0.29790303 -0.43648118  0.80452281 -0.43648118 -0.43648118
       [625] -0.36989902 -0.19547719 -0.79501396  0.57410507  0.11297170  0.26731570
       [631] -0.22544492 -0.66079465  0.41745551  0.20498604  0.26731570  0.15360150
       [637]  0.33920535  0.26731570  0.41745551  0.11297170 -0.42589493 -0.58254449
       [643]  0.41745551 -0.58477673  0.77455508 -0.35679942  0.68794510  0.64320058
       [649] -0.42589493  0.49743796 -0.87744954 -0.42589493  0.26731570  0.26731570
       [655] -0.66079465 -0.43648118 -0.79501396  0.26731570 -0.19547719  0.26731570
       [661] -0.31205490  0.20498604 -0.26397097 -0.31205490  0.68794510  0.02952789
       [667] -0.58254449  0.33920535  0.70209697 -0.22544492 -0.36989902  0.41522327
       [673] -0.43648118 -0.31205490  0.26731570 -0.58477673 -0.19547719 -0.43648118
       [679] -0.31205490  0.56351882 -0.17269890 -0.42589493 -0.31205490 -0.15568743
       [685]  0.33920535 -0.88702830 -0.43648118  0.16310381 -0.31205490  0.63010098
       [691]  0.15360150 -0.50933859  0.49743796 -0.50933859 -0.25003843  0.20498604
       [697]  0.20498604  0.49743796  0.73602903  0.20498604  0.74996157  0.73602903
       [703]  0.08189300 -0.26397097  0.63010098  0.70209697 -0.79501396 -0.42589493
       [709]  0.57410507  0.68794510  0.84431257  0.11297170  0.20498604  0.41745551
       [715] -0.50933859 -0.50933859  0.41745551 -0.19547719 -0.31205490 -0.50256204
       [721]  0.49066141  0.57410507 -0.50256204 -0.58254449 -0.84639850 -0.72676320
       [727] -0.19547719 -0.36989902 -0.50933859  0.33920535 -0.36989902 -0.73268430
       [733] -0.58254449  0.63010098 -0.65854737  0.63010098  0.26731570 -0.22544492
       [739] -0.35679942  0.16310381 -0.50933859 -0.58477673  0.16310381  0.26731570
       [745] -0.31205490  0.49066141 -0.25003843 -0.88702830  0.27323680 -0.29790303
       [751]  0.27323680 -0.58477673 -0.58477673  0.33920535 -0.50256204  0.26731570
       [757] -0.42589493  0.63010098 -0.66079465  0.05871756 -0.22544492  0.63010098
       [763]  0.34145263 -0.17269890  0.73602903 -0.31205490 -0.50256204 -0.58254449
       [769] -0.50256204 -0.35679942 -0.35679942  0.11297170  0.26731570 -0.50933859
       [775] -0.31205490 -0.35679942  0.34145263  0.26731570 -0.36989902  0.15360150
       [781]  0.33920535  0.64320058  0.20498604 -0.36989902 -0.42589493  0.68794510
       [787] -0.26397097  0.49743796  0.49743796  0.41522327  0.70209697  0.15360150
       [793] -0.50256204  0.26731570 -0.19547719  0.49743796  0.56351882 -0.58254449
       [799] -0.35679942 -0.26397097  0.41745551 -0.58254449  0.20498604  0.16310381
       [805]  0.27323680 -0.73268430 -0.31205490 -0.42589493 -0.26397097  0.16310381
       [811]  0.15360150 -0.50933859 -0.72676320  0.20498604 -0.26397097 -0.42589493
       [817] -0.22544492 -0.50933859 -0.43648118 -0.19547719 -0.79501396  0.26731570
       [823]  0.20498604  0.11297170  0.11297170  0.63010098  0.57410507 -0.19547719
       [829] -0.50256204 -0.43648118 -0.22544492 -0.25003843 -0.50933859  0.49066141
       [835] -0.31205490 -0.22544492  0.56351882 -0.35679942 -0.84639850  0.41522327
       [841]  0.33920535  0.57410507 -0.73268430 -0.29790303 -0.58477673 -0.36989902
       [847] -0.26397097 -0.26397097  0.26731570 -0.17269890 -0.50256204  0.57410507
       [853] -0.58254449 -0.25003843  0.41745551 -0.36989902 -0.50933859  0.41745551
       [859]  0.49066141 -0.73268430  0.49066141  0.26731570 -0.65854737  0.21334351
       [865]  0.56351882 -0.58477673  0.16310381  0.49066141  0.41745551 -0.26397097
       [871]  0.41745551  0.11297170  0.33920535  0.63010098  0.08189300  0.26731570
       [877]  0.41745551  0.64320058  0.56351882  0.34145263 -0.36989902 -0.19547719
       [883]  0.49743796  0.11297170  0.41745551  0.56351882  0.33920535  0.41745551
       [889] -0.36989902  0.20498604  0.57410507 -0.19547719  0.57410507  0.34145263
       [895]  0.41522327  0.56351882 -0.31205490  0.16310381 -0.65854737  0.33920535
       [901] -0.58254449 -0.31205490  0.21334351  0.68794510  0.26731570 -0.26397097
       [907]  0.26731570  0.41522327  0.68794510  0.20498604  0.33920535 -0.36989902
       [913] -0.58477673  0.41745551 -0.36989902  0.20498604  0.63010098  0.56351882
       [919]  0.41522327  0.11297170 -0.58477673  0.64320058 -0.42589493 -0.50256204
       [925]  0.33920535 -0.19547719  0.41745551  0.41522327  0.49743796 -0.58477673
       [931]  0.26731570  0.21334351  0.41745551 -0.42589493 -0.58254449 -0.36989902
       [937] -0.58477673 -0.72676320 -0.19547719 -0.73268430 -0.50933859 -0.42589493
       [943] -0.36989902  0.11297170 -0.31205490 -0.58477673 -0.19547719 -0.25003843
       [949]  0.41745551  0.49743796  0.41522327  0.49066141 -0.36989902  0.11297170
       [955]  0.33920535  0.80452281 -0.50256204 -0.50933859  0.77455508  0.15360150
       [961]  0.21334351 -0.26397097  0.80452281 -0.66079465 -0.22544492 -0.22544492
       [967] -0.43648118  0.34145263  0.56351882  0.73602903  0.63010098 -0.17269890
       [973] -0.58254449 -0.72676320 -0.36989902  0.33920535 -0.72676320  0.27323680
       [979]  0.33920535 -0.73268430  0.34145263  0.08189300 -0.58254449 -0.79501396
       [985]  0.77455508 -0.66079465 -0.58254449 -0.26397097  0.49066141  0.41522327
       [991] -0.13399720  0.41522327  0.49066141 -0.36989902  0.26731570 -0.35679942
       [997] -0.91810700 -0.36989902  0.11297170  0.33920535  0.41745551  0.64320058
      [1003] -0.22544492  0.57410507  0.26731570 -0.29790303  0.04176152 -0.66079465
      [1009]  0.41522327  0.49743796 -0.22544492 -0.66079465 -0.16324988  0.56351882
      [1015]  0.41745551  0.73602903  0.82730110  0.26731570 -0.35679942  0.41745551
      [1021]  0.26731570 -0.42589493  0.08189300  0.57410507  0.34145263  0.56351882
      [1027]  0.33920535  0.77455508 -0.31205490  0.33920535 -0.42589493  0.41522327
      [1033]  0.49066141 -0.19547719  0.27323680 -0.58254449 -0.15568743 -0.42589493
      [1039] -0.73268430 -0.18425986  0.33920535  0.63010098 -0.42589493 -0.65854737
      [1045]  0.34145263 -0.66079465 -0.31205490  0.64320058 -0.36989902  0.20498604
      [1051] -0.26397097  0.68794510 -0.66079465 -0.42589493  0.49066141 -0.43648118
      [1057]  0.74996157  0.56351882 -0.36989902  0.63010098 -0.29790303  0.64320058
      [1063]  0.41522327  0.49743796  0.26731570  0.26731570  0.20498604  0.15360150
      [1069] -0.35679942 -0.66079465 -0.43648118 -0.42589493 -0.43648118 -0.15568743
      [1075]  0.20498604  0.20498604 -0.14314911  0.77455508 -0.50256204 -0.26397097
      [1081]  0.57410507  0.77455508  0.05871756 -0.17269890  0.49743796  0.73602903
      [1087] -0.25003843  0.49743796 -0.21262457  0.57410507  0.41522327  0.20498604
      [1093] -0.88702830  0.20498604 -0.66079465 -0.50933859 -0.58477673  0.80452281
      [1099]  0.68794510  0.68794510  0.05871756 -0.25003843  0.26731570  0.73602903
      [1105] -0.72676320 -0.58477673 -0.31205490  0.57410507  0.49066141  0.57410507
      [1111]  0.41522327 -0.43648118 -0.36989902 -0.25003843 -0.73268430  0.34145263
      [1117]  0.49743796  0.33920535  0.49066141  0.20498604  0.11297170  0.26731570
      [1123]  0.49743796  0.33920535  0.41745551  0.41745551 -0.35679942  0.63010098
      [1129]  0.57410507  0.33920535 -0.17269890 -0.36989902  0.16310381 -0.42589493
      [1135]  0.11297170  0.57410507 -0.29790303 -0.50256204  0.74996157  0.41745551
      [1141] -0.36989902 -0.17269890 -0.36989902  0.63010098  0.41522327 -0.58477673
      [1147]  0.20498604 -0.50933859 -0.36989902 -0.43648118  0.33920535 -0.25003843
      [1153] -0.25003843 -0.22544492 -0.79501396  0.08189300  0.11297170 -0.43648118
      [1159]  0.08189300 -0.73268430 -0.21262457 -0.22544492  0.49743796  0.27323680
      [1165]  0.26731570 -0.21262457 -0.50256204  0.77455508  0.49743796 -0.73268430
      [1171]  0.57410507 -0.42589493  0.70209697  0.09081937  0.05871756 -0.72676320
      [1177] -0.79501396  0.49066141 -0.15568743  0.41745551  0.20498604 -0.50256204
      [1183]  0.49743796 -0.66079465 -0.43648118 -0.58254449 -0.31205490  0.41522327
      [1189] -0.50933859  0.57410507  0.33920535  0.12255046 -0.78665649  0.49066141
      [1195]  0.20498604  0.68794510 -0.79501396  0.56351882  0.74996157  0.21334351
      [1201]  0.34145263  0.41522327 -0.35679942  0.33920535 -0.42589493  0.11297170
      [1207]  0.08189300 -0.26397097  0.08189300  0.68794510  0.68794510 -0.66079465
      [1213] -0.36989902  0.05871756  0.63010098  0.56351882 -0.65854737 -0.65854737
      [1219] -0.83689619 -0.17269890 -0.50933859  0.20498604  0.56351882 -0.58254449
      [1225] -0.31205490  0.20498604  0.63010098 -0.72676320  0.26731570  0.56351882
      [1231]  0.49066141 -0.79501396 -0.50933859 -0.73268430  0.08189300 -0.35679942
      [1237]  0.20498604 -0.42589493 -0.73268430 -0.31205490  0.41745551  0.33920535
      [1243]  0.41745551  0.26731570 -0.72676320 -0.50256204  0.27323680 -0.58254449
      [1249]  0.05871756 -0.31205490  0.68794510 -0.31205490  0.56351882 -0.50933859
      [1255]  0.63010098 -0.22544492 -0.50933859 -0.73268430  0.49743796 -0.58254449
      [1261]  0.49066141 -0.19547719 -0.31205490  0.33920535 -0.58254449 -0.17269890
      [1267] -0.50256204  0.33920535  0.49743796 -0.29790303  0.70209697 -0.50933859
      [1273]  0.27323680 -0.35679942  0.21334351  0.26731570  0.68794510  0.15360150
      [1279] -0.43648118 -0.65854737 -0.31205490  0.08189300 -0.17269890  0.41522327
      [1285]  0.41522327 -0.25003843  0.49743796  0.05871756 -0.17269890 -0.50933859
      [1291] -0.84639850 -0.17269890  0.41522327  0.34145263 -0.66079465 -0.43648118
      [1297]  0.34145263  0.15360150  0.63010098 -0.58477673  0.20498604 -0.17269890
      [1303]  0.20498604 -0.31205490  0.21334351 -0.66079465 -0.26397097 -0.58254449
      [1309] -0.50256204  0.15360150  0.15360150  0.57410507 -0.36989902  0.77455508
      [1315] -0.50933859 -0.73268430  0.20498604  0.11297170  0.27323680  0.33920535
      [1321]  0.41522327  0.63010098 -0.50256204  0.20498604 -0.65854737 -0.26397097
      [1327]  0.68794510  0.49066141  0.15360150  0.70209697  0.34145263 -0.50256204
      [1333] -0.73268430  0.63010098 -0.50256204  0.20498604  0.73602903  0.41745551
      [1339]  0.20498604  0.73602903  0.68794510  0.08189300  0.41745551 -0.29790303
      [1345]  0.41745551 -0.43648118 -0.50256204  0.77455508 -0.31205490  0.49066141
      [1351]  0.63010098 -0.50256204  0.11297170  0.21334351 -0.35679942  0.41522327
      [1357] -0.50933859  0.41745551  0.21334351  0.15360150 -0.26397097  0.33920535
      [1363]  0.41745551  0.77455508  0.49066141  0.33920535  0.08189300  0.63010098
      [1369]  0.33920535  0.08189300  0.34145263  0.33920535  0.09081937 -0.31205490
      [1375]  0.56351882  0.49066141  0.20498604 -0.43648118 -0.58254449 -0.42589493
      [1381] -0.22544492 -0.50256204 -0.58254449 -0.19547719  0.20498604 -0.31205490
      [1387] -0.36989902 -0.19547719 -0.15568743  0.20498604  0.49066141 -0.50933859
      [1393]  0.26731570  0.21334351  0.21334351  0.26731570 -0.42589493  0.41522327
      [1399] -0.43648118 -0.21262457  0.20498604  0.02952789 -0.42589493  0.20498604
      [1405] -0.36989902  0.63010098 -0.66079465 -0.50933859  0.12255046  0.20498604
      [1411] -0.25003843  0.49743796 -0.26397097 -0.35679942 -0.42589493 -0.91810700
      [1417]  0.34145263 -0.73268430 -0.21262457 -0.58477673 -0.31205490  0.49066141
      [1423]  0.56351882  0.15360150  0.33920535  0.26731570  0.33920535 -0.29790303
      [1429] -0.42589493 -0.19547719 -0.72676320 -0.31205490  0.41745551  0.49743796
      [1435] -0.42589493  0.80452281 -0.73268430  0.04176152  0.26731570  0.49743796
      [1441]  0.80452281 -0.73268430 -0.58477673  0.41745551  0.15360150 -0.26397097
      [1447]  0.21334351  0.64320058  0.33920535  0.27323680 -0.88702830 -0.43648118
      [1453] -0.36989902  0.57410507  0.41522327  0.34145263 -0.73268430 -0.31205490
      [1459]  0.49066141 -0.25003843  0.49743796 -0.58477673  0.68794510  0.73602903
      [1465]  0.20498604  0.49066141  0.49066141 -0.50933859 -0.66079465  0.80452281
      [1471] -0.50256204  0.16310381 -0.21262457  0.20498604 -0.36989902 -0.29790303
      [1477] -0.73268430 -0.15568743  0.15360150  0.26731570  0.63010098 -0.84639850
      [1483]  0.63010098  0.04176152  0.56351882 -0.50933859 -0.29790303  0.27323680
      [1489]  0.56351882 -0.66079465  0.33920535 -0.31205490 -0.50933859  0.26731570
      [1495] -0.58254449 -0.36989902 -0.43648118  0.20498604  0.33920535 -0.58254449
      [1501]  0.26731570 -0.50933859  0.08189300  0.80452281  0.20498604 -0.66079465
      [1507] -0.22544492 -0.50933859 -0.19547719 -0.50933859 -0.26397097 -0.43648118
      [1513]  0.63010098 -0.26397097  0.41745551  0.57410507 -0.58254449  0.49743796
      [1519] -0.17269890  0.26731570 -0.43648118  0.34145263  0.49743796  0.20498604
      [1525] -0.50933859  0.33920535 -0.25003843  0.33920535 -0.58254449  0.33920535
      [1531]  0.57410507  0.21334351  0.26731570 -0.43648118 -0.31205490  0.05871756
      [1537] -0.26397097  0.49743796  0.33920535  0.41745551  0.15360150 -0.66079465
      [1543] -0.25003843 -0.36989902  0.15360150  0.15360150 -0.31205490  0.33920535
      [1549] -0.66079465 -0.17269890  0.73602903 -0.22544492 -0.29790303  0.63010098
      [1555] -0.43648118 -0.31205490  0.41522327  0.77455508  0.34145263  0.64320058
      [1561] -0.18425986  0.41522327 -0.94128244  0.41522327  0.34145263  0.33920535
      [1567]  0.49743796 -0.94128244  0.82730110 -0.43648118  0.20498604  0.34145263
      [1573]  0.26731570 -0.43648118 -0.36989902  0.41522327 -0.31205490 -0.58477673
      [1579]  0.41522327 -0.84639850 -0.25003843 -0.36989902  0.16310381  0.82730110
      [1585]  0.11297170  0.27323680 -0.58477673 -0.29790303 -0.19547719  0.26731570
      [1591]  0.26731570 -0.35679942  0.41522327 -0.26397097 -0.58477673 -0.50933859
      [1597] -0.79501396 -0.26397097  0.20498604 -0.50933859  0.41522327  0.02952789
      [1603] -0.16324988 -0.36989902  0.33920535  0.26731570  0.63010098 -0.36989902
      [1609] -0.29790303  0.49066141  0.41745551 -0.36989902  0.26731570  0.74996157
      [1615]  0.11297170 -0.58254449  0.49066141 -0.26397097 -0.43648118 -0.19547719
      [1621] -0.58477673  0.20498604  0.41745551  0.49066141 -0.35679942  0.78737543
      [1627]  0.33920535  0.26731570  0.11297170 -0.73268430  0.41745551 -0.42589493
      [1633]  0.49066141 -0.66079465 -0.26397097 -0.73268430  0.26731570 -0.73268430
      [1639] -0.31205490  0.49066141  0.11297170 -0.66079465  0.57410507  0.33920535
      [1645] -0.50933859  0.20498604  0.70209697 -0.73268430 -0.50256204  0.49743796
      [1651]  0.68794510  0.20498604 -0.31205490 -0.50933859  0.56351882  0.41745551
      [1657] -0.26397097  0.56351882 -0.19547719 -0.79501396 -0.65854737  0.20498604
      [1663]  0.05871756 -0.50933859  0.70209697  0.49066141  0.41522327  0.15360150
      [1669] -0.14314911  0.33920535 -0.31205490  0.68794510 -0.50256204  0.78737543
      [1675] -0.42589493 -0.50256204 -0.73268430 -0.50933859  0.49066141  0.26731570
      [1681] -0.42589493 -0.29790303 -0.58254449  0.26731570  0.49743796 -0.42589493
      [1687]  0.73602903 -0.26397097  0.77455508  0.27323680 -0.36989902  0.41745551
      [1693]  0.49743796 -0.25003843  0.34145263 -0.31205490  0.63010098  0.34145263
      [1699] -0.43648118  0.56351882 -0.15568743 -0.14314911  0.41745551 -0.50256204
      [1705] -0.36989902 -0.26397097  0.27323680  0.33920535 -0.91810700 -0.58254449
      [1711] -0.19547719  0.64320058 -0.26397097 -0.58254449 -0.31205490 -0.43648118
      [1717]  0.05871756 -0.50256204 -0.22544492 -0.26397097  0.33920535 -0.22544492
      [1723] -0.73268430 -0.36989902  0.49066141  0.34145263  0.41522327 -0.22544492
      [1729]  0.41522327 -0.19547719 -0.36989902  0.56351882  0.15360150  0.41745551
      [1735]  0.33920535 -0.50933859 -0.17269890 -0.65854737 -0.26397097  0.49066141
      [1741] -0.58477673 -0.29790303 -0.43648118  0.02952789  0.49066141 -0.36989902
      [1747] -0.26397097 -0.31205490  0.15360150 -0.17269890 -0.42589493  0.26731570
      [1753] -0.26397097  0.04176152  0.68794510  0.34145263 -0.50256204 -0.26397097
      [1759] -0.31205490  0.27323680  0.15360150 -0.25003843 -0.31205490  0.49743796
      [1765]  0.41522327  0.12255046  0.04176152  0.33920535 -0.50933859  0.15360150
      [1771] -0.35679942 -0.29790303  0.20498604  0.41522327 -0.18425986  0.11297170
      [1777] -0.66079465  0.56351882 -0.22544492  0.63010098  0.21334351 -0.29790303
      [1783]  0.73602903  0.49066141 -0.21262457 -0.17269890 -0.36989902  0.34145263
      [1789]  0.20498604  0.20498604 -0.42589493  0.41522327 -0.79501396  0.41522327
      [1795]  0.05871756  0.34145263  0.63010098  0.20498604  0.41522327  0.41745551
      [1801] -0.31205490 -0.58477673  0.21334351 -0.31205490 -0.58254449 -0.58254449
      [1807]  0.64320058  0.49743796 -0.43648118 -0.58254449 -0.42589493  0.11297170
      [1813] -0.31205490  0.49066141 -0.21262457 -0.36989902  0.15360150 -0.22544492
      [1819]  0.33920535  0.77455508  0.63010098  0.08189300  0.56351882  0.68794510
      [1825] -0.22544492 -0.26397097  0.26731570 -0.78665649  0.82730110 -0.17269890
      [1831] -0.58254449  0.49066141  0.33920535 -0.36989902 -0.22544492 -0.29790303
      [1837]  0.49066141 -0.35679942 -0.43648118 -0.50933859 -0.50256204  0.26731570
      [1843]  0.21334351 -0.36989902  0.49743796  0.21334351  0.33920535 -0.17269890
      [1849] -0.66079465 -0.19547719 -0.50256204 -0.26397097 -0.26397097  0.33920535
      [1855] -0.58477673  0.15360150 -0.22544492 -0.31205490 -0.58254449  0.56351882
      [1861] -0.43648118 -0.35679942 -0.21262457 -0.22544492  0.68794510  0.20498604
      [1867]  0.20498604  0.56351882 -0.26397097 -0.58477673 -0.65854737 -0.58254449
      [1873]  0.15360150 -0.66079465  0.34145263  0.63010098  0.64320058  0.34145263
      [1879]  0.33920535  0.20498604  0.11297170 -0.58254449 -0.36989902 -0.29790303
      [1885]  0.27323680 -0.65854737  0.26731570  0.56351882 -0.65854737  0.57410507
      [1891] -0.17269890  0.49743796 -0.19547719  0.49066141  0.57410507 -0.50256204
      [1897]  0.41745551 -0.58254449  0.15360150 -0.58254449 -0.43648118 -0.58477673
      [1903]  0.33920535 -0.31205490  0.26731570 -0.72676320 -0.29790303  0.26731570
      [1909]  0.26731570 -0.31205490  0.26731570  0.33920535 -0.31205490  0.15360150
      [1915]  0.63010098 -0.50256204  0.27323680  0.20498604 -0.31205490  0.26731570
      [1921] -0.36989902  0.63010098 -0.19547719 -0.17269890  0.08189300 -0.26397097
      [1927]  0.41745551  0.64320058  0.34145263  0.57410507 -0.25003843  0.49066141
      [1933]  0.33920535 -0.26397097 -0.50256204 -0.50933859  0.15360150  0.73602903
      [1939] -0.25003843  0.41745551  0.56351882  0.49066141  0.33920535 -0.22544492
      [1945] -0.43648118  0.11297170 -0.58477673  0.26731570  0.26731570 -0.31205490
      [1951]  0.34145263  0.09081937  0.70209697  0.27323680 -0.50256204 -0.42589493
      [1957]  0.33920535  0.68794510  0.26731570  0.26731570 -0.35679942  0.15360150
      [1963] -0.50933859  0.41522327 -0.58254449  0.64320058  0.34145263  0.27323680
      [1969] -0.43648118  0.15360150  0.41522327 -0.58254449  0.41745551 -0.19547719
      [1975] -0.58254449  0.26731570 -0.50256204 -0.42589493 -0.31205490 -0.15568743
      [1981] -0.35679942  0.33920535 -0.50933859  0.64320058 -0.26397097  0.64320058
      [1987]  0.56351882  0.26731570  0.70209697  0.16310381  0.68794510  0.33920535
      [1993] -0.29790303  0.26731570  0.16310381 -0.50933859 -0.43648118  0.26731570
      [1999]  0.26731570  0.27323680
      attr(,"label")
      [1] "Residuals"

---

    Code
      (fit_mle <- estimNLR(y = y, match = match, group = group, formula = M$M1$
      formula, method = "mle", lower = M$M1$lower, upper = M$M1$upper, start = start))
    Output
      Nonlinear regression model 
      
       Model:  y ~ c + (1 - c)/(1 + exp(-(a + aDif * g) * (x - (b + bDif * g)))) 
      
      Coefficients:
            a       b       c    aDif    bDif 
       1.0779 -0.3469  0.0893 -0.0626  0.9235 
      
       Maximum likelihood estimation using the L-BFGS-B algorithm 
      Converged after 23 iterations

---

    Code
      coef(fit_mle)
    Output
                a           b           c        aDif        bDif 
       1.07785356 -0.34693642  0.08925326 -0.06260473  0.92348995 

---

    Code
      logLik(fit_mle)
    Output
      'log Lik.' -1191.904 (df=5)

---

    Code
      vcov(fit_mle)
    Output
                      a            b            c          aDif          bDif
      a     0.015987675  0.017897665 0.0066068809 -0.0000986350 -0.0013822815
      b     0.017897665  0.040677309 0.0148394967  0.0177901835 -0.0035826532
      c     0.006606881  0.014839497 0.0063269453  0.0086089359  0.0009761246
      aDif -0.000098635  0.017790183 0.0086089359  0.0311452397  0.0007864552
      bDif -0.001382282 -0.003582653 0.0009761246  0.0007864552  0.0132645725

---

    Code
      fitted(fit_mle)
    Output
         [1] 0.48169035 0.75898307 0.82965505 0.25930609 0.74378849 0.32185597
         [7] 0.54259783 0.44328898 0.74378849 0.75898307 0.78992426 0.71157291
        [13] 0.48169035 0.50772217 0.69147792 0.38070900 0.57189984 0.71157291
        [19] 0.48169035 0.36321785 0.44328898 0.80078200 0.82965505 0.78992426
        [25] 0.63374625 0.50772217 0.75898307 0.50772217 0.71157291 0.30884991
        [31] 0.50772217 0.65902646 0.74378849 0.36321785 0.48169035 0.54259783
        [37] 0.63374625 0.78992426 0.50772217 0.60225793 0.30884991 0.50772217
        [43] 0.50772217 0.74378849 0.74378849 0.48169035 0.36321785 0.50772217
        [49] 0.25930609 0.54259783 0.54259783 0.30884991 0.17686525 0.54259783
        [55] 0.36321785 0.57189984 0.36321785 0.54259783 0.54259783 0.54259783
        [61] 0.86753558 0.63374625 0.36321785 0.25930609 0.65902646 0.69147792
        [67] 0.25930609 0.69147792 0.11651182 0.89096300 0.44328898 0.25930609
        [73] 0.48169035 0.57189984 0.50772217 0.25930609 0.65902646 0.26816137
        [79] 0.36321785 0.50772217 0.54259783 0.57189984 0.25930609 0.38070900
        [85] 0.50772217 0.65902646 0.32185597 0.38070900 0.48169035 0.69147792
        [91] 0.32185597 0.71157291 0.48169035 0.71157291 0.30884991 0.25930609
        [97] 0.42132217 0.78992426 0.30884991 0.83688972 0.91367307 0.54259783
       [103] 0.54259783 0.63374625 0.42132217 0.22051175 0.74378849 0.74378849
       [109] 0.63374625 0.17686525 0.65902646 0.48169035 0.42132217 0.78992426
       [115] 0.36321785 0.57189984 0.36321785 0.82965505 0.25930609 0.48169035
       [121] 0.75898307 0.48169035 0.30884991 0.78992426 0.30884991 0.50772217
       [127] 0.30884991 0.26816137 0.30884991 0.32185597 0.48169035 0.44328898
       [133] 0.44328898 0.78992426 0.42132217 0.42132217 0.17925513 0.60225793
       [139] 0.69147792 0.78992426 0.42132217 0.21523480 0.32185597 0.74378849
       [145] 0.50772217 0.63374625 0.86317327 0.69147792 0.25930609 0.36321785
       [151] 0.30884991 0.25930609 0.63374625 0.48169035 0.78992426 0.38070900
       [157] 0.25930609 0.86317327 0.89096300 0.42132217 0.44328898 0.54259783
       [163] 0.86317327 0.17686525 0.44328898 0.48169035 0.63374625 0.86317327
       [169] 0.30884991 0.74378849 0.32185597 0.63374625 0.60225793 0.57189984
       [175] 0.69147792 0.44328898 0.48169035 0.75898307 0.82965505 0.21523480
       [181] 0.42132217 0.82965505 0.86317327 0.80078200 0.60225793 0.50772217
       [187] 0.82965505 0.38070900 0.14407997 0.69147792 0.36321785 0.50772217
       [193] 0.69147792 0.17686525 0.86317327 0.57189984 0.57189984 0.63374625
       [199] 0.74378849 0.48169035 0.36321785 0.57189984 0.26816137 0.74378849
       [205] 0.82965505 0.69147792 0.69147792 0.48169035 0.74378849 0.42132217
       [211] 0.60225793 0.42132217 0.26816137 0.54259783 0.21523480 0.32185597
       [217] 0.69147792 0.74378849 0.89096300 0.69147792 0.60225793 0.42132217
       [223] 0.42132217 0.69147792 0.42132217 0.44328898 0.69147792 0.50772217
       [229] 0.57189984 0.54259783 0.38070900 0.86317327 0.82965505 0.38070900
       [235] 0.78992426 0.69147792 0.57189984 0.89096300 0.36321785 0.86317327
       [241] 0.69147792 0.65902646 0.63374625 0.48169035 0.50772217 0.36321785
       [247] 0.48169035 0.57189984 0.60225793 0.36321785 0.78992426 0.50772217
       [253] 0.74378849 0.63374625 0.60225793 0.60225793 0.63374625 0.48169035
       [259] 0.71157291 0.74378849 0.11651182 0.65902646 0.38070900 0.30884991
       [265] 0.63374625 0.57189984 0.78992426 0.48169035 0.75898307 0.17686525
       [271] 0.48169035 0.63374625 0.74378849 0.38070900 0.86317327 0.36321785
       [277] 0.54259783 0.21523480 0.38070900 0.54259783 0.30884991 0.69147792
       [283] 0.57189984 0.44328898 0.60225793 0.75898307 0.50772217 0.74378849
       [289] 0.89096300 0.44328898 0.44328898 0.30884991 0.36321785 0.57189984
       [295] 0.48169035 0.78992426 0.60225793 0.50772217 0.60225793 0.78992426
       [301] 0.60225793 0.42132217 0.38070900 0.26816137 0.63374625 0.86317327
       [307] 0.74378849 0.86317327 0.44328898 0.42132217 0.63374625 0.30884991
       [313] 0.48169035 0.54259783 0.83688972 0.74378849 0.54259783 0.65902646
       [319] 0.57189984 0.36321785 0.30884991 0.54259783 0.69147792 0.09364144
       [325] 0.65902646 0.69147792 0.38070900 0.74378849 0.69147792 0.17686525
       [331] 0.36321785 0.42132217 0.48169035 0.30884991 0.82965505 0.50772217
       [337] 0.57189984 0.48169035 0.63374625 0.42132217 0.63374625 0.60225793
       [343] 0.74378849 0.69147792 0.50772217 0.50772217 0.48169035 0.44328898
       [349] 0.78992426 0.30884991 0.21523480 0.78992426 0.57189984 0.63374625
       [355] 0.32185597 0.78992426 0.54259783 0.30884991 0.32185597 0.44328898
       [361] 0.75898307 0.30884991 0.54259783 0.32185597 0.82965505 0.48169035
       [367] 0.38070900 0.36321785 0.30884991 0.60225793 0.38070900 0.54259783
       [373] 0.25930609 0.44328898 0.57189984 0.36321785 0.17686525 0.69147792
       [379] 0.50772217 0.74378849 0.78992426 0.54259783 0.44328898 0.57189984
       [385] 0.63374625 0.89096300 0.50772217 0.93201404 0.38070900 0.14407997
       [391] 0.36321785 0.42132217 0.71157291 0.54259783 0.50772217 0.42132217
       [397] 0.44328898 0.80078200 0.80078200 0.78992426 0.26816137 0.36321785
       [403] 0.48169035 0.78992426 0.86317327 0.42132217 0.54259783 0.60225793
       [409] 0.48169035 0.80078200 0.65902646 0.48169035 0.74378849 0.44328898
       [415] 0.57189984 0.21523480 0.54259783 0.32185597 0.44328898 0.14407997
       [421] 0.36321785 0.65902646 0.48169035 0.48169035 0.54259783 0.38070900
       [427] 0.65902646 0.65902646 0.54259783 0.50772217 0.42132217 0.48169035
       [433] 0.50772217 0.78992426 0.36321785 0.75898307 0.74378849 0.30884991
       [439] 0.26816137 0.54259783 0.60225793 0.54259783 0.69147792 0.25930609
       [445] 0.36321785 0.74378849 0.65902646 0.65902646 0.21523480 0.36321785
       [451] 0.60225793 0.17686525 0.80078200 0.54259783 0.50772217 0.71157291
       [457] 0.54259783 0.60225793 0.36321785 0.69147792 0.54259783 0.60225793
       [463] 0.71157291 0.74378849 0.22051175 0.30884991 0.54259783 0.69147792
       [469] 0.60225793 0.65902646 0.57189984 0.63374625 0.36321785 0.50772217
       [475] 0.74378849 0.69147792 0.38070900 0.54259783 0.54259783 0.69147792
       [481] 0.78992426 0.60225793 0.74378849 0.69147792 0.50772217 0.36321785
       [487] 0.74378849 0.63374625 0.48169035 0.65902646 0.69147792 0.25930609
       [493] 0.25930609 0.36321785 0.50772217 0.21523480 0.32185597 0.60225793
       [499] 0.50772217 0.75898307 0.78992426 0.26816137 0.42132217 0.36321785
       [505] 0.50772217 0.44328898 0.36321785 0.48169035 0.36321785 0.36321785
       [511] 0.36321785 0.17925513 0.22051175 0.63374625 0.71157291 0.32185597
       [517] 0.42132217 0.44328898 0.30884991 0.54259783 0.57189984 0.54259783
       [523] 0.86753558 0.75898307 0.54259783 0.65902646 0.82965505 0.60225793
       [529] 0.30884991 0.78992426 0.78992426 0.60225793 0.42132217 0.44328898
       [535] 0.36321785 0.63374625 0.63374625 0.69147792 0.50772217 0.54259783
       [541] 0.30884991 0.42132217 0.65902646 0.38070900 0.50772217 0.69147792
       [547] 0.54259783 0.48169035 0.42132217 0.25930609 0.48169035 0.25930609
       [553] 0.69147792 0.48169035 0.38070900 0.48169035 0.65902646 0.30884991
       [559] 0.63374625 0.54259783 0.78992426 0.26816137 0.50772217 0.74378849
       [565] 0.48169035 0.60225793 0.30884991 0.69147792 0.86317327 0.44328898
       [571] 0.50772217 0.71157291 0.42132217 0.48169035 0.50772217 0.54259783
       [577] 0.42132217 0.69147792 0.17686525 0.42132217 0.44328898 0.21523480
       [583] 0.50772217 0.50772217 0.54259783 0.30884991 0.48169035 0.14407997
       [589] 0.74378849 0.48169035 0.82965505 0.22051175 0.38070900 0.57189984
       [595] 0.50772217 0.50772217 0.48169035 0.25930609 0.60225793 0.63374625
       [601] 0.30884991 0.26816137 0.42132217 0.30884991 0.36321785 0.69147792
       [607] 0.78992426 0.69147792 0.75898307 0.60225793 0.63374625 0.60225793
       [613] 0.57189984 0.75898307 0.48169035 0.14407997 0.50772217 0.14407997
       [619] 0.69147792 0.32185597 0.48169035 0.21523480 0.48169035 0.48169035
       [625] 0.42132217 0.21523480 0.74378849 0.44328898 0.82965505 0.69147792
       [631] 0.25930609 0.63374625 0.57189984 0.74378849 0.69147792 0.78992426
       [637] 0.63374625 0.69147792 0.57189984 0.82965505 0.44328898 0.57189984
       [643] 0.57189984 0.60225793 0.25930609 0.38070900 0.36321785 0.38070900
       [649] 0.44328898 0.50772217 0.83688972 0.44328898 0.69147792 0.69147792
       [655] 0.63374625 0.48169035 0.74378849 0.69147792 0.21523480 0.69147792
       [661] 0.36321785 0.74378849 0.30884991 0.36321785 0.36321785 0.93201404
       [667] 0.57189984 0.63374625 0.32185597 0.25930609 0.42132217 0.60225793
       [673] 0.48169035 0.36321785 0.69147792 0.60225793 0.21523480 0.48169035
       [679] 0.36321785 0.48169035 0.17686525 0.44328898 0.36321785 0.14407997
       [685] 0.63374625 0.82965505 0.48169035 0.80078200 0.36321785 0.42132217
       [691] 0.78992426 0.54259783 0.50772217 0.54259783 0.26816137 0.74378849
       [697] 0.74378849 0.50772217 0.30884991 0.74378849 0.26816137 0.30884991
       [703] 0.86317327 0.30884991 0.42132217 0.32185597 0.74378849 0.44328898
       [709] 0.44328898 0.36321785 0.14407997 0.82965505 0.74378849 0.57189984
       [715] 0.54259783 0.54259783 0.57189984 0.21523480 0.36321785 0.50772217
       [721] 0.54259783 0.44328898 0.50772217 0.57189984 0.78992426 0.71157291
       [727] 0.21523480 0.42132217 0.54259783 0.63374625 0.42132217 0.69147792
       [733] 0.57189984 0.42132217 0.65902646 0.42132217 0.69147792 0.25930609
       [739] 0.38070900 0.80078200 0.54259783 0.60225793 0.80078200 0.69147792
       [745] 0.36321785 0.54259783 0.26816137 0.82965505 0.71157291 0.32185597
       [751] 0.71157291 0.60225793 0.60225793 0.63374625 0.50772217 0.69147792
       [757] 0.44328898 0.42132217 0.63374625 0.89096300 0.25930609 0.42132217
       [763] 0.65902646 0.17686525 0.30884991 0.36321785 0.50772217 0.57189984
       [769] 0.50772217 0.38070900 0.38070900 0.82965505 0.69147792 0.54259783
       [775] 0.36321785 0.38070900 0.65902646 0.69147792 0.42132217 0.78992426
       [781] 0.63374625 0.38070900 0.74378849 0.42132217 0.44328898 0.36321785
       [787] 0.30884991 0.50772217 0.50772217 0.60225793 0.32185597 0.78992426
       [793] 0.50772217 0.69147792 0.21523480 0.50772217 0.48169035 0.57189984
       [799] 0.38070900 0.30884991 0.57189984 0.57189984 0.74378849 0.80078200
       [805] 0.71157291 0.69147792 0.36321785 0.44328898 0.30884991 0.80078200
       [811] 0.78992426 0.54259783 0.71157291 0.74378849 0.30884991 0.44328898
       [817] 0.25930609 0.54259783 0.48169035 0.21523480 0.74378849 0.69147792
       [823] 0.74378849 0.82965505 0.82965505 0.42132217 0.44328898 0.21523480
       [829] 0.50772217 0.48169035 0.25930609 0.26816137 0.54259783 0.54259783
       [835] 0.36321785 0.25930609 0.48169035 0.38070900 0.78992426 0.60225793
       [841] 0.63374625 0.44328898 0.69147792 0.32185597 0.60225793 0.42132217
       [847] 0.30884991 0.30884991 0.69147792 0.17686525 0.50772217 0.44328898
       [853] 0.57189984 0.26816137 0.57189984 0.42132217 0.54259783 0.57189984
       [859] 0.54259783 0.69147792 0.54259783 0.69147792 0.65902646 0.75898307
       [865] 0.48169035 0.60225793 0.80078200 0.54259783 0.57189984 0.30884991
       [871] 0.57189984 0.82965505 0.63374625 0.42132217 0.86317327 0.69147792
       [877] 0.57189984 0.38070900 0.48169035 0.65902646 0.42132217 0.21523480
       [883] 0.50772217 0.82965505 0.57189984 0.48169035 0.63374625 0.57189984
       [889] 0.42132217 0.74378849 0.44328898 0.21523480 0.44328898 0.65902646
       [895] 0.60225793 0.48169035 0.36321785 0.80078200 0.65902646 0.63374625
       [901] 0.57189984 0.36321785 0.75898307 0.36321785 0.69147792 0.30884991
       [907] 0.69147792 0.60225793 0.36321785 0.74378849 0.63374625 0.42132217
       [913] 0.60225793 0.57189984 0.42132217 0.74378849 0.42132217 0.48169035
       [919] 0.60225793 0.82965505 0.60225793 0.38070900 0.44328898 0.50772217
       [925] 0.63374625 0.21523480 0.57189984 0.60225793 0.50772217 0.60225793
       [931] 0.69147792 0.75898307 0.57189984 0.44328898 0.57189984 0.42132217
       [937] 0.60225793 0.71157291 0.21523480 0.69147792 0.54259783 0.44328898
       [943] 0.42132217 0.82965505 0.36321785 0.60225793 0.21523480 0.26816137
       [949] 0.57189984 0.50772217 0.60225793 0.54259783 0.42132217 0.82965505
       [955] 0.63374625 0.21523480 0.50772217 0.54259783 0.25930609 0.78992426
       [961] 0.75898307 0.30884991 0.21523480 0.63374625 0.25930609 0.25930609
       [967] 0.48169035 0.65902646 0.48169035 0.30884991 0.42132217 0.17686525
       [973] 0.57189984 0.71157291 0.42132217 0.63374625 0.71157291 0.71157291
       [979] 0.63374625 0.69147792 0.65902646 0.86317327 0.57189984 0.74378849
       [985] 0.25930609 0.63374625 0.57189984 0.30884991 0.54259783 0.60225793
       [991] 0.09364144 0.60225793 0.54259783 0.42132217 0.69147792 0.38070900
       [997] 0.86317327 0.42132217 0.82965505 0.63374625 0.57189984 0.38070900
      [1003] 0.25930609 0.44328898 0.69147792 0.32185597 0.91367307 0.63374625
      [1009] 0.60225793 0.50772217 0.25930609 0.63374625 0.14428859 0.48169035
      [1015] 0.57189984 0.30884991 0.17686525 0.69147792 0.38070900 0.57189984
      [1021] 0.69147792 0.44328898 0.86317327 0.44328898 0.65902646 0.48169035
      [1027] 0.63374625 0.25930609 0.36321785 0.63374625 0.44328898 0.60225793
      [1033] 0.54259783 0.21523480 0.71157291 0.57189984 0.14407997 0.44328898
      [1039] 0.69147792 0.17925513 0.63374625 0.42132217 0.44328898 0.65902646
      [1045] 0.65902646 0.63374625 0.36321785 0.38070900 0.42132217 0.74378849
      [1051] 0.30884991 0.36321785 0.63374625 0.44328898 0.54259783 0.48169035
      [1057] 0.26816137 0.48169035 0.42132217 0.42132217 0.32185597 0.38070900
      [1063] 0.60225793 0.50772217 0.69147792 0.69147792 0.74378849 0.78992426
      [1069] 0.38070900 0.63374625 0.48169035 0.44328898 0.48169035 0.14407997
      [1075] 0.74378849 0.74378849 0.11651182 0.25930609 0.50772217 0.30884991
      [1081] 0.44328898 0.25930609 0.89096300 0.17686525 0.50772217 0.30884991
      [1087] 0.26816137 0.50772217 0.22051175 0.44328898 0.60225793 0.74378849
      [1093] 0.82965505 0.74378849 0.63374625 0.54259783 0.60225793 0.21523480
      [1099] 0.36321785 0.36321785 0.89096300 0.26816137 0.69147792 0.30884991
      [1105] 0.71157291 0.60225793 0.36321785 0.44328898 0.54259783 0.44328898
      [1111] 0.60225793 0.48169035 0.42132217 0.26816137 0.69147792 0.65902646
      [1117] 0.50772217 0.63374625 0.54259783 0.74378849 0.82965505 0.69147792
      [1123] 0.50772217 0.63374625 0.57189984 0.57189984 0.38070900 0.42132217
      [1129] 0.44328898 0.63374625 0.17686525 0.42132217 0.80078200 0.44328898
      [1135] 0.82965505 0.44328898 0.32185597 0.50772217 0.26816137 0.57189984
      [1141] 0.42132217 0.17686525 0.42132217 0.42132217 0.60225793 0.60225793
      [1147] 0.74378849 0.54259783 0.42132217 0.48169035 0.63374625 0.26816137
      [1153] 0.26816137 0.25930609 0.74378849 0.86317327 0.82965505 0.48169035
      [1159] 0.86317327 0.69147792 0.22051175 0.25930609 0.50772217 0.71157291
      [1165] 0.69147792 0.22051175 0.50772217 0.25930609 0.50772217 0.69147792
      [1171] 0.44328898 0.44328898 0.32185597 0.86753558 0.89096300 0.71157291
      [1177] 0.74378849 0.54259783 0.14407997 0.57189984 0.74378849 0.50772217
      [1183] 0.50772217 0.63374625 0.48169035 0.57189984 0.36321785 0.60225793
      [1189] 0.54259783 0.44328898 0.63374625 0.83688972 0.75898307 0.54259783
      [1195] 0.74378849 0.36321785 0.74378849 0.48169035 0.26816137 0.75898307
      [1201] 0.65902646 0.60225793 0.38070900 0.63374625 0.44328898 0.82965505
      [1207] 0.86317327 0.30884991 0.86317327 0.36321785 0.36321785 0.63374625
      [1213] 0.42132217 0.89096300 0.42132217 0.48169035 0.65902646 0.65902646
      [1219] 0.80078200 0.17686525 0.54259783 0.74378849 0.48169035 0.57189984
      [1225] 0.36321785 0.74378849 0.42132217 0.71157291 0.69147792 0.48169035
      [1231] 0.54259783 0.74378849 0.54259783 0.69147792 0.86317327 0.38070900
      [1237] 0.74378849 0.44328898 0.69147792 0.36321785 0.57189984 0.63374625
      [1243] 0.57189984 0.69147792 0.71157291 0.50772217 0.71157291 0.57189984
      [1249] 0.89096300 0.36321785 0.36321785 0.36321785 0.48169035 0.54259783
      [1255] 0.42132217 0.25930609 0.54259783 0.69147792 0.50772217 0.57189984
      [1261] 0.54259783 0.21523480 0.36321785 0.63374625 0.57189984 0.17686525
      [1267] 0.50772217 0.63374625 0.50772217 0.32185597 0.32185597 0.54259783
      [1273] 0.71157291 0.38070900 0.75898307 0.69147792 0.36321785 0.78992426
      [1279] 0.48169035 0.65902646 0.36321785 0.86317327 0.17686525 0.60225793
      [1285] 0.60225793 0.26816137 0.50772217 0.89096300 0.17686525 0.54259783
      [1291] 0.78992426 0.17686525 0.60225793 0.65902646 0.63374625 0.48169035
      [1297] 0.65902646 0.78992426 0.42132217 0.60225793 0.74378849 0.17686525
      [1303] 0.74378849 0.36321785 0.75898307 0.63374625 0.30884991 0.57189984
      [1309] 0.50772217 0.78992426 0.78992426 0.44328898 0.42132217 0.25930609
      [1315] 0.54259783 0.69147792 0.74378849 0.82965505 0.71157291 0.63374625
      [1321] 0.60225793 0.42132217 0.50772217 0.74378849 0.65902646 0.30884991
      [1327] 0.36321785 0.54259783 0.78992426 0.32185597 0.65902646 0.50772217
      [1333] 0.69147792 0.42132217 0.50772217 0.74378849 0.30884991 0.57189984
      [1339] 0.74378849 0.30884991 0.36321785 0.86317327 0.57189984 0.32185597
      [1345] 0.57189984 0.48169035 0.50772217 0.25930609 0.36321785 0.54259783
      [1351] 0.42132217 0.50772217 0.82965505 0.75898307 0.38070900 0.60225793
      [1357] 0.54259783 0.57189984 0.75898307 0.78992426 0.30884991 0.63374625
      [1363] 0.57189984 0.25930609 0.54259783 0.63374625 0.86317327 0.42132217
      [1369] 0.63374625 0.86317327 0.65902646 0.63374625 0.86753558 0.36321785
      [1375] 0.48169035 0.54259783 0.74378849 0.48169035 0.57189984 0.44328898
      [1381] 0.25930609 0.50772217 0.57189984 0.21523480 0.74378849 0.36321785
      [1387] 0.42132217 0.21523480 0.14407997 0.74378849 0.54259783 0.54259783
      [1393] 0.69147792 0.75898307 0.75898307 0.69147792 0.44328898 0.60225793
      [1399] 0.48169035 0.22051175 0.74378849 0.93201404 0.44328898 0.74378849
      [1405] 0.42132217 0.42132217 0.63374625 0.54259783 0.83688972 0.74378849
      [1411] 0.26816137 0.50772217 0.30884991 0.38070900 0.44328898 0.86317327
      [1417] 0.65902646 0.69147792 0.22051175 0.60225793 0.36321785 0.54259783
      [1423] 0.48169035 0.78992426 0.63374625 0.69147792 0.63374625 0.32185597
      [1429] 0.44328898 0.21523480 0.71157291 0.36321785 0.57189984 0.50772217
      [1435] 0.44328898 0.21523480 0.69147792 0.91367307 0.69147792 0.50772217
      [1441] 0.21523480 0.69147792 0.60225793 0.57189984 0.78992426 0.30884991
      [1447] 0.75898307 0.38070900 0.63374625 0.71157291 0.82965505 0.48169035
      [1453] 0.42132217 0.44328898 0.60225793 0.65902646 0.69147792 0.36321785
      [1459] 0.54259783 0.26816137 0.50772217 0.60225793 0.36321785 0.30884991
      [1465] 0.74378849 0.54259783 0.54259783 0.54259783 0.63374625 0.21523480
      [1471] 0.50772217 0.80078200 0.22051175 0.74378849 0.42132217 0.32185597
      [1477] 0.69147792 0.14407997 0.78992426 0.69147792 0.42132217 0.78992426
      [1483] 0.42132217 0.91367307 0.48169035 0.54259783 0.32185597 0.71157291
      [1489] 0.48169035 0.63374625 0.63374625 0.36321785 0.54259783 0.69147792
      [1495] 0.57189984 0.42132217 0.48169035 0.74378849 0.63374625 0.57189984
      [1501] 0.69147792 0.54259783 0.86317327 0.21523480 0.74378849 0.63374625
      [1507] 0.25930609 0.54259783 0.21523480 0.54259783 0.30884991 0.48169035
      [1513] 0.42132217 0.30884991 0.57189984 0.44328898 0.57189984 0.50772217
      [1519] 0.17686525 0.69147792 0.48169035 0.65902646 0.50772217 0.74378849
      [1525] 0.54259783 0.63374625 0.26816137 0.63374625 0.57189984 0.63374625
      [1531] 0.44328898 0.75898307 0.69147792 0.48169035 0.36321785 0.89096300
      [1537] 0.30884991 0.50772217 0.63374625 0.57189984 0.78992426 0.63374625
      [1543] 0.26816137 0.42132217 0.78992426 0.78992426 0.36321785 0.63374625
      [1549] 0.63374625 0.17686525 0.30884991 0.25930609 0.32185597 0.42132217
      [1555] 0.48169035 0.36321785 0.60225793 0.25930609 0.65902646 0.38070900
      [1561] 0.17925513 0.60225793 0.89096300 0.60225793 0.65902646 0.63374625
      [1567] 0.50772217 0.89096300 0.17686525 0.48169035 0.74378849 0.65902646
      [1573] 0.69147792 0.48169035 0.42132217 0.60225793 0.36321785 0.60225793
      [1579] 0.60225793 0.78992426 0.26816137 0.42132217 0.80078200 0.17686525
      [1585] 0.82965505 0.71157291 0.60225793 0.32185597 0.21523480 0.69147792
      [1591] 0.69147792 0.38070900 0.60225793 0.30884991 0.60225793 0.54259783
      [1597] 0.74378849 0.30884991 0.74378849 0.54259783 0.60225793 0.93201404
      [1603] 0.14428859 0.42132217 0.63374625 0.69147792 0.42132217 0.42132217
      [1609] 0.32185597 0.54259783 0.57189984 0.42132217 0.69147792 0.26816137
      [1615] 0.82965505 0.57189984 0.54259783 0.30884991 0.48169035 0.21523480
      [1621] 0.60225793 0.74378849 0.57189984 0.54259783 0.38070900 0.22051175
      [1627] 0.63374625 0.69147792 0.82965505 0.69147792 0.57189984 0.44328898
      [1633] 0.54259783 0.63374625 0.30884991 0.69147792 0.69147792 0.69147792
      [1639] 0.36321785 0.54259783 0.82965505 0.63374625 0.44328898 0.63374625
      [1645] 0.54259783 0.74378849 0.32185597 0.69147792 0.50772217 0.50772217
      [1651] 0.36321785 0.74378849 0.36321785 0.54259783 0.48169035 0.57189984
      [1657] 0.30884991 0.48169035 0.21523480 0.74378849 0.65902646 0.74378849
      [1663] 0.89096300 0.54259783 0.32185597 0.54259783 0.60225793 0.78992426
      [1669] 0.11651182 0.63374625 0.36321785 0.36321785 0.50772217 0.22051175
      [1675] 0.44328898 0.50772217 0.69147792 0.54259783 0.54259783 0.69147792
      [1681] 0.44328898 0.32185597 0.57189984 0.69147792 0.50772217 0.44328898
      [1687] 0.30884991 0.30884991 0.25930609 0.71157291 0.42132217 0.57189984
      [1693] 0.50772217 0.26816137 0.65902646 0.36321785 0.42132217 0.65902646
      [1699] 0.48169035 0.48169035 0.14407997 0.11651182 0.57189984 0.50772217
      [1705] 0.42132217 0.30884991 0.71157291 0.63374625 0.86317327 0.57189984
      [1711] 0.21523480 0.38070900 0.30884991 0.57189984 0.36321785 0.48169035
      [1717] 0.89096300 0.50772217 0.25930609 0.30884991 0.63374625 0.25930609
      [1723] 0.69147792 0.42132217 0.54259783 0.65902646 0.60225793 0.25930609
      [1729] 0.60225793 0.21523480 0.42132217 0.48169035 0.78992426 0.57189984
      [1735] 0.63374625 0.54259783 0.17686525 0.65902646 0.30884991 0.54259783
      [1741] 0.60225793 0.32185597 0.48169035 0.93201404 0.54259783 0.42132217
      [1747] 0.30884991 0.36321785 0.78992426 0.17686525 0.44328898 0.69147792
      [1753] 0.30884991 0.91367307 0.36321785 0.65902646 0.50772217 0.30884991
      [1759] 0.36321785 0.71157291 0.78992426 0.26816137 0.36321785 0.50772217
      [1765] 0.60225793 0.83688972 0.91367307 0.63374625 0.54259783 0.78992426
      [1771] 0.38070900 0.32185597 0.74378849 0.60225793 0.17925513 0.82965505
      [1777] 0.63374625 0.48169035 0.25930609 0.42132217 0.75898307 0.32185597
      [1783] 0.30884991 0.54259783 0.22051175 0.17686525 0.42132217 0.65902646
      [1789] 0.74378849 0.74378849 0.44328898 0.60225793 0.74378849 0.60225793
      [1795] 0.89096300 0.65902646 0.42132217 0.74378849 0.60225793 0.57189984
      [1801] 0.36321785 0.60225793 0.75898307 0.36321785 0.57189984 0.57189984
      [1807] 0.38070900 0.50772217 0.48169035 0.57189984 0.44328898 0.82965505
      [1813] 0.36321785 0.54259783 0.22051175 0.42132217 0.78992426 0.25930609
      [1819] 0.63374625 0.25930609 0.42132217 0.86317327 0.48169035 0.36321785
      [1825] 0.25930609 0.30884991 0.69147792 0.75898307 0.17686525 0.17686525
      [1831] 0.57189984 0.54259783 0.63374625 0.42132217 0.25930609 0.32185597
      [1837] 0.54259783 0.38070900 0.48169035 0.54259783 0.50772217 0.69147792
      [1843] 0.75898307 0.42132217 0.50772217 0.75898307 0.63374625 0.17686525
      [1849] 0.63374625 0.21523480 0.50772217 0.30884991 0.30884991 0.63374625
      [1855] 0.60225793 0.78992426 0.25930609 0.36321785 0.57189984 0.48169035
      [1861] 0.48169035 0.38070900 0.22051175 0.25930609 0.36321785 0.74378849
      [1867] 0.74378849 0.48169035 0.30884991 0.60225793 0.65902646 0.57189984
      [1873] 0.78992426 0.63374625 0.65902646 0.42132217 0.38070900 0.65902646
      [1879] 0.63374625 0.74378849 0.82965505 0.57189984 0.42132217 0.32185597
      [1885] 0.71157291 0.65902646 0.69147792 0.48169035 0.65902646 0.44328898
      [1891] 0.17686525 0.50772217 0.21523480 0.54259783 0.44328898 0.50772217
      [1897] 0.57189984 0.57189984 0.78992426 0.57189984 0.48169035 0.60225793
      [1903] 0.63374625 0.36321785 0.69147792 0.71157291 0.32185597 0.69147792
      [1909] 0.69147792 0.36321785 0.69147792 0.63374625 0.36321785 0.78992426
      [1915] 0.42132217 0.50772217 0.71157291 0.74378849 0.36321785 0.69147792
      [1921] 0.42132217 0.42132217 0.21523480 0.17686525 0.86317327 0.30884991
      [1927] 0.57189984 0.38070900 0.65902646 0.44328898 0.26816137 0.54259783
      [1933] 0.63374625 0.30884991 0.50772217 0.54259783 0.78992426 0.30884991
      [1939] 0.26816137 0.57189984 0.48169035 0.54259783 0.63374625 0.25930609
      [1945] 0.48169035 0.82965505 0.60225793 0.69147792 0.69147792 0.36321785
      [1951] 0.65902646 0.86753558 0.32185597 0.71157291 0.50772217 0.44328898
      [1957] 0.63374625 0.36321785 0.69147792 0.69147792 0.38070900 0.78992426
      [1963] 0.54259783 0.60225793 0.57189984 0.38070900 0.65902646 0.71157291
      [1969] 0.48169035 0.78992426 0.60225793 0.57189984 0.57189984 0.21523480
      [1975] 0.57189984 0.69147792 0.50772217 0.44328898 0.36321785 0.14407997
      [1981] 0.38070900 0.63374625 0.54259783 0.38070900 0.30884991 0.38070900
      [1987] 0.48169035 0.69147792 0.32185597 0.80078200 0.36321785 0.63374625
      [1993] 0.32185597 0.69147792 0.80078200 0.54259783 0.48169035 0.69147792
      [1999] 0.69147792 0.71157291
      attr(,"label")
      [1] "Fitted values"

---

    Code
      residuals(fit_mle)
    Output
         [1] -0.48169035  0.24101693  0.17034495 -0.25930609  0.25621151 -0.32185597
         [7]  0.45740217  0.55671102  0.25621151  0.24101693  0.21007574  0.28842709
        [13] -0.48169035 -0.50772217 -0.69147792 -0.38070900  0.42810016  0.28842709
        [19] -0.48169035 -0.36321785  0.55671102  0.19921800  0.17034495  0.21007574
        [25]  0.36625375  0.49227783  0.24101693 -0.50772217  0.28842709 -0.30884991
        [31] -0.50772217 -0.65902646 -0.74378849 -0.36321785  0.51830965 -0.54259783
        [37] -0.63374625  0.21007574  0.49227783 -0.60225793 -0.30884991  0.49227783
        [43] -0.50772217  0.25621151  0.25621151 -0.48169035 -0.36321785  0.49227783
        [49]  0.74069391 -0.54259783  0.45740217 -0.30884991  0.82313475 -0.54259783
        [55]  0.63678215  0.42810016 -0.36321785  0.45740217 -0.54259783  0.45740217
        [61]  0.13246442 -0.63374625  0.63678215 -0.25930609  0.34097354 -0.69147792
        [67] -0.25930609  0.30852208 -0.11651182  0.10903700 -0.44328898 -0.25930609
        [73]  0.51830965  0.42810016 -0.50772217  0.74069391  0.34097354 -0.26816137
        [79] -0.36321785  0.49227783  0.45740217 -0.57189984 -0.25930609 -0.38070900
        [85] -0.50772217 -0.65902646  0.67814403 -0.38070900 -0.48169035 -0.69147792
        [91] -0.32185597  0.28842709 -0.48169035  0.28842709  0.69115009 -0.25930609
        [97]  0.57867783  0.21007574 -0.30884991  0.16311028  0.08632693  0.45740217
       [103]  0.45740217  0.36625375 -0.42132217 -0.22051175  0.25621151 -0.74378849
       [109]  0.36625375 -0.17686525  0.34097354 -0.48169035  0.57867783  0.21007574
       [115] -0.36321785 -0.57189984  0.63678215  0.17034495 -0.25930609  0.51830965
       [121]  0.24101693 -0.48169035 -0.30884991  0.21007574 -0.30884991  0.49227783
       [127]  0.69115009 -0.26816137 -0.30884991 -0.32185597  0.51830965 -0.44328898
       [133] -0.44328898  0.21007574 -0.42132217 -0.42132217 -0.17925513  0.39774207
       [139]  0.30852208  0.21007574 -0.42132217  0.78476520 -0.32185597  0.25621151
       [145]  0.49227783 -0.63374625  0.13682673  0.30852208 -0.25930609  0.63678215
       [151] -0.30884991 -0.25930609  0.36625375 -0.48169035  0.21007574 -0.38070900
       [157] -0.25930609  0.13682673  0.10903700  0.57867783  0.55671102  0.45740217
       [163] -0.86317327 -0.17686525  0.55671102 -0.48169035  0.36625375 -0.86317327
       [169] -0.30884991  0.25621151 -0.32185597  0.36625375 -0.60225793  0.42810016
       [175] -0.69147792  0.55671102 -0.48169035  0.24101693  0.17034495 -0.21523480
       [181]  0.57867783  0.17034495  0.13682673  0.19921800 -0.60225793 -0.50772217
       [187]  0.17034495 -0.38070900 -0.14407997  0.30852208 -0.36321785  0.49227783
       [193]  0.30852208 -0.17686525  0.13682673  0.42810016 -0.57189984 -0.63374625
       [199]  0.25621151  0.51830965 -0.36321785  0.42810016 -0.26816137  0.25621151
       [205]  0.17034495 -0.69147792  0.30852208 -0.48169035  0.25621151 -0.42132217
       [211] -0.60225793  0.57867783  0.73183863 -0.54259783 -0.21523480 -0.32185597
       [217]  0.30852208  0.25621151  0.10903700  0.30852208  0.39774207 -0.42132217
       [223] -0.42132217 -0.69147792 -0.42132217  0.55671102  0.30852208  0.49227783
       [229]  0.42810016 -0.54259783  0.61929100  0.13682673  0.17034495  0.61929100
       [235]  0.21007574 -0.69147792  0.42810016 -0.89096300 -0.36321785  0.13682673
       [241]  0.30852208 -0.65902646  0.36625375  0.51830965  0.49227783 -0.36321785
       [247] -0.48169035 -0.57189984  0.39774207 -0.36321785  0.21007574  0.49227783
       [253]  0.25621151 -0.63374625 -0.60225793 -0.60225793  0.36625375  0.51830965
       [259]  0.28842709  0.25621151 -0.11651182  0.34097354 -0.38070900 -0.30884991
       [265]  0.36625375 -0.57189984  0.21007574 -0.48169035  0.24101693 -0.17686525
       [271] -0.48169035 -0.63374625  0.25621151 -0.38070900  0.13682673 -0.36321785
       [277] -0.54259783 -0.21523480  0.61929100 -0.54259783 -0.30884991  0.30852208
       [283]  0.42810016 -0.44328898 -0.60225793 -0.75898307  0.49227783 -0.74378849
       [289]  0.10903700 -0.44328898 -0.44328898 -0.30884991  0.63678215 -0.57189984
       [295]  0.51830965  0.21007574  0.39774207 -0.50772217  0.39774207  0.21007574
       [301]  0.39774207 -0.42132217 -0.38070900 -0.26816137 -0.63374625  0.13682673
       [307]  0.25621151  0.13682673  0.55671102 -0.42132217 -0.63374625 -0.30884991
       [313] -0.48169035 -0.54259783  0.16311028  0.25621151 -0.54259783 -0.65902646
       [319]  0.42810016 -0.36321785  0.69115009  0.45740217  0.30852208 -0.09364144
       [325]  0.34097354  0.30852208 -0.38070900  0.25621151  0.30852208 -0.17686525
       [331] -0.36321785 -0.42132217 -0.48169035  0.69115009  0.17034495  0.49227783
       [337] -0.57189984  0.51830965  0.36625375 -0.42132217 -0.63374625  0.39774207
       [343]  0.25621151 -0.69147792  0.49227783  0.49227783  0.51830965  0.55671102
       [349]  0.21007574 -0.30884991 -0.21523480  0.21007574 -0.57189984  0.36625375
       [355] -0.32185597  0.21007574 -0.54259783 -0.30884991 -0.32185597  0.55671102
       [361]  0.24101693  0.69115009 -0.54259783 -0.32185597  0.17034495 -0.48169035
       [367] -0.38070900 -0.36321785 -0.30884991 -0.60225793 -0.38070900 -0.54259783
       [373]  0.74069391 -0.44328898  0.42810016  0.63678215 -0.17686525 -0.69147792
       [379]  0.49227783  0.25621151  0.21007574 -0.54259783  0.55671102 -0.57189984
       [385] -0.63374625  0.10903700 -0.50772217  0.06798596 -0.38070900 -0.14407997
       [391] -0.36321785 -0.42132217  0.28842709 -0.54259783 -0.50772217  0.57867783
       [397] -0.44328898  0.19921800 -0.80078200  0.21007574 -0.26816137 -0.36321785
       [403] -0.48169035 -0.78992426  0.13682673 -0.42132217  0.45740217  0.39774207
       [409]  0.51830965  0.19921800  0.34097354  0.51830965  0.25621151 -0.44328898
       [415] -0.57189984 -0.21523480  0.45740217 -0.32185597  0.55671102  0.85592003
       [421] -0.36321785  0.34097354 -0.48169035 -0.48169035  0.45740217 -0.38070900
       [427] -0.65902646  0.34097354 -0.54259783  0.49227783 -0.42132217  0.51830965
       [433]  0.49227783  0.21007574 -0.36321785  0.24101693  0.25621151  0.69115009
       [439]  0.73183863 -0.54259783  0.39774207  0.45740217  0.30852208 -0.25930609
       [445] -0.36321785  0.25621151 -0.65902646 -0.65902646 -0.21523480 -0.36321785
       [451]  0.39774207 -0.17686525  0.19921800  0.45740217  0.49227783  0.28842709
       [457]  0.45740217  0.39774207  0.63678215  0.30852208  0.45740217  0.39774207
       [463] -0.71157291 -0.74378849  0.77948825  0.69115009 -0.54259783  0.30852208
       [469] -0.60225793  0.34097354 -0.57189984  0.36625375 -0.36321785 -0.50772217
       [475]  0.25621151  0.30852208 -0.38070900 -0.54259783 -0.54259783  0.30852208
       [481]  0.21007574 -0.60225793  0.25621151  0.30852208  0.49227783 -0.36321785
       [487]  0.25621151 -0.63374625 -0.48169035  0.34097354 -0.69147792 -0.25930609
       [493]  0.74069391 -0.36321785 -0.50772217  0.78476520  0.67814403  0.39774207
       [499] -0.50772217  0.24101693 -0.78992426 -0.26816137 -0.42132217  0.63678215
       [505] -0.50772217  0.55671102  0.63678215 -0.48169035  0.63678215  0.63678215
       [511] -0.36321785 -0.17925513 -0.22051175  0.36625375 -0.71157291 -0.32185597
       [517] -0.42132217  0.55671102 -0.30884991  0.45740217  0.42810016  0.45740217
       [523]  0.13246442 -0.75898307  0.45740217  0.34097354  0.17034495 -0.60225793
       [529] -0.30884991 -0.78992426  0.21007574 -0.60225793 -0.42132217  0.55671102
       [535]  0.63678215  0.36625375  0.36625375  0.30852208  0.49227783  0.45740217
       [541] -0.30884991 -0.42132217  0.34097354 -0.38070900  0.49227783  0.30852208
       [547] -0.54259783 -0.48169035 -0.42132217  0.74069391 -0.48169035 -0.25930609
       [553]  0.30852208  0.51830965  0.61929100 -0.48169035  0.34097354 -0.30884991
       [559]  0.36625375  0.45740217  0.21007574 -0.26816137  0.49227783  0.25621151
       [565]  0.51830965  0.39774207 -0.30884991 -0.69147792  0.13682673  0.55671102
       [571] -0.50772217 -0.71157291 -0.42132217  0.51830965  0.49227783 -0.54259783
       [577] -0.42132217  0.30852208  0.82313475 -0.42132217  0.55671102 -0.21523480
       [583]  0.49227783 -0.50772217  0.45740217 -0.30884991 -0.48169035 -0.14407997
       [589] -0.74378849  0.51830965  0.17034495 -0.22051175  0.61929100  0.42810016
       [595] -0.50772217  0.49227783  0.51830965 -0.25930609  0.39774207 -0.63374625
       [601]  0.69115009 -0.26816137  0.57867783  0.69115009 -0.36321785  0.30852208
       [607] -0.78992426 -0.69147792  0.24101693  0.39774207  0.36625375 -0.60225793
       [613] -0.57189984  0.24101693  0.51830965 -0.14407997 -0.50772217 -0.14407997
       [619] -0.69147792 -0.32185597 -0.48169035  0.78476520 -0.48169035 -0.48169035
       [625] -0.42132217 -0.21523480 -0.74378849  0.55671102  0.17034495  0.30852208
       [631] -0.25930609 -0.63374625  0.42810016  0.25621151  0.30852208  0.21007574
       [637]  0.36625375  0.30852208  0.42810016  0.17034495 -0.44328898 -0.57189984
       [643]  0.42810016 -0.60225793  0.74069391 -0.38070900  0.63678215  0.61929100
       [649] -0.44328898  0.49227783 -0.83688972 -0.44328898  0.30852208  0.30852208
       [655] -0.63374625 -0.48169035 -0.74378849  0.30852208 -0.21523480  0.30852208
       [661] -0.36321785  0.25621151 -0.30884991 -0.36321785  0.63678215  0.06798596
       [667] -0.57189984  0.36625375  0.67814403 -0.25930609 -0.42132217  0.39774207
       [673] -0.48169035 -0.36321785  0.30852208 -0.60225793 -0.21523480 -0.48169035
       [679] -0.36321785  0.51830965 -0.17686525 -0.44328898 -0.36321785 -0.14407997
       [685]  0.36625375 -0.82965505 -0.48169035  0.19921800 -0.36321785  0.57867783
       [691]  0.21007574 -0.54259783  0.49227783 -0.54259783 -0.26816137  0.25621151
       [697]  0.25621151  0.49227783  0.69115009  0.25621151  0.73183863  0.69115009
       [703]  0.13682673 -0.30884991  0.57867783  0.67814403 -0.74378849 -0.44328898
       [709]  0.55671102  0.63678215  0.85592003  0.17034495  0.25621151  0.42810016
       [715] -0.54259783 -0.54259783  0.42810016 -0.21523480 -0.36321785 -0.50772217
       [721]  0.45740217  0.55671102 -0.50772217 -0.57189984 -0.78992426 -0.71157291
       [727] -0.21523480 -0.42132217 -0.54259783  0.36625375 -0.42132217 -0.69147792
       [733] -0.57189984  0.57867783 -0.65902646  0.57867783  0.30852208 -0.25930609
       [739] -0.38070900  0.19921800 -0.54259783 -0.60225793  0.19921800  0.30852208
       [745] -0.36321785  0.45740217 -0.26816137 -0.82965505  0.28842709 -0.32185597
       [751]  0.28842709 -0.60225793 -0.60225793  0.36625375 -0.50772217  0.30852208
       [757] -0.44328898  0.57867783 -0.63374625  0.10903700 -0.25930609  0.57867783
       [763]  0.34097354 -0.17686525  0.69115009 -0.36321785 -0.50772217 -0.57189984
       [769] -0.50772217 -0.38070900 -0.38070900  0.17034495  0.30852208 -0.54259783
       [775] -0.36321785 -0.38070900  0.34097354  0.30852208 -0.42132217  0.21007574
       [781]  0.36625375  0.61929100  0.25621151 -0.42132217 -0.44328898  0.63678215
       [787] -0.30884991  0.49227783  0.49227783  0.39774207  0.67814403  0.21007574
       [793] -0.50772217  0.30852208 -0.21523480  0.49227783  0.51830965 -0.57189984
       [799] -0.38070900 -0.30884991  0.42810016 -0.57189984  0.25621151  0.19921800
       [805]  0.28842709 -0.69147792 -0.36321785 -0.44328898 -0.30884991  0.19921800
       [811]  0.21007574 -0.54259783 -0.71157291  0.25621151 -0.30884991 -0.44328898
       [817] -0.25930609 -0.54259783 -0.48169035 -0.21523480 -0.74378849  0.30852208
       [823]  0.25621151  0.17034495  0.17034495  0.57867783  0.55671102 -0.21523480
       [829] -0.50772217 -0.48169035 -0.25930609 -0.26816137 -0.54259783  0.45740217
       [835] -0.36321785 -0.25930609  0.51830965 -0.38070900 -0.78992426  0.39774207
       [841]  0.36625375  0.55671102 -0.69147792 -0.32185597 -0.60225793 -0.42132217
       [847] -0.30884991 -0.30884991  0.30852208 -0.17686525 -0.50772217  0.55671102
       [853] -0.57189984 -0.26816137  0.42810016 -0.42132217 -0.54259783  0.42810016
       [859]  0.45740217 -0.69147792  0.45740217  0.30852208 -0.65902646  0.24101693
       [865]  0.51830965 -0.60225793  0.19921800  0.45740217  0.42810016 -0.30884991
       [871]  0.42810016  0.17034495  0.36625375  0.57867783  0.13682673  0.30852208
       [877]  0.42810016  0.61929100  0.51830965  0.34097354 -0.42132217 -0.21523480
       [883]  0.49227783  0.17034495  0.42810016  0.51830965  0.36625375  0.42810016
       [889] -0.42132217  0.25621151  0.55671102 -0.21523480  0.55671102  0.34097354
       [895]  0.39774207  0.51830965 -0.36321785  0.19921800 -0.65902646  0.36625375
       [901] -0.57189984 -0.36321785  0.24101693  0.63678215  0.30852208 -0.30884991
       [907]  0.30852208  0.39774207  0.63678215  0.25621151  0.36625375 -0.42132217
       [913] -0.60225793  0.42810016 -0.42132217  0.25621151  0.57867783  0.51830965
       [919]  0.39774207  0.17034495 -0.60225793  0.61929100 -0.44328898 -0.50772217
       [925]  0.36625375 -0.21523480  0.42810016  0.39774207  0.49227783 -0.60225793
       [931]  0.30852208  0.24101693  0.42810016 -0.44328898 -0.57189984 -0.42132217
       [937] -0.60225793 -0.71157291 -0.21523480 -0.69147792 -0.54259783 -0.44328898
       [943] -0.42132217  0.17034495 -0.36321785 -0.60225793 -0.21523480 -0.26816137
       [949]  0.42810016  0.49227783  0.39774207  0.45740217 -0.42132217  0.17034495
       [955]  0.36625375  0.78476520 -0.50772217 -0.54259783  0.74069391  0.21007574
       [961]  0.24101693 -0.30884991  0.78476520 -0.63374625 -0.25930609 -0.25930609
       [967] -0.48169035  0.34097354  0.51830965  0.69115009  0.57867783 -0.17686525
       [973] -0.57189984 -0.71157291 -0.42132217  0.36625375 -0.71157291  0.28842709
       [979]  0.36625375 -0.69147792  0.34097354  0.13682673 -0.57189984 -0.74378849
       [985]  0.74069391 -0.63374625 -0.57189984 -0.30884991  0.45740217  0.39774207
       [991] -0.09364144  0.39774207  0.45740217 -0.42132217  0.30852208 -0.38070900
       [997] -0.86317327 -0.42132217  0.17034495  0.36625375  0.42810016  0.61929100
      [1003] -0.25930609  0.55671102  0.30852208 -0.32185597  0.08632693 -0.63374625
      [1009]  0.39774207  0.49227783 -0.25930609 -0.63374625 -0.14428859  0.51830965
      [1015]  0.42810016  0.69115009  0.82313475  0.30852208 -0.38070900  0.42810016
      [1021]  0.30852208 -0.44328898  0.13682673  0.55671102  0.34097354  0.51830965
      [1027]  0.36625375  0.74069391 -0.36321785  0.36625375 -0.44328898  0.39774207
      [1033]  0.45740217 -0.21523480  0.28842709 -0.57189984 -0.14407997 -0.44328898
      [1039] -0.69147792 -0.17925513  0.36625375  0.57867783 -0.44328898 -0.65902646
      [1045]  0.34097354 -0.63374625 -0.36321785  0.61929100 -0.42132217  0.25621151
      [1051] -0.30884991  0.63678215 -0.63374625 -0.44328898  0.45740217 -0.48169035
      [1057]  0.73183863  0.51830965 -0.42132217  0.57867783 -0.32185597  0.61929100
      [1063]  0.39774207  0.49227783  0.30852208  0.30852208  0.25621151  0.21007574
      [1069] -0.38070900 -0.63374625 -0.48169035 -0.44328898 -0.48169035 -0.14407997
      [1075]  0.25621151  0.25621151 -0.11651182  0.74069391 -0.50772217 -0.30884991
      [1081]  0.55671102  0.74069391  0.10903700 -0.17686525  0.49227783  0.69115009
      [1087] -0.26816137  0.49227783 -0.22051175  0.55671102  0.39774207  0.25621151
      [1093] -0.82965505  0.25621151 -0.63374625 -0.54259783 -0.60225793  0.78476520
      [1099]  0.63678215  0.63678215  0.10903700 -0.26816137  0.30852208  0.69115009
      [1105] -0.71157291 -0.60225793 -0.36321785  0.55671102  0.45740217  0.55671102
      [1111]  0.39774207 -0.48169035 -0.42132217 -0.26816137 -0.69147792  0.34097354
      [1117]  0.49227783  0.36625375  0.45740217  0.25621151  0.17034495  0.30852208
      [1123]  0.49227783  0.36625375  0.42810016  0.42810016 -0.38070900  0.57867783
      [1129]  0.55671102  0.36625375 -0.17686525 -0.42132217  0.19921800 -0.44328898
      [1135]  0.17034495  0.55671102 -0.32185597 -0.50772217  0.73183863  0.42810016
      [1141] -0.42132217 -0.17686525 -0.42132217  0.57867783  0.39774207 -0.60225793
      [1147]  0.25621151 -0.54259783 -0.42132217 -0.48169035  0.36625375 -0.26816137
      [1153] -0.26816137 -0.25930609 -0.74378849  0.13682673  0.17034495 -0.48169035
      [1159]  0.13682673 -0.69147792 -0.22051175 -0.25930609  0.49227783  0.28842709
      [1165]  0.30852208 -0.22051175 -0.50772217  0.74069391  0.49227783 -0.69147792
      [1171]  0.55671102 -0.44328898  0.67814403  0.13246442  0.10903700 -0.71157291
      [1177] -0.74378849  0.45740217 -0.14407997  0.42810016  0.25621151 -0.50772217
      [1183]  0.49227783 -0.63374625 -0.48169035 -0.57189984 -0.36321785  0.39774207
      [1189] -0.54259783  0.55671102  0.36625375  0.16311028 -0.75898307  0.45740217
      [1195]  0.25621151  0.63678215 -0.74378849  0.51830965  0.73183863  0.24101693
      [1201]  0.34097354  0.39774207 -0.38070900  0.36625375 -0.44328898  0.17034495
      [1207]  0.13682673 -0.30884991  0.13682673  0.63678215  0.63678215 -0.63374625
      [1213] -0.42132217  0.10903700  0.57867783  0.51830965 -0.65902646 -0.65902646
      [1219] -0.80078200 -0.17686525 -0.54259783  0.25621151  0.51830965 -0.57189984
      [1225] -0.36321785  0.25621151  0.57867783 -0.71157291  0.30852208  0.51830965
      [1231]  0.45740217 -0.74378849 -0.54259783 -0.69147792  0.13682673 -0.38070900
      [1237]  0.25621151 -0.44328898 -0.69147792 -0.36321785  0.42810016  0.36625375
      [1243]  0.42810016  0.30852208 -0.71157291 -0.50772217  0.28842709 -0.57189984
      [1249]  0.10903700 -0.36321785  0.63678215 -0.36321785  0.51830965 -0.54259783
      [1255]  0.57867783 -0.25930609 -0.54259783 -0.69147792  0.49227783 -0.57189984
      [1261]  0.45740217 -0.21523480 -0.36321785  0.36625375 -0.57189984 -0.17686525
      [1267] -0.50772217  0.36625375  0.49227783 -0.32185597  0.67814403 -0.54259783
      [1273]  0.28842709 -0.38070900  0.24101693  0.30852208  0.63678215  0.21007574
      [1279] -0.48169035 -0.65902646 -0.36321785  0.13682673 -0.17686525  0.39774207
      [1285]  0.39774207 -0.26816137  0.49227783  0.10903700 -0.17686525 -0.54259783
      [1291] -0.78992426 -0.17686525  0.39774207  0.34097354 -0.63374625 -0.48169035
      [1297]  0.34097354  0.21007574  0.57867783 -0.60225793  0.25621151 -0.17686525
      [1303]  0.25621151 -0.36321785  0.24101693 -0.63374625 -0.30884991 -0.57189984
      [1309] -0.50772217  0.21007574  0.21007574  0.55671102 -0.42132217  0.74069391
      [1315] -0.54259783 -0.69147792  0.25621151  0.17034495  0.28842709  0.36625375
      [1321]  0.39774207  0.57867783 -0.50772217  0.25621151 -0.65902646 -0.30884991
      [1327]  0.63678215  0.45740217  0.21007574  0.67814403  0.34097354 -0.50772217
      [1333] -0.69147792  0.57867783 -0.50772217  0.25621151  0.69115009  0.42810016
      [1339]  0.25621151  0.69115009  0.63678215  0.13682673  0.42810016 -0.32185597
      [1345]  0.42810016 -0.48169035 -0.50772217  0.74069391 -0.36321785  0.45740217
      [1351]  0.57867783 -0.50772217  0.17034495  0.24101693 -0.38070900  0.39774207
      [1357] -0.54259783  0.42810016  0.24101693  0.21007574 -0.30884991  0.36625375
      [1363]  0.42810016  0.74069391  0.45740217  0.36625375  0.13682673  0.57867783
      [1369]  0.36625375  0.13682673  0.34097354  0.36625375  0.13246442 -0.36321785
      [1375]  0.51830965  0.45740217  0.25621151 -0.48169035 -0.57189984 -0.44328898
      [1381] -0.25930609 -0.50772217 -0.57189984 -0.21523480  0.25621151 -0.36321785
      [1387] -0.42132217 -0.21523480 -0.14407997  0.25621151  0.45740217 -0.54259783
      [1393]  0.30852208  0.24101693  0.24101693  0.30852208 -0.44328898  0.39774207
      [1399] -0.48169035 -0.22051175  0.25621151  0.06798596 -0.44328898  0.25621151
      [1405] -0.42132217  0.57867783 -0.63374625 -0.54259783  0.16311028  0.25621151
      [1411] -0.26816137  0.49227783 -0.30884991 -0.38070900 -0.44328898 -0.86317327
      [1417]  0.34097354 -0.69147792 -0.22051175 -0.60225793 -0.36321785  0.45740217
      [1423]  0.51830965  0.21007574  0.36625375  0.30852208  0.36625375 -0.32185597
      [1429] -0.44328898 -0.21523480 -0.71157291 -0.36321785  0.42810016  0.49227783
      [1435] -0.44328898  0.78476520 -0.69147792  0.08632693  0.30852208  0.49227783
      [1441]  0.78476520 -0.69147792 -0.60225793  0.42810016  0.21007574 -0.30884991
      [1447]  0.24101693  0.61929100  0.36625375  0.28842709 -0.82965505 -0.48169035
      [1453] -0.42132217  0.55671102  0.39774207  0.34097354 -0.69147792 -0.36321785
      [1459]  0.45740217 -0.26816137  0.49227783 -0.60225793  0.63678215  0.69115009
      [1465]  0.25621151  0.45740217  0.45740217 -0.54259783 -0.63374625  0.78476520
      [1471] -0.50772217  0.19921800 -0.22051175  0.25621151 -0.42132217 -0.32185597
      [1477] -0.69147792 -0.14407997  0.21007574  0.30852208  0.57867783 -0.78992426
      [1483]  0.57867783  0.08632693  0.51830965 -0.54259783 -0.32185597  0.28842709
      [1489]  0.51830965 -0.63374625  0.36625375 -0.36321785 -0.54259783  0.30852208
      [1495] -0.57189984 -0.42132217 -0.48169035  0.25621151  0.36625375 -0.57189984
      [1501]  0.30852208 -0.54259783  0.13682673  0.78476520  0.25621151 -0.63374625
      [1507] -0.25930609 -0.54259783 -0.21523480 -0.54259783 -0.30884991 -0.48169035
      [1513]  0.57867783 -0.30884991  0.42810016  0.55671102 -0.57189984  0.49227783
      [1519] -0.17686525  0.30852208 -0.48169035  0.34097354  0.49227783  0.25621151
      [1525] -0.54259783  0.36625375 -0.26816137  0.36625375 -0.57189984  0.36625375
      [1531]  0.55671102  0.24101693  0.30852208 -0.48169035 -0.36321785  0.10903700
      [1537] -0.30884991  0.49227783  0.36625375  0.42810016  0.21007574 -0.63374625
      [1543] -0.26816137 -0.42132217  0.21007574  0.21007574 -0.36321785  0.36625375
      [1549] -0.63374625 -0.17686525  0.69115009 -0.25930609 -0.32185597  0.57867783
      [1555] -0.48169035 -0.36321785  0.39774207  0.74069391  0.34097354  0.61929100
      [1561] -0.17925513  0.39774207 -0.89096300  0.39774207  0.34097354  0.36625375
      [1567]  0.49227783 -0.89096300  0.82313475 -0.48169035  0.25621151  0.34097354
      [1573]  0.30852208 -0.48169035 -0.42132217  0.39774207 -0.36321785 -0.60225793
      [1579]  0.39774207 -0.78992426 -0.26816137 -0.42132217  0.19921800  0.82313475
      [1585]  0.17034495  0.28842709 -0.60225793 -0.32185597 -0.21523480  0.30852208
      [1591]  0.30852208 -0.38070900  0.39774207 -0.30884991 -0.60225793 -0.54259783
      [1597] -0.74378849 -0.30884991  0.25621151 -0.54259783  0.39774207  0.06798596
      [1603] -0.14428859 -0.42132217  0.36625375  0.30852208  0.57867783 -0.42132217
      [1609] -0.32185597  0.45740217  0.42810016 -0.42132217  0.30852208  0.73183863
      [1615]  0.17034495 -0.57189984  0.45740217 -0.30884991 -0.48169035 -0.21523480
      [1621] -0.60225793  0.25621151  0.42810016  0.45740217 -0.38070900  0.77948825
      [1627]  0.36625375  0.30852208  0.17034495 -0.69147792  0.42810016 -0.44328898
      [1633]  0.45740217 -0.63374625 -0.30884991 -0.69147792  0.30852208 -0.69147792
      [1639] -0.36321785  0.45740217  0.17034495 -0.63374625  0.55671102  0.36625375
      [1645] -0.54259783  0.25621151  0.67814403 -0.69147792 -0.50772217  0.49227783
      [1651]  0.63678215  0.25621151 -0.36321785 -0.54259783  0.51830965  0.42810016
      [1657] -0.30884991  0.51830965 -0.21523480 -0.74378849 -0.65902646  0.25621151
      [1663]  0.10903700 -0.54259783  0.67814403  0.45740217  0.39774207  0.21007574
      [1669] -0.11651182  0.36625375 -0.36321785  0.63678215 -0.50772217  0.77948825
      [1675] -0.44328898 -0.50772217 -0.69147792 -0.54259783  0.45740217  0.30852208
      [1681] -0.44328898 -0.32185597 -0.57189984  0.30852208  0.49227783 -0.44328898
      [1687]  0.69115009 -0.30884991  0.74069391  0.28842709 -0.42132217  0.42810016
      [1693]  0.49227783 -0.26816137  0.34097354 -0.36321785  0.57867783  0.34097354
      [1699] -0.48169035  0.51830965 -0.14407997 -0.11651182  0.42810016 -0.50772217
      [1705] -0.42132217 -0.30884991  0.28842709  0.36625375 -0.86317327 -0.57189984
      [1711] -0.21523480  0.61929100 -0.30884991 -0.57189984 -0.36321785 -0.48169035
      [1717]  0.10903700 -0.50772217 -0.25930609 -0.30884991  0.36625375 -0.25930609
      [1723] -0.69147792 -0.42132217  0.45740217  0.34097354  0.39774207 -0.25930609
      [1729]  0.39774207 -0.21523480 -0.42132217  0.51830965  0.21007574  0.42810016
      [1735]  0.36625375 -0.54259783 -0.17686525 -0.65902646 -0.30884991  0.45740217
      [1741] -0.60225793 -0.32185597 -0.48169035  0.06798596  0.45740217 -0.42132217
      [1747] -0.30884991 -0.36321785  0.21007574 -0.17686525 -0.44328898  0.30852208
      [1753] -0.30884991  0.08632693  0.63678215  0.34097354 -0.50772217 -0.30884991
      [1759] -0.36321785  0.28842709  0.21007574 -0.26816137 -0.36321785  0.49227783
      [1765]  0.39774207  0.16311028  0.08632693  0.36625375 -0.54259783  0.21007574
      [1771] -0.38070900 -0.32185597  0.25621151  0.39774207 -0.17925513  0.17034495
      [1777] -0.63374625  0.51830965 -0.25930609  0.57867783  0.24101693 -0.32185597
      [1783]  0.69115009  0.45740217 -0.22051175 -0.17686525 -0.42132217  0.34097354
      [1789]  0.25621151  0.25621151 -0.44328898  0.39774207 -0.74378849  0.39774207
      [1795]  0.10903700  0.34097354  0.57867783  0.25621151  0.39774207  0.42810016
      [1801] -0.36321785 -0.60225793  0.24101693 -0.36321785 -0.57189984 -0.57189984
      [1807]  0.61929100  0.49227783 -0.48169035 -0.57189984 -0.44328898  0.17034495
      [1813] -0.36321785  0.45740217 -0.22051175 -0.42132217  0.21007574 -0.25930609
      [1819]  0.36625375  0.74069391  0.57867783  0.13682673  0.51830965  0.63678215
      [1825] -0.25930609 -0.30884991  0.30852208 -0.75898307  0.82313475 -0.17686525
      [1831] -0.57189984  0.45740217  0.36625375 -0.42132217 -0.25930609 -0.32185597
      [1837]  0.45740217 -0.38070900 -0.48169035 -0.54259783 -0.50772217  0.30852208
      [1843]  0.24101693 -0.42132217  0.49227783  0.24101693  0.36625375 -0.17686525
      [1849] -0.63374625 -0.21523480 -0.50772217 -0.30884991 -0.30884991  0.36625375
      [1855] -0.60225793  0.21007574 -0.25930609 -0.36321785 -0.57189984  0.51830965
      [1861] -0.48169035 -0.38070900 -0.22051175 -0.25930609  0.63678215  0.25621151
      [1867]  0.25621151  0.51830965 -0.30884991 -0.60225793 -0.65902646 -0.57189984
      [1873]  0.21007574 -0.63374625  0.34097354  0.57867783  0.61929100  0.34097354
      [1879]  0.36625375  0.25621151  0.17034495 -0.57189984 -0.42132217 -0.32185597
      [1885]  0.28842709 -0.65902646  0.30852208  0.51830965 -0.65902646  0.55671102
      [1891] -0.17686525  0.49227783 -0.21523480  0.45740217  0.55671102 -0.50772217
      [1897]  0.42810016 -0.57189984  0.21007574 -0.57189984 -0.48169035 -0.60225793
      [1903]  0.36625375 -0.36321785  0.30852208 -0.71157291 -0.32185597  0.30852208
      [1909]  0.30852208 -0.36321785  0.30852208  0.36625375 -0.36321785  0.21007574
      [1915]  0.57867783 -0.50772217  0.28842709  0.25621151 -0.36321785  0.30852208
      [1921] -0.42132217  0.57867783 -0.21523480 -0.17686525  0.13682673 -0.30884991
      [1927]  0.42810016  0.61929100  0.34097354  0.55671102 -0.26816137  0.45740217
      [1933]  0.36625375 -0.30884991 -0.50772217 -0.54259783  0.21007574  0.69115009
      [1939] -0.26816137  0.42810016  0.51830965  0.45740217  0.36625375 -0.25930609
      [1945] -0.48169035  0.17034495 -0.60225793  0.30852208  0.30852208 -0.36321785
      [1951]  0.34097354  0.13246442  0.67814403  0.28842709 -0.50772217 -0.44328898
      [1957]  0.36625375  0.63678215  0.30852208  0.30852208 -0.38070900  0.21007574
      [1963] -0.54259783  0.39774207 -0.57189984  0.61929100  0.34097354  0.28842709
      [1969] -0.48169035  0.21007574  0.39774207 -0.57189984  0.42810016 -0.21523480
      [1975] -0.57189984  0.30852208 -0.50772217 -0.44328898 -0.36321785 -0.14407997
      [1981] -0.38070900  0.36625375 -0.54259783  0.61929100 -0.30884991  0.61929100
      [1987]  0.51830965  0.30852208  0.67814403  0.19921800  0.63678215  0.36625375
      [1993] -0.32185597  0.30852208  0.19921800 -0.54259783 -0.48169035  0.30852208
      [1999]  0.30852208  0.28842709
      attr(,"label")
      [1] "Residuals"

---

    Code
      (fit_em <- estimNLR(y = y, match = match, group = group, formula = M$M1$formula,
      method = "em", lower = M$M1$lower, upper = M$M1$upper, start = start))
    Output
      Nonlinear regression model 
      
       Model:  y ~ c + (1 - c)/(1 + exp(-(b0 + b1 * x + b2 * g + b3 * x * g))) 
      
      Coefficients:
           b0      b1      b2      b3       c 
       0.5503  0.9941 -0.8388 -0.1536  0.0000 
      
       Maximum likelihood estimation using the EM algorithm 
      Converged after 2 iterations

---

    Code
      coef(fit_em)
    Output
              b0         b1         b2         b3          c 
       0.5503440  0.9940975 -0.8387766 -0.1535927  0.0000000 

---

    Code
      logLik(fit_em)
    Output
      'log Lik.' -1192.331 (df=5)

---

    Code
      vcov(fit_em)
    Output
                  b0           b1          b2           b3           c
      b0  0.08658573 -0.036631987  0.04091179 -0.034224858 -0.04507052
      b1 -0.03663199  0.024578025 -0.02262850  0.008356037  0.02094865
      b2  0.04091179 -0.022628503  0.03622273 -0.018122854 -0.02559373
      b3 -0.03422486  0.008356037 -0.01812285  0.026512557  0.01832306
      c  -0.04507052  0.020948650 -0.02559373  0.018323057  0.02497989

---

    Code
      fitted(fit_em)
    Output
         [1] 0.45487411 0.76352613 0.87628488 0.22037531 0.78877573 0.28435576
         [7] 0.52239129 0.42976528 0.78877573 0.76352613 0.83721296 0.71125529
        [13] 0.45487411 0.50931523 0.73056430 0.35368440 0.58839620 0.71125529
        [19] 0.45487411 0.32690028 0.42976528 0.80887717 0.87628488 0.83721296
        [25] 0.66316115 0.50931523 0.76352613 0.50931523 0.71125529 0.27034765
        [31] 0.50931523 0.65268611 0.78877573 0.32690028 0.45487411 0.52239129
        [37] 0.66316115 0.83721296 0.50931523 0.58910004 0.27034765 0.50931523
        [43] 0.50931523 0.78877573 0.78877573 0.45487411 0.32690028 0.50931523
        [49] 0.22037531 0.52239129 0.52239129 0.27034765 0.14127713 0.52239129
        [55] 0.32690028 0.58839620 0.32690028 0.52239129 0.52239129 0.52239129
        [61] 0.87910405 0.66316115 0.32690028 0.22037531 0.65268611 0.73056430
        [67] 0.22037531 0.73056430 0.08738702 0.93072359 0.42976528 0.22037531
        [73] 0.45487411 0.58839620 0.50931523 0.22037531 0.65268611 0.22390881
        [79] 0.32690028 0.50931523 0.52239129 0.58839620 0.22037531 0.35368440
        [85] 0.50931523 0.65268611 0.28435576 0.35368440 0.45487411 0.73056430
        [91] 0.28435576 0.71125529 0.45487411 0.71125529 0.27034765 0.22037531
        [97] 0.38897634 0.83721296 0.27034765 0.84727053 0.94872579 0.52239129
       [103] 0.52239129 0.66316115 0.38897634 0.17320152 0.78877573 0.78877573
       [109] 0.66316115 0.14127713 0.65268611 0.45487411 0.38897634 0.83721296
       [115] 0.32690028 0.58839620 0.32690028 0.87628488 0.22037531 0.45487411
       [121] 0.76352613 0.45487411 0.27034765 0.83721296 0.27034765 0.50931523
       [127] 0.27034765 0.22390881 0.27034765 0.28435576 0.45487411 0.42976528
       [133] 0.42976528 0.83721296 0.38897634 0.38897634 0.13202412 0.58910004
       [139] 0.73056430 0.83721296 0.38897634 0.17739435 0.28435576 0.78877573
       [145] 0.50931523 0.66316115 0.90702032 0.73056430 0.22037531 0.32690028
       [151] 0.27034765 0.22037531 0.66316115 0.45487411 0.83721296 0.35368440
       [157] 0.22037531 0.90702032 0.93072359 0.38897634 0.42976528 0.52239129
       [163] 0.90702032 0.14127713 0.42976528 0.45487411 0.66316115 0.90702032
       [169] 0.27034765 0.78877573 0.28435576 0.66316115 0.58910004 0.58839620
       [175] 0.73056430 0.42976528 0.45487411 0.76352613 0.87628488 0.17739435
       [181] 0.38897634 0.87628488 0.90702032 0.80887717 0.58910004 0.50931523
       [187] 0.87628488 0.35368440 0.11151645 0.73056430 0.32690028 0.50931523
       [193] 0.73056430 0.14127713 0.90702032 0.58839620 0.58839620 0.66316115
       [199] 0.78877573 0.45487411 0.32690028 0.58839620 0.22390881 0.78877573
       [205] 0.87628488 0.73056430 0.73056430 0.45487411 0.78877573 0.38897634
       [211] 0.58910004 0.38897634 0.22390881 0.52239129 0.17739435 0.28435576
       [217] 0.73056430 0.78877573 0.93072359 0.73056430 0.58910004 0.38897634
       [223] 0.38897634 0.73056430 0.38897634 0.42976528 0.73056430 0.50931523
       [229] 0.58839620 0.52239129 0.35368440 0.90702032 0.87628488 0.35368440
       [235] 0.83721296 0.73056430 0.58839620 0.93072359 0.32690028 0.90702032
       [241] 0.73056430 0.65268611 0.66316115 0.45487411 0.50931523 0.32690028
       [247] 0.45487411 0.58839620 0.58910004 0.32690028 0.83721296 0.50931523
       [253] 0.78877573 0.66316115 0.58910004 0.58910004 0.66316115 0.45487411
       [259] 0.71125529 0.78877573 0.08738702 0.65268611 0.35368440 0.27034765
       [265] 0.66316115 0.58839620 0.83721296 0.45487411 0.76352613 0.14127713
       [271] 0.45487411 0.66316115 0.78877573 0.35368440 0.90702032 0.32690028
       [277] 0.52239129 0.17739435 0.35368440 0.52239129 0.27034765 0.73056430
       [283] 0.58839620 0.42976528 0.58910004 0.76352613 0.50931523 0.78877573
       [289] 0.93072359 0.42976528 0.42976528 0.27034765 0.32690028 0.58839620
       [295] 0.45487411 0.83721296 0.58910004 0.50931523 0.58910004 0.83721296
       [301] 0.58910004 0.38897634 0.35368440 0.22390881 0.66316115 0.90702032
       [307] 0.78877573 0.90702032 0.42976528 0.38897634 0.66316115 0.27034765
       [313] 0.45487411 0.52239129 0.84727053 0.78877573 0.52239129 0.65268611
       [319] 0.58839620 0.32690028 0.27034765 0.52239129 0.73056430 0.06807856
       [325] 0.65268611 0.73056430 0.35368440 0.78877573 0.73056430 0.14127713
       [331] 0.32690028 0.38897634 0.45487411 0.27034765 0.87628488 0.50931523
       [337] 0.58839620 0.45487411 0.66316115 0.38897634 0.66316115 0.58910004
       [343] 0.78877573 0.73056430 0.50931523 0.50931523 0.45487411 0.42976528
       [349] 0.83721296 0.27034765 0.17739435 0.83721296 0.58839620 0.66316115
       [355] 0.28435576 0.83721296 0.52239129 0.27034765 0.28435576 0.42976528
       [361] 0.76352613 0.27034765 0.52239129 0.28435576 0.87628488 0.45487411
       [367] 0.35368440 0.32690028 0.27034765 0.58910004 0.35368440 0.52239129
       [373] 0.22037531 0.42976528 0.58839620 0.32690028 0.14127713 0.73056430
       [379] 0.50931523 0.78877573 0.83721296 0.52239129 0.42976528 0.58839620
       [385] 0.66316115 0.93072359 0.50931523 0.96223973 0.35368440 0.11151645
       [391] 0.32690028 0.38897634 0.71125529 0.52239129 0.50931523 0.38897634
       [397] 0.42976528 0.80887717 0.80887717 0.83721296 0.22390881 0.32690028
       [403] 0.45487411 0.83721296 0.90702032 0.38897634 0.52239129 0.58910004
       [409] 0.45487411 0.80887717 0.65268611 0.45487411 0.78877573 0.42976528
       [415] 0.58839620 0.17739435 0.52239129 0.28435576 0.42976528 0.11151645
       [421] 0.32690028 0.65268611 0.45487411 0.45487411 0.52239129 0.35368440
       [427] 0.65268611 0.65268611 0.52239129 0.50931523 0.38897634 0.45487411
       [433] 0.50931523 0.83721296 0.32690028 0.76352613 0.78877573 0.27034765
       [439] 0.22390881 0.52239129 0.58910004 0.52239129 0.73056430 0.22037531
       [445] 0.32690028 0.78877573 0.65268611 0.65268611 0.17739435 0.32690028
       [451] 0.58910004 0.14127713 0.80887717 0.52239129 0.50931523 0.71125529
       [457] 0.52239129 0.58910004 0.32690028 0.73056430 0.52239129 0.58910004
       [463] 0.71125529 0.78877573 0.17320152 0.27034765 0.52239129 0.73056430
       [469] 0.58910004 0.65268611 0.58839620 0.66316115 0.32690028 0.50931523
       [475] 0.78877573 0.73056430 0.35368440 0.52239129 0.52239129 0.73056430
       [481] 0.83721296 0.58910004 0.78877573 0.73056430 0.50931523 0.32690028
       [487] 0.78877573 0.66316115 0.45487411 0.65268611 0.73056430 0.22037531
       [493] 0.22037531 0.32690028 0.50931523 0.17739435 0.28435576 0.58910004
       [499] 0.50931523 0.76352613 0.83721296 0.22390881 0.38897634 0.32690028
       [505] 0.50931523 0.42976528 0.32690028 0.45487411 0.32690028 0.32690028
       [511] 0.32690028 0.13202412 0.17320152 0.66316115 0.71125529 0.28435576
       [517] 0.38897634 0.42976528 0.27034765 0.52239129 0.58839620 0.52239129
       [523] 0.87910405 0.76352613 0.52239129 0.65268611 0.87628488 0.58910004
       [529] 0.27034765 0.83721296 0.83721296 0.58910004 0.38897634 0.42976528
       [535] 0.32690028 0.66316115 0.66316115 0.73056430 0.50931523 0.52239129
       [541] 0.27034765 0.38897634 0.65268611 0.35368440 0.50931523 0.73056430
       [547] 0.52239129 0.45487411 0.38897634 0.22037531 0.45487411 0.22037531
       [553] 0.73056430 0.45487411 0.35368440 0.45487411 0.65268611 0.27034765
       [559] 0.66316115 0.52239129 0.83721296 0.22390881 0.50931523 0.78877573
       [565] 0.45487411 0.58910004 0.27034765 0.73056430 0.90702032 0.42976528
       [571] 0.50931523 0.71125529 0.38897634 0.45487411 0.50931523 0.52239129
       [577] 0.38897634 0.73056430 0.14127713 0.38897634 0.42976528 0.17739435
       [583] 0.50931523 0.50931523 0.52239129 0.27034765 0.45487411 0.11151645
       [589] 0.78877573 0.45487411 0.87628488 0.17320152 0.35368440 0.58839620
       [595] 0.50931523 0.50931523 0.45487411 0.22037531 0.58910004 0.66316115
       [601] 0.27034765 0.22390881 0.38897634 0.27034765 0.32690028 0.73056430
       [607] 0.83721296 0.73056430 0.76352613 0.58910004 0.66316115 0.58910004
       [613] 0.58839620 0.76352613 0.45487411 0.11151645 0.50931523 0.11151645
       [619] 0.73056430 0.28435576 0.45487411 0.17739435 0.45487411 0.45487411
       [625] 0.38897634 0.17739435 0.78877573 0.42976528 0.87628488 0.73056430
       [631] 0.22037531 0.66316115 0.58839620 0.78877573 0.73056430 0.83721296
       [637] 0.66316115 0.73056430 0.58839620 0.87628488 0.42976528 0.58839620
       [643] 0.58839620 0.58910004 0.22037531 0.35368440 0.32690028 0.35368440
       [649] 0.42976528 0.50931523 0.84727053 0.42976528 0.73056430 0.73056430
       [655] 0.66316115 0.45487411 0.78877573 0.73056430 0.17739435 0.73056430
       [661] 0.32690028 0.78877573 0.27034765 0.32690028 0.32690028 0.96223973
       [667] 0.58839620 0.66316115 0.28435576 0.22037531 0.38897634 0.58910004
       [673] 0.45487411 0.32690028 0.73056430 0.58910004 0.17739435 0.45487411
       [679] 0.32690028 0.45487411 0.14127713 0.42976528 0.32690028 0.11151645
       [685] 0.66316115 0.87628488 0.45487411 0.80887717 0.32690028 0.38897634
       [691] 0.83721296 0.52239129 0.50931523 0.52239129 0.22390881 0.78877573
       [697] 0.78877573 0.50931523 0.27034765 0.78877573 0.22390881 0.27034765
       [703] 0.90702032 0.27034765 0.38897634 0.28435576 0.78877573 0.42976528
       [709] 0.42976528 0.32690028 0.11151645 0.87628488 0.78877573 0.58839620
       [715] 0.52239129 0.52239129 0.58839620 0.17739435 0.32690028 0.50931523
       [721] 0.52239129 0.42976528 0.50931523 0.58839620 0.83721296 0.71125529
       [727] 0.17739435 0.38897634 0.52239129 0.66316115 0.38897634 0.73056430
       [733] 0.58839620 0.38897634 0.65268611 0.38897634 0.73056430 0.22037531
       [739] 0.35368440 0.80887717 0.52239129 0.58910004 0.80887717 0.73056430
       [745] 0.32690028 0.52239129 0.22390881 0.87628488 0.71125529 0.28435576
       [751] 0.71125529 0.58910004 0.58910004 0.66316115 0.50931523 0.73056430
       [757] 0.42976528 0.38897634 0.66316115 0.93072359 0.22037531 0.38897634
       [763] 0.65268611 0.14127713 0.27034765 0.32690028 0.50931523 0.58839620
       [769] 0.50931523 0.35368440 0.35368440 0.87628488 0.73056430 0.52239129
       [775] 0.32690028 0.35368440 0.65268611 0.73056430 0.38897634 0.83721296
       [781] 0.66316115 0.35368440 0.78877573 0.38897634 0.42976528 0.32690028
       [787] 0.27034765 0.50931523 0.50931523 0.58910004 0.28435576 0.83721296
       [793] 0.50931523 0.73056430 0.17739435 0.50931523 0.45487411 0.58839620
       [799] 0.35368440 0.27034765 0.58839620 0.58839620 0.78877573 0.80887717
       [805] 0.71125529 0.73056430 0.32690028 0.42976528 0.27034765 0.80887717
       [811] 0.83721296 0.52239129 0.71125529 0.78877573 0.27034765 0.42976528
       [817] 0.22037531 0.52239129 0.45487411 0.17739435 0.78877573 0.73056430
       [823] 0.78877573 0.87628488 0.87628488 0.38897634 0.42976528 0.17739435
       [829] 0.50931523 0.45487411 0.22037531 0.22390881 0.52239129 0.52239129
       [835] 0.32690028 0.22037531 0.45487411 0.35368440 0.83721296 0.58910004
       [841] 0.66316115 0.42976528 0.73056430 0.28435576 0.58910004 0.38897634
       [847] 0.27034765 0.27034765 0.73056430 0.14127713 0.50931523 0.42976528
       [853] 0.58839620 0.22390881 0.58839620 0.38897634 0.52239129 0.58839620
       [859] 0.52239129 0.73056430 0.52239129 0.73056430 0.65268611 0.76352613
       [865] 0.45487411 0.58910004 0.80887717 0.52239129 0.58839620 0.27034765
       [871] 0.58839620 0.87628488 0.66316115 0.38897634 0.90702032 0.73056430
       [877] 0.58839620 0.35368440 0.45487411 0.65268611 0.38897634 0.17739435
       [883] 0.50931523 0.87628488 0.58839620 0.45487411 0.66316115 0.58839620
       [889] 0.38897634 0.78877573 0.42976528 0.17739435 0.42976528 0.65268611
       [895] 0.58910004 0.45487411 0.32690028 0.80887717 0.65268611 0.66316115
       [901] 0.58839620 0.32690028 0.76352613 0.32690028 0.73056430 0.27034765
       [907] 0.73056430 0.58910004 0.32690028 0.78877573 0.66316115 0.38897634
       [913] 0.58910004 0.58839620 0.38897634 0.78877573 0.38897634 0.45487411
       [919] 0.58910004 0.87628488 0.58910004 0.35368440 0.42976528 0.50931523
       [925] 0.66316115 0.17739435 0.58839620 0.58910004 0.50931523 0.58910004
       [931] 0.73056430 0.76352613 0.58839620 0.42976528 0.58839620 0.38897634
       [937] 0.58910004 0.71125529 0.17739435 0.73056430 0.52239129 0.42976528
       [943] 0.38897634 0.87628488 0.32690028 0.58910004 0.17739435 0.22390881
       [949] 0.58839620 0.50931523 0.58910004 0.52239129 0.38897634 0.87628488
       [955] 0.66316115 0.17739435 0.50931523 0.52239129 0.22037531 0.83721296
       [961] 0.76352613 0.27034765 0.17739435 0.66316115 0.22037531 0.22037531
       [967] 0.45487411 0.65268611 0.45487411 0.27034765 0.38897634 0.14127713
       [973] 0.58839620 0.71125529 0.38897634 0.66316115 0.71125529 0.71125529
       [979] 0.66316115 0.73056430 0.65268611 0.90702032 0.58839620 0.78877573
       [985] 0.22037531 0.66316115 0.58839620 0.27034765 0.52239129 0.58910004
       [991] 0.06807856 0.58910004 0.52239129 0.38897634 0.73056430 0.35368440
       [997] 0.90702032 0.38897634 0.87628488 0.66316115 0.58839620 0.35368440
      [1003] 0.22037531 0.42976528 0.73056430 0.28435576 0.94872579 0.66316115
      [1009] 0.58910004 0.50931523 0.22037531 0.66316115 0.09945871 0.45487411
      [1015] 0.58839620 0.27034765 0.14127713 0.73056430 0.35368440 0.58839620
      [1021] 0.73056430 0.42976528 0.90702032 0.42976528 0.65268611 0.45487411
      [1027] 0.66316115 0.22037531 0.32690028 0.66316115 0.42976528 0.58910004
      [1033] 0.52239129 0.17739435 0.71125529 0.58839620 0.11151645 0.42976528
      [1039] 0.73056430 0.13202412 0.66316115 0.38897634 0.42976528 0.65268611
      [1045] 0.65268611 0.66316115 0.32690028 0.35368440 0.38897634 0.78877573
      [1051] 0.27034765 0.32690028 0.66316115 0.42976528 0.52239129 0.45487411
      [1057] 0.22390881 0.45487411 0.38897634 0.38897634 0.28435576 0.35368440
      [1063] 0.58910004 0.50931523 0.73056430 0.73056430 0.78877573 0.83721296
      [1069] 0.35368440 0.66316115 0.45487411 0.42976528 0.45487411 0.11151645
      [1075] 0.78877573 0.78877573 0.08738702 0.22037531 0.50931523 0.27034765
      [1081] 0.42976528 0.22037531 0.93072359 0.14127713 0.50931523 0.27034765
      [1087] 0.22390881 0.50931523 0.17320152 0.42976528 0.58910004 0.78877573
      [1093] 0.87628488 0.78877573 0.66316115 0.52239129 0.58910004 0.17739435
      [1099] 0.32690028 0.32690028 0.93072359 0.22390881 0.73056430 0.27034765
      [1105] 0.71125529 0.58910004 0.32690028 0.42976528 0.52239129 0.42976528
      [1111] 0.58910004 0.45487411 0.38897634 0.22390881 0.73056430 0.65268611
      [1117] 0.50931523 0.66316115 0.52239129 0.78877573 0.87628488 0.73056430
      [1123] 0.50931523 0.66316115 0.58839620 0.58839620 0.35368440 0.38897634
      [1129] 0.42976528 0.66316115 0.14127713 0.38897634 0.80887717 0.42976528
      [1135] 0.87628488 0.42976528 0.28435576 0.50931523 0.22390881 0.58839620
      [1141] 0.38897634 0.14127713 0.38897634 0.38897634 0.58910004 0.58910004
      [1147] 0.78877573 0.52239129 0.38897634 0.45487411 0.66316115 0.22390881
      [1153] 0.22390881 0.22037531 0.78877573 0.90702032 0.87628488 0.45487411
      [1159] 0.90702032 0.73056430 0.17320152 0.22037531 0.50931523 0.71125529
      [1165] 0.73056430 0.17320152 0.50931523 0.22037531 0.50931523 0.73056430
      [1171] 0.42976528 0.42976528 0.28435576 0.87910405 0.93072359 0.71125529
      [1177] 0.78877573 0.52239129 0.11151645 0.58839620 0.78877573 0.50931523
      [1183] 0.50931523 0.66316115 0.45487411 0.58839620 0.32690028 0.58910004
      [1189] 0.52239129 0.42976528 0.66316115 0.84727053 0.76352613 0.52239129
      [1195] 0.78877573 0.32690028 0.78877573 0.45487411 0.22390881 0.76352613
      [1201] 0.65268611 0.58910004 0.35368440 0.66316115 0.42976528 0.87628488
      [1207] 0.90702032 0.27034765 0.90702032 0.32690028 0.32690028 0.66316115
      [1213] 0.38897634 0.93072359 0.38897634 0.45487411 0.65268611 0.65268611
      [1219] 0.80887717 0.14127713 0.52239129 0.78877573 0.45487411 0.58839620
      [1225] 0.32690028 0.78877573 0.38897634 0.71125529 0.73056430 0.45487411
      [1231] 0.52239129 0.78877573 0.52239129 0.73056430 0.90702032 0.35368440
      [1237] 0.78877573 0.42976528 0.73056430 0.32690028 0.58839620 0.66316115
      [1243] 0.58839620 0.73056430 0.71125529 0.50931523 0.71125529 0.58839620
      [1249] 0.93072359 0.32690028 0.32690028 0.32690028 0.45487411 0.52239129
      [1255] 0.38897634 0.22037531 0.52239129 0.73056430 0.50931523 0.58839620
      [1261] 0.52239129 0.17739435 0.32690028 0.66316115 0.58839620 0.14127713
      [1267] 0.50931523 0.66316115 0.50931523 0.28435576 0.28435576 0.52239129
      [1273] 0.71125529 0.35368440 0.76352613 0.73056430 0.32690028 0.83721296
      [1279] 0.45487411 0.65268611 0.32690028 0.90702032 0.14127713 0.58910004
      [1285] 0.58910004 0.22390881 0.50931523 0.93072359 0.14127713 0.52239129
      [1291] 0.83721296 0.14127713 0.58910004 0.65268611 0.66316115 0.45487411
      [1297] 0.65268611 0.83721296 0.38897634 0.58910004 0.78877573 0.14127713
      [1303] 0.78877573 0.32690028 0.76352613 0.66316115 0.27034765 0.58839620
      [1309] 0.50931523 0.83721296 0.83721296 0.42976528 0.38897634 0.22037531
      [1315] 0.52239129 0.73056430 0.78877573 0.87628488 0.71125529 0.66316115
      [1321] 0.58910004 0.38897634 0.50931523 0.78877573 0.65268611 0.27034765
      [1327] 0.32690028 0.52239129 0.83721296 0.28435576 0.65268611 0.50931523
      [1333] 0.73056430 0.38897634 0.50931523 0.78877573 0.27034765 0.58839620
      [1339] 0.78877573 0.27034765 0.32690028 0.90702032 0.58839620 0.28435576
      [1345] 0.58839620 0.45487411 0.50931523 0.22037531 0.32690028 0.52239129
      [1351] 0.38897634 0.50931523 0.87628488 0.76352613 0.35368440 0.58910004
      [1357] 0.52239129 0.58839620 0.76352613 0.83721296 0.27034765 0.66316115
      [1363] 0.58839620 0.22037531 0.52239129 0.66316115 0.90702032 0.38897634
      [1369] 0.66316115 0.90702032 0.65268611 0.66316115 0.87910405 0.32690028
      [1375] 0.45487411 0.52239129 0.78877573 0.45487411 0.58839620 0.42976528
      [1381] 0.22037531 0.50931523 0.58839620 0.17739435 0.78877573 0.32690028
      [1387] 0.38897634 0.17739435 0.11151645 0.78877573 0.52239129 0.52239129
      [1393] 0.73056430 0.76352613 0.76352613 0.73056430 0.42976528 0.58910004
      [1399] 0.45487411 0.17320152 0.78877573 0.96223973 0.42976528 0.78877573
      [1405] 0.38897634 0.38897634 0.66316115 0.52239129 0.84727053 0.78877573
      [1411] 0.22390881 0.50931523 0.27034765 0.35368440 0.42976528 0.90702032
      [1417] 0.65268611 0.73056430 0.17320152 0.58910004 0.32690028 0.52239129
      [1423] 0.45487411 0.83721296 0.66316115 0.73056430 0.66316115 0.28435576
      [1429] 0.42976528 0.17739435 0.71125529 0.32690028 0.58839620 0.50931523
      [1435] 0.42976528 0.17739435 0.73056430 0.94872579 0.73056430 0.50931523
      [1441] 0.17739435 0.73056430 0.58910004 0.58839620 0.83721296 0.27034765
      [1447] 0.76352613 0.35368440 0.66316115 0.71125529 0.87628488 0.45487411
      [1453] 0.38897634 0.42976528 0.58910004 0.65268611 0.73056430 0.32690028
      [1459] 0.52239129 0.22390881 0.50931523 0.58910004 0.32690028 0.27034765
      [1465] 0.78877573 0.52239129 0.52239129 0.52239129 0.66316115 0.17739435
      [1471] 0.50931523 0.80887717 0.17320152 0.78877573 0.38897634 0.28435576
      [1477] 0.73056430 0.11151645 0.83721296 0.73056430 0.38897634 0.83721296
      [1483] 0.38897634 0.94872579 0.45487411 0.52239129 0.28435576 0.71125529
      [1489] 0.45487411 0.66316115 0.66316115 0.32690028 0.52239129 0.73056430
      [1495] 0.58839620 0.38897634 0.45487411 0.78877573 0.66316115 0.58839620
      [1501] 0.73056430 0.52239129 0.90702032 0.17739435 0.78877573 0.66316115
      [1507] 0.22037531 0.52239129 0.17739435 0.52239129 0.27034765 0.45487411
      [1513] 0.38897634 0.27034765 0.58839620 0.42976528 0.58839620 0.50931523
      [1519] 0.14127713 0.73056430 0.45487411 0.65268611 0.50931523 0.78877573
      [1525] 0.52239129 0.66316115 0.22390881 0.66316115 0.58839620 0.66316115
      [1531] 0.42976528 0.76352613 0.73056430 0.45487411 0.32690028 0.93072359
      [1537] 0.27034765 0.50931523 0.66316115 0.58839620 0.83721296 0.66316115
      [1543] 0.22390881 0.38897634 0.83721296 0.83721296 0.32690028 0.66316115
      [1549] 0.66316115 0.14127713 0.27034765 0.22037531 0.28435576 0.38897634
      [1555] 0.45487411 0.32690028 0.58910004 0.22037531 0.65268611 0.35368440
      [1561] 0.13202412 0.58910004 0.93072359 0.58910004 0.65268611 0.66316115
      [1567] 0.50931523 0.93072359 0.14127713 0.45487411 0.78877573 0.65268611
      [1573] 0.73056430 0.45487411 0.38897634 0.58910004 0.32690028 0.58910004
      [1579] 0.58910004 0.83721296 0.22390881 0.38897634 0.80887717 0.14127713
      [1585] 0.87628488 0.71125529 0.58910004 0.28435576 0.17739435 0.73056430
      [1591] 0.73056430 0.35368440 0.58910004 0.27034765 0.58910004 0.52239129
      [1597] 0.78877573 0.27034765 0.78877573 0.52239129 0.58910004 0.96223973
      [1603] 0.09945871 0.38897634 0.66316115 0.73056430 0.38897634 0.38897634
      [1609] 0.28435576 0.52239129 0.58839620 0.38897634 0.73056430 0.22390881
      [1615] 0.87628488 0.58839620 0.52239129 0.27034765 0.45487411 0.17739435
      [1621] 0.58910004 0.78877573 0.58839620 0.52239129 0.35368440 0.17320152
      [1627] 0.66316115 0.73056430 0.87628488 0.73056430 0.58839620 0.42976528
      [1633] 0.52239129 0.66316115 0.27034765 0.73056430 0.73056430 0.73056430
      [1639] 0.32690028 0.52239129 0.87628488 0.66316115 0.42976528 0.66316115
      [1645] 0.52239129 0.78877573 0.28435576 0.73056430 0.50931523 0.50931523
      [1651] 0.32690028 0.78877573 0.32690028 0.52239129 0.45487411 0.58839620
      [1657] 0.27034765 0.45487411 0.17739435 0.78877573 0.65268611 0.78877573
      [1663] 0.93072359 0.52239129 0.28435576 0.52239129 0.58910004 0.83721296
      [1669] 0.08738702 0.66316115 0.32690028 0.32690028 0.50931523 0.17320152
      [1675] 0.42976528 0.50931523 0.73056430 0.52239129 0.52239129 0.73056430
      [1681] 0.42976528 0.28435576 0.58839620 0.73056430 0.50931523 0.42976528
      [1687] 0.27034765 0.27034765 0.22037531 0.71125529 0.38897634 0.58839620
      [1693] 0.50931523 0.22390881 0.65268611 0.32690028 0.38897634 0.65268611
      [1699] 0.45487411 0.45487411 0.11151645 0.08738702 0.58839620 0.50931523
      [1705] 0.38897634 0.27034765 0.71125529 0.66316115 0.90702032 0.58839620
      [1711] 0.17739435 0.35368440 0.27034765 0.58839620 0.32690028 0.45487411
      [1717] 0.93072359 0.50931523 0.22037531 0.27034765 0.66316115 0.22037531
      [1723] 0.73056430 0.38897634 0.52239129 0.65268611 0.58910004 0.22037531
      [1729] 0.58910004 0.17739435 0.38897634 0.45487411 0.83721296 0.58839620
      [1735] 0.66316115 0.52239129 0.14127713 0.65268611 0.27034765 0.52239129
      [1741] 0.58910004 0.28435576 0.45487411 0.96223973 0.52239129 0.38897634
      [1747] 0.27034765 0.32690028 0.83721296 0.14127713 0.42976528 0.73056430
      [1753] 0.27034765 0.94872579 0.32690028 0.65268611 0.50931523 0.27034765
      [1759] 0.32690028 0.71125529 0.83721296 0.22390881 0.32690028 0.50931523
      [1765] 0.58910004 0.84727053 0.94872579 0.66316115 0.52239129 0.83721296
      [1771] 0.35368440 0.28435576 0.78877573 0.58910004 0.13202412 0.87628488
      [1777] 0.66316115 0.45487411 0.22037531 0.38897634 0.76352613 0.28435576
      [1783] 0.27034765 0.52239129 0.17320152 0.14127713 0.38897634 0.65268611
      [1789] 0.78877573 0.78877573 0.42976528 0.58910004 0.78877573 0.58910004
      [1795] 0.93072359 0.65268611 0.38897634 0.78877573 0.58910004 0.58839620
      [1801] 0.32690028 0.58910004 0.76352613 0.32690028 0.58839620 0.58839620
      [1807] 0.35368440 0.50931523 0.45487411 0.58839620 0.42976528 0.87628488
      [1813] 0.32690028 0.52239129 0.17320152 0.38897634 0.83721296 0.22037531
      [1819] 0.66316115 0.22037531 0.38897634 0.90702032 0.45487411 0.32690028
      [1825] 0.22037531 0.27034765 0.73056430 0.76352613 0.14127713 0.14127713
      [1831] 0.58839620 0.52239129 0.66316115 0.38897634 0.22037531 0.28435576
      [1837] 0.52239129 0.35368440 0.45487411 0.52239129 0.50931523 0.73056430
      [1843] 0.76352613 0.38897634 0.50931523 0.76352613 0.66316115 0.14127713
      [1849] 0.66316115 0.17739435 0.50931523 0.27034765 0.27034765 0.66316115
      [1855] 0.58910004 0.83721296 0.22037531 0.32690028 0.58839620 0.45487411
      [1861] 0.45487411 0.35368440 0.17320152 0.22037531 0.32690028 0.78877573
      [1867] 0.78877573 0.45487411 0.27034765 0.58910004 0.65268611 0.58839620
      [1873] 0.83721296 0.66316115 0.65268611 0.38897634 0.35368440 0.65268611
      [1879] 0.66316115 0.78877573 0.87628488 0.58839620 0.38897634 0.28435576
      [1885] 0.71125529 0.65268611 0.73056430 0.45487411 0.65268611 0.42976528
      [1891] 0.14127713 0.50931523 0.17739435 0.52239129 0.42976528 0.50931523
      [1897] 0.58839620 0.58839620 0.83721296 0.58839620 0.45487411 0.58910004
      [1903] 0.66316115 0.32690028 0.73056430 0.71125529 0.28435576 0.73056430
      [1909] 0.73056430 0.32690028 0.73056430 0.66316115 0.32690028 0.83721296
      [1915] 0.38897634 0.50931523 0.71125529 0.78877573 0.32690028 0.73056430
      [1921] 0.38897634 0.38897634 0.17739435 0.14127713 0.90702032 0.27034765
      [1927] 0.58839620 0.35368440 0.65268611 0.42976528 0.22390881 0.52239129
      [1933] 0.66316115 0.27034765 0.50931523 0.52239129 0.83721296 0.27034765
      [1939] 0.22390881 0.58839620 0.45487411 0.52239129 0.66316115 0.22037531
      [1945] 0.45487411 0.87628488 0.58910004 0.73056430 0.73056430 0.32690028
      [1951] 0.65268611 0.87910405 0.28435576 0.71125529 0.50931523 0.42976528
      [1957] 0.66316115 0.32690028 0.73056430 0.73056430 0.35368440 0.83721296
      [1963] 0.52239129 0.58910004 0.58839620 0.35368440 0.65268611 0.71125529
      [1969] 0.45487411 0.83721296 0.58910004 0.58839620 0.58839620 0.17739435
      [1975] 0.58839620 0.73056430 0.50931523 0.42976528 0.32690028 0.11151645
      [1981] 0.35368440 0.66316115 0.52239129 0.35368440 0.27034765 0.35368440
      [1987] 0.45487411 0.73056430 0.28435576 0.80887717 0.32690028 0.66316115
      [1993] 0.28435576 0.73056430 0.80887717 0.52239129 0.45487411 0.73056430
      [1999] 0.73056430 0.71125529
      attr(,"label")
      [1] "Fitted values"

---

    Code
      residuals(fit_em)
    Output
         [1] -0.45487411  0.23647387  0.12371512 -0.22037531  0.21122427 -0.28435576
         [7]  0.47760871  0.57023472  0.21122427  0.23647387  0.16278704  0.28874471
        [13] -0.45487411 -0.50931523 -0.73056430 -0.35368440  0.41160380  0.28874471
        [19] -0.45487411 -0.32690028  0.57023472  0.19112283  0.12371512  0.16278704
        [25]  0.33683885  0.49068477  0.23647387 -0.50931523  0.28874471 -0.27034765
        [31] -0.50931523 -0.65268611 -0.78877573 -0.32690028  0.54512589 -0.52239129
        [37] -0.66316115  0.16278704  0.49068477 -0.58910004 -0.27034765  0.49068477
        [43] -0.50931523  0.21122427  0.21122427 -0.45487411 -0.32690028  0.49068477
        [49]  0.77962469 -0.52239129  0.47760871 -0.27034765  0.85872287 -0.52239129
        [55]  0.67309972  0.41160380 -0.32690028  0.47760871 -0.52239129  0.47760871
        [61]  0.12089595 -0.66316115  0.67309972 -0.22037531  0.34731389 -0.73056430
        [67] -0.22037531  0.26943570 -0.08738702  0.06927641 -0.42976528 -0.22037531
        [73]  0.54512589  0.41160380 -0.50931523  0.77962469  0.34731389 -0.22390881
        [79] -0.32690028  0.49068477  0.47760871 -0.58839620 -0.22037531 -0.35368440
        [85] -0.50931523 -0.65268611  0.71564424 -0.35368440 -0.45487411 -0.73056430
        [91] -0.28435576  0.28874471 -0.45487411  0.28874471  0.72965235 -0.22037531
        [97]  0.61102366  0.16278704 -0.27034765  0.15272947  0.05127421  0.47760871
       [103]  0.47760871  0.33683885 -0.38897634 -0.17320152  0.21122427 -0.78877573
       [109]  0.33683885 -0.14127713  0.34731389 -0.45487411  0.61102366  0.16278704
       [115] -0.32690028 -0.58839620  0.67309972  0.12371512 -0.22037531  0.54512589
       [121]  0.23647387 -0.45487411 -0.27034765  0.16278704 -0.27034765  0.49068477
       [127]  0.72965235 -0.22390881 -0.27034765 -0.28435576  0.54512589 -0.42976528
       [133] -0.42976528  0.16278704 -0.38897634 -0.38897634 -0.13202412  0.41089996
       [139]  0.26943570  0.16278704 -0.38897634  0.82260565 -0.28435576  0.21122427
       [145]  0.49068477 -0.66316115  0.09297968  0.26943570 -0.22037531  0.67309972
       [151] -0.27034765 -0.22037531  0.33683885 -0.45487411  0.16278704 -0.35368440
       [157] -0.22037531  0.09297968  0.06927641  0.61102366  0.57023472  0.47760871
       [163] -0.90702032 -0.14127713  0.57023472 -0.45487411  0.33683885 -0.90702032
       [169] -0.27034765  0.21122427 -0.28435576  0.33683885 -0.58910004  0.41160380
       [175] -0.73056430  0.57023472 -0.45487411  0.23647387  0.12371512 -0.17739435
       [181]  0.61102366  0.12371512  0.09297968  0.19112283 -0.58910004 -0.50931523
       [187]  0.12371512 -0.35368440 -0.11151645  0.26943570 -0.32690028  0.49068477
       [193]  0.26943570 -0.14127713  0.09297968  0.41160380 -0.58839620 -0.66316115
       [199]  0.21122427  0.54512589 -0.32690028  0.41160380 -0.22390881  0.21122427
       [205]  0.12371512 -0.73056430  0.26943570 -0.45487411  0.21122427 -0.38897634
       [211] -0.58910004  0.61102366  0.77609119 -0.52239129 -0.17739435 -0.28435576
       [217]  0.26943570  0.21122427  0.06927641  0.26943570  0.41089996 -0.38897634
       [223] -0.38897634 -0.73056430 -0.38897634  0.57023472  0.26943570  0.49068477
       [229]  0.41160380 -0.52239129  0.64631560  0.09297968  0.12371512  0.64631560
       [235]  0.16278704 -0.73056430  0.41160380 -0.93072359 -0.32690028  0.09297968
       [241]  0.26943570 -0.65268611  0.33683885  0.54512589  0.49068477 -0.32690028
       [247] -0.45487411 -0.58839620  0.41089996 -0.32690028  0.16278704  0.49068477
       [253]  0.21122427 -0.66316115 -0.58910004 -0.58910004  0.33683885  0.54512589
       [259]  0.28874471  0.21122427 -0.08738702  0.34731389 -0.35368440 -0.27034765
       [265]  0.33683885 -0.58839620  0.16278704 -0.45487411  0.23647387 -0.14127713
       [271] -0.45487411 -0.66316115  0.21122427 -0.35368440  0.09297968 -0.32690028
       [277] -0.52239129 -0.17739435  0.64631560 -0.52239129 -0.27034765  0.26943570
       [283]  0.41160380 -0.42976528 -0.58910004 -0.76352613  0.49068477 -0.78877573
       [289]  0.06927641 -0.42976528 -0.42976528 -0.27034765  0.67309972 -0.58839620
       [295]  0.54512589  0.16278704  0.41089996 -0.50931523  0.41089996  0.16278704
       [301]  0.41089996 -0.38897634 -0.35368440 -0.22390881 -0.66316115  0.09297968
       [307]  0.21122427  0.09297968  0.57023472 -0.38897634 -0.66316115 -0.27034765
       [313] -0.45487411 -0.52239129  0.15272947  0.21122427 -0.52239129 -0.65268611
       [319]  0.41160380 -0.32690028  0.72965235  0.47760871  0.26943570 -0.06807856
       [325]  0.34731389  0.26943570 -0.35368440  0.21122427  0.26943570 -0.14127713
       [331] -0.32690028 -0.38897634 -0.45487411  0.72965235  0.12371512  0.49068477
       [337] -0.58839620  0.54512589  0.33683885 -0.38897634 -0.66316115  0.41089996
       [343]  0.21122427 -0.73056430  0.49068477  0.49068477  0.54512589  0.57023472
       [349]  0.16278704 -0.27034765 -0.17739435  0.16278704 -0.58839620  0.33683885
       [355] -0.28435576  0.16278704 -0.52239129 -0.27034765 -0.28435576  0.57023472
       [361]  0.23647387  0.72965235 -0.52239129 -0.28435576  0.12371512 -0.45487411
       [367] -0.35368440 -0.32690028 -0.27034765 -0.58910004 -0.35368440 -0.52239129
       [373]  0.77962469 -0.42976528  0.41160380  0.67309972 -0.14127713 -0.73056430
       [379]  0.49068477  0.21122427  0.16278704 -0.52239129  0.57023472 -0.58839620
       [385] -0.66316115  0.06927641 -0.50931523  0.03776027 -0.35368440 -0.11151645
       [391] -0.32690028 -0.38897634  0.28874471 -0.52239129 -0.50931523  0.61102366
       [397] -0.42976528  0.19112283 -0.80887717  0.16278704 -0.22390881 -0.32690028
       [403] -0.45487411 -0.83721296  0.09297968 -0.38897634  0.47760871  0.41089996
       [409]  0.54512589  0.19112283  0.34731389  0.54512589  0.21122427 -0.42976528
       [415] -0.58839620 -0.17739435  0.47760871 -0.28435576  0.57023472  0.88848355
       [421] -0.32690028  0.34731389 -0.45487411 -0.45487411  0.47760871 -0.35368440
       [427] -0.65268611  0.34731389 -0.52239129  0.49068477 -0.38897634  0.54512589
       [433]  0.49068477  0.16278704 -0.32690028  0.23647387  0.21122427  0.72965235
       [439]  0.77609119 -0.52239129  0.41089996  0.47760871  0.26943570 -0.22037531
       [445] -0.32690028  0.21122427 -0.65268611 -0.65268611 -0.17739435 -0.32690028
       [451]  0.41089996 -0.14127713  0.19112283  0.47760871  0.49068477  0.28874471
       [457]  0.47760871  0.41089996  0.67309972  0.26943570  0.47760871  0.41089996
       [463] -0.71125529 -0.78877573  0.82679848  0.72965235 -0.52239129  0.26943570
       [469] -0.58910004  0.34731389 -0.58839620  0.33683885 -0.32690028 -0.50931523
       [475]  0.21122427  0.26943570 -0.35368440 -0.52239129 -0.52239129  0.26943570
       [481]  0.16278704 -0.58910004  0.21122427  0.26943570  0.49068477 -0.32690028
       [487]  0.21122427 -0.66316115 -0.45487411  0.34731389 -0.73056430 -0.22037531
       [493]  0.77962469 -0.32690028 -0.50931523  0.82260565  0.71564424  0.41089996
       [499] -0.50931523  0.23647387 -0.83721296 -0.22390881 -0.38897634  0.67309972
       [505] -0.50931523  0.57023472  0.67309972 -0.45487411  0.67309972  0.67309972
       [511] -0.32690028 -0.13202412 -0.17320152  0.33683885 -0.71125529 -0.28435576
       [517] -0.38897634  0.57023472 -0.27034765  0.47760871  0.41160380  0.47760871
       [523]  0.12089595 -0.76352613  0.47760871  0.34731389  0.12371512 -0.58910004
       [529] -0.27034765 -0.83721296  0.16278704 -0.58910004 -0.38897634  0.57023472
       [535]  0.67309972  0.33683885  0.33683885  0.26943570  0.49068477  0.47760871
       [541] -0.27034765 -0.38897634  0.34731389 -0.35368440  0.49068477  0.26943570
       [547] -0.52239129 -0.45487411 -0.38897634  0.77962469 -0.45487411 -0.22037531
       [553]  0.26943570  0.54512589  0.64631560 -0.45487411  0.34731389 -0.27034765
       [559]  0.33683885  0.47760871  0.16278704 -0.22390881  0.49068477  0.21122427
       [565]  0.54512589  0.41089996 -0.27034765 -0.73056430  0.09297968  0.57023472
       [571] -0.50931523 -0.71125529 -0.38897634  0.54512589  0.49068477 -0.52239129
       [577] -0.38897634  0.26943570  0.85872287 -0.38897634  0.57023472 -0.17739435
       [583]  0.49068477 -0.50931523  0.47760871 -0.27034765 -0.45487411 -0.11151645
       [589] -0.78877573  0.54512589  0.12371512 -0.17320152  0.64631560  0.41160380
       [595] -0.50931523  0.49068477  0.54512589 -0.22037531  0.41089996 -0.66316115
       [601]  0.72965235 -0.22390881  0.61102366  0.72965235 -0.32690028  0.26943570
       [607] -0.83721296 -0.73056430  0.23647387  0.41089996  0.33683885 -0.58910004
       [613] -0.58839620  0.23647387  0.54512589 -0.11151645 -0.50931523 -0.11151645
       [619] -0.73056430 -0.28435576 -0.45487411  0.82260565 -0.45487411 -0.45487411
       [625] -0.38897634 -0.17739435 -0.78877573  0.57023472  0.12371512  0.26943570
       [631] -0.22037531 -0.66316115  0.41160380  0.21122427  0.26943570  0.16278704
       [637]  0.33683885  0.26943570  0.41160380  0.12371512 -0.42976528 -0.58839620
       [643]  0.41160380 -0.58910004  0.77962469 -0.35368440  0.67309972  0.64631560
       [649] -0.42976528  0.49068477 -0.84727053 -0.42976528  0.26943570  0.26943570
       [655] -0.66316115 -0.45487411 -0.78877573  0.26943570 -0.17739435  0.26943570
       [661] -0.32690028  0.21122427 -0.27034765 -0.32690028  0.67309972  0.03776027
       [667] -0.58839620  0.33683885  0.71564424 -0.22037531 -0.38897634  0.41089996
       [673] -0.45487411 -0.32690028  0.26943570 -0.58910004 -0.17739435 -0.45487411
       [679] -0.32690028  0.54512589 -0.14127713 -0.42976528 -0.32690028 -0.11151645
       [685]  0.33683885 -0.87628488 -0.45487411  0.19112283 -0.32690028  0.61102366
       [691]  0.16278704 -0.52239129  0.49068477 -0.52239129 -0.22390881  0.21122427
       [697]  0.21122427  0.49068477  0.72965235  0.21122427  0.77609119  0.72965235
       [703]  0.09297968 -0.27034765  0.61102366  0.71564424 -0.78877573 -0.42976528
       [709]  0.57023472  0.67309972  0.88848355  0.12371512  0.21122427  0.41160380
       [715] -0.52239129 -0.52239129  0.41160380 -0.17739435 -0.32690028 -0.50931523
       [721]  0.47760871  0.57023472 -0.50931523 -0.58839620 -0.83721296 -0.71125529
       [727] -0.17739435 -0.38897634 -0.52239129  0.33683885 -0.38897634 -0.73056430
       [733] -0.58839620  0.61102366 -0.65268611  0.61102366  0.26943570 -0.22037531
       [739] -0.35368440  0.19112283 -0.52239129 -0.58910004  0.19112283  0.26943570
       [745] -0.32690028  0.47760871 -0.22390881 -0.87628488  0.28874471 -0.28435576
       [751]  0.28874471 -0.58910004 -0.58910004  0.33683885 -0.50931523  0.26943570
       [757] -0.42976528  0.61102366 -0.66316115  0.06927641 -0.22037531  0.61102366
       [763]  0.34731389 -0.14127713  0.72965235 -0.32690028 -0.50931523 -0.58839620
       [769] -0.50931523 -0.35368440 -0.35368440  0.12371512  0.26943570 -0.52239129
       [775] -0.32690028 -0.35368440  0.34731389  0.26943570 -0.38897634  0.16278704
       [781]  0.33683885  0.64631560  0.21122427 -0.38897634 -0.42976528  0.67309972
       [787] -0.27034765  0.49068477  0.49068477  0.41089996  0.71564424  0.16278704
       [793] -0.50931523  0.26943570 -0.17739435  0.49068477  0.54512589 -0.58839620
       [799] -0.35368440 -0.27034765  0.41160380 -0.58839620  0.21122427  0.19112283
       [805]  0.28874471 -0.73056430 -0.32690028 -0.42976528 -0.27034765  0.19112283
       [811]  0.16278704 -0.52239129 -0.71125529  0.21122427 -0.27034765 -0.42976528
       [817] -0.22037531 -0.52239129 -0.45487411 -0.17739435 -0.78877573  0.26943570
       [823]  0.21122427  0.12371512  0.12371512  0.61102366  0.57023472 -0.17739435
       [829] -0.50931523 -0.45487411 -0.22037531 -0.22390881 -0.52239129  0.47760871
       [835] -0.32690028 -0.22037531  0.54512589 -0.35368440 -0.83721296  0.41089996
       [841]  0.33683885  0.57023472 -0.73056430 -0.28435576 -0.58910004 -0.38897634
       [847] -0.27034765 -0.27034765  0.26943570 -0.14127713 -0.50931523  0.57023472
       [853] -0.58839620 -0.22390881  0.41160380 -0.38897634 -0.52239129  0.41160380
       [859]  0.47760871 -0.73056430  0.47760871  0.26943570 -0.65268611  0.23647387
       [865]  0.54512589 -0.58910004  0.19112283  0.47760871  0.41160380 -0.27034765
       [871]  0.41160380  0.12371512  0.33683885  0.61102366  0.09297968  0.26943570
       [877]  0.41160380  0.64631560  0.54512589  0.34731389 -0.38897634 -0.17739435
       [883]  0.49068477  0.12371512  0.41160380  0.54512589  0.33683885  0.41160380
       [889] -0.38897634  0.21122427  0.57023472 -0.17739435  0.57023472  0.34731389
       [895]  0.41089996  0.54512589 -0.32690028  0.19112283 -0.65268611  0.33683885
       [901] -0.58839620 -0.32690028  0.23647387  0.67309972  0.26943570 -0.27034765
       [907]  0.26943570  0.41089996  0.67309972  0.21122427  0.33683885 -0.38897634
       [913] -0.58910004  0.41160380 -0.38897634  0.21122427  0.61102366  0.54512589
       [919]  0.41089996  0.12371512 -0.58910004  0.64631560 -0.42976528 -0.50931523
       [925]  0.33683885 -0.17739435  0.41160380  0.41089996  0.49068477 -0.58910004
       [931]  0.26943570  0.23647387  0.41160380 -0.42976528 -0.58839620 -0.38897634
       [937] -0.58910004 -0.71125529 -0.17739435 -0.73056430 -0.52239129 -0.42976528
       [943] -0.38897634  0.12371512 -0.32690028 -0.58910004 -0.17739435 -0.22390881
       [949]  0.41160380  0.49068477  0.41089996  0.47760871 -0.38897634  0.12371512
       [955]  0.33683885  0.82260565 -0.50931523 -0.52239129  0.77962469  0.16278704
       [961]  0.23647387 -0.27034765  0.82260565 -0.66316115 -0.22037531 -0.22037531
       [967] -0.45487411  0.34731389  0.54512589  0.72965235  0.61102366 -0.14127713
       [973] -0.58839620 -0.71125529 -0.38897634  0.33683885 -0.71125529  0.28874471
       [979]  0.33683885 -0.73056430  0.34731389  0.09297968 -0.58839620 -0.78877573
       [985]  0.77962469 -0.66316115 -0.58839620 -0.27034765  0.47760871  0.41089996
       [991] -0.06807856  0.41089996  0.47760871 -0.38897634  0.26943570 -0.35368440
       [997] -0.90702032 -0.38897634  0.12371512  0.33683885  0.41160380  0.64631560
      [1003] -0.22037531  0.57023472  0.26943570 -0.28435576  0.05127421 -0.66316115
      [1009]  0.41089996  0.49068477 -0.22037531 -0.66316115 -0.09945871  0.54512589
      [1015]  0.41160380  0.72965235  0.85872287  0.26943570 -0.35368440  0.41160380
      [1021]  0.26943570 -0.42976528  0.09297968  0.57023472  0.34731389  0.54512589
      [1027]  0.33683885  0.77962469 -0.32690028  0.33683885 -0.42976528  0.41089996
      [1033]  0.47760871 -0.17739435  0.28874471 -0.58839620 -0.11151645 -0.42976528
      [1039] -0.73056430 -0.13202412  0.33683885  0.61102366 -0.42976528 -0.65268611
      [1045]  0.34731389 -0.66316115 -0.32690028  0.64631560 -0.38897634  0.21122427
      [1051] -0.27034765  0.67309972 -0.66316115 -0.42976528  0.47760871 -0.45487411
      [1057]  0.77609119  0.54512589 -0.38897634  0.61102366 -0.28435576  0.64631560
      [1063]  0.41089996  0.49068477  0.26943570  0.26943570  0.21122427  0.16278704
      [1069] -0.35368440 -0.66316115 -0.45487411 -0.42976528 -0.45487411 -0.11151645
      [1075]  0.21122427  0.21122427 -0.08738702  0.77962469 -0.50931523 -0.27034765
      [1081]  0.57023472  0.77962469  0.06927641 -0.14127713  0.49068477  0.72965235
      [1087] -0.22390881  0.49068477 -0.17320152  0.57023472  0.41089996  0.21122427
      [1093] -0.87628488  0.21122427 -0.66316115 -0.52239129 -0.58910004  0.82260565
      [1099]  0.67309972  0.67309972  0.06927641 -0.22390881  0.26943570  0.72965235
      [1105] -0.71125529 -0.58910004 -0.32690028  0.57023472  0.47760871  0.57023472
      [1111]  0.41089996 -0.45487411 -0.38897634 -0.22390881 -0.73056430  0.34731389
      [1117]  0.49068477  0.33683885  0.47760871  0.21122427  0.12371512  0.26943570
      [1123]  0.49068477  0.33683885  0.41160380  0.41160380 -0.35368440  0.61102366
      [1129]  0.57023472  0.33683885 -0.14127713 -0.38897634  0.19112283 -0.42976528
      [1135]  0.12371512  0.57023472 -0.28435576 -0.50931523  0.77609119  0.41160380
      [1141] -0.38897634 -0.14127713 -0.38897634  0.61102366  0.41089996 -0.58910004
      [1147]  0.21122427 -0.52239129 -0.38897634 -0.45487411  0.33683885 -0.22390881
      [1153] -0.22390881 -0.22037531 -0.78877573  0.09297968  0.12371512 -0.45487411
      [1159]  0.09297968 -0.73056430 -0.17320152 -0.22037531  0.49068477  0.28874471
      [1165]  0.26943570 -0.17320152 -0.50931523  0.77962469  0.49068477 -0.73056430
      [1171]  0.57023472 -0.42976528  0.71564424  0.12089595  0.06927641 -0.71125529
      [1177] -0.78877573  0.47760871 -0.11151645  0.41160380  0.21122427 -0.50931523
      [1183]  0.49068477 -0.66316115 -0.45487411 -0.58839620 -0.32690028  0.41089996
      [1189] -0.52239129  0.57023472  0.33683885  0.15272947 -0.76352613  0.47760871
      [1195]  0.21122427  0.67309972 -0.78877573  0.54512589  0.77609119  0.23647387
      [1201]  0.34731389  0.41089996 -0.35368440  0.33683885 -0.42976528  0.12371512
      [1207]  0.09297968 -0.27034765  0.09297968  0.67309972  0.67309972 -0.66316115
      [1213] -0.38897634  0.06927641  0.61102366  0.54512589 -0.65268611 -0.65268611
      [1219] -0.80887717 -0.14127713 -0.52239129  0.21122427  0.54512589 -0.58839620
      [1225] -0.32690028  0.21122427  0.61102366 -0.71125529  0.26943570  0.54512589
      [1231]  0.47760871 -0.78877573 -0.52239129 -0.73056430  0.09297968 -0.35368440
      [1237]  0.21122427 -0.42976528 -0.73056430 -0.32690028  0.41160380  0.33683885
      [1243]  0.41160380  0.26943570 -0.71125529 -0.50931523  0.28874471 -0.58839620
      [1249]  0.06927641 -0.32690028  0.67309972 -0.32690028  0.54512589 -0.52239129
      [1255]  0.61102366 -0.22037531 -0.52239129 -0.73056430  0.49068477 -0.58839620
      [1261]  0.47760871 -0.17739435 -0.32690028  0.33683885 -0.58839620 -0.14127713
      [1267] -0.50931523  0.33683885  0.49068477 -0.28435576  0.71564424 -0.52239129
      [1273]  0.28874471 -0.35368440  0.23647387  0.26943570  0.67309972  0.16278704
      [1279] -0.45487411 -0.65268611 -0.32690028  0.09297968 -0.14127713  0.41089996
      [1285]  0.41089996 -0.22390881  0.49068477  0.06927641 -0.14127713 -0.52239129
      [1291] -0.83721296 -0.14127713  0.41089996  0.34731389 -0.66316115 -0.45487411
      [1297]  0.34731389  0.16278704  0.61102366 -0.58910004  0.21122427 -0.14127713
      [1303]  0.21122427 -0.32690028  0.23647387 -0.66316115 -0.27034765 -0.58839620
      [1309] -0.50931523  0.16278704  0.16278704  0.57023472 -0.38897634  0.77962469
      [1315] -0.52239129 -0.73056430  0.21122427  0.12371512  0.28874471  0.33683885
      [1321]  0.41089996  0.61102366 -0.50931523  0.21122427 -0.65268611 -0.27034765
      [1327]  0.67309972  0.47760871  0.16278704  0.71564424  0.34731389 -0.50931523
      [1333] -0.73056430  0.61102366 -0.50931523  0.21122427  0.72965235  0.41160380
      [1339]  0.21122427  0.72965235  0.67309972  0.09297968  0.41160380 -0.28435576
      [1345]  0.41160380 -0.45487411 -0.50931523  0.77962469 -0.32690028  0.47760871
      [1351]  0.61102366 -0.50931523  0.12371512  0.23647387 -0.35368440  0.41089996
      [1357] -0.52239129  0.41160380  0.23647387  0.16278704 -0.27034765  0.33683885
      [1363]  0.41160380  0.77962469  0.47760871  0.33683885  0.09297968  0.61102366
      [1369]  0.33683885  0.09297968  0.34731389  0.33683885  0.12089595 -0.32690028
      [1375]  0.54512589  0.47760871  0.21122427 -0.45487411 -0.58839620 -0.42976528
      [1381] -0.22037531 -0.50931523 -0.58839620 -0.17739435  0.21122427 -0.32690028
      [1387] -0.38897634 -0.17739435 -0.11151645  0.21122427  0.47760871 -0.52239129
      [1393]  0.26943570  0.23647387  0.23647387  0.26943570 -0.42976528  0.41089996
      [1399] -0.45487411 -0.17320152  0.21122427  0.03776027 -0.42976528  0.21122427
      [1405] -0.38897634  0.61102366 -0.66316115 -0.52239129  0.15272947  0.21122427
      [1411] -0.22390881  0.49068477 -0.27034765 -0.35368440 -0.42976528 -0.90702032
      [1417]  0.34731389 -0.73056430 -0.17320152 -0.58910004 -0.32690028  0.47760871
      [1423]  0.54512589  0.16278704  0.33683885  0.26943570  0.33683885 -0.28435576
      [1429] -0.42976528 -0.17739435 -0.71125529 -0.32690028  0.41160380  0.49068477
      [1435] -0.42976528  0.82260565 -0.73056430  0.05127421  0.26943570  0.49068477
      [1441]  0.82260565 -0.73056430 -0.58910004  0.41160380  0.16278704 -0.27034765
      [1447]  0.23647387  0.64631560  0.33683885  0.28874471 -0.87628488 -0.45487411
      [1453] -0.38897634  0.57023472  0.41089996  0.34731389 -0.73056430 -0.32690028
      [1459]  0.47760871 -0.22390881  0.49068477 -0.58910004  0.67309972  0.72965235
      [1465]  0.21122427  0.47760871  0.47760871 -0.52239129 -0.66316115  0.82260565
      [1471] -0.50931523  0.19112283 -0.17320152  0.21122427 -0.38897634 -0.28435576
      [1477] -0.73056430 -0.11151645  0.16278704  0.26943570  0.61102366 -0.83721296
      [1483]  0.61102366  0.05127421  0.54512589 -0.52239129 -0.28435576  0.28874471
      [1489]  0.54512589 -0.66316115  0.33683885 -0.32690028 -0.52239129  0.26943570
      [1495] -0.58839620 -0.38897634 -0.45487411  0.21122427  0.33683885 -0.58839620
      [1501]  0.26943570 -0.52239129  0.09297968  0.82260565  0.21122427 -0.66316115
      [1507] -0.22037531 -0.52239129 -0.17739435 -0.52239129 -0.27034765 -0.45487411
      [1513]  0.61102366 -0.27034765  0.41160380  0.57023472 -0.58839620  0.49068477
      [1519] -0.14127713  0.26943570 -0.45487411  0.34731389  0.49068477  0.21122427
      [1525] -0.52239129  0.33683885 -0.22390881  0.33683885 -0.58839620  0.33683885
      [1531]  0.57023472  0.23647387  0.26943570 -0.45487411 -0.32690028  0.06927641
      [1537] -0.27034765  0.49068477  0.33683885  0.41160380  0.16278704 -0.66316115
      [1543] -0.22390881 -0.38897634  0.16278704  0.16278704 -0.32690028  0.33683885
      [1549] -0.66316115 -0.14127713  0.72965235 -0.22037531 -0.28435576  0.61102366
      [1555] -0.45487411 -0.32690028  0.41089996  0.77962469  0.34731389  0.64631560
      [1561] -0.13202412  0.41089996 -0.93072359  0.41089996  0.34731389  0.33683885
      [1567]  0.49068477 -0.93072359  0.85872287 -0.45487411  0.21122427  0.34731389
      [1573]  0.26943570 -0.45487411 -0.38897634  0.41089996 -0.32690028 -0.58910004
      [1579]  0.41089996 -0.83721296 -0.22390881 -0.38897634  0.19112283  0.85872287
      [1585]  0.12371512  0.28874471 -0.58910004 -0.28435576 -0.17739435  0.26943570
      [1591]  0.26943570 -0.35368440  0.41089996 -0.27034765 -0.58910004 -0.52239129
      [1597] -0.78877573 -0.27034765  0.21122427 -0.52239129  0.41089996  0.03776027
      [1603] -0.09945871 -0.38897634  0.33683885  0.26943570  0.61102366 -0.38897634
      [1609] -0.28435576  0.47760871  0.41160380 -0.38897634  0.26943570  0.77609119
      [1615]  0.12371512 -0.58839620  0.47760871 -0.27034765 -0.45487411 -0.17739435
      [1621] -0.58910004  0.21122427  0.41160380  0.47760871 -0.35368440  0.82679848
      [1627]  0.33683885  0.26943570  0.12371512 -0.73056430  0.41160380 -0.42976528
      [1633]  0.47760871 -0.66316115 -0.27034765 -0.73056430  0.26943570 -0.73056430
      [1639] -0.32690028  0.47760871  0.12371512 -0.66316115  0.57023472  0.33683885
      [1645] -0.52239129  0.21122427  0.71564424 -0.73056430 -0.50931523  0.49068477
      [1651]  0.67309972  0.21122427 -0.32690028 -0.52239129  0.54512589  0.41160380
      [1657] -0.27034765  0.54512589 -0.17739435 -0.78877573 -0.65268611  0.21122427
      [1663]  0.06927641 -0.52239129  0.71564424  0.47760871  0.41089996  0.16278704
      [1669] -0.08738702  0.33683885 -0.32690028  0.67309972 -0.50931523  0.82679848
      [1675] -0.42976528 -0.50931523 -0.73056430 -0.52239129  0.47760871  0.26943570
      [1681] -0.42976528 -0.28435576 -0.58839620  0.26943570  0.49068477 -0.42976528
      [1687]  0.72965235 -0.27034765  0.77962469  0.28874471 -0.38897634  0.41160380
      [1693]  0.49068477 -0.22390881  0.34731389 -0.32690028  0.61102366  0.34731389
      [1699] -0.45487411  0.54512589 -0.11151645 -0.08738702  0.41160380 -0.50931523
      [1705] -0.38897634 -0.27034765  0.28874471  0.33683885 -0.90702032 -0.58839620
      [1711] -0.17739435  0.64631560 -0.27034765 -0.58839620 -0.32690028 -0.45487411
      [1717]  0.06927641 -0.50931523 -0.22037531 -0.27034765  0.33683885 -0.22037531
      [1723] -0.73056430 -0.38897634  0.47760871  0.34731389  0.41089996 -0.22037531
      [1729]  0.41089996 -0.17739435 -0.38897634  0.54512589  0.16278704  0.41160380
      [1735]  0.33683885 -0.52239129 -0.14127713 -0.65268611 -0.27034765  0.47760871
      [1741] -0.58910004 -0.28435576 -0.45487411  0.03776027  0.47760871 -0.38897634
      [1747] -0.27034765 -0.32690028  0.16278704 -0.14127713 -0.42976528  0.26943570
      [1753] -0.27034765  0.05127421  0.67309972  0.34731389 -0.50931523 -0.27034765
      [1759] -0.32690028  0.28874471  0.16278704 -0.22390881 -0.32690028  0.49068477
      [1765]  0.41089996  0.15272947  0.05127421  0.33683885 -0.52239129  0.16278704
      [1771] -0.35368440 -0.28435576  0.21122427  0.41089996 -0.13202412  0.12371512
      [1777] -0.66316115  0.54512589 -0.22037531  0.61102366  0.23647387 -0.28435576
      [1783]  0.72965235  0.47760871 -0.17320152 -0.14127713 -0.38897634  0.34731389
      [1789]  0.21122427  0.21122427 -0.42976528  0.41089996 -0.78877573  0.41089996
      [1795]  0.06927641  0.34731389  0.61102366  0.21122427  0.41089996  0.41160380
      [1801] -0.32690028 -0.58910004  0.23647387 -0.32690028 -0.58839620 -0.58839620
      [1807]  0.64631560  0.49068477 -0.45487411 -0.58839620 -0.42976528  0.12371512
      [1813] -0.32690028  0.47760871 -0.17320152 -0.38897634  0.16278704 -0.22037531
      [1819]  0.33683885  0.77962469  0.61102366  0.09297968  0.54512589  0.67309972
      [1825] -0.22037531 -0.27034765  0.26943570 -0.76352613  0.85872287 -0.14127713
      [1831] -0.58839620  0.47760871  0.33683885 -0.38897634 -0.22037531 -0.28435576
      [1837]  0.47760871 -0.35368440 -0.45487411 -0.52239129 -0.50931523  0.26943570
      [1843]  0.23647387 -0.38897634  0.49068477  0.23647387  0.33683885 -0.14127713
      [1849] -0.66316115 -0.17739435 -0.50931523 -0.27034765 -0.27034765  0.33683885
      [1855] -0.58910004  0.16278704 -0.22037531 -0.32690028 -0.58839620  0.54512589
      [1861] -0.45487411 -0.35368440 -0.17320152 -0.22037531  0.67309972  0.21122427
      [1867]  0.21122427  0.54512589 -0.27034765 -0.58910004 -0.65268611 -0.58839620
      [1873]  0.16278704 -0.66316115  0.34731389  0.61102366  0.64631560  0.34731389
      [1879]  0.33683885  0.21122427  0.12371512 -0.58839620 -0.38897634 -0.28435576
      [1885]  0.28874471 -0.65268611  0.26943570  0.54512589 -0.65268611  0.57023472
      [1891] -0.14127713  0.49068477 -0.17739435  0.47760871  0.57023472 -0.50931523
      [1897]  0.41160380 -0.58839620  0.16278704 -0.58839620 -0.45487411 -0.58910004
      [1903]  0.33683885 -0.32690028  0.26943570 -0.71125529 -0.28435576  0.26943570
      [1909]  0.26943570 -0.32690028  0.26943570  0.33683885 -0.32690028  0.16278704
      [1915]  0.61102366 -0.50931523  0.28874471  0.21122427 -0.32690028  0.26943570
      [1921] -0.38897634  0.61102366 -0.17739435 -0.14127713  0.09297968 -0.27034765
      [1927]  0.41160380  0.64631560  0.34731389  0.57023472 -0.22390881  0.47760871
      [1933]  0.33683885 -0.27034765 -0.50931523 -0.52239129  0.16278704  0.72965235
      [1939] -0.22390881  0.41160380  0.54512589  0.47760871  0.33683885 -0.22037531
      [1945] -0.45487411  0.12371512 -0.58910004  0.26943570  0.26943570 -0.32690028
      [1951]  0.34731389  0.12089595  0.71564424  0.28874471 -0.50931523 -0.42976528
      [1957]  0.33683885  0.67309972  0.26943570  0.26943570 -0.35368440  0.16278704
      [1963] -0.52239129  0.41089996 -0.58839620  0.64631560  0.34731389  0.28874471
      [1969] -0.45487411  0.16278704  0.41089996 -0.58839620  0.41160380 -0.17739435
      [1975] -0.58839620  0.26943570 -0.50931523 -0.42976528 -0.32690028 -0.11151645
      [1981] -0.35368440  0.33683885 -0.52239129  0.64631560 -0.27034765  0.64631560
      [1987]  0.54512589  0.26943570  0.71564424  0.19112283  0.67309972  0.33683885
      [1993] -0.28435576  0.26943570  0.19112283 -0.52239129 -0.45487411  0.26943570
      [1999]  0.26943570  0.28874471
      attr(,"label")
      [1] "Residuals"

---

    Code
      (fit_plf <- estimNLR(y = y, match = match, group = group, formula = M$M1$
      formula, method = "plf", lower = M$M1$lower, upper = M$M1$upper, start = start))
    Output
      Nonlinear regression model 
      
       Model:  y ~ c + (1 - c)/(1 + exp(-(b0 + b1 * x + b2 * g + b3 * x * g))) 
      
      Coefficients:
           b0      b1      b2      b3       c 
       0.5503  0.9941 -0.8388 -0.1536  0.0028 
      
       Maximum likelihood estimation using the PLF-based algorithm 
      Converged after 3 iterations

---

    Code
      coef(fit_plf)
    Output
                b0           b1           b2           b3            c 
       0.550343985  0.994097463 -0.838776617 -0.153592745  0.002780102 

---

    Code
      logLik(fit_plf)
    Output
      'log Lik.' -1192.321 (df=5)

---

    Code
      vcov(fit_plf)
    Output
                  b0           b1          b2           b3           c
      b0  0.05495893 -0.021684101  0.02259576 -0.020979118 -0.02753933
      b1 -0.02168410  0.017562348 -0.01398739  0.002060718  0.01266679
      b2  0.02259576 -0.013987390  0.02572108 -0.010506627 -0.01546232
      b3 -0.02097912  0.002060718 -0.01050663  0.021088110  0.01098863
      c  -0.02753933  0.012666789 -0.01546232  0.010988632  0.01526970

---

    Code
      fitted(fit_plf)
    Output
         [1] 0.45638962 0.76418355 0.87662882 0.22254275 0.78936295 0.28634532
         [7] 0.52371909 0.43135059 0.78936295 0.76418355 0.83766553 0.71205803
        [13] 0.45638962 0.51067938 0.73131336 0.35548122 0.58954050 0.71205803
        [19] 0.45638962 0.32877157 0.43135059 0.80940851 0.87662882 0.83766553
        [25] 0.66409760 0.51067938 0.76418355 0.51067938 0.71205803 0.27237616
        [31] 0.51067938 0.65365167 0.78936295 0.32877157 0.45638962 0.52371909
        [37] 0.66409760 0.83766553 0.51067938 0.59024238 0.27237616 0.51067938
        [43] 0.51067938 0.78936295 0.78936295 0.45638962 0.32877157 0.51067938
        [49] 0.22254275 0.52371909 0.52371909 0.27237616 0.14366447 0.52371909
        [55] 0.32877157 0.58954050 0.32877157 0.52371909 0.52371909 0.52371909
        [61] 0.87944015 0.66409760 0.32877157 0.22254275 0.65365167 0.73131336
        [67] 0.22254275 0.73131336 0.08992418 0.93091619 0.43135059 0.22254275
        [73] 0.45638962 0.58954050 0.51067938 0.22254275 0.65365167 0.22606643
        [79] 0.32877157 0.51067938 0.52371909 0.58954050 0.22254275 0.35548122
        [85] 0.51067938 0.65365167 0.28634532 0.35548122 0.45638962 0.73131336
        [91] 0.28634532 0.71205803 0.45638962 0.71205803 0.27237616 0.22254275
        [97] 0.39067504 0.83766553 0.27237616 0.84769514 0.94886834 0.52371909
       [103] 0.52371909 0.66409760 0.39067504 0.17550010 0.78936295 0.78936295
       [109] 0.66409760 0.14366447 0.65365167 0.45638962 0.39067504 0.83766553
       [115] 0.32877157 0.58954050 0.32877157 0.87662882 0.22254275 0.45638962
       [121] 0.76418355 0.45638962 0.27237616 0.83766553 0.27237616 0.51067938
       [127] 0.27237616 0.22606643 0.27237616 0.28634532 0.45638962 0.43135059
       [133] 0.43135059 0.83766553 0.39067504 0.39067504 0.13443718 0.59024238
       [139] 0.73131336 0.83766553 0.39067504 0.17968128 0.28634532 0.78936295
       [145] 0.51067938 0.66409760 0.90727881 0.73131336 0.22254275 0.32877157
       [151] 0.27237616 0.22254275 0.66409760 0.45638962 0.83766553 0.35548122
       [157] 0.22254275 0.90727881 0.93091619 0.39067504 0.43135059 0.52371909
       [163] 0.90727881 0.14366447 0.43135059 0.45638962 0.66409760 0.90727881
       [169] 0.27237616 0.78936295 0.28634532 0.66409760 0.59024238 0.58954050
       [175] 0.73131336 0.43135059 0.45638962 0.76418355 0.87662882 0.17968128
       [181] 0.39067504 0.87662882 0.90727881 0.80940851 0.59024238 0.51067938
       [187] 0.87662882 0.35548122 0.11398653 0.73131336 0.32877157 0.51067938
       [193] 0.73131336 0.14366447 0.90727881 0.58954050 0.58954050 0.66409760
       [199] 0.78936295 0.45638962 0.32877157 0.58954050 0.22606643 0.78936295
       [205] 0.87662882 0.73131336 0.73131336 0.45638962 0.78936295 0.39067504
       [211] 0.59024238 0.39067504 0.22606643 0.52371909 0.17968128 0.28634532
       [217] 0.73131336 0.78936295 0.93091619 0.73131336 0.59024238 0.39067504
       [223] 0.39067504 0.73131336 0.39067504 0.43135059 0.73131336 0.51067938
       [229] 0.58954050 0.52371909 0.35548122 0.90727881 0.87662882 0.35548122
       [235] 0.83766553 0.73131336 0.58954050 0.93091619 0.32877157 0.90727881
       [241] 0.73131336 0.65365167 0.66409760 0.45638962 0.51067938 0.32877157
       [247] 0.45638962 0.58954050 0.59024238 0.32877157 0.83766553 0.51067938
       [253] 0.78936295 0.66409760 0.59024238 0.59024238 0.66409760 0.45638962
       [259] 0.71205803 0.78936295 0.08992418 0.65365167 0.35548122 0.27237616
       [265] 0.66409760 0.58954050 0.83766553 0.45638962 0.76418355 0.14366447
       [271] 0.45638962 0.66409760 0.78936295 0.35548122 0.90727881 0.32877157
       [277] 0.52371909 0.17968128 0.35548122 0.52371909 0.27237616 0.73131336
       [283] 0.58954050 0.43135059 0.59024238 0.76418355 0.51067938 0.78936295
       [289] 0.93091619 0.43135059 0.43135059 0.27237616 0.32877157 0.58954050
       [295] 0.45638962 0.83766553 0.59024238 0.51067938 0.59024238 0.83766553
       [301] 0.59024238 0.39067504 0.35548122 0.22606643 0.66409760 0.90727881
       [307] 0.78936295 0.90727881 0.43135059 0.39067504 0.66409760 0.27237616
       [313] 0.45638962 0.52371909 0.84769514 0.78936295 0.52371909 0.65365167
       [319] 0.58954050 0.32877157 0.27237616 0.52371909 0.73131336 0.07066939
       [325] 0.65365167 0.73131336 0.35548122 0.78936295 0.73131336 0.14366447
       [331] 0.32877157 0.39067504 0.45638962 0.27237616 0.87662882 0.51067938
       [337] 0.58954050 0.45638962 0.66409760 0.39067504 0.66409760 0.59024238
       [343] 0.78936295 0.73131336 0.51067938 0.51067938 0.45638962 0.43135059
       [349] 0.83766553 0.27237616 0.17968128 0.83766553 0.58954050 0.66409760
       [355] 0.28634532 0.83766553 0.52371909 0.27237616 0.28634532 0.43135059
       [361] 0.76418355 0.27237616 0.52371909 0.28634532 0.87662882 0.45638962
       [367] 0.35548122 0.32877157 0.27237616 0.59024238 0.35548122 0.52371909
       [373] 0.22254275 0.43135059 0.58954050 0.32877157 0.14366447 0.73131336
       [379] 0.51067938 0.78936295 0.83766553 0.52371909 0.43135059 0.58954050
       [385] 0.66409760 0.93091619 0.51067938 0.96234471 0.35548122 0.11398653
       [391] 0.32877157 0.39067504 0.71205803 0.52371909 0.51067938 0.39067504
       [397] 0.43135059 0.80940851 0.80940851 0.83766553 0.22606643 0.32877157
       [403] 0.45638962 0.83766553 0.90727881 0.39067504 0.52371909 0.59024238
       [409] 0.45638962 0.80940851 0.65365167 0.45638962 0.78936295 0.43135059
       [415] 0.58954050 0.17968128 0.52371909 0.28634532 0.43135059 0.11398653
       [421] 0.32877157 0.65365167 0.45638962 0.45638962 0.52371909 0.35548122
       [427] 0.65365167 0.65365167 0.52371909 0.51067938 0.39067504 0.45638962
       [433] 0.51067938 0.83766553 0.32877157 0.76418355 0.78936295 0.27237616
       [439] 0.22606643 0.52371909 0.59024238 0.52371909 0.73131336 0.22254275
       [445] 0.32877157 0.78936295 0.65365167 0.65365167 0.17968128 0.32877157
       [451] 0.59024238 0.14366447 0.80940851 0.52371909 0.51067938 0.71205803
       [457] 0.52371909 0.59024238 0.32877157 0.73131336 0.52371909 0.59024238
       [463] 0.71205803 0.78936295 0.17550010 0.27237616 0.52371909 0.73131336
       [469] 0.59024238 0.65365167 0.58954050 0.66409760 0.32877157 0.51067938
       [475] 0.78936295 0.73131336 0.35548122 0.52371909 0.52371909 0.73131336
       [481] 0.83766553 0.59024238 0.78936295 0.73131336 0.51067938 0.32877157
       [487] 0.78936295 0.66409760 0.45638962 0.65365167 0.73131336 0.22254275
       [493] 0.22254275 0.32877157 0.51067938 0.17968128 0.28634532 0.59024238
       [499] 0.51067938 0.76418355 0.83766553 0.22606643 0.39067504 0.32877157
       [505] 0.51067938 0.43135059 0.32877157 0.45638962 0.32877157 0.32877157
       [511] 0.32877157 0.13443718 0.17550010 0.66409760 0.71205803 0.28634532
       [517] 0.39067504 0.43135059 0.27237616 0.52371909 0.58954050 0.52371909
       [523] 0.87944015 0.76418355 0.52371909 0.65365167 0.87662882 0.59024238
       [529] 0.27237616 0.83766553 0.83766553 0.59024238 0.39067504 0.43135059
       [535] 0.32877157 0.66409760 0.66409760 0.73131336 0.51067938 0.52371909
       [541] 0.27237616 0.39067504 0.65365167 0.35548122 0.51067938 0.73131336
       [547] 0.52371909 0.45638962 0.39067504 0.22254275 0.45638962 0.22254275
       [553] 0.73131336 0.45638962 0.35548122 0.45638962 0.65365167 0.27237616
       [559] 0.66409760 0.52371909 0.83766553 0.22606643 0.51067938 0.78936295
       [565] 0.45638962 0.59024238 0.27237616 0.73131336 0.90727881 0.43135059
       [571] 0.51067938 0.71205803 0.39067504 0.45638962 0.51067938 0.52371909
       [577] 0.39067504 0.73131336 0.14366447 0.39067504 0.43135059 0.17968128
       [583] 0.51067938 0.51067938 0.52371909 0.27237616 0.45638962 0.11398653
       [589] 0.78936295 0.45638962 0.87662882 0.17550010 0.35548122 0.58954050
       [595] 0.51067938 0.51067938 0.45638962 0.22254275 0.59024238 0.66409760
       [601] 0.27237616 0.22606643 0.39067504 0.27237616 0.32877157 0.73131336
       [607] 0.83766553 0.73131336 0.76418355 0.59024238 0.66409760 0.59024238
       [613] 0.58954050 0.76418355 0.45638962 0.11398653 0.51067938 0.11398653
       [619] 0.73131336 0.28634532 0.45638962 0.17968128 0.45638962 0.45638962
       [625] 0.39067504 0.17968128 0.78936295 0.43135059 0.87662882 0.73131336
       [631] 0.22254275 0.66409760 0.58954050 0.78936295 0.73131336 0.83766553
       [637] 0.66409760 0.73131336 0.58954050 0.87662882 0.43135059 0.58954050
       [643] 0.58954050 0.59024238 0.22254275 0.35548122 0.32877157 0.35548122
       [649] 0.43135059 0.51067938 0.84769514 0.43135059 0.73131336 0.73131336
       [655] 0.66409760 0.45638962 0.78936295 0.73131336 0.17968128 0.73131336
       [661] 0.32877157 0.78936295 0.27237616 0.32877157 0.32877157 0.96234471
       [667] 0.58954050 0.66409760 0.28634532 0.22254275 0.39067504 0.59024238
       [673] 0.45638962 0.32877157 0.73131336 0.59024238 0.17968128 0.45638962
       [679] 0.32877157 0.45638962 0.14366447 0.43135059 0.32877157 0.11398653
       [685] 0.66409760 0.87662882 0.45638962 0.80940851 0.32877157 0.39067504
       [691] 0.83766553 0.52371909 0.51067938 0.52371909 0.22606643 0.78936295
       [697] 0.78936295 0.51067938 0.27237616 0.78936295 0.22606643 0.27237616
       [703] 0.90727881 0.27237616 0.39067504 0.28634532 0.78936295 0.43135059
       [709] 0.43135059 0.32877157 0.11398653 0.87662882 0.78936295 0.58954050
       [715] 0.52371909 0.52371909 0.58954050 0.17968128 0.32877157 0.51067938
       [721] 0.52371909 0.43135059 0.51067938 0.58954050 0.83766553 0.71205803
       [727] 0.17968128 0.39067504 0.52371909 0.66409760 0.39067504 0.73131336
       [733] 0.58954050 0.39067504 0.65365167 0.39067504 0.73131336 0.22254275
       [739] 0.35548122 0.80940851 0.52371909 0.59024238 0.80940851 0.73131336
       [745] 0.32877157 0.52371909 0.22606643 0.87662882 0.71205803 0.28634532
       [751] 0.71205803 0.59024238 0.59024238 0.66409760 0.51067938 0.73131336
       [757] 0.43135059 0.39067504 0.66409760 0.93091619 0.22254275 0.39067504
       [763] 0.65365167 0.14366447 0.27237616 0.32877157 0.51067938 0.58954050
       [769] 0.51067938 0.35548122 0.35548122 0.87662882 0.73131336 0.52371909
       [775] 0.32877157 0.35548122 0.65365167 0.73131336 0.39067504 0.83766553
       [781] 0.66409760 0.35548122 0.78936295 0.39067504 0.43135059 0.32877157
       [787] 0.27237616 0.51067938 0.51067938 0.59024238 0.28634532 0.83766553
       [793] 0.51067938 0.73131336 0.17968128 0.51067938 0.45638962 0.58954050
       [799] 0.35548122 0.27237616 0.58954050 0.58954050 0.78936295 0.80940851
       [805] 0.71205803 0.73131336 0.32877157 0.43135059 0.27237616 0.80940851
       [811] 0.83766553 0.52371909 0.71205803 0.78936295 0.27237616 0.43135059
       [817] 0.22254275 0.52371909 0.45638962 0.17968128 0.78936295 0.73131336
       [823] 0.78936295 0.87662882 0.87662882 0.39067504 0.43135059 0.17968128
       [829] 0.51067938 0.45638962 0.22254275 0.22606643 0.52371909 0.52371909
       [835] 0.32877157 0.22254275 0.45638962 0.35548122 0.83766553 0.59024238
       [841] 0.66409760 0.43135059 0.73131336 0.28634532 0.59024238 0.39067504
       [847] 0.27237616 0.27237616 0.73131336 0.14366447 0.51067938 0.43135059
       [853] 0.58954050 0.22606643 0.58954050 0.39067504 0.52371909 0.58954050
       [859] 0.52371909 0.73131336 0.52371909 0.73131336 0.65365167 0.76418355
       [865] 0.45638962 0.59024238 0.80940851 0.52371909 0.58954050 0.27237616
       [871] 0.58954050 0.87662882 0.66409760 0.39067504 0.90727881 0.73131336
       [877] 0.58954050 0.35548122 0.45638962 0.65365167 0.39067504 0.17968128
       [883] 0.51067938 0.87662882 0.58954050 0.45638962 0.66409760 0.58954050
       [889] 0.39067504 0.78936295 0.43135059 0.17968128 0.43135059 0.65365167
       [895] 0.59024238 0.45638962 0.32877157 0.80940851 0.65365167 0.66409760
       [901] 0.58954050 0.32877157 0.76418355 0.32877157 0.73131336 0.27237616
       [907] 0.73131336 0.59024238 0.32877157 0.78936295 0.66409760 0.39067504
       [913] 0.59024238 0.58954050 0.39067504 0.78936295 0.39067504 0.45638962
       [919] 0.59024238 0.87662882 0.59024238 0.35548122 0.43135059 0.51067938
       [925] 0.66409760 0.17968128 0.58954050 0.59024238 0.51067938 0.59024238
       [931] 0.73131336 0.76418355 0.58954050 0.43135059 0.58954050 0.39067504
       [937] 0.59024238 0.71205803 0.17968128 0.73131336 0.52371909 0.43135059
       [943] 0.39067504 0.87662882 0.32877157 0.59024238 0.17968128 0.22606643
       [949] 0.58954050 0.51067938 0.59024238 0.52371909 0.39067504 0.87662882
       [955] 0.66409760 0.17968128 0.51067938 0.52371909 0.22254275 0.83766553
       [961] 0.76418355 0.27237616 0.17968128 0.66409760 0.22254275 0.22254275
       [967] 0.45638962 0.65365167 0.45638962 0.27237616 0.39067504 0.14366447
       [973] 0.58954050 0.71205803 0.39067504 0.66409760 0.71205803 0.71205803
       [979] 0.66409760 0.73131336 0.65365167 0.90727881 0.58954050 0.78936295
       [985] 0.22254275 0.66409760 0.58954050 0.27237616 0.52371909 0.59024238
       [991] 0.07066939 0.59024238 0.52371909 0.39067504 0.73131336 0.35548122
       [997] 0.90727881 0.39067504 0.87662882 0.66409760 0.58954050 0.35548122
      [1003] 0.22254275 0.43135059 0.73131336 0.28634532 0.94886834 0.66409760
      [1009] 0.59024238 0.51067938 0.22254275 0.66409760 0.10196231 0.45638962
      [1015] 0.58954050 0.27237616 0.14366447 0.73131336 0.35548122 0.58954050
      [1021] 0.73131336 0.43135059 0.90727881 0.43135059 0.65365167 0.45638962
      [1027] 0.66409760 0.22254275 0.32877157 0.66409760 0.43135059 0.59024238
      [1033] 0.52371909 0.17968128 0.71205803 0.58954050 0.11398653 0.43135059
      [1039] 0.73131336 0.13443718 0.66409760 0.39067504 0.43135059 0.65365167
      [1045] 0.65365167 0.66409760 0.32877157 0.35548122 0.39067504 0.78936295
      [1051] 0.27237616 0.32877157 0.66409760 0.43135059 0.52371909 0.45638962
      [1057] 0.22606643 0.45638962 0.39067504 0.39067504 0.28634532 0.35548122
      [1063] 0.59024238 0.51067938 0.73131336 0.73131336 0.78936295 0.83766553
      [1069] 0.35548122 0.66409760 0.45638962 0.43135059 0.45638962 0.11398653
      [1075] 0.78936295 0.78936295 0.08992418 0.22254275 0.51067938 0.27237616
      [1081] 0.43135059 0.22254275 0.93091619 0.14366447 0.51067938 0.27237616
      [1087] 0.22606643 0.51067938 0.17550010 0.43135059 0.59024238 0.78936295
      [1093] 0.87662882 0.78936295 0.66409760 0.52371909 0.59024238 0.17968128
      [1099] 0.32877157 0.32877157 0.93091619 0.22606643 0.73131336 0.27237616
      [1105] 0.71205803 0.59024238 0.32877157 0.43135059 0.52371909 0.43135059
      [1111] 0.59024238 0.45638962 0.39067504 0.22606643 0.73131336 0.65365167
      [1117] 0.51067938 0.66409760 0.52371909 0.78936295 0.87662882 0.73131336
      [1123] 0.51067938 0.66409760 0.58954050 0.58954050 0.35548122 0.39067504
      [1129] 0.43135059 0.66409760 0.14366447 0.39067504 0.80940851 0.43135059
      [1135] 0.87662882 0.43135059 0.28634532 0.51067938 0.22606643 0.58954050
      [1141] 0.39067504 0.14366447 0.39067504 0.39067504 0.59024238 0.59024238
      [1147] 0.78936295 0.52371909 0.39067504 0.45638962 0.66409760 0.22606643
      [1153] 0.22606643 0.22254275 0.78936295 0.90727881 0.87662882 0.45638962
      [1159] 0.90727881 0.73131336 0.17550010 0.22254275 0.51067938 0.71205803
      [1165] 0.73131336 0.17550010 0.51067938 0.22254275 0.51067938 0.73131336
      [1171] 0.43135059 0.43135059 0.28634532 0.87944015 0.93091619 0.71205803
      [1177] 0.78936295 0.52371909 0.11398653 0.58954050 0.78936295 0.51067938
      [1183] 0.51067938 0.66409760 0.45638962 0.58954050 0.32877157 0.59024238
      [1189] 0.52371909 0.43135059 0.66409760 0.84769514 0.76418355 0.52371909
      [1195] 0.78936295 0.32877157 0.78936295 0.45638962 0.22606643 0.76418355
      [1201] 0.65365167 0.59024238 0.35548122 0.66409760 0.43135059 0.87662882
      [1207] 0.90727881 0.27237616 0.90727881 0.32877157 0.32877157 0.66409760
      [1213] 0.39067504 0.93091619 0.39067504 0.45638962 0.65365167 0.65365167
      [1219] 0.80940851 0.14366447 0.52371909 0.78936295 0.45638962 0.58954050
      [1225] 0.32877157 0.78936295 0.39067504 0.71205803 0.73131336 0.45638962
      [1231] 0.52371909 0.78936295 0.52371909 0.73131336 0.90727881 0.35548122
      [1237] 0.78936295 0.43135059 0.73131336 0.32877157 0.58954050 0.66409760
      [1243] 0.58954050 0.73131336 0.71205803 0.51067938 0.71205803 0.58954050
      [1249] 0.93091619 0.32877157 0.32877157 0.32877157 0.45638962 0.52371909
      [1255] 0.39067504 0.22254275 0.52371909 0.73131336 0.51067938 0.58954050
      [1261] 0.52371909 0.17968128 0.32877157 0.66409760 0.58954050 0.14366447
      [1267] 0.51067938 0.66409760 0.51067938 0.28634532 0.28634532 0.52371909
      [1273] 0.71205803 0.35548122 0.76418355 0.73131336 0.32877157 0.83766553
      [1279] 0.45638962 0.65365167 0.32877157 0.90727881 0.14366447 0.59024238
      [1285] 0.59024238 0.22606643 0.51067938 0.93091619 0.14366447 0.52371909
      [1291] 0.83766553 0.14366447 0.59024238 0.65365167 0.66409760 0.45638962
      [1297] 0.65365167 0.83766553 0.39067504 0.59024238 0.78936295 0.14366447
      [1303] 0.78936295 0.32877157 0.76418355 0.66409760 0.27237616 0.58954050
      [1309] 0.51067938 0.83766553 0.83766553 0.43135059 0.39067504 0.22254275
      [1315] 0.52371909 0.73131336 0.78936295 0.87662882 0.71205803 0.66409760
      [1321] 0.59024238 0.39067504 0.51067938 0.78936295 0.65365167 0.27237616
      [1327] 0.32877157 0.52371909 0.83766553 0.28634532 0.65365167 0.51067938
      [1333] 0.73131336 0.39067504 0.51067938 0.78936295 0.27237616 0.58954050
      [1339] 0.78936295 0.27237616 0.32877157 0.90727881 0.58954050 0.28634532
      [1345] 0.58954050 0.45638962 0.51067938 0.22254275 0.32877157 0.52371909
      [1351] 0.39067504 0.51067938 0.87662882 0.76418355 0.35548122 0.59024238
      [1357] 0.52371909 0.58954050 0.76418355 0.83766553 0.27237616 0.66409760
      [1363] 0.58954050 0.22254275 0.52371909 0.66409760 0.90727881 0.39067504
      [1369] 0.66409760 0.90727881 0.65365167 0.66409760 0.87944015 0.32877157
      [1375] 0.45638962 0.52371909 0.78936295 0.45638962 0.58954050 0.43135059
      [1381] 0.22254275 0.51067938 0.58954050 0.17968128 0.78936295 0.32877157
      [1387] 0.39067504 0.17968128 0.11398653 0.78936295 0.52371909 0.52371909
      [1393] 0.73131336 0.76418355 0.76418355 0.73131336 0.43135059 0.59024238
      [1399] 0.45638962 0.17550010 0.78936295 0.96234471 0.43135059 0.78936295
      [1405] 0.39067504 0.39067504 0.66409760 0.52371909 0.84769514 0.78936295
      [1411] 0.22606643 0.51067938 0.27237616 0.35548122 0.43135059 0.90727881
      [1417] 0.65365167 0.73131336 0.17550010 0.59024238 0.32877157 0.52371909
      [1423] 0.45638962 0.83766553 0.66409760 0.73131336 0.66409760 0.28634532
      [1429] 0.43135059 0.17968128 0.71205803 0.32877157 0.58954050 0.51067938
      [1435] 0.43135059 0.17968128 0.73131336 0.94886834 0.73131336 0.51067938
      [1441] 0.17968128 0.73131336 0.59024238 0.58954050 0.83766553 0.27237616
      [1447] 0.76418355 0.35548122 0.66409760 0.71205803 0.87662882 0.45638962
      [1453] 0.39067504 0.43135059 0.59024238 0.65365167 0.73131336 0.32877157
      [1459] 0.52371909 0.22606643 0.51067938 0.59024238 0.32877157 0.27237616
      [1465] 0.78936295 0.52371909 0.52371909 0.52371909 0.66409760 0.17968128
      [1471] 0.51067938 0.80940851 0.17550010 0.78936295 0.39067504 0.28634532
      [1477] 0.73131336 0.11398653 0.83766553 0.73131336 0.39067504 0.83766553
      [1483] 0.39067504 0.94886834 0.45638962 0.52371909 0.28634532 0.71205803
      [1489] 0.45638962 0.66409760 0.66409760 0.32877157 0.52371909 0.73131336
      [1495] 0.58954050 0.39067504 0.45638962 0.78936295 0.66409760 0.58954050
      [1501] 0.73131336 0.52371909 0.90727881 0.17968128 0.78936295 0.66409760
      [1507] 0.22254275 0.52371909 0.17968128 0.52371909 0.27237616 0.45638962
      [1513] 0.39067504 0.27237616 0.58954050 0.43135059 0.58954050 0.51067938
      [1519] 0.14366447 0.73131336 0.45638962 0.65365167 0.51067938 0.78936295
      [1525] 0.52371909 0.66409760 0.22606643 0.66409760 0.58954050 0.66409760
      [1531] 0.43135059 0.76418355 0.73131336 0.45638962 0.32877157 0.93091619
      [1537] 0.27237616 0.51067938 0.66409760 0.58954050 0.83766553 0.66409760
      [1543] 0.22606643 0.39067504 0.83766553 0.83766553 0.32877157 0.66409760
      [1549] 0.66409760 0.14366447 0.27237616 0.22254275 0.28634532 0.39067504
      [1555] 0.45638962 0.32877157 0.59024238 0.22254275 0.65365167 0.35548122
      [1561] 0.13443718 0.59024238 0.93091619 0.59024238 0.65365167 0.66409760
      [1567] 0.51067938 0.93091619 0.14366447 0.45638962 0.78936295 0.65365167
      [1573] 0.73131336 0.45638962 0.39067504 0.59024238 0.32877157 0.59024238
      [1579] 0.59024238 0.83766553 0.22606643 0.39067504 0.80940851 0.14366447
      [1585] 0.87662882 0.71205803 0.59024238 0.28634532 0.17968128 0.73131336
      [1591] 0.73131336 0.35548122 0.59024238 0.27237616 0.59024238 0.52371909
      [1597] 0.78936295 0.27237616 0.78936295 0.52371909 0.59024238 0.96234471
      [1603] 0.10196231 0.39067504 0.66409760 0.73131336 0.39067504 0.39067504
      [1609] 0.28634532 0.52371909 0.58954050 0.39067504 0.73131336 0.22606643
      [1615] 0.87662882 0.58954050 0.52371909 0.27237616 0.45638962 0.17968128
      [1621] 0.59024238 0.78936295 0.58954050 0.52371909 0.35548122 0.17550010
      [1627] 0.66409760 0.73131336 0.87662882 0.73131336 0.58954050 0.43135059
      [1633] 0.52371909 0.66409760 0.27237616 0.73131336 0.73131336 0.73131336
      [1639] 0.32877157 0.52371909 0.87662882 0.66409760 0.43135059 0.66409760
      [1645] 0.52371909 0.78936295 0.28634532 0.73131336 0.51067938 0.51067938
      [1651] 0.32877157 0.78936295 0.32877157 0.52371909 0.45638962 0.58954050
      [1657] 0.27237616 0.45638962 0.17968128 0.78936295 0.65365167 0.78936295
      [1663] 0.93091619 0.52371909 0.28634532 0.52371909 0.59024238 0.83766553
      [1669] 0.08992418 0.66409760 0.32877157 0.32877157 0.51067938 0.17550010
      [1675] 0.43135059 0.51067938 0.73131336 0.52371909 0.52371909 0.73131336
      [1681] 0.43135059 0.28634532 0.58954050 0.73131336 0.51067938 0.43135059
      [1687] 0.27237616 0.27237616 0.22254275 0.71205803 0.39067504 0.58954050
      [1693] 0.51067938 0.22606643 0.65365167 0.32877157 0.39067504 0.65365167
      [1699] 0.45638962 0.45638962 0.11398653 0.08992418 0.58954050 0.51067938
      [1705] 0.39067504 0.27237616 0.71205803 0.66409760 0.90727881 0.58954050
      [1711] 0.17968128 0.35548122 0.27237616 0.58954050 0.32877157 0.45638962
      [1717] 0.93091619 0.51067938 0.22254275 0.27237616 0.66409760 0.22254275
      [1723] 0.73131336 0.39067504 0.52371909 0.65365167 0.59024238 0.22254275
      [1729] 0.59024238 0.17968128 0.39067504 0.45638962 0.83766553 0.58954050
      [1735] 0.66409760 0.52371909 0.14366447 0.65365167 0.27237616 0.52371909
      [1741] 0.59024238 0.28634532 0.45638962 0.96234471 0.52371909 0.39067504
      [1747] 0.27237616 0.32877157 0.83766553 0.14366447 0.43135059 0.73131336
      [1753] 0.27237616 0.94886834 0.32877157 0.65365167 0.51067938 0.27237616
      [1759] 0.32877157 0.71205803 0.83766553 0.22606643 0.32877157 0.51067938
      [1765] 0.59024238 0.84769514 0.94886834 0.66409760 0.52371909 0.83766553
      [1771] 0.35548122 0.28634532 0.78936295 0.59024238 0.13443718 0.87662882
      [1777] 0.66409760 0.45638962 0.22254275 0.39067504 0.76418355 0.28634532
      [1783] 0.27237616 0.52371909 0.17550010 0.14366447 0.39067504 0.65365167
      [1789] 0.78936295 0.78936295 0.43135059 0.59024238 0.78936295 0.59024238
      [1795] 0.93091619 0.65365167 0.39067504 0.78936295 0.59024238 0.58954050
      [1801] 0.32877157 0.59024238 0.76418355 0.32877157 0.58954050 0.58954050
      [1807] 0.35548122 0.51067938 0.45638962 0.58954050 0.43135059 0.87662882
      [1813] 0.32877157 0.52371909 0.17550010 0.39067504 0.83766553 0.22254275
      [1819] 0.66409760 0.22254275 0.39067504 0.90727881 0.45638962 0.32877157
      [1825] 0.22254275 0.27237616 0.73131336 0.76418355 0.14366447 0.14366447
      [1831] 0.58954050 0.52371909 0.66409760 0.39067504 0.22254275 0.28634532
      [1837] 0.52371909 0.35548122 0.45638962 0.52371909 0.51067938 0.73131336
      [1843] 0.76418355 0.39067504 0.51067938 0.76418355 0.66409760 0.14366447
      [1849] 0.66409760 0.17968128 0.51067938 0.27237616 0.27237616 0.66409760
      [1855] 0.59024238 0.83766553 0.22254275 0.32877157 0.58954050 0.45638962
      [1861] 0.45638962 0.35548122 0.17550010 0.22254275 0.32877157 0.78936295
      [1867] 0.78936295 0.45638962 0.27237616 0.59024238 0.65365167 0.58954050
      [1873] 0.83766553 0.66409760 0.65365167 0.39067504 0.35548122 0.65365167
      [1879] 0.66409760 0.78936295 0.87662882 0.58954050 0.39067504 0.28634532
      [1885] 0.71205803 0.65365167 0.73131336 0.45638962 0.65365167 0.43135059
      [1891] 0.14366447 0.51067938 0.17968128 0.52371909 0.43135059 0.51067938
      [1897] 0.58954050 0.58954050 0.83766553 0.58954050 0.45638962 0.59024238
      [1903] 0.66409760 0.32877157 0.73131336 0.71205803 0.28634532 0.73131336
      [1909] 0.73131336 0.32877157 0.73131336 0.66409760 0.32877157 0.83766553
      [1915] 0.39067504 0.51067938 0.71205803 0.78936295 0.32877157 0.73131336
      [1921] 0.39067504 0.39067504 0.17968128 0.14366447 0.90727881 0.27237616
      [1927] 0.58954050 0.35548122 0.65365167 0.43135059 0.22606643 0.52371909
      [1933] 0.66409760 0.27237616 0.51067938 0.52371909 0.83766553 0.27237616
      [1939] 0.22606643 0.58954050 0.45638962 0.52371909 0.66409760 0.22254275
      [1945] 0.45638962 0.87662882 0.59024238 0.73131336 0.73131336 0.32877157
      [1951] 0.65365167 0.87944015 0.28634532 0.71205803 0.51067938 0.43135059
      [1957] 0.66409760 0.32877157 0.73131336 0.73131336 0.35548122 0.83766553
      [1963] 0.52371909 0.59024238 0.58954050 0.35548122 0.65365167 0.71205803
      [1969] 0.45638962 0.83766553 0.59024238 0.58954050 0.58954050 0.17968128
      [1975] 0.58954050 0.73131336 0.51067938 0.43135059 0.32877157 0.11398653
      [1981] 0.35548122 0.66409760 0.52371909 0.35548122 0.27237616 0.35548122
      [1987] 0.45638962 0.73131336 0.28634532 0.80940851 0.32877157 0.66409760
      [1993] 0.28634532 0.73131336 0.80940851 0.52371909 0.45638962 0.73131336
      [1999] 0.73131336 0.71205803
      attr(,"label")
      [1] "Fitted values"

---

    Code
      residuals(fit_plf)
    Output
         [1] -0.45638962  0.23581645  0.12337118 -0.22254275  0.21063705 -0.28634532
         [7]  0.47628091  0.56864941  0.21063705  0.23581645  0.16233447  0.28794197
        [13] -0.45638962 -0.51067938 -0.73131336 -0.35548122  0.41045950  0.28794197
        [19] -0.45638962 -0.32877157  0.56864941  0.19059149  0.12337118  0.16233447
        [25]  0.33590240  0.48932062  0.23581645 -0.51067938  0.28794197 -0.27237616
        [31] -0.51067938 -0.65365167 -0.78936295 -0.32877157  0.54361038 -0.52371909
        [37] -0.66409760  0.16233447  0.48932062 -0.59024238 -0.27237616  0.48932062
        [43] -0.51067938  0.21063705  0.21063705 -0.45638962 -0.32877157  0.48932062
        [49]  0.77745725 -0.52371909  0.47628091 -0.27237616  0.85633553 -0.52371909
        [55]  0.67122843  0.41045950 -0.32877157  0.47628091 -0.52371909  0.47628091
        [61]  0.12055985 -0.66409760  0.67122843 -0.22254275  0.34634833 -0.73131336
        [67] -0.22254275  0.26868664 -0.08992418  0.06908381 -0.43135059 -0.22254275
        [73]  0.54361038  0.41045950 -0.51067938  0.77745725  0.34634833 -0.22606643
        [79] -0.32877157  0.48932062  0.47628091 -0.58954050 -0.22254275 -0.35548122
        [85] -0.51067938 -0.65365167  0.71365468 -0.35548122 -0.45638962 -0.73131336
        [91] -0.28634532  0.28794197 -0.45638962  0.28794197  0.72762384 -0.22254275
        [97]  0.60932496  0.16233447 -0.27237616  0.15230486  0.05113166  0.47628091
       [103]  0.47628091  0.33590240 -0.39067504 -0.17550010  0.21063705 -0.78936295
       [109]  0.33590240 -0.14366447  0.34634833 -0.45638962  0.60932496  0.16233447
       [115] -0.32877157 -0.58954050  0.67122843  0.12337118 -0.22254275  0.54361038
       [121]  0.23581645 -0.45638962 -0.27237616  0.16233447 -0.27237616  0.48932062
       [127]  0.72762384 -0.22606643 -0.27237616 -0.28634532  0.54361038 -0.43135059
       [133] -0.43135059  0.16233447 -0.39067504 -0.39067504 -0.13443718  0.40975762
       [139]  0.26868664  0.16233447 -0.39067504  0.82031872 -0.28634532  0.21063705
       [145]  0.48932062 -0.66409760  0.09272119  0.26868664 -0.22254275  0.67122843
       [151] -0.27237616 -0.22254275  0.33590240 -0.45638962  0.16233447 -0.35548122
       [157] -0.22254275  0.09272119  0.06908381  0.60932496  0.56864941  0.47628091
       [163] -0.90727881 -0.14366447  0.56864941 -0.45638962  0.33590240 -0.90727881
       [169] -0.27237616  0.21063705 -0.28634532  0.33590240 -0.59024238  0.41045950
       [175] -0.73131336  0.56864941 -0.45638962  0.23581645  0.12337118 -0.17968128
       [181]  0.60932496  0.12337118  0.09272119  0.19059149 -0.59024238 -0.51067938
       [187]  0.12337118 -0.35548122 -0.11398653  0.26868664 -0.32877157  0.48932062
       [193]  0.26868664 -0.14366447  0.09272119  0.41045950 -0.58954050 -0.66409760
       [199]  0.21063705  0.54361038 -0.32877157  0.41045950 -0.22606643  0.21063705
       [205]  0.12337118 -0.73131336  0.26868664 -0.45638962  0.21063705 -0.39067504
       [211] -0.59024238  0.60932496  0.77393357 -0.52371909 -0.17968128 -0.28634532
       [217]  0.26868664  0.21063705  0.06908381  0.26868664  0.40975762 -0.39067504
       [223] -0.39067504 -0.73131336 -0.39067504  0.56864941  0.26868664  0.48932062
       [229]  0.41045950 -0.52371909  0.64451878  0.09272119  0.12337118  0.64451878
       [235]  0.16233447 -0.73131336  0.41045950 -0.93091619 -0.32877157  0.09272119
       [241]  0.26868664 -0.65365167  0.33590240  0.54361038  0.48932062 -0.32877157
       [247] -0.45638962 -0.58954050  0.40975762 -0.32877157  0.16233447  0.48932062
       [253]  0.21063705 -0.66409760 -0.59024238 -0.59024238  0.33590240  0.54361038
       [259]  0.28794197  0.21063705 -0.08992418  0.34634833 -0.35548122 -0.27237616
       [265]  0.33590240 -0.58954050  0.16233447 -0.45638962  0.23581645 -0.14366447
       [271] -0.45638962 -0.66409760  0.21063705 -0.35548122  0.09272119 -0.32877157
       [277] -0.52371909 -0.17968128  0.64451878 -0.52371909 -0.27237616  0.26868664
       [283]  0.41045950 -0.43135059 -0.59024238 -0.76418355  0.48932062 -0.78936295
       [289]  0.06908381 -0.43135059 -0.43135059 -0.27237616  0.67122843 -0.58954050
       [295]  0.54361038  0.16233447  0.40975762 -0.51067938  0.40975762  0.16233447
       [301]  0.40975762 -0.39067504 -0.35548122 -0.22606643 -0.66409760  0.09272119
       [307]  0.21063705  0.09272119  0.56864941 -0.39067504 -0.66409760 -0.27237616
       [313] -0.45638962 -0.52371909  0.15230486  0.21063705 -0.52371909 -0.65365167
       [319]  0.41045950 -0.32877157  0.72762384  0.47628091  0.26868664 -0.07066939
       [325]  0.34634833  0.26868664 -0.35548122  0.21063705  0.26868664 -0.14366447
       [331] -0.32877157 -0.39067504 -0.45638962  0.72762384  0.12337118  0.48932062
       [337] -0.58954050  0.54361038  0.33590240 -0.39067504 -0.66409760  0.40975762
       [343]  0.21063705 -0.73131336  0.48932062  0.48932062  0.54361038  0.56864941
       [349]  0.16233447 -0.27237616 -0.17968128  0.16233447 -0.58954050  0.33590240
       [355] -0.28634532  0.16233447 -0.52371909 -0.27237616 -0.28634532  0.56864941
       [361]  0.23581645  0.72762384 -0.52371909 -0.28634532  0.12337118 -0.45638962
       [367] -0.35548122 -0.32877157 -0.27237616 -0.59024238 -0.35548122 -0.52371909
       [373]  0.77745725 -0.43135059  0.41045950  0.67122843 -0.14366447 -0.73131336
       [379]  0.48932062  0.21063705  0.16233447 -0.52371909  0.56864941 -0.58954050
       [385] -0.66409760  0.06908381 -0.51067938  0.03765529 -0.35548122 -0.11398653
       [391] -0.32877157 -0.39067504  0.28794197 -0.52371909 -0.51067938  0.60932496
       [397] -0.43135059  0.19059149 -0.80940851  0.16233447 -0.22606643 -0.32877157
       [403] -0.45638962 -0.83766553  0.09272119 -0.39067504  0.47628091  0.40975762
       [409]  0.54361038  0.19059149  0.34634833  0.54361038  0.21063705 -0.43135059
       [415] -0.58954050 -0.17968128  0.47628091 -0.28634532  0.56864941  0.88601347
       [421] -0.32877157  0.34634833 -0.45638962 -0.45638962  0.47628091 -0.35548122
       [427] -0.65365167  0.34634833 -0.52371909  0.48932062 -0.39067504  0.54361038
       [433]  0.48932062  0.16233447 -0.32877157  0.23581645  0.21063705  0.72762384
       [439]  0.77393357 -0.52371909  0.40975762  0.47628091  0.26868664 -0.22254275
       [445] -0.32877157  0.21063705 -0.65365167 -0.65365167 -0.17968128 -0.32877157
       [451]  0.40975762 -0.14366447  0.19059149  0.47628091  0.48932062  0.28794197
       [457]  0.47628091  0.40975762  0.67122843  0.26868664  0.47628091  0.40975762
       [463] -0.71205803 -0.78936295  0.82449990  0.72762384 -0.52371909  0.26868664
       [469] -0.59024238  0.34634833 -0.58954050  0.33590240 -0.32877157 -0.51067938
       [475]  0.21063705  0.26868664 -0.35548122 -0.52371909 -0.52371909  0.26868664
       [481]  0.16233447 -0.59024238  0.21063705  0.26868664  0.48932062 -0.32877157
       [487]  0.21063705 -0.66409760 -0.45638962  0.34634833 -0.73131336 -0.22254275
       [493]  0.77745725 -0.32877157 -0.51067938  0.82031872  0.71365468  0.40975762
       [499] -0.51067938  0.23581645 -0.83766553 -0.22606643 -0.39067504  0.67122843
       [505] -0.51067938  0.56864941  0.67122843 -0.45638962  0.67122843  0.67122843
       [511] -0.32877157 -0.13443718 -0.17550010  0.33590240 -0.71205803 -0.28634532
       [517] -0.39067504  0.56864941 -0.27237616  0.47628091  0.41045950  0.47628091
       [523]  0.12055985 -0.76418355  0.47628091  0.34634833  0.12337118 -0.59024238
       [529] -0.27237616 -0.83766553  0.16233447 -0.59024238 -0.39067504  0.56864941
       [535]  0.67122843  0.33590240  0.33590240  0.26868664  0.48932062  0.47628091
       [541] -0.27237616 -0.39067504  0.34634833 -0.35548122  0.48932062  0.26868664
       [547] -0.52371909 -0.45638962 -0.39067504  0.77745725 -0.45638962 -0.22254275
       [553]  0.26868664  0.54361038  0.64451878 -0.45638962  0.34634833 -0.27237616
       [559]  0.33590240  0.47628091  0.16233447 -0.22606643  0.48932062  0.21063705
       [565]  0.54361038  0.40975762 -0.27237616 -0.73131336  0.09272119  0.56864941
       [571] -0.51067938 -0.71205803 -0.39067504  0.54361038  0.48932062 -0.52371909
       [577] -0.39067504  0.26868664  0.85633553 -0.39067504  0.56864941 -0.17968128
       [583]  0.48932062 -0.51067938  0.47628091 -0.27237616 -0.45638962 -0.11398653
       [589] -0.78936295  0.54361038  0.12337118 -0.17550010  0.64451878  0.41045950
       [595] -0.51067938  0.48932062  0.54361038 -0.22254275  0.40975762 -0.66409760
       [601]  0.72762384 -0.22606643  0.60932496  0.72762384 -0.32877157  0.26868664
       [607] -0.83766553 -0.73131336  0.23581645  0.40975762  0.33590240 -0.59024238
       [613] -0.58954050  0.23581645  0.54361038 -0.11398653 -0.51067938 -0.11398653
       [619] -0.73131336 -0.28634532 -0.45638962  0.82031872 -0.45638962 -0.45638962
       [625] -0.39067504 -0.17968128 -0.78936295  0.56864941  0.12337118  0.26868664
       [631] -0.22254275 -0.66409760  0.41045950  0.21063705  0.26868664  0.16233447
       [637]  0.33590240  0.26868664  0.41045950  0.12337118 -0.43135059 -0.58954050
       [643]  0.41045950 -0.59024238  0.77745725 -0.35548122  0.67122843  0.64451878
       [649] -0.43135059  0.48932062 -0.84769514 -0.43135059  0.26868664  0.26868664
       [655] -0.66409760 -0.45638962 -0.78936295  0.26868664 -0.17968128  0.26868664
       [661] -0.32877157  0.21063705 -0.27237616 -0.32877157  0.67122843  0.03765529
       [667] -0.58954050  0.33590240  0.71365468 -0.22254275 -0.39067504  0.40975762
       [673] -0.45638962 -0.32877157  0.26868664 -0.59024238 -0.17968128 -0.45638962
       [679] -0.32877157  0.54361038 -0.14366447 -0.43135059 -0.32877157 -0.11398653
       [685]  0.33590240 -0.87662882 -0.45638962  0.19059149 -0.32877157  0.60932496
       [691]  0.16233447 -0.52371909  0.48932062 -0.52371909 -0.22606643  0.21063705
       [697]  0.21063705  0.48932062  0.72762384  0.21063705  0.77393357  0.72762384
       [703]  0.09272119 -0.27237616  0.60932496  0.71365468 -0.78936295 -0.43135059
       [709]  0.56864941  0.67122843  0.88601347  0.12337118  0.21063705  0.41045950
       [715] -0.52371909 -0.52371909  0.41045950 -0.17968128 -0.32877157 -0.51067938
       [721]  0.47628091  0.56864941 -0.51067938 -0.58954050 -0.83766553 -0.71205803
       [727] -0.17968128 -0.39067504 -0.52371909  0.33590240 -0.39067504 -0.73131336
       [733] -0.58954050  0.60932496 -0.65365167  0.60932496  0.26868664 -0.22254275
       [739] -0.35548122  0.19059149 -0.52371909 -0.59024238  0.19059149  0.26868664
       [745] -0.32877157  0.47628091 -0.22606643 -0.87662882  0.28794197 -0.28634532
       [751]  0.28794197 -0.59024238 -0.59024238  0.33590240 -0.51067938  0.26868664
       [757] -0.43135059  0.60932496 -0.66409760  0.06908381 -0.22254275  0.60932496
       [763]  0.34634833 -0.14366447  0.72762384 -0.32877157 -0.51067938 -0.58954050
       [769] -0.51067938 -0.35548122 -0.35548122  0.12337118  0.26868664 -0.52371909
       [775] -0.32877157 -0.35548122  0.34634833  0.26868664 -0.39067504  0.16233447
       [781]  0.33590240  0.64451878  0.21063705 -0.39067504 -0.43135059  0.67122843
       [787] -0.27237616  0.48932062  0.48932062  0.40975762  0.71365468  0.16233447
       [793] -0.51067938  0.26868664 -0.17968128  0.48932062  0.54361038 -0.58954050
       [799] -0.35548122 -0.27237616  0.41045950 -0.58954050  0.21063705  0.19059149
       [805]  0.28794197 -0.73131336 -0.32877157 -0.43135059 -0.27237616  0.19059149
       [811]  0.16233447 -0.52371909 -0.71205803  0.21063705 -0.27237616 -0.43135059
       [817] -0.22254275 -0.52371909 -0.45638962 -0.17968128 -0.78936295  0.26868664
       [823]  0.21063705  0.12337118  0.12337118  0.60932496  0.56864941 -0.17968128
       [829] -0.51067938 -0.45638962 -0.22254275 -0.22606643 -0.52371909  0.47628091
       [835] -0.32877157 -0.22254275  0.54361038 -0.35548122 -0.83766553  0.40975762
       [841]  0.33590240  0.56864941 -0.73131336 -0.28634532 -0.59024238 -0.39067504
       [847] -0.27237616 -0.27237616  0.26868664 -0.14366447 -0.51067938  0.56864941
       [853] -0.58954050 -0.22606643  0.41045950 -0.39067504 -0.52371909  0.41045950
       [859]  0.47628091 -0.73131336  0.47628091  0.26868664 -0.65365167  0.23581645
       [865]  0.54361038 -0.59024238  0.19059149  0.47628091  0.41045950 -0.27237616
       [871]  0.41045950  0.12337118  0.33590240  0.60932496  0.09272119  0.26868664
       [877]  0.41045950  0.64451878  0.54361038  0.34634833 -0.39067504 -0.17968128
       [883]  0.48932062  0.12337118  0.41045950  0.54361038  0.33590240  0.41045950
       [889] -0.39067504  0.21063705  0.56864941 -0.17968128  0.56864941  0.34634833
       [895]  0.40975762  0.54361038 -0.32877157  0.19059149 -0.65365167  0.33590240
       [901] -0.58954050 -0.32877157  0.23581645  0.67122843  0.26868664 -0.27237616
       [907]  0.26868664  0.40975762  0.67122843  0.21063705  0.33590240 -0.39067504
       [913] -0.59024238  0.41045950 -0.39067504  0.21063705  0.60932496  0.54361038
       [919]  0.40975762  0.12337118 -0.59024238  0.64451878 -0.43135059 -0.51067938
       [925]  0.33590240 -0.17968128  0.41045950  0.40975762  0.48932062 -0.59024238
       [931]  0.26868664  0.23581645  0.41045950 -0.43135059 -0.58954050 -0.39067504
       [937] -0.59024238 -0.71205803 -0.17968128 -0.73131336 -0.52371909 -0.43135059
       [943] -0.39067504  0.12337118 -0.32877157 -0.59024238 -0.17968128 -0.22606643
       [949]  0.41045950  0.48932062  0.40975762  0.47628091 -0.39067504  0.12337118
       [955]  0.33590240  0.82031872 -0.51067938 -0.52371909  0.77745725  0.16233447
       [961]  0.23581645 -0.27237616  0.82031872 -0.66409760 -0.22254275 -0.22254275
       [967] -0.45638962  0.34634833  0.54361038  0.72762384  0.60932496 -0.14366447
       [973] -0.58954050 -0.71205803 -0.39067504  0.33590240 -0.71205803  0.28794197
       [979]  0.33590240 -0.73131336  0.34634833  0.09272119 -0.58954050 -0.78936295
       [985]  0.77745725 -0.66409760 -0.58954050 -0.27237616  0.47628091  0.40975762
       [991] -0.07066939  0.40975762  0.47628091 -0.39067504  0.26868664 -0.35548122
       [997] -0.90727881 -0.39067504  0.12337118  0.33590240  0.41045950  0.64451878
      [1003] -0.22254275  0.56864941  0.26868664 -0.28634532  0.05113166 -0.66409760
      [1009]  0.40975762  0.48932062 -0.22254275 -0.66409760 -0.10196231  0.54361038
      [1015]  0.41045950  0.72762384  0.85633553  0.26868664 -0.35548122  0.41045950
      [1021]  0.26868664 -0.43135059  0.09272119  0.56864941  0.34634833  0.54361038
      [1027]  0.33590240  0.77745725 -0.32877157  0.33590240 -0.43135059  0.40975762
      [1033]  0.47628091 -0.17968128  0.28794197 -0.58954050 -0.11398653 -0.43135059
      [1039] -0.73131336 -0.13443718  0.33590240  0.60932496 -0.43135059 -0.65365167
      [1045]  0.34634833 -0.66409760 -0.32877157  0.64451878 -0.39067504  0.21063705
      [1051] -0.27237616  0.67122843 -0.66409760 -0.43135059  0.47628091 -0.45638962
      [1057]  0.77393357  0.54361038 -0.39067504  0.60932496 -0.28634532  0.64451878
      [1063]  0.40975762  0.48932062  0.26868664  0.26868664  0.21063705  0.16233447
      [1069] -0.35548122 -0.66409760 -0.45638962 -0.43135059 -0.45638962 -0.11398653
      [1075]  0.21063705  0.21063705 -0.08992418  0.77745725 -0.51067938 -0.27237616
      [1081]  0.56864941  0.77745725  0.06908381 -0.14366447  0.48932062  0.72762384
      [1087] -0.22606643  0.48932062 -0.17550010  0.56864941  0.40975762  0.21063705
      [1093] -0.87662882  0.21063705 -0.66409760 -0.52371909 -0.59024238  0.82031872
      [1099]  0.67122843  0.67122843  0.06908381 -0.22606643  0.26868664  0.72762384
      [1105] -0.71205803 -0.59024238 -0.32877157  0.56864941  0.47628091  0.56864941
      [1111]  0.40975762 -0.45638962 -0.39067504 -0.22606643 -0.73131336  0.34634833
      [1117]  0.48932062  0.33590240  0.47628091  0.21063705  0.12337118  0.26868664
      [1123]  0.48932062  0.33590240  0.41045950  0.41045950 -0.35548122  0.60932496
      [1129]  0.56864941  0.33590240 -0.14366447 -0.39067504  0.19059149 -0.43135059
      [1135]  0.12337118  0.56864941 -0.28634532 -0.51067938  0.77393357  0.41045950
      [1141] -0.39067504 -0.14366447 -0.39067504  0.60932496  0.40975762 -0.59024238
      [1147]  0.21063705 -0.52371909 -0.39067504 -0.45638962  0.33590240 -0.22606643
      [1153] -0.22606643 -0.22254275 -0.78936295  0.09272119  0.12337118 -0.45638962
      [1159]  0.09272119 -0.73131336 -0.17550010 -0.22254275  0.48932062  0.28794197
      [1165]  0.26868664 -0.17550010 -0.51067938  0.77745725  0.48932062 -0.73131336
      [1171]  0.56864941 -0.43135059  0.71365468  0.12055985  0.06908381 -0.71205803
      [1177] -0.78936295  0.47628091 -0.11398653  0.41045950  0.21063705 -0.51067938
      [1183]  0.48932062 -0.66409760 -0.45638962 -0.58954050 -0.32877157  0.40975762
      [1189] -0.52371909  0.56864941  0.33590240  0.15230486 -0.76418355  0.47628091
      [1195]  0.21063705  0.67122843 -0.78936295  0.54361038  0.77393357  0.23581645
      [1201]  0.34634833  0.40975762 -0.35548122  0.33590240 -0.43135059  0.12337118
      [1207]  0.09272119 -0.27237616  0.09272119  0.67122843  0.67122843 -0.66409760
      [1213] -0.39067504  0.06908381  0.60932496  0.54361038 -0.65365167 -0.65365167
      [1219] -0.80940851 -0.14366447 -0.52371909  0.21063705  0.54361038 -0.58954050
      [1225] -0.32877157  0.21063705  0.60932496 -0.71205803  0.26868664  0.54361038
      [1231]  0.47628091 -0.78936295 -0.52371909 -0.73131336  0.09272119 -0.35548122
      [1237]  0.21063705 -0.43135059 -0.73131336 -0.32877157  0.41045950  0.33590240
      [1243]  0.41045950  0.26868664 -0.71205803 -0.51067938  0.28794197 -0.58954050
      [1249]  0.06908381 -0.32877157  0.67122843 -0.32877157  0.54361038 -0.52371909
      [1255]  0.60932496 -0.22254275 -0.52371909 -0.73131336  0.48932062 -0.58954050
      [1261]  0.47628091 -0.17968128 -0.32877157  0.33590240 -0.58954050 -0.14366447
      [1267] -0.51067938  0.33590240  0.48932062 -0.28634532  0.71365468 -0.52371909
      [1273]  0.28794197 -0.35548122  0.23581645  0.26868664  0.67122843  0.16233447
      [1279] -0.45638962 -0.65365167 -0.32877157  0.09272119 -0.14366447  0.40975762
      [1285]  0.40975762 -0.22606643  0.48932062  0.06908381 -0.14366447 -0.52371909
      [1291] -0.83766553 -0.14366447  0.40975762  0.34634833 -0.66409760 -0.45638962
      [1297]  0.34634833  0.16233447  0.60932496 -0.59024238  0.21063705 -0.14366447
      [1303]  0.21063705 -0.32877157  0.23581645 -0.66409760 -0.27237616 -0.58954050
      [1309] -0.51067938  0.16233447  0.16233447  0.56864941 -0.39067504  0.77745725
      [1315] -0.52371909 -0.73131336  0.21063705  0.12337118  0.28794197  0.33590240
      [1321]  0.40975762  0.60932496 -0.51067938  0.21063705 -0.65365167 -0.27237616
      [1327]  0.67122843  0.47628091  0.16233447  0.71365468  0.34634833 -0.51067938
      [1333] -0.73131336  0.60932496 -0.51067938  0.21063705  0.72762384  0.41045950
      [1339]  0.21063705  0.72762384  0.67122843  0.09272119  0.41045950 -0.28634532
      [1345]  0.41045950 -0.45638962 -0.51067938  0.77745725 -0.32877157  0.47628091
      [1351]  0.60932496 -0.51067938  0.12337118  0.23581645 -0.35548122  0.40975762
      [1357] -0.52371909  0.41045950  0.23581645  0.16233447 -0.27237616  0.33590240
      [1363]  0.41045950  0.77745725  0.47628091  0.33590240  0.09272119  0.60932496
      [1369]  0.33590240  0.09272119  0.34634833  0.33590240  0.12055985 -0.32877157
      [1375]  0.54361038  0.47628091  0.21063705 -0.45638962 -0.58954050 -0.43135059
      [1381] -0.22254275 -0.51067938 -0.58954050 -0.17968128  0.21063705 -0.32877157
      [1387] -0.39067504 -0.17968128 -0.11398653  0.21063705  0.47628091 -0.52371909
      [1393]  0.26868664  0.23581645  0.23581645  0.26868664 -0.43135059  0.40975762
      [1399] -0.45638962 -0.17550010  0.21063705  0.03765529 -0.43135059  0.21063705
      [1405] -0.39067504  0.60932496 -0.66409760 -0.52371909  0.15230486  0.21063705
      [1411] -0.22606643  0.48932062 -0.27237616 -0.35548122 -0.43135059 -0.90727881
      [1417]  0.34634833 -0.73131336 -0.17550010 -0.59024238 -0.32877157  0.47628091
      [1423]  0.54361038  0.16233447  0.33590240  0.26868664  0.33590240 -0.28634532
      [1429] -0.43135059 -0.17968128 -0.71205803 -0.32877157  0.41045950  0.48932062
      [1435] -0.43135059  0.82031872 -0.73131336  0.05113166  0.26868664  0.48932062
      [1441]  0.82031872 -0.73131336 -0.59024238  0.41045950  0.16233447 -0.27237616
      [1447]  0.23581645  0.64451878  0.33590240  0.28794197 -0.87662882 -0.45638962
      [1453] -0.39067504  0.56864941  0.40975762  0.34634833 -0.73131336 -0.32877157
      [1459]  0.47628091 -0.22606643  0.48932062 -0.59024238  0.67122843  0.72762384
      [1465]  0.21063705  0.47628091  0.47628091 -0.52371909 -0.66409760  0.82031872
      [1471] -0.51067938  0.19059149 -0.17550010  0.21063705 -0.39067504 -0.28634532
      [1477] -0.73131336 -0.11398653  0.16233447  0.26868664  0.60932496 -0.83766553
      [1483]  0.60932496  0.05113166  0.54361038 -0.52371909 -0.28634532  0.28794197
      [1489]  0.54361038 -0.66409760  0.33590240 -0.32877157 -0.52371909  0.26868664
      [1495] -0.58954050 -0.39067504 -0.45638962  0.21063705  0.33590240 -0.58954050
      [1501]  0.26868664 -0.52371909  0.09272119  0.82031872  0.21063705 -0.66409760
      [1507] -0.22254275 -0.52371909 -0.17968128 -0.52371909 -0.27237616 -0.45638962
      [1513]  0.60932496 -0.27237616  0.41045950  0.56864941 -0.58954050  0.48932062
      [1519] -0.14366447  0.26868664 -0.45638962  0.34634833  0.48932062  0.21063705
      [1525] -0.52371909  0.33590240 -0.22606643  0.33590240 -0.58954050  0.33590240
      [1531]  0.56864941  0.23581645  0.26868664 -0.45638962 -0.32877157  0.06908381
      [1537] -0.27237616  0.48932062  0.33590240  0.41045950  0.16233447 -0.66409760
      [1543] -0.22606643 -0.39067504  0.16233447  0.16233447 -0.32877157  0.33590240
      [1549] -0.66409760 -0.14366447  0.72762384 -0.22254275 -0.28634532  0.60932496
      [1555] -0.45638962 -0.32877157  0.40975762  0.77745725  0.34634833  0.64451878
      [1561] -0.13443718  0.40975762 -0.93091619  0.40975762  0.34634833  0.33590240
      [1567]  0.48932062 -0.93091619  0.85633553 -0.45638962  0.21063705  0.34634833
      [1573]  0.26868664 -0.45638962 -0.39067504  0.40975762 -0.32877157 -0.59024238
      [1579]  0.40975762 -0.83766553 -0.22606643 -0.39067504  0.19059149  0.85633553
      [1585]  0.12337118  0.28794197 -0.59024238 -0.28634532 -0.17968128  0.26868664
      [1591]  0.26868664 -0.35548122  0.40975762 -0.27237616 -0.59024238 -0.52371909
      [1597] -0.78936295 -0.27237616  0.21063705 -0.52371909  0.40975762  0.03765529
      [1603] -0.10196231 -0.39067504  0.33590240  0.26868664  0.60932496 -0.39067504
      [1609] -0.28634532  0.47628091  0.41045950 -0.39067504  0.26868664  0.77393357
      [1615]  0.12337118 -0.58954050  0.47628091 -0.27237616 -0.45638962 -0.17968128
      [1621] -0.59024238  0.21063705  0.41045950  0.47628091 -0.35548122  0.82449990
      [1627]  0.33590240  0.26868664  0.12337118 -0.73131336  0.41045950 -0.43135059
      [1633]  0.47628091 -0.66409760 -0.27237616 -0.73131336  0.26868664 -0.73131336
      [1639] -0.32877157  0.47628091  0.12337118 -0.66409760  0.56864941  0.33590240
      [1645] -0.52371909  0.21063705  0.71365468 -0.73131336 -0.51067938  0.48932062
      [1651]  0.67122843  0.21063705 -0.32877157 -0.52371909  0.54361038  0.41045950
      [1657] -0.27237616  0.54361038 -0.17968128 -0.78936295 -0.65365167  0.21063705
      [1663]  0.06908381 -0.52371909  0.71365468  0.47628091  0.40975762  0.16233447
      [1669] -0.08992418  0.33590240 -0.32877157  0.67122843 -0.51067938  0.82449990
      [1675] -0.43135059 -0.51067938 -0.73131336 -0.52371909  0.47628091  0.26868664
      [1681] -0.43135059 -0.28634532 -0.58954050  0.26868664  0.48932062 -0.43135059
      [1687]  0.72762384 -0.27237616  0.77745725  0.28794197 -0.39067504  0.41045950
      [1693]  0.48932062 -0.22606643  0.34634833 -0.32877157  0.60932496  0.34634833
      [1699] -0.45638962  0.54361038 -0.11398653 -0.08992418  0.41045950 -0.51067938
      [1705] -0.39067504 -0.27237616  0.28794197  0.33590240 -0.90727881 -0.58954050
      [1711] -0.17968128  0.64451878 -0.27237616 -0.58954050 -0.32877157 -0.45638962
      [1717]  0.06908381 -0.51067938 -0.22254275 -0.27237616  0.33590240 -0.22254275
      [1723] -0.73131336 -0.39067504  0.47628091  0.34634833  0.40975762 -0.22254275
      [1729]  0.40975762 -0.17968128 -0.39067504  0.54361038  0.16233447  0.41045950
      [1735]  0.33590240 -0.52371909 -0.14366447 -0.65365167 -0.27237616  0.47628091
      [1741] -0.59024238 -0.28634532 -0.45638962  0.03765529  0.47628091 -0.39067504
      [1747] -0.27237616 -0.32877157  0.16233447 -0.14366447 -0.43135059  0.26868664
      [1753] -0.27237616  0.05113166  0.67122843  0.34634833 -0.51067938 -0.27237616
      [1759] -0.32877157  0.28794197  0.16233447 -0.22606643 -0.32877157  0.48932062
      [1765]  0.40975762  0.15230486  0.05113166  0.33590240 -0.52371909  0.16233447
      [1771] -0.35548122 -0.28634532  0.21063705  0.40975762 -0.13443718  0.12337118
      [1777] -0.66409760  0.54361038 -0.22254275  0.60932496  0.23581645 -0.28634532
      [1783]  0.72762384  0.47628091 -0.17550010 -0.14366447 -0.39067504  0.34634833
      [1789]  0.21063705  0.21063705 -0.43135059  0.40975762 -0.78936295  0.40975762
      [1795]  0.06908381  0.34634833  0.60932496  0.21063705  0.40975762  0.41045950
      [1801] -0.32877157 -0.59024238  0.23581645 -0.32877157 -0.58954050 -0.58954050
      [1807]  0.64451878  0.48932062 -0.45638962 -0.58954050 -0.43135059  0.12337118
      [1813] -0.32877157  0.47628091 -0.17550010 -0.39067504  0.16233447 -0.22254275
      [1819]  0.33590240  0.77745725  0.60932496  0.09272119  0.54361038  0.67122843
      [1825] -0.22254275 -0.27237616  0.26868664 -0.76418355  0.85633553 -0.14366447
      [1831] -0.58954050  0.47628091  0.33590240 -0.39067504 -0.22254275 -0.28634532
      [1837]  0.47628091 -0.35548122 -0.45638962 -0.52371909 -0.51067938  0.26868664
      [1843]  0.23581645 -0.39067504  0.48932062  0.23581645  0.33590240 -0.14366447
      [1849] -0.66409760 -0.17968128 -0.51067938 -0.27237616 -0.27237616  0.33590240
      [1855] -0.59024238  0.16233447 -0.22254275 -0.32877157 -0.58954050  0.54361038
      [1861] -0.45638962 -0.35548122 -0.17550010 -0.22254275  0.67122843  0.21063705
      [1867]  0.21063705  0.54361038 -0.27237616 -0.59024238 -0.65365167 -0.58954050
      [1873]  0.16233447 -0.66409760  0.34634833  0.60932496  0.64451878  0.34634833
      [1879]  0.33590240  0.21063705  0.12337118 -0.58954050 -0.39067504 -0.28634532
      [1885]  0.28794197 -0.65365167  0.26868664  0.54361038 -0.65365167  0.56864941
      [1891] -0.14366447  0.48932062 -0.17968128  0.47628091  0.56864941 -0.51067938
      [1897]  0.41045950 -0.58954050  0.16233447 -0.58954050 -0.45638962 -0.59024238
      [1903]  0.33590240 -0.32877157  0.26868664 -0.71205803 -0.28634532  0.26868664
      [1909]  0.26868664 -0.32877157  0.26868664  0.33590240 -0.32877157  0.16233447
      [1915]  0.60932496 -0.51067938  0.28794197  0.21063705 -0.32877157  0.26868664
      [1921] -0.39067504  0.60932496 -0.17968128 -0.14366447  0.09272119 -0.27237616
      [1927]  0.41045950  0.64451878  0.34634833  0.56864941 -0.22606643  0.47628091
      [1933]  0.33590240 -0.27237616 -0.51067938 -0.52371909  0.16233447  0.72762384
      [1939] -0.22606643  0.41045950  0.54361038  0.47628091  0.33590240 -0.22254275
      [1945] -0.45638962  0.12337118 -0.59024238  0.26868664  0.26868664 -0.32877157
      [1951]  0.34634833  0.12055985  0.71365468  0.28794197 -0.51067938 -0.43135059
      [1957]  0.33590240  0.67122843  0.26868664  0.26868664 -0.35548122  0.16233447
      [1963] -0.52371909  0.40975762 -0.58954050  0.64451878  0.34634833  0.28794197
      [1969] -0.45638962  0.16233447  0.40975762 -0.58954050  0.41045950 -0.17968128
      [1975] -0.58954050  0.26868664 -0.51067938 -0.43135059 -0.32877157 -0.11398653
      [1981] -0.35548122  0.33590240 -0.52371909  0.64451878 -0.27237616  0.64451878
      [1987]  0.54361038  0.26868664  0.71365468  0.19059149  0.67122843  0.33590240
      [1993] -0.28634532  0.26868664  0.19059149 -0.52371909 -0.45638962  0.26868664
      [1999]  0.26868664  0.28794197
      attr(,"label")
      [1] "Residuals"

---

    Code
      (fit_irls <- estimNLR(y = y, match = match, group = group, formula = M$M1$
        formula, method = "irls"))
    Output
      Nonlinear regression model 
      
       Model:  y ~ exp(x + g + x:g) / (1 + exp(x + g + x:g)) 
      
      Coefficients:
      (Intercept)           x           g         x:g 
           0.5503      0.9941     -0.8388     -0.1536 
      
       Maximum likelihood estimation using the iteratively reweighted least squares algorithm 
      Converged after 4 iterations

---

    Code
      coef(fit_irls)
    Output
      (Intercept)           x           g         x:g 
        0.5503440   0.9940975  -0.8387766  -0.1535927 

---

    Code
      logLik(fit_irls)
    Output
      'log Lik.' -1192.331 (df=4)

---

    Code
      vcov(fit_irls)
    Output
                   (Intercept)            x             g           x:g
      (Intercept)  0.005266250  0.001165077 -0.0052662505 -0.0011650775
      x            0.001165077  0.007010056 -0.0011650775 -0.0070100558
      g           -0.005266250 -0.001165077  0.0100000836  0.0006504587
      x:g         -0.001165077 -0.007010056  0.0006504587  0.0130723680

---

    Code
      fitted(fit_irls)
    Output
               1          2          3          4          5          6          7 
      0.45487411 0.76352613 0.87628488 0.22037531 0.78877573 0.28435576 0.52239129 
               8          9         10         11         12         13         14 
      0.42976528 0.78877573 0.76352613 0.83721296 0.71125529 0.45487411 0.50931523 
              15         16         17         18         19         20         21 
      0.73056430 0.35368440 0.58839620 0.71125529 0.45487411 0.32690028 0.42976528 
              22         23         24         25         26         27         28 
      0.80887717 0.87628488 0.83721296 0.66316115 0.50931523 0.76352613 0.50931523 
              29         30         31         32         33         34         35 
      0.71125529 0.27034765 0.50931523 0.65268611 0.78877573 0.32690028 0.45487411 
              36         37         38         39         40         41         42 
      0.52239129 0.66316115 0.83721296 0.50931523 0.58910004 0.27034765 0.50931523 
              43         44         45         46         47         48         49 
      0.50931523 0.78877573 0.78877573 0.45487411 0.32690028 0.50931523 0.22037531 
              50         51         52         53         54         55         56 
      0.52239129 0.52239129 0.27034765 0.14127713 0.52239129 0.32690028 0.58839620 
              57         58         59         60         61         62         63 
      0.32690028 0.52239129 0.52239129 0.52239129 0.87910405 0.66316115 0.32690028 
              64         65         66         67         68         69         70 
      0.22037531 0.65268611 0.73056430 0.22037531 0.73056430 0.08738702 0.93072359 
              71         72         73         74         75         76         77 
      0.42976528 0.22037531 0.45487411 0.58839620 0.50931523 0.22037531 0.65268611 
              78         79         80         81         82         83         84 
      0.22390881 0.32690028 0.50931523 0.52239129 0.58839620 0.22037531 0.35368440 
              85         86         87         88         89         90         91 
      0.50931523 0.65268611 0.28435576 0.35368440 0.45487411 0.73056430 0.28435576 
              92         93         94         95         96         97         98 
      0.71125529 0.45487411 0.71125529 0.27034765 0.22037531 0.38897634 0.83721296 
              99        100        101        102        103        104        105 
      0.27034765 0.84727053 0.94872579 0.52239129 0.52239129 0.66316115 0.38897634 
             106        107        108        109        110        111        112 
      0.17320152 0.78877573 0.78877573 0.66316115 0.14127713 0.65268611 0.45487411 
             113        114        115        116        117        118        119 
      0.38897634 0.83721296 0.32690028 0.58839620 0.32690028 0.87628488 0.22037531 
             120        121        122        123        124        125        126 
      0.45487411 0.76352613 0.45487411 0.27034765 0.83721296 0.27034765 0.50931523 
             127        128        129        130        131        132        133 
      0.27034765 0.22390881 0.27034765 0.28435576 0.45487411 0.42976528 0.42976528 
             134        135        136        137        138        139        140 
      0.83721296 0.38897634 0.38897634 0.13202412 0.58910004 0.73056430 0.83721296 
             141        142        143        144        145        146        147 
      0.38897634 0.17739435 0.28435576 0.78877573 0.50931523 0.66316115 0.90702032 
             148        149        150        151        152        153        154 
      0.73056430 0.22037531 0.32690028 0.27034765 0.22037531 0.66316115 0.45487411 
             155        156        157        158        159        160        161 
      0.83721296 0.35368440 0.22037531 0.90702032 0.93072359 0.38897634 0.42976528 
             162        163        164        165        166        167        168 
      0.52239129 0.90702032 0.14127713 0.42976528 0.45487411 0.66316115 0.90702032 
             169        170        171        172        173        174        175 
      0.27034765 0.78877573 0.28435576 0.66316115 0.58910004 0.58839620 0.73056430 
             176        177        178        179        180        181        182 
      0.42976528 0.45487411 0.76352613 0.87628488 0.17739435 0.38897634 0.87628488 
             183        184        185        186        187        188        189 
      0.90702032 0.80887717 0.58910004 0.50931523 0.87628488 0.35368440 0.11151645 
             190        191        192        193        194        195        196 
      0.73056430 0.32690028 0.50931523 0.73056430 0.14127713 0.90702032 0.58839620 
             197        198        199        200        201        202        203 
      0.58839620 0.66316115 0.78877573 0.45487411 0.32690028 0.58839620 0.22390881 
             204        205        206        207        208        209        210 
      0.78877573 0.87628488 0.73056430 0.73056430 0.45487411 0.78877573 0.38897634 
             211        212        213        214        215        216        217 
      0.58910004 0.38897634 0.22390881 0.52239129 0.17739435 0.28435576 0.73056430 
             218        219        220        221        222        223        224 
      0.78877573 0.93072359 0.73056430 0.58910004 0.38897634 0.38897634 0.73056430 
             225        226        227        228        229        230        231 
      0.38897634 0.42976528 0.73056430 0.50931523 0.58839620 0.52239129 0.35368440 
             232        233        234        235        236        237        238 
      0.90702032 0.87628488 0.35368440 0.83721296 0.73056430 0.58839620 0.93072359 
             239        240        241        242        243        244        245 
      0.32690028 0.90702032 0.73056430 0.65268611 0.66316115 0.45487411 0.50931523 
             246        247        248        249        250        251        252 
      0.32690028 0.45487411 0.58839620 0.58910004 0.32690028 0.83721296 0.50931523 
             253        254        255        256        257        258        259 
      0.78877573 0.66316115 0.58910004 0.58910004 0.66316115 0.45487411 0.71125529 
             260        261        262        263        264        265        266 
      0.78877573 0.08738702 0.65268611 0.35368440 0.27034765 0.66316115 0.58839620 
             267        268        269        270        271        272        273 
      0.83721296 0.45487411 0.76352613 0.14127713 0.45487411 0.66316115 0.78877573 
             274        275        276        277        278        279        280 
      0.35368440 0.90702032 0.32690028 0.52239129 0.17739435 0.35368440 0.52239129 
             281        282        283        284        285        286        287 
      0.27034765 0.73056430 0.58839620 0.42976528 0.58910004 0.76352613 0.50931523 
             288        289        290        291        292        293        294 
      0.78877573 0.93072359 0.42976528 0.42976528 0.27034765 0.32690028 0.58839620 
             295        296        297        298        299        300        301 
      0.45487411 0.83721296 0.58910004 0.50931523 0.58910004 0.83721296 0.58910004 
             302        303        304        305        306        307        308 
      0.38897634 0.35368440 0.22390881 0.66316115 0.90702032 0.78877573 0.90702032 
             309        310        311        312        313        314        315 
      0.42976528 0.38897634 0.66316115 0.27034765 0.45487411 0.52239129 0.84727053 
             316        317        318        319        320        321        322 
      0.78877573 0.52239129 0.65268611 0.58839620 0.32690028 0.27034765 0.52239129 
             323        324        325        326        327        328        329 
      0.73056430 0.06807856 0.65268611 0.73056430 0.35368440 0.78877573 0.73056430 
             330        331        332        333        334        335        336 
      0.14127713 0.32690028 0.38897634 0.45487411 0.27034765 0.87628488 0.50931523 
             337        338        339        340        341        342        343 
      0.58839620 0.45487411 0.66316115 0.38897634 0.66316115 0.58910004 0.78877573 
             344        345        346        347        348        349        350 
      0.73056430 0.50931523 0.50931523 0.45487411 0.42976528 0.83721296 0.27034765 
             351        352        353        354        355        356        357 
      0.17739435 0.83721296 0.58839620 0.66316115 0.28435576 0.83721296 0.52239129 
             358        359        360        361        362        363        364 
      0.27034765 0.28435576 0.42976528 0.76352613 0.27034765 0.52239129 0.28435576 
             365        366        367        368        369        370        371 
      0.87628488 0.45487411 0.35368440 0.32690028 0.27034765 0.58910004 0.35368440 
             372        373        374        375        376        377        378 
      0.52239129 0.22037531 0.42976528 0.58839620 0.32690028 0.14127713 0.73056430 
             379        380        381        382        383        384        385 
      0.50931523 0.78877573 0.83721296 0.52239129 0.42976528 0.58839620 0.66316115 
             386        387        388        389        390        391        392 
      0.93072359 0.50931523 0.96223973 0.35368440 0.11151645 0.32690028 0.38897634 
             393        394        395        396        397        398        399 
      0.71125529 0.52239129 0.50931523 0.38897634 0.42976528 0.80887717 0.80887717 
             400        401        402        403        404        405        406 
      0.83721296 0.22390881 0.32690028 0.45487411 0.83721296 0.90702032 0.38897634 
             407        408        409        410        411        412        413 
      0.52239129 0.58910004 0.45487411 0.80887717 0.65268611 0.45487411 0.78877573 
             414        415        416        417        418        419        420 
      0.42976528 0.58839620 0.17739435 0.52239129 0.28435576 0.42976528 0.11151645 
             421        422        423        424        425        426        427 
      0.32690028 0.65268611 0.45487411 0.45487411 0.52239129 0.35368440 0.65268611 
             428        429        430        431        432        433        434 
      0.65268611 0.52239129 0.50931523 0.38897634 0.45487411 0.50931523 0.83721296 
             435        436        437        438        439        440        441 
      0.32690028 0.76352613 0.78877573 0.27034765 0.22390881 0.52239129 0.58910004 
             442        443        444        445        446        447        448 
      0.52239129 0.73056430 0.22037531 0.32690028 0.78877573 0.65268611 0.65268611 
             449        450        451        452        453        454        455 
      0.17739435 0.32690028 0.58910004 0.14127713 0.80887717 0.52239129 0.50931523 
             456        457        458        459        460        461        462 
      0.71125529 0.52239129 0.58910004 0.32690028 0.73056430 0.52239129 0.58910004 
             463        464        465        466        467        468        469 
      0.71125529 0.78877573 0.17320152 0.27034765 0.52239129 0.73056430 0.58910004 
             470        471        472        473        474        475        476 
      0.65268611 0.58839620 0.66316115 0.32690028 0.50931523 0.78877573 0.73056430 
             477        478        479        480        481        482        483 
      0.35368440 0.52239129 0.52239129 0.73056430 0.83721296 0.58910004 0.78877573 
             484        485        486        487        488        489        490 
      0.73056430 0.50931523 0.32690028 0.78877573 0.66316115 0.45487411 0.65268611 
             491        492        493        494        495        496        497 
      0.73056430 0.22037531 0.22037531 0.32690028 0.50931523 0.17739435 0.28435576 
             498        499        500        501        502        503        504 
      0.58910004 0.50931523 0.76352613 0.83721296 0.22390881 0.38897634 0.32690028 
             505        506        507        508        509        510        511 
      0.50931523 0.42976528 0.32690028 0.45487411 0.32690028 0.32690028 0.32690028 
             512        513        514        515        516        517        518 
      0.13202412 0.17320152 0.66316115 0.71125529 0.28435576 0.38897634 0.42976528 
             519        520        521        522        523        524        525 
      0.27034765 0.52239129 0.58839620 0.52239129 0.87910405 0.76352613 0.52239129 
             526        527        528        529        530        531        532 
      0.65268611 0.87628488 0.58910004 0.27034765 0.83721296 0.83721296 0.58910004 
             533        534        535        536        537        538        539 
      0.38897634 0.42976528 0.32690028 0.66316115 0.66316115 0.73056430 0.50931523 
             540        541        542        543        544        545        546 
      0.52239129 0.27034765 0.38897634 0.65268611 0.35368440 0.50931523 0.73056430 
             547        548        549        550        551        552        553 
      0.52239129 0.45487411 0.38897634 0.22037531 0.45487411 0.22037531 0.73056430 
             554        555        556        557        558        559        560 
      0.45487411 0.35368440 0.45487411 0.65268611 0.27034765 0.66316115 0.52239129 
             561        562        563        564        565        566        567 
      0.83721296 0.22390881 0.50931523 0.78877573 0.45487411 0.58910004 0.27034765 
             568        569        570        571        572        573        574 
      0.73056430 0.90702032 0.42976528 0.50931523 0.71125529 0.38897634 0.45487411 
             575        576        577        578        579        580        581 
      0.50931523 0.52239129 0.38897634 0.73056430 0.14127713 0.38897634 0.42976528 
             582        583        584        585        586        587        588 
      0.17739435 0.50931523 0.50931523 0.52239129 0.27034765 0.45487411 0.11151645 
             589        590        591        592        593        594        595 
      0.78877573 0.45487411 0.87628488 0.17320152 0.35368440 0.58839620 0.50931523 
             596        597        598        599        600        601        602 
      0.50931523 0.45487411 0.22037531 0.58910004 0.66316115 0.27034765 0.22390881 
             603        604        605        606        607        608        609 
      0.38897634 0.27034765 0.32690028 0.73056430 0.83721296 0.73056430 0.76352613 
             610        611        612        613        614        615        616 
      0.58910004 0.66316115 0.58910004 0.58839620 0.76352613 0.45487411 0.11151645 
             617        618        619        620        621        622        623 
      0.50931523 0.11151645 0.73056430 0.28435576 0.45487411 0.17739435 0.45487411 
             624        625        626        627        628        629        630 
      0.45487411 0.38897634 0.17739435 0.78877573 0.42976528 0.87628488 0.73056430 
             631        632        633        634        635        636        637 
      0.22037531 0.66316115 0.58839620 0.78877573 0.73056430 0.83721296 0.66316115 
             638        639        640        641        642        643        644 
      0.73056430 0.58839620 0.87628488 0.42976528 0.58839620 0.58839620 0.58910004 
             645        646        647        648        649        650        651 
      0.22037531 0.35368440 0.32690028 0.35368440 0.42976528 0.50931523 0.84727053 
             652        653        654        655        656        657        658 
      0.42976528 0.73056430 0.73056430 0.66316115 0.45487411 0.78877573 0.73056430 
             659        660        661        662        663        664        665 
      0.17739435 0.73056430 0.32690028 0.78877573 0.27034765 0.32690028 0.32690028 
             666        667        668        669        670        671        672 
      0.96223973 0.58839620 0.66316115 0.28435576 0.22037531 0.38897634 0.58910004 
             673        674        675        676        677        678        679 
      0.45487411 0.32690028 0.73056430 0.58910004 0.17739435 0.45487411 0.32690028 
             680        681        682        683        684        685        686 
      0.45487411 0.14127713 0.42976528 0.32690028 0.11151645 0.66316115 0.87628488 
             687        688        689        690        691        692        693 
      0.45487411 0.80887717 0.32690028 0.38897634 0.83721296 0.52239129 0.50931523 
             694        695        696        697        698        699        700 
      0.52239129 0.22390881 0.78877573 0.78877573 0.50931523 0.27034765 0.78877573 
             701        702        703        704        705        706        707 
      0.22390881 0.27034765 0.90702032 0.27034765 0.38897634 0.28435576 0.78877573 
             708        709        710        711        712        713        714 
      0.42976528 0.42976528 0.32690028 0.11151645 0.87628488 0.78877573 0.58839620 
             715        716        717        718        719        720        721 
      0.52239129 0.52239129 0.58839620 0.17739435 0.32690028 0.50931523 0.52239129 
             722        723        724        725        726        727        728 
      0.42976528 0.50931523 0.58839620 0.83721296 0.71125529 0.17739435 0.38897634 
             729        730        731        732        733        734        735 
      0.52239129 0.66316115 0.38897634 0.73056430 0.58839620 0.38897634 0.65268611 
             736        737        738        739        740        741        742 
      0.38897634 0.73056430 0.22037531 0.35368440 0.80887717 0.52239129 0.58910004 
             743        744        745        746        747        748        749 
      0.80887717 0.73056430 0.32690028 0.52239129 0.22390881 0.87628488 0.71125529 
             750        751        752        753        754        755        756 
      0.28435576 0.71125529 0.58910004 0.58910004 0.66316115 0.50931523 0.73056430 
             757        758        759        760        761        762        763 
      0.42976528 0.38897634 0.66316115 0.93072359 0.22037531 0.38897634 0.65268611 
             764        765        766        767        768        769        770 
      0.14127713 0.27034765 0.32690028 0.50931523 0.58839620 0.50931523 0.35368440 
             771        772        773        774        775        776        777 
      0.35368440 0.87628488 0.73056430 0.52239129 0.32690028 0.35368440 0.65268611 
             778        779        780        781        782        783        784 
      0.73056430 0.38897634 0.83721296 0.66316115 0.35368440 0.78877573 0.38897634 
             785        786        787        788        789        790        791 
      0.42976528 0.32690028 0.27034765 0.50931523 0.50931523 0.58910004 0.28435576 
             792        793        794        795        796        797        798 
      0.83721296 0.50931523 0.73056430 0.17739435 0.50931523 0.45487411 0.58839620 
             799        800        801        802        803        804        805 
      0.35368440 0.27034765 0.58839620 0.58839620 0.78877573 0.80887717 0.71125529 
             806        807        808        809        810        811        812 
      0.73056430 0.32690028 0.42976528 0.27034765 0.80887717 0.83721296 0.52239129 
             813        814        815        816        817        818        819 
      0.71125529 0.78877573 0.27034765 0.42976528 0.22037531 0.52239129 0.45487411 
             820        821        822        823        824        825        826 
      0.17739435 0.78877573 0.73056430 0.78877573 0.87628488 0.87628488 0.38897634 
             827        828        829        830        831        832        833 
      0.42976528 0.17739435 0.50931523 0.45487411 0.22037531 0.22390881 0.52239129 
             834        835        836        837        838        839        840 
      0.52239129 0.32690028 0.22037531 0.45487411 0.35368440 0.83721296 0.58910004 
             841        842        843        844        845        846        847 
      0.66316115 0.42976528 0.73056430 0.28435576 0.58910004 0.38897634 0.27034765 
             848        849        850        851        852        853        854 
      0.27034765 0.73056430 0.14127713 0.50931523 0.42976528 0.58839620 0.22390881 
             855        856        857        858        859        860        861 
      0.58839620 0.38897634 0.52239129 0.58839620 0.52239129 0.73056430 0.52239129 
             862        863        864        865        866        867        868 
      0.73056430 0.65268611 0.76352613 0.45487411 0.58910004 0.80887717 0.52239129 
             869        870        871        872        873        874        875 
      0.58839620 0.27034765 0.58839620 0.87628488 0.66316115 0.38897634 0.90702032 
             876        877        878        879        880        881        882 
      0.73056430 0.58839620 0.35368440 0.45487411 0.65268611 0.38897634 0.17739435 
             883        884        885        886        887        888        889 
      0.50931523 0.87628488 0.58839620 0.45487411 0.66316115 0.58839620 0.38897634 
             890        891        892        893        894        895        896 
      0.78877573 0.42976528 0.17739435 0.42976528 0.65268611 0.58910004 0.45487411 
             897        898        899        900        901        902        903 
      0.32690028 0.80887717 0.65268611 0.66316115 0.58839620 0.32690028 0.76352613 
             904        905        906        907        908        909        910 
      0.32690028 0.73056430 0.27034765 0.73056430 0.58910004 0.32690028 0.78877573 
             911        912        913        914        915        916        917 
      0.66316115 0.38897634 0.58910004 0.58839620 0.38897634 0.78877573 0.38897634 
             918        919        920        921        922        923        924 
      0.45487411 0.58910004 0.87628488 0.58910004 0.35368440 0.42976528 0.50931523 
             925        926        927        928        929        930        931 
      0.66316115 0.17739435 0.58839620 0.58910004 0.50931523 0.58910004 0.73056430 
             932        933        934        935        936        937        938 
      0.76352613 0.58839620 0.42976528 0.58839620 0.38897634 0.58910004 0.71125529 
             939        940        941        942        943        944        945 
      0.17739435 0.73056430 0.52239129 0.42976528 0.38897634 0.87628488 0.32690028 
             946        947        948        949        950        951        952 
      0.58910004 0.17739435 0.22390881 0.58839620 0.50931523 0.58910004 0.52239129 
             953        954        955        956        957        958        959 
      0.38897634 0.87628488 0.66316115 0.17739435 0.50931523 0.52239129 0.22037531 
             960        961        962        963        964        965        966 
      0.83721296 0.76352613 0.27034765 0.17739435 0.66316115 0.22037531 0.22037531 
             967        968        969        970        971        972        973 
      0.45487411 0.65268611 0.45487411 0.27034765 0.38897634 0.14127713 0.58839620 
             974        975        976        977        978        979        980 
      0.71125529 0.38897634 0.66316115 0.71125529 0.71125529 0.66316115 0.73056430 
             981        982        983        984        985        986        987 
      0.65268611 0.90702032 0.58839620 0.78877573 0.22037531 0.66316115 0.58839620 
             988        989        990        991        992        993        994 
      0.27034765 0.52239129 0.58910004 0.06807856 0.58910004 0.52239129 0.38897634 
             995        996        997        998        999       1000       1001 
      0.73056430 0.35368440 0.90702032 0.38897634 0.87628488 0.66316115 0.58839620 
            1002       1003       1004       1005       1006       1007       1008 
      0.35368440 0.22037531 0.42976528 0.73056430 0.28435576 0.94872579 0.66316115 
            1009       1010       1011       1012       1013       1014       1015 
      0.58910004 0.50931523 0.22037531 0.66316115 0.09945871 0.45487411 0.58839620 
            1016       1017       1018       1019       1020       1021       1022 
      0.27034765 0.14127713 0.73056430 0.35368440 0.58839620 0.73056430 0.42976528 
            1023       1024       1025       1026       1027       1028       1029 
      0.90702032 0.42976528 0.65268611 0.45487411 0.66316115 0.22037531 0.32690028 
            1030       1031       1032       1033       1034       1035       1036 
      0.66316115 0.42976528 0.58910004 0.52239129 0.17739435 0.71125529 0.58839620 
            1037       1038       1039       1040       1041       1042       1043 
      0.11151645 0.42976528 0.73056430 0.13202412 0.66316115 0.38897634 0.42976528 
            1044       1045       1046       1047       1048       1049       1050 
      0.65268611 0.65268611 0.66316115 0.32690028 0.35368440 0.38897634 0.78877573 
            1051       1052       1053       1054       1055       1056       1057 
      0.27034765 0.32690028 0.66316115 0.42976528 0.52239129 0.45487411 0.22390881 
            1058       1059       1060       1061       1062       1063       1064 
      0.45487411 0.38897634 0.38897634 0.28435576 0.35368440 0.58910004 0.50931523 
            1065       1066       1067       1068       1069       1070       1071 
      0.73056430 0.73056430 0.78877573 0.83721296 0.35368440 0.66316115 0.45487411 
            1072       1073       1074       1075       1076       1077       1078 
      0.42976528 0.45487411 0.11151645 0.78877573 0.78877573 0.08738702 0.22037531 
            1079       1080       1081       1082       1083       1084       1085 
      0.50931523 0.27034765 0.42976528 0.22037531 0.93072359 0.14127713 0.50931523 
            1086       1087       1088       1089       1090       1091       1092 
      0.27034765 0.22390881 0.50931523 0.17320152 0.42976528 0.58910004 0.78877573 
            1093       1094       1095       1096       1097       1098       1099 
      0.87628488 0.78877573 0.66316115 0.52239129 0.58910004 0.17739435 0.32690028 
            1100       1101       1102       1103       1104       1105       1106 
      0.32690028 0.93072359 0.22390881 0.73056430 0.27034765 0.71125529 0.58910004 
            1107       1108       1109       1110       1111       1112       1113 
      0.32690028 0.42976528 0.52239129 0.42976528 0.58910004 0.45487411 0.38897634 
            1114       1115       1116       1117       1118       1119       1120 
      0.22390881 0.73056430 0.65268611 0.50931523 0.66316115 0.52239129 0.78877573 
            1121       1122       1123       1124       1125       1126       1127 
      0.87628488 0.73056430 0.50931523 0.66316115 0.58839620 0.58839620 0.35368440 
            1128       1129       1130       1131       1132       1133       1134 
      0.38897634 0.42976528 0.66316115 0.14127713 0.38897634 0.80887717 0.42976528 
            1135       1136       1137       1138       1139       1140       1141 
      0.87628488 0.42976528 0.28435576 0.50931523 0.22390881 0.58839620 0.38897634 
            1142       1143       1144       1145       1146       1147       1148 
      0.14127713 0.38897634 0.38897634 0.58910004 0.58910004 0.78877573 0.52239129 
            1149       1150       1151       1152       1153       1154       1155 
      0.38897634 0.45487411 0.66316115 0.22390881 0.22390881 0.22037531 0.78877573 
            1156       1157       1158       1159       1160       1161       1162 
      0.90702032 0.87628488 0.45487411 0.90702032 0.73056430 0.17320152 0.22037531 
            1163       1164       1165       1166       1167       1168       1169 
      0.50931523 0.71125529 0.73056430 0.17320152 0.50931523 0.22037531 0.50931523 
            1170       1171       1172       1173       1174       1175       1176 
      0.73056430 0.42976528 0.42976528 0.28435576 0.87910405 0.93072359 0.71125529 
            1177       1178       1179       1180       1181       1182       1183 
      0.78877573 0.52239129 0.11151645 0.58839620 0.78877573 0.50931523 0.50931523 
            1184       1185       1186       1187       1188       1189       1190 
      0.66316115 0.45487411 0.58839620 0.32690028 0.58910004 0.52239129 0.42976528 
            1191       1192       1193       1194       1195       1196       1197 
      0.66316115 0.84727053 0.76352613 0.52239129 0.78877573 0.32690028 0.78877573 
            1198       1199       1200       1201       1202       1203       1204 
      0.45487411 0.22390881 0.76352613 0.65268611 0.58910004 0.35368440 0.66316115 
            1205       1206       1207       1208       1209       1210       1211 
      0.42976528 0.87628488 0.90702032 0.27034765 0.90702032 0.32690028 0.32690028 
            1212       1213       1214       1215       1216       1217       1218 
      0.66316115 0.38897634 0.93072359 0.38897634 0.45487411 0.65268611 0.65268611 
            1219       1220       1221       1222       1223       1224       1225 
      0.80887717 0.14127713 0.52239129 0.78877573 0.45487411 0.58839620 0.32690028 
            1226       1227       1228       1229       1230       1231       1232 
      0.78877573 0.38897634 0.71125529 0.73056430 0.45487411 0.52239129 0.78877573 
            1233       1234       1235       1236       1237       1238       1239 
      0.52239129 0.73056430 0.90702032 0.35368440 0.78877573 0.42976528 0.73056430 
            1240       1241       1242       1243       1244       1245       1246 
      0.32690028 0.58839620 0.66316115 0.58839620 0.73056430 0.71125529 0.50931523 
            1247       1248       1249       1250       1251       1252       1253 
      0.71125529 0.58839620 0.93072359 0.32690028 0.32690028 0.32690028 0.45487411 
            1254       1255       1256       1257       1258       1259       1260 
      0.52239129 0.38897634 0.22037531 0.52239129 0.73056430 0.50931523 0.58839620 
            1261       1262       1263       1264       1265       1266       1267 
      0.52239129 0.17739435 0.32690028 0.66316115 0.58839620 0.14127713 0.50931523 
            1268       1269       1270       1271       1272       1273       1274 
      0.66316115 0.50931523 0.28435576 0.28435576 0.52239129 0.71125529 0.35368440 
            1275       1276       1277       1278       1279       1280       1281 
      0.76352613 0.73056430 0.32690028 0.83721296 0.45487411 0.65268611 0.32690028 
            1282       1283       1284       1285       1286       1287       1288 
      0.90702032 0.14127713 0.58910004 0.58910004 0.22390881 0.50931523 0.93072359 
            1289       1290       1291       1292       1293       1294       1295 
      0.14127713 0.52239129 0.83721296 0.14127713 0.58910004 0.65268611 0.66316115 
            1296       1297       1298       1299       1300       1301       1302 
      0.45487411 0.65268611 0.83721296 0.38897634 0.58910004 0.78877573 0.14127713 
            1303       1304       1305       1306       1307       1308       1309 
      0.78877573 0.32690028 0.76352613 0.66316115 0.27034765 0.58839620 0.50931523 
            1310       1311       1312       1313       1314       1315       1316 
      0.83721296 0.83721296 0.42976528 0.38897634 0.22037531 0.52239129 0.73056430 
            1317       1318       1319       1320       1321       1322       1323 
      0.78877573 0.87628488 0.71125529 0.66316115 0.58910004 0.38897634 0.50931523 
            1324       1325       1326       1327       1328       1329       1330 
      0.78877573 0.65268611 0.27034765 0.32690028 0.52239129 0.83721296 0.28435576 
            1331       1332       1333       1334       1335       1336       1337 
      0.65268611 0.50931523 0.73056430 0.38897634 0.50931523 0.78877573 0.27034765 
            1338       1339       1340       1341       1342       1343       1344 
      0.58839620 0.78877573 0.27034765 0.32690028 0.90702032 0.58839620 0.28435576 
            1345       1346       1347       1348       1349       1350       1351 
      0.58839620 0.45487411 0.50931523 0.22037531 0.32690028 0.52239129 0.38897634 
            1352       1353       1354       1355       1356       1357       1358 
      0.50931523 0.87628488 0.76352613 0.35368440 0.58910004 0.52239129 0.58839620 
            1359       1360       1361       1362       1363       1364       1365 
      0.76352613 0.83721296 0.27034765 0.66316115 0.58839620 0.22037531 0.52239129 
            1366       1367       1368       1369       1370       1371       1372 
      0.66316115 0.90702032 0.38897634 0.66316115 0.90702032 0.65268611 0.66316115 
            1373       1374       1375       1376       1377       1378       1379 
      0.87910405 0.32690028 0.45487411 0.52239129 0.78877573 0.45487411 0.58839620 
            1380       1381       1382       1383       1384       1385       1386 
      0.42976528 0.22037531 0.50931523 0.58839620 0.17739435 0.78877573 0.32690028 
            1387       1388       1389       1390       1391       1392       1393 
      0.38897634 0.17739435 0.11151645 0.78877573 0.52239129 0.52239129 0.73056430 
            1394       1395       1396       1397       1398       1399       1400 
      0.76352613 0.76352613 0.73056430 0.42976528 0.58910004 0.45487411 0.17320152 
            1401       1402       1403       1404       1405       1406       1407 
      0.78877573 0.96223973 0.42976528 0.78877573 0.38897634 0.38897634 0.66316115 
            1408       1409       1410       1411       1412       1413       1414 
      0.52239129 0.84727053 0.78877573 0.22390881 0.50931523 0.27034765 0.35368440 
            1415       1416       1417       1418       1419       1420       1421 
      0.42976528 0.90702032 0.65268611 0.73056430 0.17320152 0.58910004 0.32690028 
            1422       1423       1424       1425       1426       1427       1428 
      0.52239129 0.45487411 0.83721296 0.66316115 0.73056430 0.66316115 0.28435576 
            1429       1430       1431       1432       1433       1434       1435 
      0.42976528 0.17739435 0.71125529 0.32690028 0.58839620 0.50931523 0.42976528 
            1436       1437       1438       1439       1440       1441       1442 
      0.17739435 0.73056430 0.94872579 0.73056430 0.50931523 0.17739435 0.73056430 
            1443       1444       1445       1446       1447       1448       1449 
      0.58910004 0.58839620 0.83721296 0.27034765 0.76352613 0.35368440 0.66316115 
            1450       1451       1452       1453       1454       1455       1456 
      0.71125529 0.87628488 0.45487411 0.38897634 0.42976528 0.58910004 0.65268611 
            1457       1458       1459       1460       1461       1462       1463 
      0.73056430 0.32690028 0.52239129 0.22390881 0.50931523 0.58910004 0.32690028 
            1464       1465       1466       1467       1468       1469       1470 
      0.27034765 0.78877573 0.52239129 0.52239129 0.52239129 0.66316115 0.17739435 
            1471       1472       1473       1474       1475       1476       1477 
      0.50931523 0.80887717 0.17320152 0.78877573 0.38897634 0.28435576 0.73056430 
            1478       1479       1480       1481       1482       1483       1484 
      0.11151645 0.83721296 0.73056430 0.38897634 0.83721296 0.38897634 0.94872579 
            1485       1486       1487       1488       1489       1490       1491 
      0.45487411 0.52239129 0.28435576 0.71125529 0.45487411 0.66316115 0.66316115 
            1492       1493       1494       1495       1496       1497       1498 
      0.32690028 0.52239129 0.73056430 0.58839620 0.38897634 0.45487411 0.78877573 
            1499       1500       1501       1502       1503       1504       1505 
      0.66316115 0.58839620 0.73056430 0.52239129 0.90702032 0.17739435 0.78877573 
            1506       1507       1508       1509       1510       1511       1512 
      0.66316115 0.22037531 0.52239129 0.17739435 0.52239129 0.27034765 0.45487411 
            1513       1514       1515       1516       1517       1518       1519 
      0.38897634 0.27034765 0.58839620 0.42976528 0.58839620 0.50931523 0.14127713 
            1520       1521       1522       1523       1524       1525       1526 
      0.73056430 0.45487411 0.65268611 0.50931523 0.78877573 0.52239129 0.66316115 
            1527       1528       1529       1530       1531       1532       1533 
      0.22390881 0.66316115 0.58839620 0.66316115 0.42976528 0.76352613 0.73056430 
            1534       1535       1536       1537       1538       1539       1540 
      0.45487411 0.32690028 0.93072359 0.27034765 0.50931523 0.66316115 0.58839620 
            1541       1542       1543       1544       1545       1546       1547 
      0.83721296 0.66316115 0.22390881 0.38897634 0.83721296 0.83721296 0.32690028 
            1548       1549       1550       1551       1552       1553       1554 
      0.66316115 0.66316115 0.14127713 0.27034765 0.22037531 0.28435576 0.38897634 
            1555       1556       1557       1558       1559       1560       1561 
      0.45487411 0.32690028 0.58910004 0.22037531 0.65268611 0.35368440 0.13202412 
            1562       1563       1564       1565       1566       1567       1568 
      0.58910004 0.93072359 0.58910004 0.65268611 0.66316115 0.50931523 0.93072359 
            1569       1570       1571       1572       1573       1574       1575 
      0.14127713 0.45487411 0.78877573 0.65268611 0.73056430 0.45487411 0.38897634 
            1576       1577       1578       1579       1580       1581       1582 
      0.58910004 0.32690028 0.58910004 0.58910004 0.83721296 0.22390881 0.38897634 
            1583       1584       1585       1586       1587       1588       1589 
      0.80887717 0.14127713 0.87628488 0.71125529 0.58910004 0.28435576 0.17739435 
            1590       1591       1592       1593       1594       1595       1596 
      0.73056430 0.73056430 0.35368440 0.58910004 0.27034765 0.58910004 0.52239129 
            1597       1598       1599       1600       1601       1602       1603 
      0.78877573 0.27034765 0.78877573 0.52239129 0.58910004 0.96223973 0.09945871 
            1604       1605       1606       1607       1608       1609       1610 
      0.38897634 0.66316115 0.73056430 0.38897634 0.38897634 0.28435576 0.52239129 
            1611       1612       1613       1614       1615       1616       1617 
      0.58839620 0.38897634 0.73056430 0.22390881 0.87628488 0.58839620 0.52239129 
            1618       1619       1620       1621       1622       1623       1624 
      0.27034765 0.45487411 0.17739435 0.58910004 0.78877573 0.58839620 0.52239129 
            1625       1626       1627       1628       1629       1630       1631 
      0.35368440 0.17320152 0.66316115 0.73056430 0.87628488 0.73056430 0.58839620 
            1632       1633       1634       1635       1636       1637       1638 
      0.42976528 0.52239129 0.66316115 0.27034765 0.73056430 0.73056430 0.73056430 
            1639       1640       1641       1642       1643       1644       1645 
      0.32690028 0.52239129 0.87628488 0.66316115 0.42976528 0.66316115 0.52239129 
            1646       1647       1648       1649       1650       1651       1652 
      0.78877573 0.28435576 0.73056430 0.50931523 0.50931523 0.32690028 0.78877573 
            1653       1654       1655       1656       1657       1658       1659 
      0.32690028 0.52239129 0.45487411 0.58839620 0.27034765 0.45487411 0.17739435 
            1660       1661       1662       1663       1664       1665       1666 
      0.78877573 0.65268611 0.78877573 0.93072359 0.52239129 0.28435576 0.52239129 
            1667       1668       1669       1670       1671       1672       1673 
      0.58910004 0.83721296 0.08738702 0.66316115 0.32690028 0.32690028 0.50931523 
            1674       1675       1676       1677       1678       1679       1680 
      0.17320152 0.42976528 0.50931523 0.73056430 0.52239129 0.52239129 0.73056430 
            1681       1682       1683       1684       1685       1686       1687 
      0.42976528 0.28435576 0.58839620 0.73056430 0.50931523 0.42976528 0.27034765 
            1688       1689       1690       1691       1692       1693       1694 
      0.27034765 0.22037531 0.71125529 0.38897634 0.58839620 0.50931523 0.22390881 
            1695       1696       1697       1698       1699       1700       1701 
      0.65268611 0.32690028 0.38897634 0.65268611 0.45487411 0.45487411 0.11151645 
            1702       1703       1704       1705       1706       1707       1708 
      0.08738702 0.58839620 0.50931523 0.38897634 0.27034765 0.71125529 0.66316115 
            1709       1710       1711       1712       1713       1714       1715 
      0.90702032 0.58839620 0.17739435 0.35368440 0.27034765 0.58839620 0.32690028 
            1716       1717       1718       1719       1720       1721       1722 
      0.45487411 0.93072359 0.50931523 0.22037531 0.27034765 0.66316115 0.22037531 
            1723       1724       1725       1726       1727       1728       1729 
      0.73056430 0.38897634 0.52239129 0.65268611 0.58910004 0.22037531 0.58910004 
            1730       1731       1732       1733       1734       1735       1736 
      0.17739435 0.38897634 0.45487411 0.83721296 0.58839620 0.66316115 0.52239129 
            1737       1738       1739       1740       1741       1742       1743 
      0.14127713 0.65268611 0.27034765 0.52239129 0.58910004 0.28435576 0.45487411 
            1744       1745       1746       1747       1748       1749       1750 
      0.96223973 0.52239129 0.38897634 0.27034765 0.32690028 0.83721296 0.14127713 
            1751       1752       1753       1754       1755       1756       1757 
      0.42976528 0.73056430 0.27034765 0.94872579 0.32690028 0.65268611 0.50931523 
            1758       1759       1760       1761       1762       1763       1764 
      0.27034765 0.32690028 0.71125529 0.83721296 0.22390881 0.32690028 0.50931523 
            1765       1766       1767       1768       1769       1770       1771 
      0.58910004 0.84727053 0.94872579 0.66316115 0.52239129 0.83721296 0.35368440 
            1772       1773       1774       1775       1776       1777       1778 
      0.28435576 0.78877573 0.58910004 0.13202412 0.87628488 0.66316115 0.45487411 
            1779       1780       1781       1782       1783       1784       1785 
      0.22037531 0.38897634 0.76352613 0.28435576 0.27034765 0.52239129 0.17320152 
            1786       1787       1788       1789       1790       1791       1792 
      0.14127713 0.38897634 0.65268611 0.78877573 0.78877573 0.42976528 0.58910004 
            1793       1794       1795       1796       1797       1798       1799 
      0.78877573 0.58910004 0.93072359 0.65268611 0.38897634 0.78877573 0.58910004 
            1800       1801       1802       1803       1804       1805       1806 
      0.58839620 0.32690028 0.58910004 0.76352613 0.32690028 0.58839620 0.58839620 
            1807       1808       1809       1810       1811       1812       1813 
      0.35368440 0.50931523 0.45487411 0.58839620 0.42976528 0.87628488 0.32690028 
            1814       1815       1816       1817       1818       1819       1820 
      0.52239129 0.17320152 0.38897634 0.83721296 0.22037531 0.66316115 0.22037531 
            1821       1822       1823       1824       1825       1826       1827 
      0.38897634 0.90702032 0.45487411 0.32690028 0.22037531 0.27034765 0.73056430 
            1828       1829       1830       1831       1832       1833       1834 
      0.76352613 0.14127713 0.14127713 0.58839620 0.52239129 0.66316115 0.38897634 
            1835       1836       1837       1838       1839       1840       1841 
      0.22037531 0.28435576 0.52239129 0.35368440 0.45487411 0.52239129 0.50931523 
            1842       1843       1844       1845       1846       1847       1848 
      0.73056430 0.76352613 0.38897634 0.50931523 0.76352613 0.66316115 0.14127713 
            1849       1850       1851       1852       1853       1854       1855 
      0.66316115 0.17739435 0.50931523 0.27034765 0.27034765 0.66316115 0.58910004 
            1856       1857       1858       1859       1860       1861       1862 
      0.83721296 0.22037531 0.32690028 0.58839620 0.45487411 0.45487411 0.35368440 
            1863       1864       1865       1866       1867       1868       1869 
      0.17320152 0.22037531 0.32690028 0.78877573 0.78877573 0.45487411 0.27034765 
            1870       1871       1872       1873       1874       1875       1876 
      0.58910004 0.65268611 0.58839620 0.83721296 0.66316115 0.65268611 0.38897634 
            1877       1878       1879       1880       1881       1882       1883 
      0.35368440 0.65268611 0.66316115 0.78877573 0.87628488 0.58839620 0.38897634 
            1884       1885       1886       1887       1888       1889       1890 
      0.28435576 0.71125529 0.65268611 0.73056430 0.45487411 0.65268611 0.42976528 
            1891       1892       1893       1894       1895       1896       1897 
      0.14127713 0.50931523 0.17739435 0.52239129 0.42976528 0.50931523 0.58839620 
            1898       1899       1900       1901       1902       1903       1904 
      0.58839620 0.83721296 0.58839620 0.45487411 0.58910004 0.66316115 0.32690028 
            1905       1906       1907       1908       1909       1910       1911 
      0.73056430 0.71125529 0.28435576 0.73056430 0.73056430 0.32690028 0.73056430 
            1912       1913       1914       1915       1916       1917       1918 
      0.66316115 0.32690028 0.83721296 0.38897634 0.50931523 0.71125529 0.78877573 
            1919       1920       1921       1922       1923       1924       1925 
      0.32690028 0.73056430 0.38897634 0.38897634 0.17739435 0.14127713 0.90702032 
            1926       1927       1928       1929       1930       1931       1932 
      0.27034765 0.58839620 0.35368440 0.65268611 0.42976528 0.22390881 0.52239129 
            1933       1934       1935       1936       1937       1938       1939 
      0.66316115 0.27034765 0.50931523 0.52239129 0.83721296 0.27034765 0.22390881 
            1940       1941       1942       1943       1944       1945       1946 
      0.58839620 0.45487411 0.52239129 0.66316115 0.22037531 0.45487411 0.87628488 
            1947       1948       1949       1950       1951       1952       1953 
      0.58910004 0.73056430 0.73056430 0.32690028 0.65268611 0.87910405 0.28435576 
            1954       1955       1956       1957       1958       1959       1960 
      0.71125529 0.50931523 0.42976528 0.66316115 0.32690028 0.73056430 0.73056430 
            1961       1962       1963       1964       1965       1966       1967 
      0.35368440 0.83721296 0.52239129 0.58910004 0.58839620 0.35368440 0.65268611 
            1968       1969       1970       1971       1972       1973       1974 
      0.71125529 0.45487411 0.83721296 0.58910004 0.58839620 0.58839620 0.17739435 
            1975       1976       1977       1978       1979       1980       1981 
      0.58839620 0.73056430 0.50931523 0.42976528 0.32690028 0.11151645 0.35368440 
            1982       1983       1984       1985       1986       1987       1988 
      0.66316115 0.52239129 0.35368440 0.27034765 0.35368440 0.45487411 0.73056430 
            1989       1990       1991       1992       1993       1994       1995 
      0.28435576 0.80887717 0.32690028 0.66316115 0.28435576 0.73056430 0.80887717 
            1996       1997       1998       1999       2000 
      0.52239129 0.45487411 0.73056430 0.73056430 0.71125529 
      attr(,"label")
      [1] "Fitted values"

---

    Code
      residuals(fit_irls)
    Output
               1          2          3          4          5          6          7 
       -1.834439   1.309713   1.141181  -1.282668   1.267787  -1.397342   1.914274 
               8          9         10         11         12         13         14 
        2.326852   1.267787   1.309713   1.194439   1.405965  -1.834439  -2.037968 
              15         16         17         18         19         20         21 
       -3.711461  -1.547232   1.699535   1.405965  -1.834439  -1.485664   2.326852 
              22         23         24         25         26         27         28 
        1.236282   1.141181   1.194439   1.507929   1.963421   1.309713  -2.037968 
              29         30         31         32         33         34         35 
        1.405965  -1.370516  -2.037968  -2.879240  -4.734304  -1.485664   2.198410 
              36         37         38         39         40         41         42 
       -2.093764  -2.968779   1.194439   1.963421  -2.433682  -1.370516   1.963421 
              43         44         45         46         47         48         49 
       -2.037968   1.267787   1.267787  -1.834439  -1.485664   1.963421   4.537713 
              50         51         52         53         54         55         56 
       -2.093764   1.914274  -1.370516   7.078287  -2.093764   3.059037   1.699535 
              57         58         59         60         61         62         63 
       -1.485664   1.914274  -2.093764   1.914274   1.137522  -2.968779   3.059037 
              64         65         66         67         68         69         70 
       -1.282668   1.532130  -3.711461  -1.282668   1.368805  -1.095755   1.074433 
              71         72         73         74         75         76         77 
       -1.753664  -1.282668   2.198410   1.699535  -2.037968   4.537713   1.532130 
              78         79         80         81         82         83         84 
       -1.288508  -1.485664   1.963421   1.914274  -2.429521  -1.282668  -1.547232 
              85         86         87         88         89         90         91 
       -2.037968  -2.879240   3.516721  -1.547232  -1.834439  -3.711461  -1.397342 
              92         93         94         95         96         97         98 
        1.405965  -1.834439   1.405965   3.698941  -1.282668   2.570850   1.194439 
              99        100        101        102        103        104        105 
       -1.370516   1.180261   1.054045   1.914274   1.914274   1.507929  -1.636598 
             106        107        108        109        110        111        112 
       -1.209485   1.267787  -4.734304   1.507929  -1.164520   1.532130  -1.834439 
             113        114        115        116        117        118        119 
        2.570850   1.194439  -1.485664  -2.429521   3.059037   1.141181  -1.282668 
             120        121        122        123        124        125        126 
        2.198410   1.309713  -1.834439  -1.370516   1.194439  -1.370516   1.963421 
             127        128        129        130        131        132        133 
        3.698941  -1.288508  -1.370516  -1.397342   2.198410  -1.753664  -1.753664 
             134        135        136        137        138        139        140 
        1.194439  -1.636598  -1.636598  -1.152106   1.697505   1.368805   1.194439 
             141        142        143        144        145        146        147 
       -1.636598   5.637158  -1.397342   1.267787   1.963421  -2.968779   1.102511 
             148        149        150        151        152        153        154 
        1.368805  -1.282668   3.059037  -1.370516  -1.282668   1.507929  -1.834439 
             155        156        157        158        159        160        161 
        1.194439  -1.547232  -1.282668   1.102511   1.074433   2.570850   2.326852 
             162        163        164        165        166        167        168 
        1.914274 -10.755038  -1.164520   2.326852  -1.834439   1.507929 -10.755038 
             169        170        171        172        173        174        175 
       -1.370516   1.267787  -1.397342   1.507929  -2.433682   1.699535  -3.711461 
             176        177        178        179        180        181        182 
        2.326852  -1.834439   1.309713   1.141181  -1.215649   2.570850   1.141181 
             183        184        185        186        187        188        189 
        1.102511   1.236282  -2.433682  -2.037968   1.141181  -1.547232  -1.125513 
             190        191        192        193        194        195        196 
        1.368805  -1.485664   1.963421   1.368805  -1.164520   1.102511   1.699535 
             197        198        199        200        201        202        203 
       -2.429521  -2.968779   1.267787   2.198410  -1.485664   1.699535  -1.288508 
             204        205        206        207        208        209        210 
        1.267787   1.141181  -3.711461   1.368805  -1.834439   1.267787  -1.636598 
             211        212        213        214        215        216        217 
       -2.433682   2.570850   4.466104  -2.093764  -1.215649  -1.397342   1.368805 
             218        219        220        221        222        223        224 
        1.267787   1.074433   1.368805   1.697505  -1.636598  -1.636598  -3.711461 
             225        226        227        228        229        230        231 
       -1.636598   2.326852   1.368805   1.963421   1.699535  -2.093764   2.827379 
             232        233        234        235        236        237        238 
        1.102511   1.141181   2.827379   1.194439  -3.711461   1.699535 -14.434929 
             239        240        241        242        243        244        245 
       -1.485664   1.102511   1.368805  -2.879240   1.507929   2.198410   1.963421 
             246        247        248        249        250        251        252 
       -1.485664  -1.834439  -2.429521   1.697505  -1.485664   1.194439   1.963421 
             253        254        255        256        257        258        259 
        1.267787  -2.968779  -2.433682  -2.433682   1.507929   2.198410   1.405965 
             260        261        262        263        264        265        266 
        1.267787  -1.095755   1.532130  -1.547232  -1.370516   1.507929  -2.429521 
             267        268        269        270        271        272        273 
        1.194439  -1.834439   1.309713  -1.164520  -1.834439  -2.968779   1.267787 
             274        275        276        277        278        279        280 
       -1.547232   1.102511  -1.485664  -2.093764  -1.215649   2.827379  -2.093764 
             281        282        283        284        285        286        287 
       -1.370516   1.368805   1.699535  -1.753664  -2.433682  -4.228797   1.963421 
             288        289        290        291        292        293        294 
       -4.734304   1.074433  -1.753664  -1.753664  -1.370516   3.059037  -2.429521 
             295        296        297        298        299        300        301 
        2.198410   1.194439   1.697505  -2.037968   1.697505   1.194439   1.697505 
             302        303        304        305        306        307        308 
       -1.636598  -1.547232  -1.288508  -2.968779   1.102511   1.267787   1.102511 
             309        310        311        312        313        314        315 
        2.326852  -1.636598  -2.968779  -1.370516  -1.834439  -2.093764   1.180261 
             316        317        318        319        320        321        322 
        1.267787  -2.093764  -2.879240   1.699535  -1.485664   3.698941   1.914274 
             323        324        325        326        327        328        329 
        1.368805  -1.073052   1.532130   1.368805  -1.547232   1.267787   1.368805 
             330        331        332        333        334        335        336 
       -1.164520  -1.485664  -1.636598  -1.834439   3.698941   1.141181   1.963421 
             337        338        339        340        341        342        343 
       -2.429521   2.198410   1.507929  -1.636598  -2.968779   1.697505   1.267787 
             344        345        346        347        348        349        350 
       -3.711461   1.963421   1.963421   2.198410   2.326852   1.194439  -1.370516 
             351        352        353        354        355        356        357 
       -1.215649   1.194439  -2.429521   1.507929  -1.397342   1.194439  -2.093764 
             358        359        360        361        362        363        364 
       -1.370516  -1.397342   2.326852   1.309713   3.698941  -2.093764  -1.397342 
             365        366        367        368        369        370        371 
        1.141181  -1.834439  -1.547232  -1.485664  -1.370516  -2.433682  -1.547232 
             372        373        374        375        376        377        378 
       -2.093764   4.537713  -1.753664   1.699535   3.059037  -1.164520  -3.711461 
             379        380        381        382        383        384        385 
        1.963421   1.267787   1.194439  -2.093764   2.326852  -2.429521  -2.968779 
             386        387        388        389        390        391        392 
        1.074433  -2.037968   1.039242  -1.547232  -1.125513  -1.485664  -1.636598 
             393        394        395        396        397        398        399 
        1.405965  -2.093764  -2.037968   2.570850  -1.753664   1.236282  -5.232237 
             400        401        402        403        404        405        406 
        1.194439  -1.288508  -1.485664  -1.834439  -6.142995   1.102511  -1.636598 
             407        408        409        410        411        412        413 
        1.914274   1.697505   2.198410   1.236282   1.532130   2.198410   1.267787 
             414        415        416        417        418        419        420 
       -1.753664  -2.429521  -1.215649   1.914274  -1.397342   2.326852   8.967286 
             421        422        423        424        425        426        427 
       -1.485664   1.532130  -1.834439  -1.834439   1.914274  -1.547232  -2.879240 
             428        429        430        431        432        433        434 
        1.532130  -2.093764   1.963421  -1.636598   2.198410   1.963421   1.194439 
             435        436        437        438        439        440        441 
       -1.485664   1.309713   1.267787   3.698941   4.466104  -2.093764   1.697505 
             442        443        444        445        446        447        448 
        1.914274   1.368805  -1.282668  -1.485664   1.267787  -2.879240  -2.879240 
             449        450        451        452        453        454        455 
       -1.215649  -1.485664   1.697505  -1.164520   1.236282   1.914274   1.963421 
             456        457        458        459        460        461        462 
        1.405965   1.914274   1.697505   3.059037   1.368805   1.914274   1.697505 
             463        464        465        466        467        468        469 
       -3.463267  -4.734304   5.773621   3.698941  -2.093764   1.368805  -2.433682 
             470        471        472        473        474        475        476 
        1.532130  -2.429521   1.507929  -1.485664  -2.037968   1.267787   1.368805 
             477        478        479        480        481        482        483 
       -1.547232  -2.093764  -2.093764   1.368805   1.194439  -2.433682   1.267787 
             484        485        486        487        488        489        490 
        1.368805   1.963421  -1.485664   1.267787  -2.968779  -1.834439   1.532130 
             491        492        493        494        495        496        497 
       -3.711461  -1.282668   4.537713  -1.485664  -2.037968   5.637158   3.516721 
             498        499        500        501        502        503        504 
        1.697505  -2.037968   1.309713  -6.142995  -1.288508  -1.636598   3.059037 
             505        506        507        508        509        510        511 
       -2.037968   2.326852   3.059037  -1.834439   3.059037   3.059037  -1.485664 
             512        513        514        515        516        517        518 
       -1.152106  -1.209485   1.507929  -3.463267  -1.397342  -1.636598   2.326852 
             519        520        521        522        523        524        525 
       -1.370516   1.914274   1.699535   1.914274   1.137522  -4.228797   1.914274 
             526        527        528        529        530        531        532 
        1.532130   1.141181  -2.433682  -1.370516  -6.142995   1.194439  -2.433682 
             533        534        535        536        537        538        539 
       -1.636598   2.326852   3.059037   1.507929   1.507929   1.368805   1.963421 
             540        541        542        543        544        545        546 
        1.914274  -1.370516  -1.636598   1.532130  -1.547232   1.963421   1.368805 
             547        548        549        550        551        552        553 
       -2.093764  -1.834439  -1.636598   4.537713  -1.834439  -1.282668   1.368805 
             554        555        556        557        558        559        560 
        2.198410   2.827379  -1.834439   1.532130  -1.370516   1.507929   1.914274 
             561        562        563        564        565        566        567 
        1.194439  -1.288508   1.963421   1.267787   2.198410   1.697505  -1.370516 
             568        569        570        571        572        573        574 
       -3.711461   1.102511   2.326852  -2.037968  -3.463267  -1.636598   2.198410 
             575        576        577        578        579        580        581 
        1.963421  -2.093764  -1.636598   1.368805   7.078287  -1.636598   2.326852 
             582        583        584        585        586        587        588 
       -1.215649   1.963421  -2.037968   1.914274  -1.370516  -1.834439  -1.125513 
             589        590        591        592        593        594        595 
       -4.734304   2.198410   1.141181  -1.209485   2.827379   1.699535  -2.037968 
             596        597        598        599        600        601        602 
        1.963421   2.198410  -1.282668   1.697505  -2.968779   3.698941  -1.288508 
             603        604        605        606        607        608        609 
        2.570850   3.698941  -1.485664   1.368805  -6.142995  -3.711461   1.309713 
             610        611        612        613        614        615        616 
        1.697505   1.507929  -2.433682  -2.429521   1.309713   2.198410  -1.125513 
             617        618        619        620        621        622        623 
       -2.037968  -1.125513  -3.711461  -1.397342  -1.834439   5.637158  -1.834439 
             624        625        626        627        628        629        630 
       -1.834439  -1.636598  -1.215649  -4.734304   2.326852   1.141181   1.368805 
             631        632        633        634        635        636        637 
       -1.282668  -2.968779   1.699535   1.267787   1.368805   1.194439   1.507929 
             638        639        640        641        642        643        644 
        1.368805   1.699535   1.141181  -1.753664  -2.429521   1.699535  -2.433682 
             645        646        647        648        649        650        651 
        4.537713  -1.547232   3.059037   2.827379  -1.753664   1.963421  -6.547525 
             652        653        654        655        656        657        658 
       -1.753664   1.368805   1.368805  -2.968779  -1.834439  -4.734304   1.368805 
             659        660        661        662        663        664        665 
       -1.215649   1.368805  -1.485664   1.267787  -1.370516  -1.485664   3.059037 
             666        667        668        669        670        671        672 
        1.039242  -2.429521   1.507929   3.516721  -1.282668  -1.636598   1.697505 
             673        674        675        676        677        678        679 
       -1.834439  -1.485664   1.368805  -2.433682  -1.215649  -1.834439  -1.485664 
             680        681        682        683        684        685        686 
        2.198410  -1.164520  -1.753664  -1.485664  -1.125513   1.507929  -8.083086 
             687        688        689        690        691        692        693 
       -1.834439   1.236282  -1.485664   2.570850   1.194439  -2.093764   1.963421 
             694        695        696        697        698        699        700 
       -2.093764  -1.288508   1.267787   1.267787   1.963421   3.698941   1.267787 
             701        702        703        704        705        706        707 
        4.466104   3.698941   1.102511  -1.370516   2.570850   3.516721  -4.734304 
             708        709        710        711        712        713        714 
       -1.753664   2.326852   3.059037   8.967286   1.141181   1.267787   1.699535 
             715        716        717        718        719        720        721 
       -2.093764  -2.093764   1.699535  -1.215649  -1.485664  -2.037968   1.914274 
             722        723        724        725        726        727        728 
        2.326852  -2.037968  -2.429521  -6.142995  -3.463267  -1.215649  -1.636598 
             729        730        731        732        733        734        735 
       -2.093764   1.507929  -1.636598  -3.711461  -2.429521   2.570850  -2.879240 
             736        737        738        739        740        741        742 
        2.570850   1.368805  -1.282668  -1.547232   1.236282  -2.093764  -2.433682 
             743        744        745        746        747        748        749 
        1.236282   1.368805  -1.485664   1.914274  -1.288508  -8.083086   1.405965 
             750        751        752        753        754        755        756 
       -1.397342   1.405965  -2.433682  -2.433682   1.507929  -2.037968   1.368805 
             757        758        759        760        761        762        763 
       -1.753664   2.570850  -2.968779   1.074433  -1.282668   2.570850   1.532130 
             764        765        766        767        768        769        770 
       -1.164520   3.698941  -1.485664  -2.037968  -2.429521  -2.037968  -1.547232 
             771        772        773        774        775        776        777 
       -1.547232   1.141181   1.368805  -2.093764  -1.485664  -1.547232   1.532130 
             778        779        780        781        782        783        784 
        1.368805  -1.636598   1.194439   1.507929   2.827379   1.267787  -1.636598 
             785        786        787        788        789        790        791 
       -1.753664   3.059037  -1.370516   1.963421   1.963421   1.697505   3.516721 
             792        793        794        795        796        797        798 
        1.194439  -2.037968   1.368805  -1.215649   1.963421   2.198410  -2.429521 
             799        800        801        802        803        804        805 
       -1.547232  -1.370516   1.699535  -2.429521   1.267787   1.236282   1.405965 
             806        807        808        809        810        811        812 
       -3.711461  -1.485664  -1.753664  -1.370516   1.236282   1.194439  -2.093764 
             813        814        815        816        817        818        819 
       -3.463267   1.267787  -1.370516  -1.753664  -1.282668  -2.093764  -1.834439 
             820        821        822        823        824        825        826 
       -1.215649  -4.734304   1.368805   1.267787   1.141181   1.141181   2.570850 
             827        828        829        830        831        832        833 
        2.326852  -1.215649  -2.037968  -1.834439  -1.282668  -1.288508  -2.093764 
             834        835        836        837        838        839        840 
        1.914274  -1.485664  -1.282668   2.198410  -1.547232  -6.142995   1.697505 
             841        842        843        844        845        846        847 
        1.507929   2.326852  -3.711461  -1.397342  -2.433682  -1.636598  -1.370516 
             848        849        850        851        852        853        854 
       -1.370516   1.368805  -1.164520  -2.037968   2.326852  -2.429521  -1.288508 
             855        856        857        858        859        860        861 
        1.699535  -1.636598  -2.093764   1.699535   1.914274  -3.711461   1.914274 
             862        863        864        865        866        867        868 
        1.368805  -2.879240   1.309713   2.198410  -2.433682   1.236282   1.914274 
             869        870        871        872        873        874        875 
        1.699535  -1.370516   1.699535   1.141181   1.507929   2.570850   1.102511 
             876        877        878        879        880        881        882 
        1.368805   1.699535   2.827379   2.198410   1.532130  -1.636598  -1.215649 
             883        884        885        886        887        888        889 
        1.963421   1.141181   1.699535   2.198410   1.507929   1.699535  -1.636598 
             890        891        892        893        894        895        896 
        1.267787   2.326852  -1.215649   2.326852   1.532130   1.697505   2.198410 
             897        898        899        900        901        902        903 
       -1.485664   1.236282  -2.879240   1.507929  -2.429521  -1.485664   1.309713 
             904        905        906        907        908        909        910 
        3.059037   1.368805  -1.370516   1.368805   1.697505   3.059037   1.267787 
             911        912        913        914        915        916        917 
        1.507929  -1.636598  -2.433682   1.699535  -1.636598   1.267787   2.570850 
             918        919        920        921        922        923        924 
        2.198410   1.697505   1.141181  -2.433682   2.827379  -1.753664  -2.037968 
             925        926        927        928        929        930        931 
        1.507929  -1.215649   1.699535   1.697505   1.963421  -2.433682   1.368805 
             932        933        934        935        936        937        938 
        1.309713   1.699535  -1.753664  -2.429521  -1.636598  -2.433682  -3.463267 
             939        940        941        942        943        944        945 
       -1.215649  -3.711461  -2.093764  -1.753664  -1.636598   1.141181  -1.485664 
             946        947        948        949        950        951        952 
       -2.433682  -1.215649  -1.288508   1.699535   1.963421   1.697505   1.914274 
             953        954        955        956        957        958        959 
       -1.636598   1.141181   1.507929   5.637158  -2.037968  -2.093764   4.537713 
             960        961        962        963        964        965        966 
        1.194439   1.309713  -1.370516   5.637158  -2.968779  -1.282668  -1.282668 
             967        968        969        970        971        972        973 
       -1.834439   1.532130   2.198410   3.698941   2.570850  -1.164520  -2.429521 
             974        975        976        977        978        979        980 
       -3.463267  -1.636598   1.507929  -3.463267   1.405965   1.507929  -3.711461 
             981        982        983        984        985        986        987 
        1.532130   1.102511  -2.429521  -4.734304   4.537713  -2.968779  -2.429521 
             988        989        990        991        992        993        994 
       -1.370516   1.914274   1.697505  -1.073052   1.697505   1.914274  -1.636598 
             995        996        997        998        999       1000       1001 
        1.368805  -1.547232 -10.755038  -1.636598   1.141181   1.507929   1.699535 
            1002       1003       1004       1005       1006       1007       1008 
        2.827379  -1.282668   2.326852   1.368805  -1.397342   1.054045  -2.968779 
            1009       1010       1011       1012       1013       1014       1015 
        1.697505   1.963421  -1.282668  -2.968779  -1.110443   2.198410   1.699535 
            1016       1017       1018       1019       1020       1021       1022 
        3.698941   7.078287   1.368805  -1.547232   1.699535   1.368805  -1.753664 
            1023       1024       1025       1026       1027       1028       1029 
        1.102511   2.326852   1.532130   2.198410   1.507929   4.537713  -1.485664 
            1030       1031       1032       1033       1034       1035       1036 
        1.507929  -1.753664   1.697505   1.914274  -1.215649   1.405965  -2.429521 
            1037       1038       1039       1040       1041       1042       1043 
       -1.125513  -1.753664  -3.711461  -1.152106   1.507929   2.570850  -1.753664 
            1044       1045       1046       1047       1048       1049       1050 
       -2.879240   1.532130  -2.968779  -1.485664   2.827379  -1.636598   1.267787 
            1051       1052       1053       1054       1055       1056       1057 
       -1.370516   3.059037  -2.968779  -1.753664   1.914274  -1.834439   4.466104 
            1058       1059       1060       1061       1062       1063       1064 
        2.198410  -1.636598   2.570850  -1.397342   2.827379   1.697505   1.963421 
            1065       1066       1067       1068       1069       1070       1071 
        1.368805   1.368805   1.267787   1.194439  -1.547232  -2.968779  -1.834439 
            1072       1073       1074       1075       1076       1077       1078 
       -1.753664  -1.834439  -1.125513   1.267787   1.267787  -1.095755   4.537713 
            1079       1080       1081       1082       1083       1084       1085 
       -2.037968  -1.370516   2.326852   4.537713   1.074433  -1.164520   1.963421 
            1086       1087       1088       1089       1090       1091       1092 
        3.698941  -1.288508   1.963421  -1.209485   2.326852   1.697505   1.267787 
            1093       1094       1095       1096       1097       1098       1099 
       -8.083086   1.267787  -2.968779  -2.093764  -2.433682   5.637158   3.059037 
            1100       1101       1102       1103       1104       1105       1106 
        3.059037   1.074433  -1.288508   1.368805   3.698941  -3.463267  -2.433682 
            1107       1108       1109       1110       1111       1112       1113 
       -1.485664   2.326852   1.914274   2.326852   1.697505  -1.834439  -1.636598 
            1114       1115       1116       1117       1118       1119       1120 
       -1.288508  -3.711461   1.532130   1.963421   1.507929   1.914274   1.267787 
            1121       1122       1123       1124       1125       1126       1127 
        1.141181   1.368805   1.963421   1.507929   1.699535   1.699535  -1.547232 
            1128       1129       1130       1131       1132       1133       1134 
        2.570850   2.326852   1.507929  -1.164520  -1.636598   1.236282  -1.753664 
            1135       1136       1137       1138       1139       1140       1141 
        1.141181   2.326852  -1.397342  -2.037968   4.466104   1.699535  -1.636598 
            1142       1143       1144       1145       1146       1147       1148 
       -1.164520  -1.636598   2.570850   1.697505  -2.433682   1.267787  -2.093764 
            1149       1150       1151       1152       1153       1154       1155 
       -1.636598  -1.834439   1.507929  -1.288508  -1.288508  -1.282668  -4.734304 
            1156       1157       1158       1159       1160       1161       1162 
        1.102511   1.141181  -1.834439   1.102511  -3.711461  -1.209485  -1.282668 
            1163       1164       1165       1166       1167       1168       1169 
        1.963421   1.405965   1.368805  -1.209485  -2.037968   4.537713   1.963421 
            1170       1171       1172       1173       1174       1175       1176 
       -3.711461   2.326852  -1.753664   3.516721   1.137522   1.074433  -3.463267 
            1177       1178       1179       1180       1181       1182       1183 
       -4.734304   1.914274  -1.125513   1.699535   1.267787  -2.037968   1.963421 
            1184       1185       1186       1187       1188       1189       1190 
       -2.968779  -1.834439  -2.429521  -1.485664   1.697505  -2.093764   2.326852 
            1191       1192       1193       1194       1195       1196       1197 
        1.507929   1.180261  -4.228797   1.914274   1.267787   3.059037  -4.734304 
            1198       1199       1200       1201       1202       1203       1204 
        2.198410   4.466104   1.309713   1.532130   1.697505  -1.547232   1.507929 
            1205       1206       1207       1208       1209       1210       1211 
       -1.753664   1.141181   1.102511  -1.370516   1.102511   3.059037   3.059037 
            1212       1213       1214       1215       1216       1217       1218 
       -2.968779  -1.636598   1.074433   2.570850   2.198410  -2.879240  -2.879240 
            1219       1220       1221       1222       1223       1224       1225 
       -5.232237  -1.164520  -2.093764   1.267787   2.198410  -2.429521  -1.485664 
            1226       1227       1228       1229       1230       1231       1232 
        1.267787   2.570850  -3.463267   1.368805   2.198410   1.914274  -4.734304 
            1233       1234       1235       1236       1237       1238       1239 
       -2.093764  -3.711461   1.102511  -1.547232   1.267787  -1.753664  -3.711461 
            1240       1241       1242       1243       1244       1245       1246 
       -1.485664   1.699535   1.507929   1.699535   1.368805  -3.463267  -2.037968 
            1247       1248       1249       1250       1251       1252       1253 
        1.405965  -2.429521   1.074433  -1.485664   3.059037  -1.485664   2.198410 
            1254       1255       1256       1257       1258       1259       1260 
       -2.093764   2.570850  -1.282668  -2.093764  -3.711461   1.963421  -2.429521 
            1261       1262       1263       1264       1265       1266       1267 
        1.914274  -1.215649  -1.485664   1.507929  -2.429521  -1.164520  -2.037968 
            1268       1269       1270       1271       1272       1273       1274 
        1.507929   1.963421  -1.397342   3.516721  -2.093764   1.405965  -1.547232 
            1275       1276       1277       1278       1279       1280       1281 
        1.309713   1.368805   3.059037   1.194439  -1.834439  -2.879240  -1.485664 
            1282       1283       1284       1285       1286       1287       1288 
        1.102511  -1.164520   1.697505   1.697505  -1.288508   1.963421   1.074433 
            1289       1290       1291       1292       1293       1294       1295 
       -1.164520  -2.093764  -6.142995  -1.164520   1.697505   1.532130  -2.968779 
            1296       1297       1298       1299       1300       1301       1302 
       -1.834439   1.532130   1.194439   2.570850  -2.433682   1.267787  -1.164520 
            1303       1304       1305       1306       1307       1308       1309 
        1.267787  -1.485664   1.309713  -2.968779  -1.370516  -2.429521  -2.037968 
            1310       1311       1312       1313       1314       1315       1316 
        1.194439   1.194439   2.326852  -1.636598   4.537713  -2.093764  -3.711461 
            1317       1318       1319       1320       1321       1322       1323 
        1.267787   1.141181   1.405965   1.507929   1.697505   2.570850  -2.037968 
            1324       1325       1326       1327       1328       1329       1330 
        1.267787  -2.879240  -1.370516   3.059037   1.914274   1.194439   3.516721 
            1331       1332       1333       1334       1335       1336       1337 
        1.532130  -2.037968  -3.711461   2.570850  -2.037968   1.267787   3.698941 
            1338       1339       1340       1341       1342       1343       1344 
        1.699535   1.267787   3.698941   3.059037   1.102511   1.699535  -1.397342 
            1345       1346       1347       1348       1349       1350       1351 
        1.699535  -1.834439  -2.037968   4.537713  -1.485664   1.914274   2.570850 
            1352       1353       1354       1355       1356       1357       1358 
       -2.037968   1.141181   1.309713  -1.547232   1.697505  -2.093764   1.699535 
            1359       1360       1361       1362       1363       1364       1365 
        1.309713   1.194439  -1.370516   1.507929   1.699535   4.537713   1.914274 
            1366       1367       1368       1369       1370       1371       1372 
        1.507929   1.102511   2.570850   1.507929   1.102511   1.532130   1.507929 
            1373       1374       1375       1376       1377       1378       1379 
        1.137522  -1.485664   2.198410   1.914274   1.267787  -1.834439  -2.429521 
            1380       1381       1382       1383       1384       1385       1386 
       -1.753664  -1.282668  -2.037968  -2.429521  -1.215649   1.267787  -1.485664 
            1387       1388       1389       1390       1391       1392       1393 
       -1.636598  -1.215649  -1.125513   1.267787   1.914274  -2.093764   1.368805 
            1394       1395       1396       1397       1398       1399       1400 
        1.309713   1.309713   1.368805  -1.753664   1.697505  -1.834439  -1.209485 
            1401       1402       1403       1404       1405       1406       1407 
        1.267787   1.039242  -1.753664   1.267787  -1.636598   2.570850  -2.968779 
            1408       1409       1410       1411       1412       1413       1414 
       -2.093764   1.180261   1.267787  -1.288508   1.963421  -1.370516  -1.547232 
            1415       1416       1417       1418       1419       1420       1421 
       -1.753664 -10.755038   1.532130  -3.711461  -1.209485  -2.433682  -1.485664 
            1422       1423       1424       1425       1426       1427       1428 
        1.914274   2.198410   1.194439   1.507929   1.368805   1.507929  -1.397342 
            1429       1430       1431       1432       1433       1434       1435 
       -1.753664  -1.215649  -3.463267  -1.485664   1.699535   1.963421  -1.753664 
            1436       1437       1438       1439       1440       1441       1442 
        5.637158  -3.711461   1.054045   1.368805   1.963421   5.637158  -3.711461 
            1443       1444       1445       1446       1447       1448       1449 
       -2.433682   1.699535   1.194439  -1.370516   1.309713   2.827379   1.507929 
            1450       1451       1452       1453       1454       1455       1456 
        1.405965  -8.083086  -1.834439  -1.636598   2.326852   1.697505   1.532130 
            1457       1458       1459       1460       1461       1462       1463 
       -3.711461  -1.485664   1.914274  -1.288508   1.963421  -2.433682   3.059037 
            1464       1465       1466       1467       1468       1469       1470 
        3.698941   1.267787   1.914274   1.914274  -2.093764  -2.968779   5.637158 
            1471       1472       1473       1474       1475       1476       1477 
       -2.037968   1.236282  -1.209485   1.267787  -1.636598  -1.397342  -3.711461 
            1478       1479       1480       1481       1482       1483       1484 
       -1.125513   1.194439   1.368805   2.570850  -6.142995   2.570850   1.054045 
            1485       1486       1487       1488       1489       1490       1491 
        2.198410  -2.093764  -1.397342   1.405965   2.198410  -2.968779   1.507929 
            1492       1493       1494       1495       1496       1497       1498 
       -1.485664  -2.093764   1.368805  -2.429521  -1.636598  -1.834439   1.267787 
            1499       1500       1501       1502       1503       1504       1505 
        1.507929  -2.429521   1.368805  -2.093764   1.102511   5.637158   1.267787 
            1506       1507       1508       1509       1510       1511       1512 
       -2.968779  -1.282668  -2.093764  -1.215649  -2.093764  -1.370516  -1.834439 
            1513       1514       1515       1516       1517       1518       1519 
        2.570850  -1.370516   1.699535   2.326852  -2.429521   1.963421  -1.164520 
            1520       1521       1522       1523       1524       1525       1526 
        1.368805  -1.834439   1.532130   1.963421   1.267787  -2.093764   1.507929 
            1527       1528       1529       1530       1531       1532       1533 
       -1.288508   1.507929  -2.429521   1.507929   2.326852   1.309713   1.368805 
            1534       1535       1536       1537       1538       1539       1540 
       -1.834439  -1.485664   1.074433  -1.370516   1.963421   1.507929   1.699535 
            1541       1542       1543       1544       1545       1546       1547 
        1.194439  -2.968779  -1.288508  -1.636598   1.194439   1.194439  -1.485664 
            1548       1549       1550       1551       1552       1553       1554 
        1.507929  -2.968779  -1.164520   3.698941  -1.282668  -1.397342   2.570850 
            1555       1556       1557       1558       1559       1560       1561 
       -1.834439  -1.485664   1.697505   4.537713   1.532130   2.827379  -1.152106 
            1562       1563       1564       1565       1566       1567       1568 
        1.697505 -14.434929   1.697505   1.532130   1.507929   1.963421 -14.434929 
            1569       1570       1571       1572       1573       1574       1575 
        7.078287  -1.834439   1.267787   1.532130   1.368805  -1.834439  -1.636598 
            1576       1577       1578       1579       1580       1581       1582 
        1.697505  -1.485664  -2.433682   1.697505  -6.142995  -1.288508  -1.636598 
            1583       1584       1585       1586       1587       1588       1589 
        1.236282   7.078287   1.141181   1.405965  -2.433682  -1.397342  -1.215649 
            1590       1591       1592       1593       1594       1595       1596 
        1.368805   1.368805  -1.547232   1.697505  -1.370516  -2.433682  -2.093764 
            1597       1598       1599       1600       1601       1602       1603 
       -4.734304  -1.370516   1.267787  -2.093764   1.697505   1.039242  -1.110443 
            1604       1605       1606       1607       1608       1609       1610 
       -1.636598   1.507929   1.368805   2.570850  -1.636598  -1.397342   1.914274 
            1611       1612       1613       1614       1615       1616       1617 
        1.699535  -1.636598   1.368805   4.466104   1.141181  -2.429521   1.914274 
            1618       1619       1620       1621       1622       1623       1624 
       -1.370516  -1.834439  -1.215649  -2.433682   1.267787   1.699535   1.914274 
            1625       1626       1627       1628       1629       1630       1631 
       -1.547232   5.773621   1.507929   1.368805   1.141181  -3.711461   1.699535 
            1632       1633       1634       1635       1636       1637       1638 
       -1.753664   1.914274  -2.968779  -1.370516  -3.711461   1.368805  -3.711461 
            1639       1640       1641       1642       1643       1644       1645 
       -1.485664   1.914274   1.141181  -2.968779   2.326852   1.507929  -2.093764 
            1646       1647       1648       1649       1650       1651       1652 
        1.267787   3.516721  -3.711461  -2.037968   1.963421   3.059037   1.267787 
            1653       1654       1655       1656       1657       1658       1659 
       -1.485664  -2.093764   2.198410   1.699535  -1.370516   2.198410  -1.215649 
            1660       1661       1662       1663       1664       1665       1666 
       -4.734304  -2.879240   1.267787   1.074433  -2.093764   3.516721   1.914274 
            1667       1668       1669       1670       1671       1672       1673 
        1.697505   1.194439  -1.095755   1.507929  -1.485664   3.059037  -2.037968 
            1674       1675       1676       1677       1678       1679       1680 
        5.773621  -1.753664  -2.037968  -3.711461  -2.093764   1.914274   1.368805 
            1681       1682       1683       1684       1685       1686       1687 
       -1.753664  -1.397342  -2.429521   1.368805   1.963421  -1.753664   3.698941 
            1688       1689       1690       1691       1692       1693       1694 
       -1.370516   4.537713   1.405965  -1.636598   1.699535   1.963421  -1.288508 
            1695       1696       1697       1698       1699       1700       1701 
        1.532130  -1.485664   2.570850   1.532130  -1.834439   2.198410  -1.125513 
            1702       1703       1704       1705       1706       1707       1708 
       -1.095755   1.699535  -2.037968  -1.636598  -1.370516   1.405965   1.507929 
            1709       1710       1711       1712       1713       1714       1715 
      -10.755038  -2.429521  -1.215649   2.827379  -1.370516  -2.429521  -1.485664 
            1716       1717       1718       1719       1720       1721       1722 
       -1.834439   1.074433  -2.037968  -1.282668  -1.370516   1.507929  -1.282668 
            1723       1724       1725       1726       1727       1728       1729 
       -3.711461  -1.636598   1.914274   1.532130   1.697505  -1.282668   1.697505 
            1730       1731       1732       1733       1734       1735       1736 
       -1.215649  -1.636598   2.198410   1.194439   1.699535   1.507929  -2.093764 
            1737       1738       1739       1740       1741       1742       1743 
       -1.164520  -2.879240  -1.370516   1.914274  -2.433682  -1.397342  -1.834439 
            1744       1745       1746       1747       1748       1749       1750 
        1.039242   1.914274  -1.636598  -1.370516  -1.485664   1.194439  -1.164520 
            1751       1752       1753       1754       1755       1756       1757 
       -1.753664   1.368805  -1.370516   1.054045   3.059037   1.532130  -2.037968 
            1758       1759       1760       1761       1762       1763       1764 
       -1.370516  -1.485664   1.405965   1.194439  -1.288508  -1.485664   1.963421 
            1765       1766       1767       1768       1769       1770       1771 
        1.697505   1.180261   1.054045   1.507929  -2.093764   1.194439  -1.547232 
            1772       1773       1774       1775       1776       1777       1778 
       -1.397342   1.267787   1.697505  -1.152106   1.141181  -2.968779   2.198410 
            1779       1780       1781       1782       1783       1784       1785 
       -1.282668   2.570850   1.309713  -1.397342   3.698941   1.914274  -1.209485 
            1786       1787       1788       1789       1790       1791       1792 
       -1.164520  -1.636598   1.532130   1.267787   1.267787  -1.753664   1.697505 
            1793       1794       1795       1796       1797       1798       1799 
       -4.734304   1.697505   1.074433   1.532130   2.570850   1.267787   1.697505 
            1800       1801       1802       1803       1804       1805       1806 
        1.699535  -1.485664  -2.433682   1.309713  -1.485664  -2.429521  -2.429521 
            1807       1808       1809       1810       1811       1812       1813 
        2.827379   1.963421  -1.834439  -2.429521  -1.753664   1.141181  -1.485664 
            1814       1815       1816       1817       1818       1819       1820 
        1.914274  -1.209485  -1.636598   1.194439  -1.282668   1.507929   4.537713 
            1821       1822       1823       1824       1825       1826       1827 
        2.570850   1.102511   2.198410   3.059037  -1.282668  -1.370516   1.368805 
            1828       1829       1830       1831       1832       1833       1834 
       -4.228797   7.078287  -1.164520  -2.429521   1.914274   1.507929  -1.636598 
            1835       1836       1837       1838       1839       1840       1841 
       -1.282668  -1.397342   1.914274  -1.547232  -1.834439  -2.093764  -2.037968 
            1842       1843       1844       1845       1846       1847       1848 
        1.368805   1.309713  -1.636598   1.963421   1.309713   1.507929  -1.164520 
            1849       1850       1851       1852       1853       1854       1855 
       -2.968779  -1.215649  -2.037968  -1.370516  -1.370516   1.507929  -2.433682 
            1856       1857       1858       1859       1860       1861       1862 
        1.194439  -1.282668  -1.485664  -2.429521   2.198410  -1.834439  -1.547232 
            1863       1864       1865       1866       1867       1868       1869 
       -1.209485  -1.282668   3.059037   1.267787   1.267787   2.198410  -1.370516 
            1870       1871       1872       1873       1874       1875       1876 
       -2.433682  -2.879240  -2.429521   1.194439  -2.968779   1.532130   2.570850 
            1877       1878       1879       1880       1881       1882       1883 
        2.827379   1.532130   1.507929   1.267787   1.141181  -2.429521  -1.636598 
            1884       1885       1886       1887       1888       1889       1890 
       -1.397342   1.405965  -2.879240   1.368805   2.198410  -2.879240   2.326852 
            1891       1892       1893       1894       1895       1896       1897 
       -1.164520   1.963421  -1.215649   1.914274   2.326852  -2.037968   1.699535 
            1898       1899       1900       1901       1902       1903       1904 
       -2.429521   1.194439  -2.429521  -1.834439  -2.433682   1.507929  -1.485664 
            1905       1906       1907       1908       1909       1910       1911 
        1.368805  -3.463267  -1.397342   1.368805   1.368805  -1.485664   1.368805 
            1912       1913       1914       1915       1916       1917       1918 
        1.507929  -1.485664   1.194439   2.570850  -2.037968   1.405965   1.267787 
            1919       1920       1921       1922       1923       1924       1925 
       -1.485664   1.368805  -1.636598   2.570850  -1.215649  -1.164520   1.102511 
            1926       1927       1928       1929       1930       1931       1932 
       -1.370516   1.699535   2.827379   1.532130   2.326852  -1.288508   1.914274 
            1933       1934       1935       1936       1937       1938       1939 
        1.507929  -1.370516  -2.037968  -2.093764   1.194439   3.698941  -1.288508 
            1940       1941       1942       1943       1944       1945       1946 
        1.699535   2.198410   1.914274   1.507929  -1.282668  -1.834439   1.141181 
            1947       1948       1949       1950       1951       1952       1953 
       -2.433682   1.368805   1.368805  -1.485664   1.532130   1.137522   3.516721 
            1954       1955       1956       1957       1958       1959       1960 
        1.405965  -2.037968  -1.753664   1.507929   3.059037   1.368805   1.368805 
            1961       1962       1963       1964       1965       1966       1967 
       -1.547232   1.194439  -2.093764   1.697505  -2.429521   2.827379   1.532130 
            1968       1969       1970       1971       1972       1973       1974 
        1.405965  -1.834439   1.194439   1.697505  -2.429521   1.699535  -1.215649 
            1975       1976       1977       1978       1979       1980       1981 
       -2.429521   1.368805  -2.037968  -1.753664  -1.485664  -1.125513  -1.547232 
            1982       1983       1984       1985       1986       1987       1988 
        1.507929  -2.093764   2.827379  -1.370516   2.827379   2.198410   1.368805 
            1989       1990       1991       1992       1993       1994       1995 
        3.516721   1.236282   3.059037   1.507929  -1.397342   1.368805   1.236282 
            1996       1997       1998       1999       2000 
       -2.093764  -1.834439   1.368805   1.368805   1.405965 
      attr(,"label")
      [1] "Residuals"

