% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\docType{class}
\name{Style-class}
\alias{Style-class}
\alias{Style}
\alias{StyleRaw-class}
\alias{StyleRaw}
\alias{StyleAnsi-class}
\alias{StyleAnsi}
\alias{StyleAnsi8NeutralRgb-class}
\alias{StyleAnsi8NeutralRgb}
\alias{StyleAnsi8NeutralYb-class}
\alias{StyleAnsi8NeutralYb}
\alias{StyleAnsi256LightRgb-class}
\alias{StyleAnsi256LightRgb}
\alias{StyleAnsi256LightYb-class}
\alias{StyleAnsi256LightYb}
\alias{StyleAnsi256DarkRgb-class}
\alias{StyleAnsi256DarkRgb}
\alias{StyleAnsi256DarkYb-class}
\alias{StyleAnsi256DarkYb}
\alias{StyleHtml-class}
\alias{StyleHtml}
\alias{StyleHtmlLightRgb-class}
\alias{StyleHtmlLightRgb}
\alias{StyleHtmlLightYb-class}
\alias{StyleHtmlLightYb}
\title{Customize Appearance of Diff}
\arguments{
\item{funs}{a \code{\link{StyleFuns}} object that contains all the functions
represented above}

\item{text}{a \code{\link{StyleText}} object that contains the non-content
text used by the diff (e.g. \code{gutter.insert.txt})}

\item{summary}{a \code{\link{StyleSummary}} object that contains formatting
functions and other meta data for rendering summaries}

\item{wrap}{TRUE or FALSE, whether the text should be hard wrapped to fit in
the console}

\item{pad}{TRUE or FALSE, whether text should be right padded}

\item{pager}{what type of \code{\link{Pager}} to use}

\item{nchar.fun}{function to use to count characters; intended mostly for
internal use}

\item{wrap}{TRUE or FALSE, whether text should be hard wrapped at
\code{disp.width}}

\item{na.sub}{what character value to substitute for NA elements; NA elements
are generated when lining up side by side diffs by adding padding rows; by
default the text styles replace these with a blank character string, and
the HTML styles leave them as NA for the HTML formatting functions to deal
with}

\item{blank}{sub what character value to replace blanks with; needed in
particular for HTML rendering (uses \code{"&nbsp;"}) to prevent lines from
collapsing}

\item{disp.width}{how many columns the text representation of the objects to
diff is allowed to take up before it is hard wrapped (assuming \code{wrap}
is TRUE).  See param \code{disp.width} for \code{\link{diffPrint}}.}

\item{finalizer}{function that accepts at least two parameters and requires
no more than two parameters, will receive as the first parameter the
the object to render (either a \code{Diff} or a \code{DiffSummary}
object), and the text representation of that object as the second
argument.  This allows final modifications to the character output so that
it is displayed correctly by the pager.  For example, \code{StyleHtml}
objects use it to generate HTML headers if the \code{Diff} is destined to
be displayed in a browser.  The object themselves are passed along to
provide information about the paging device and other contextual data to
the function.}

\item{html.output}{(\code{StyleHtml} objects only) one of:
\itemize{
  \item \dQuote{page}: Include all HTML/CSS/JS required to create a
    stand-alone web page with the diff.
  \item \dQuote{diff.w.style}: The CSS and HTML, but without any of the
    outer tags that would make it a proper HTML page (i.e. no
    \code{<html>/<head>} tags or the like) and without the JS; note that
    technically this is illegal HTML since we have \code{<style>} tags
    floating outside of \code{<head>} tags, but it seems to work in most
    browsers.
  \item \dQuote{diff.only}: Like \dQuote{diff.w.style}, but without the CSS
  \item \dQuote{auto}: Pick one of the above based on \code{Pager}, will
     chose \dQuote{page} if the pager is of type \code{PagerBrowser} (as in
     that case the output is destined to be displayed in a browser like
     device), or \dQuote{diff.only} if it is not.
}}

\item{escape.html.entities}{(\code{StyleHtml} objects only) TRUE (default)
or FALSE, whether to escape HTML entities in the input}

\item{scale}{(\code{StyleHtml} objects only) TRUE (default) or FALSE,
whether to scale HTML output to fit to the viewport}

\item{css}{(\code{StyleHtml} objects only) path to file containing CSS styles
to style HTML output with}

\item{js}{(\code{StyleHtml} objects only) path to file containing Javascript
used for scaling output to viewports.}
}
\value{
Style S4 object
}
\description{
S4 objects that expose the formatting controls for \code{Diff}
objects.  Many predefined formats are defined as classes that extend the
base \code{Style} class.  You may fine tune styles by either extending
the pre-defined classes, or modifying an instance thereof.
}
\section{Pre-defined Classes}{


Pre-defined classes are used to populate the \code{\link{PaletteOfStyles}}
object, which in turn allows the \code{diff*} methods to pick the
appropriate \code{Style} for each combination of the \code{format},
\code{color.mode}, and \code{brightness} parameters when the \code{style}
parameter is set to \dQuote{auto}.  The following classes are pre-defined:

\itemize{
  \item \code{StyleRaw}: No styles applied
  \item \code{StyleAnsi8NeutralRgb}
  \item \code{StyleAnsi8NeutralYb}
  \item \code{StyleAnsi256LightRgb}
  \item \code{StyleAnsi256LightYb}
  \item \code{StyleAnsi256DarkRgb}
  \item \code{StyleAnsi256DarkYb}
  \item \code{StyleHtmlLightRgb}
  \item \code{StyleHtmlLightYb}
}
Each of these classes has an associated constructor function with the
same name (see examples).  Objects instantiated from these classes
may also be used directly as the value for the \code{style} parameter to the
\code{diff*} methods. This will override the automatic selection process
that uses \code{\link{PaletteOfStyles}}.  If you wish to tweak an
auto-selected style rather than explicitly specify one, pass a parameter
list instead of a \code{Style} objects as the \code{style} parameter to the
\code{diff*} methods (see examples).

There are predefined classes for most combinations of
\code{format/color.mode/brightness}, but not all.  For example, there are
only \dQuote{light} \code{brightness} defined for the \dQuote{html}
\code{format}, and those classes are re-used for all possible
\code{brightness} values, and the 8 color ANSI neutral classes are used
for the 256 color neutral selections as well.

To get a preview of what a style looks like just instantiate
an object; the \code{show} method will output a trivial diff to screen with
styles applied.  Note that for ANSI styles of the dark and light variety
the show method colors the terminal background and foregrounds in compatible
colors.  In normal usage the terminal background and foreground colors are
left untouched so you should not expect light styles to look good on dark
background and vice versa even if they render correctly when showing the
style object.
}

\section{Style Structure}{


Most of the customization is done by specifying functions that operate on
character vectors and return a modified character vector of the same length.
The intended use case is to pass \code{crayon} functions such as
\code{crayon::red}, although you may pass any function of your liking
that behaves as described.  Formatting functions are expected to return their
inputs formatted in such a way that their \emph{display} width is unchanged.
If your formatting functions change display width output may not render
properly, particularly when using \code{mode="sidebyside"}.

The visual representation of the diff has many nested components.  The
functions you specify here will be applied starting with the innermost ones.
A schematic of the various component that represent an inserted line follows
(note \dQuote{insert} abbreviated to \dQuote{ins}, and \dQuote{gutter}
abbreviated to \dQuote{gtr}):
\preformatted{+- line ---------------------------------------------------+
|+- line.ins ---------------------------------------------+|
||+- gtr ------------------------++- text ---------------+||
|||+- gtr.ins ---++- gtr.pad ---+||+- text.ins ---------+|||
||||             ||             ||||      +- word.ins -+||||
|||| gtr.ins.txt || gtr.pad.txt |||| DIFF | TEXT HERE  |||||
||||             ||             ||||      +------------+||||
|||+-------------++-------------+||+--------------------+|||
||+------------------------------++----------------------+||
|+--------------------------------------------------------+|
+----------------------------------------------------------+
}
A similar model applies to deleted and matching lines.  The boxes represent
functions.  \code{gutter.insert.txt} represents the text to use in the gutter
and is not a function. \code{DIFF TEXT HERE} is text from the objects being
diffed, with the portion that has different words inside the
\code{word.insert}.  \code{gutter.pad} and \code{gutter.pad.txt} are used to
separate the gutter from the text and usually end up resolving to a space.

Most of the functions defined here default to \code{\link{identity}}, but
you are given the flexibility to fully format the diff.  See
\code{\link{StyleFuns}} and \code{\link{StyleText}} for a full listing of
the adjustable elements.

In side-by-side mode there are two \dQuote{lines} per screen line, each with
the structure described here.

The structure described here may change in the future.
}

\section{HTML Styles}{


If you use a \code{Style} that inherits from \code{StyleHtml} the
diff will be wrapped in HTML tags, styled with CSS, and output to
\code{getOption("viewer")} if your IDE supports it (e.g. Rstudio), or
directly to the browser otherwise, assuming that the default
\code{\link{Pager}} or a correctly configured pager that inherits from
\code{\link{PagerBrowser}} is in effect.  Otherwise, the raw HTML will be
output to your terminal.

By default HTML output sent to the viewer/browser is a full stand-alone
webpage with CSS styles to format and color the diff, and JS code to
handle scaling.  The CSS and JS is read from the
\link[=webfiles]{default files} and injected into the HTML to simplify
packaging of the output.  You can customize the CSS and JS by using the
\code{css} and \code{js} arguments respectively, but read the rest of this
documentation section if you plan on doing so.

Should you want to capture the HTML output for use elsewhere, you can do
so by using \code{as.character} on the return value of the \code{diff*}
methods.  If you want the raw HTML without any of the headers, CSS, and
JS use \code{html.ouput="diff.only"} when you instantiate the
\code{StyleHtml} object (see examples), or disable the \code{\link{Pager}}.
Another option is \code{html.output="diff.w.style"} which will add
\code{<style>} tags with the CSS, but without wrapping those in \code{<head>}
tags. This last option results in illegal HTML with a \code{<style>} block
outside of the \code{<head>} block, but appears to work and is useful if you
want to embed HTML someplace but do not have access to the headers.

If you wish to modify the CSS styles you should do so cautiously.  The
HTML and CSS work well together out of the box, but may not take to kindly
to modifications.  The safest changes you can make are to the colors of the
scheme.  You also probably should not modify the functions in the
\code{@funs} slot of the \code{StyleHtml} object.  If you want to provide
your own custom styles make a copy of the file at the location returned by
\code{diffobj_css()}, modify it to your liking, and pass the location of your
modified sheet back via the \code{css} argument (see examples).

The javascript controls the scaling of the output such that its width fits
in the viewport.  If you wish to turn of this behavior you can do so via the
\code{scale} argument.  You may need to modify the javascript if you modify
the \code{@funs} functions, but otherwise you are probably best off leaving
the javascript untouched.  You can provide the location of a modified
javascript file via the \code{js} argument.

Both the CSS and JS files can be specified via options,
\dQuote{diffobj.html.css}, and \dQuote{diffobj.html.js} respectively.

If you define your own custom \code{StyleHtml} object you may want to modify
the slot \code{@funs@container}.  This slot contains a function that is
applied to the entire diff output.  For example, \code{StyleHtmlLightRgb}
uses \code{@funs@container <- cont_f("light", "rgb")}.  \code{cont_f} returns
a function that accepts a character vector as an argument and returns
that value wrapped in a \code{DIV} block with class
\dQuote{"diffobj_container light rgb"}.  This allows the CSS style sheet to
target the \code{Diff} elements with the correct styles.
}

\section{Modifying Style Parameters Directly}{


Often you will want to specify some of the style parameters (e.g.
\code{scale} for html styles) while still relying on the default style
selection to pick the specific style.  You can do so by passing a list to the
\code{style} parameter of the \code{\link[=diffPrint]{diff*}} methods.
See examples.
}

\section{New Classes}{


You can in theory create entirely new classes that extent \code{Style}.  For
example you could generate a class that renders the diff in \code{grid}
graphics.  Note however that we have not tested such extensions and it is
possible there is some embedded code that will misbehave with such a new
class.
}

\examples{
\dontrun{
## Create a new style based on existing style by changing
## gutter symbols and guide color; see `?StyleFuns` and
## `?StyleText` for a full list of adjustable elements
my.style <- StyleAnsi8NeutralYb()
my.style   ## `show` method gives you a preview of the style
my.style@text@gutter.insert <- "+++"
my.style@text@gutter.delete <- "---"
my.style@funs@text.guide <- crayon::green
my.style   ## Notice gutters and guide color

## Provide a custom style sheet; here we assume there is a style sheet at
## `HOME/web/mycss.css`
my.css <- file.path(path.expand("~"), "web", "mycss.css")
diffPrint(1:5, 2:6, style=StyleHtmlLightYb(css=my.css))

## Turn of scaling; notice how we pass a list to `style`
## and we do not need to specify a specific style
diffPrint(letters, letters[-5], format="html", style=list(scale=FALSE))

## Alternatively we can do the same by specifying a style, but we must
## give an exact html style instead of relying on preferences to pick
## one for us
my.style <- StyleHtmlLightYb(scale=FALSE)
diffPrint(letters, letters[-5], style=my.style)
}
## Return only the raw HTML without any of the headers
as.character(
  diffPrint(1:5, 2:6, format="html", style=list(html.output="diff.only"))
)
}
