% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visual-diff.R
\name{visual_diff}
\alias{visual_diff}
\title{HTML widget to visually compare two files}
\usage{
visual_diff(file_old, file_new, width = NULL, height = NULL)
}
\arguments{
\item{file_old, file_new}{Paths to files to compare}

\item{width, height}{Output size}
}
\value{
A HTML widget
}
\description{
Currently supports:
\itemize{
\item image diffs for \code{.svg} and \code{.png}
\item tabular diffs for \code{.csv}
\item text diffs for everything else
}
}
\examples{
path1 <- tempfile()
path2 <- tempfile()
writeLines(letters, path1)
writeLines(letters[-13], path2)

if (interactive()) {
  visual_diff(path1, path2)
}
}
\seealso{
\code{\link[=visual_diff_output]{visual_diff_output()}} for use within Shiny apps
}
