% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{DigitalDLSorterDNN-class}
\alias{DigitalDLSorterDNN-class}
\alias{DigitalDLSorterDNN}
\title{The DigitalDLSorterDNN Class}
\description{
The DigitalDLSorterDNN object stores all the information related to Deep
Neural Network models. It contains the trained model, the training history
and the results of prediction on test data. After running
\code{\link{calculateEvalMetrics}}, it is possible to find the performance
evaluation of the model on test data (see \code{?\link{calculateEvalMetrics}}
for details).
}
\details{
The steps related to Deep Learning are carried out using the \pkg{keras}
package which uses the R6 classes system. If you want to save the object as
an RDS file, \code{digitalDLSorteR} provides a \code{saveRDS} generic
function that transforms the model stored as an R6 object into a native valid
R object. Specifically, the model is converted into a list with the
architecture of the network and the weights learned during training. That is
the minimum information needed to use the model as predictor. If you want to
keep the optimizer state, see \code{?\link{saveTrainedModelAsH5}}. If you
want to store \code{\link{DigitalDLSorter}} object on disk as an RDA file,
see \code{?\link{preparingToSave}}.
}
\section{Slots}{

\describe{
\item{\code{model}}{Trained Deep Neural Network. This slot can contain an R6
\code{keras.engine.sequential.Sequential} object or a list with two
elements: the architecture of the model and the resulting weights after
training.}

\item{\code{training.history}}{List with the evolution of the selected metrics during
training.}

\item{\code{test.metrics}}{Performance of the model on test data.}

\item{\code{test.pred}}{Deconvolution results on test data. Columns are cell types,
rows are samples and each entry corresponds to the proportion of this cell
type in this sample.}

\item{\code{cell.types}}{Vector with cell types to deconvolute.}

\item{\code{features}}{Vector with the features used during training. These features
will be used in subsequent predictions (the nomenclature used in new bulk
RNA-Seq samples must be the same).}

\item{\code{test.deconv.metrics}}{Performance of the model on each sample of test
data compared to known cell proportions. This slot is used after
\code{\link{calculateEvalMetrics}} (see \code{?\link{calculateEvalMetrics}}
for more details).}
}}

