% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disbayes-package.R
\docType{data}
\name{ihdtrends}
\alias{ihdtrends}
\title{Trends in ischemic heart disease in England}
\format{
A data frame with columns:

\code{gender}: \code{"male"} or \code{"female"}. 

\code{age}: Year of age. 

\code{year}: Calendar year.

\code{p2017}: Estimated ratio between the outcome in the calendar
year and the outcome in 2017.

\code{outcome}: Outcome referred to (incidence or case fatality).
}
\source{
Scarborough, P., Wickramasinghe, K., Bhatnagar, P. and Rayner, M. (2011) Trends in coronary heart disease, 1961-2001. British Heart Foundation.

Smolina, K., Wright, F. L., Rayner, M. and Goldacre, M. J. (2012) Determinants of the decline in mortality from acute myocardial infarction in England between 2002 and 2010: linked national database study. BMJ, 344.

British Heart Foundation (2020) Heart and Circulatory Disease Statistics 2020. British Heart Foundation.
}
\usage{
ihdtrends
}
\description{
Trends in ischemic heart disease in England
}
\details{
The data were interpolated and smoothed to produce a matrix by year of age and
calendar year, using the script at \url{https://github.com/chjackson/disbayes/blob/master/data-raw/trends.r}.
}
\keyword{datasets}
