% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/maxLik.R
\name{maxLik}
\alias{maxLik}
\title{Maximum Likelihood Inference}
\usage{
maxLik(projectName, clearHalo, diskDiam = 6, maxDist = 30,
  standardLoc = 2.5, ymax = 125, xplots = 5, height = 8, width = 8,
  FoG = 20, RAD = "all", needML = TRUE, popUp = TRUE,
  nameVector = TRUE, overwrite = TRUE, plotParam = TRUE, plotFoG = TRUE,
  savePDF = TRUE, plotSub = NA, plotCompon = FALSE)
}
\arguments{
\item{projectName}{the short name in use for the project.}

\item{clearHalo}{numeric value that indicates which picture should be used to represent a clear halo (i.e., the clear space beside the disk).}

\item{diskDiam}{the diameter of the diffusion disk in mm, defaults to 6.}

\item{maxDist}{a numeric value indicating the maximum distance away from the disk to be considered. Defaults to 30mm.}

\item{standardLoc}{a numberic value indicating the location (on the disk) to use to standardize intensity across photographs. The position of standardLoc is a position that should theoretically have the same intensity in all photographs, i.e., the white of the disk. The defaul value (2.5mm) was chosen after testing of 6mm disks that contain some writing. If smaller disks are used standardLoc should be scaled appropriately. You can see where standardLoc falls in each photograph in \code{plotRaw} (the red dashed line). To suppress this standardization use standardLoc = FALSE.}

\item{ymax}{a numeric value indicating the maximum y value plotted in each graph, does not influence maximum likelihood fitting}

\item{xplots}{a numeric value indicating how many plots to plot in each row, does not influence maximum likelihood fitting}

\item{height}{a numeric value indicating the height of the pdf file generated, does not influence maximum likelihood fitting}

\item{width}{a numeric value indicating the width of the pdf file generated, does not influence maximum likelihood fitting}

\item{FoG}{a numeric value indicating the the critical level of the area under the curve to plot, does not influence maximum likelihood fitting. Current only \code{FoG} = "80" (80\% reduction in growth), \code{FoG} = "50" (50\% reduction in growth), and \code{FoG} = "20" (20\% reduction in growth) are supported. Note, the critical level for FoG can be different than that chosen for RAD.}

\item{RAD}{a numeric value indicating the critical level of the radius of inhibition (i.e., resistance) parameter to plot, does not influence maximum likelihood fitting. Currently only \code{RAD} = "80" (80\% reduction in growth), \code{RAD} = "50" (50\% reduction in growth), \code{RAD} = "20" (20\% reduction in growth), and \code{RAD} = "all" are supported.}

\item{needML}{a logical value indicating whether the maximum likelihood results already exist in the global environment or not. If \code{\link{maxLik}} has already been run in this session then needML can be set to FALSE, which allows the user to replot the results without the need to rerun the time consuming maximum likelihood models. Defaults to TRUE.}

\item{popUp}{a logical value indicating whether to pop up the figure after it has been created.}

\item{nameVector}{either a logial value indicating whether to plot the photograph names above the graph or not or a vector the same length as the number of pictures containing the desired names. Defaults to TRUE.}

\item{overwrite}{a logical value indicating whether to overwrite existing figures created on the same day for the same project name.defaults to TRUE.}

\item{plotParam}{a logical value indicating whether to save plots containing, at minimum, the fitted logistic equatoin and specified RAD levels to plot, but may also include the FoG \code{plotFoG} = "TRUE" or the components of the logistic equation \code{plotCompon} = "TRUE". Defaults to TRUE.}

\item{plotFoG}{a logical value indicating whether to plot the FoG or not. Defaults to TRUE}

\item{savePDF}{a logical value indicating whether to save a PDF file or open a new quartz. Defaults to TRUE.}

\item{plotSub}{allows you to plot only a subset of photographs - indicate with a vector the corresponding numeric indices of the data you wish to plot. Photographs are numbered alphabetically by name, and the photograph numbers can also be found by using the showNum option in \code{\link{plotRaw}}. Defaults to NA, which will plot data from all photographs. Note this does not affect the analysis component, all data is always analyzed.}

\item{plotCompon}{plots the two terms of the double logistic equation. Defaults to FALSE}
}
\value{
Two lists, ML and ML2 are saved to the global environment. A pdf file with one plot for each photograph is saved to visualize the results of curve fitting, zone of inhibition (resistance) and the area under the curve (tolerance).
}
\description{
\code{maxLik}  uses maximum likelihood to find the logistic and double logistic equations that best describe the shape of the imageJ output data to then fit parameters that describe reistance, tolerance and sensitivity.
}
\details{
\code{\link{maxLik}} searches for the maximum likelihood (ML) parameter for a single logistic and double logistic equation using the pixel intensity information previously determined from \code{\link{IJMacro}}. The equations fit are
single logistic ('ML'):
	y = asymA*exp(scalA(x-od50A))\(1+exp(scalA(x-od50A)))+N(0, sigma)
 double logistic ('ML2'):
	y = asymA*exp(scalA(x-od50A))\(1+exp(scalA(x-od50A)))+asymB*exp(scalB(x-od50B)))\(1+exp(scalB(x-od50B)))+N(0, sigma)
where asymA and asymB are the two asymptotes, od50A and odB are the midpoints (of the two curves), scalA and scalB are the slopes at odA and odB divided by asymA/4 and asymB/4, respectively. Specifically, \code{\link{maxLik}} uses the\code{\link[subplex]{subplex}} method of \code{\link{optim}}, as implemented in \code{\link[diversitree]{find.mle}}.  The single logistic is the essentially the same as the double, yet fits only a single asymptote, midpoint and slope. The results from the double logistic fit are used in \code{\link{createDataframe}} to find the resistance points as well as to fit the area under the curve and thus tolerance, the single logistic is used to determine the midpoint of the curve which is later used to find sensitivity, i.e., the slope at this midpoint.
}
\section{Important}{

The photograph specified with \code{clearHalo} is extremely important to determine tolerance, as the intensity beside the disk for the chosen photograph is subtracted for all photographs. Choosing the photograph to be used for this purpose is the only subjective aspect of this pipeline; lighting and camera settings will determine the degre to which the hue of the plate backbground changes among different photographs. Care should be taken to ensure that plate background will be as similar as possible among different plates. Photographs are numbered alphabetically by name, and can also be found using \code{\link{plotRaw}}, showNum = TRUE. In many experiments a suitable strain will already be included, however a good practice is to always take a photograph of a blank plate with just the disk in the center to use for this purpose (and save it with a name like "a" so that it is always the first photograph in the list (i.e., `clearHalo = 1`). The (non)results from this photograph can be later removed in the function `createDataframe()`.
}

\section{Warning}{

Depending on the number of photographs to be analyzed, `maxLik()` can take a fair amount of time, upwards of an hour or more. This is due to the maximum likelihood fitting procedures, which determine the best fit parameters from multiple different starting values. The status is indicated by a series of dots (".") in the R console, with one dot per photograph. If for some reason the procedure gets halted in the middle of \code{maxLik()} (e.g., computer is shut down) as long as R remains open it should resume where it left off when the computer is reactivated.
}

\section{References}{

Richard G. Fitzjohn (2012) Diversitree: comparative phylogenetic analyses of diversification in R. Methods in Ecology and Evolution. 3:1084-1092.
}
\examples{
\dontrun{
maxLik("myProject", clearHalo=1)
maxLik("myProject", clearHalo=1, xplots = 2, height = 4, width = 6, needML = FALSE)
}
}
\seealso{
\code{\link{saveMLParam}} to save the parameter estimates for asym, od50, scal and sigma, as well as the log likelihood of the single and double logistic models.
}

