% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_optimize_loess.R
\name{utils_optimize_loess}
\alias{utils_optimize_loess}
\title{Optimize Loess Models for Time Series Resampling}
\usage{
utils_optimize_loess(x = NULL, y = NULL, max_complexity = FALSE)
}
\arguments{
\item{x}{(required, numeric vector) predictor, a time vector coerced to numeric. Default: NULL}

\item{y}{(required, numeric vector) response, a column of a zoo object. Default: NULL}

\item{max_complexity}{(required, logical). If TRUE, RMSE optimization is ignored, and the model of maximum complexity is returned. Default: FALSE}
}
\value{
Loess model.
}
\description{
Internal function used in \code{\link[=zoo_resample]{zoo_resample()}}. It finds the \code{span} parameter of a univariate Loess (Locally Estimated Scatterplot Smoothing.) model \code{y ~ x} fitted with \code{\link[stats:loess]{stats::loess()}} that minimizes the root mean squared error (rmse) between observations and predictions, and returns a model fitted with such \code{span}.
}
\examples{

#zoo time series
xy <- zoo_simulate(
  cols = 1,
  rows = 30
)

#optimize loess model
m <- utils_optimize_loess(
  x = as.numeric(zoo::index(xy)), #predictor
  y = xy[, 1] #response
)

print(m)

#plot observation
plot(
  x = zoo::index(xy),
  y = xy[, 1],
  col = "forestgreen",
  type = "l",
  lwd = 2
  )

#plot prediction
points(
  x = zoo::index(xy),
  y = stats::predict(
    object = m,
    newdata = as.numeric(zoo::index(xy))
    ),
  col = "red4"
  )

}
\seealso{
Other tsl_processing_internal: 
\code{\link{utils_drop_geometry}()},
\code{\link{utils_global_scaling_params}()},
\code{\link{utils_optimize_spline}()},
\code{\link{utils_rescale_vector}()}
}
\concept{tsl_processing_internal}
