% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetInterval_SpecialSet.R
\name{NegReals}
\alias{NegReals}
\title{Set of Negative Reals}
\value{
Returns R6 object of class NegReals.
}
\description{
The mathematical set of negative real numbers.
}
\details{
The set of Negative Reals is defined as the union of the set of negative rationals and negative
irrationals, i.e.
\deqn{NegReals = I^- \cup Q^-}{NegReals = I- \cup Q-}
where \eqn{I^-}{I-} is the set of negative irrationals and \eqn{Q^-}{Q-} is the set of negative rationals.

\eqn{0} may or may not be included (depending on the \code{zero} argument).
}
\section{Constructor}{
 NegReals$new(dim = 1, zero = FALSE)
}

\section{Constructor Arguments}{

 \tabular{lll}{
   \strong{Argument} \tab \strong{Type} \tab \strong{Details} \cr
   \code{dim} \tab numeric \tab Dimension of the set. \cr
   \code{zero = FALSE} \tab logical \tab If TRUE, zero is included in the set. \cr
}
}

\examples{
NegReals$new()
NegReals$new(zero = TRUE)
NegReals$new(dim = 2)

}
\seealso{
\code{\link{listSpecialSets}}
}
