% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetInterval_Interval.R
\name{Interval}
\alias{Interval}
\title{R6 Generalised Class for Symbolic Intervals}
\value{
Returns an R6 object of class Interval.
}
\description{
A symbolic R6 Interval class.
}
\details{
Intervals are distinguished from sets in R6 as they can take an infinite range and are defined
over a continuous range (albeit integer or numeric).
}
\section{Constructor}{
 Interval$new(lower = -Inf, upper = Inf, type = "[]", class = "numeric", dim = 1)
}

\section{Constructor Arguments}{

\tabular{lll}{
\strong{Argument} \tab \strong{Type} \tab \strong{Details} \cr
\code{lower} \tab numeric \tab Lower limit of interval. \cr
\code{upper} \tab numeric \tab Upper limit of interval. \cr
\code{type} \tab character \tab Interval type, one of (), (], [), []. \cr
\code{class} \tab character \tab Atomic class, one of "numeric" or "integer". \cr
\code{dim} \tab integer \tab Dimension of SetInterval.
}
}

\section{Public Methods}{

\tabular{ll}{
\strong{Accessor Methods} \tab \strong{Link} \cr
\code{type()} \tab  \code{\link{type.SetInterval}}  \cr
\code{dimension()} \tab \code{\link{dimension.SetInterval}}\cr
\code{max()} \tab  \code{\link{max.SetInterval}} \cr
\code{min()} \tab  \code{\link{min.SetInterval}} \cr
\code{sup()} \tab  \code{\link{sup.SetInterval}}  \cr
\code{inf()} \tab  \code{\link{inf.SetInterval}}  \cr
\code{getSymbol()} \tab  \code{\link{getSymbol.SetInterval}} \cr
\code{class()} \tab  \code{\link{class.SetInterval}}  \cr
\tab \cr \tab \cr \tab \cr
\strong{Interval Methods} \tab \strong{Link} \cr
\code{length()} \tab  \code{\link{length.Interval}}  \cr
\code{as.numeric()} \tab  \code{\link{as.numeric.Interval}}  \cr
\tab \cr \tab \cr \tab \cr
\strong{Validation Methods} \tab \strong{Link} \cr
\code{liesInSetInterval(x, all = FALSE, bound = FALSE)} \tab \code{\link{liesInSetInterval}} \cr
\tab \cr \tab \cr \tab \cr
\strong{Representation Methods} \tab \strong{Link} \cr
\code{print()} \tab \code{\link[base]{print}} \cr
}
}

\seealso{
\code{\link{Set}}
}
