% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listDistributions.R
\name{listDistributions}
\alias{listDistributions}
\title{Lists Implemented Distributions}
\usage{
listDistributions(simplify = FALSE, filter = NULL)
}
\arguments{
\item{simplify}{logical. If FALSE (default) returns distributions with traits as a data.table, otherwise returns
distribution names as characters.}

\item{filter}{list to filter distributions by. See examples.}
}
\value{
Either a list of characters (if \code{simplify} is TRUE) or a data.table of \code{SDistribution}s and their traits.
}
\description{
Lists distr6 distributions in a data.table or a character vector, can be filtered by
traits and implemented package.
}
\examples{
listDistributions()

# Filter list
listDistributions(filter = list(VariateForm = "univariate"))

# Filter is case-insensitive
listDistributions(filter = list(VaLuESupport = "discrete"))

# Multiple filters
listDistributions(filter = list(VaLuESupport = "discrete", package = "extraDistr"))

}
\seealso{
\code{\link{SDistribution}}
}
