% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Categorical.R
\name{Categorical}
\alias{Categorical}
\title{Create a Categorical distribution}
\usage{
Categorical(outcomes, p = NULL)
}
\arguments{
\item{outcomes}{A vector specifying the elements in the sample
space. Can be numeric, factor, character, or logical.}

\item{p}{A vector of success probabilities for each outcome.
Each element of \code{p} can be any positive value -- the vector gets
normalized internally. Defaults to \code{NULL}, in which case the
distribution is assumed to be uniform.}
}
\value{
A \code{Categorical} object.
}
\description{
Create a Categorical distribution
}
\examples{

set.seed(27)

X <- Categorical(1:3, p = c(0.4, 0.1, 0.5))
X

Y <- Categorical(LETTERS[1:4])
Y

random(X, 10)
random(Y, 10)

pdf(X, 1)
log_pdf(X, 1)

cdf(X, 1)
quantile(X, 0.5)

# cdfs are only defined for numeric sample spaces. this errors!
# cdf(Y, "a")

# same for quantiles. this also errors!
# quantile(Y, 0.7)
}
\seealso{
Other discrete distributions: 
\code{\link{Bernoulli}()},
\code{\link{Binomial}()},
\code{\link{Geometric}()},
\code{\link{HurdleNegativeBinomial}()},
\code{\link{HurdlePoisson}()},
\code{\link{HyperGeometric}()},
\code{\link{Multinomial}()},
\code{\link{NegativeBinomial}()},
\code{\link{Poisson}()},
\code{\link{PoissonBinomial}()},
\code{\link{ZINegativeBinomial}()},
\code{\link{ZIPoisson}()},
\code{\link{ZTNegativeBinomial}()},
\code{\link{ZTPoisson}()}
}
\concept{discrete distributions}
