% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterHex.R
\name{scatterHex}
\alias{scatterHex}
\title{scatter plot where observations are grouped into hexagonal bins and then summarized}
\usage{
scatterHex(
  data_frame,
  x.by,
  y.by,
  color.by = NULL,
  bins = 30,
  color.method = NULL,
  split.by = NULL,
  rows.use = NULL,
  color.panel = dittoColors(),
  colors = seq_along(color.panel),
  x.adjustment = NULL,
  y.adjustment = NULL,
  color.adjustment = NULL,
  x.adj.fxn = NULL,
  y.adj.fxn = NULL,
  color.adj.fxn = NULL,
  multivar.split.dir = c("col", "row"),
  split.nrow = NULL,
  split.ncol = NULL,
  split.adjust = list(),
  min.density = NA,
  max.density = NA,
  min.color = "#F0E442",
  max.color = "#0072B2",
  min.opacity = 0.2,
  max.opacity = 1,
  min = NA,
  max = NA,
  rename.color.groups = NULL,
  xlab = x.by,
  ylab = y.by,
  main = "make",
  sub = NULL,
  theme = theme_bw(),
  do.contour = FALSE,
  contour.color = "black",
  contour.linetype = 1,
  do.ellipse = FALSE,
  do.label = FALSE,
  labels.size = 5,
  labels.highlight = TRUE,
  labels.repel = TRUE,
  labels.split.by = split.by,
  labels.repel.adjust = list(),
  add.trajectory.by.groups = NULL,
  add.trajectory.curves = NULL,
  trajectory.group.by,
  trajectory.arrow.size = 0.15,
  legend.show = TRUE,
  legend.color.title = "make",
  legend.color.breaks = waiver(),
  legend.color.breaks.labels = waiver(),
  legend.density.title = "Observations",
  legend.density.breaks = waiver(),
  legend.density.breaks.labels = waiver(),
  show.grid.lines = TRUE,
  data.out = FALSE
)
}
\arguments{
\item{data_frame}{A data_frame where columns are features and rows are observations you might wish to visualize.}

\item{x.by, y.by}{Single strings denoting the name of a column of \code{data_frame} containing numeric data to use for the x- and y-axis of the scatterplot.}

\item{color.by}{Single string denoting the name of a column of \code{data_frame} to use, instead of point density, for setting the color of plotted hexagons.
Alternatively, a string vector naming multiple such columns of data to plot at once.}

\item{bins}{Numeric or numeric vector giving the number of hexagonal bins in the x and y directions. Set to 30 by default.}

\item{color.method}{Single string that specifies how \code{color.by} data should be summarized per each hexagonal bin.
Options, and the default, depend on whether the \code{color.by}-data is continuous versus discrete:

\strong{Continuous}: String naming a function for how target data should be summarized for each bin.
Can be any function that inputs (summarizes) a numeric vector and outputs a single numeric value.
Default is \code{median}.
Other useful options are \code{sum}, \code{mean}, \code{sd}, or \code{max}.
You can also use a custom function as long as you give it a name; e.g. first run \code{logsum <- function(x) \{ log(sum(x)) \}} externally, then give \code{color.method = "logsum"}

\strong{Discrete}: A string signifying whether the color should (default) be simply based on the "max" grouping of the bin,
or based on the "max.prop"ortion of observations belonging to any grouping.}

\item{split.by}{1 or 2 strings denoting the name(s) of column(s) of \code{data_frame} containing discrete data to use for faceting / separating data points into separate plots.

When 2 columns are named, c(row,col), the first is used as rows and the second is used for columns of the resulting facet grid.

When 1 column is named, shape control can be achieved with \code{split.nrow} and \code{split.ncol}}

\item{rows.use}{String vector of rownames of \code{data_frame} OR an integer vector specifying the row-indices of data points which should be plotted.

Alternatively, a Logical vector, the same length as the number of rows in \code{data_frame}, where \code{TRUE} values indicate which rows to plot.}

\item{color.panel}{String vector which sets the colors to draw from when \code{color.by} indicates discrete data.
\code{dittoColors()} by default, see \code{\link{dittoColors}} for contents.

A named vector can be used if names are matched to the distinct values of the \code{color.by} data.}

\item{colors}{Integer vector, the indexes / order, of colors from \code{color.panel} to actually use.

Useful for quickly swapping around colors of the default set (when not using names for color matching).}

\item{x.adjustment, y.adjustment, color.adjustment}{A recognized string indicating whether numeric \code{x.by}, \code{y.by}, and \code{color.by} data should be used directly (default) or should be adjusted to be
\itemize{
\item{"z-score": scaled with the scale() function to produce a relative-to-mean z-score representation}
\item{"relative.to.max": divided by the maximum value to give percent of max values between [0,1]}
}

Ignored if the target data is not numeric as these known adjustments target numeric data only.

In order to leave the unedited data available for use in other features, the adjusted data are put in a new column and that new column is used for plotting.}

\item{x.adj.fxn, y.adj.fxn, color.adj.fxn}{If you wish to apply a function to edit the \code{x.by}, \code{y.by}, or \code{color.by} data before use, in a way not possible with the \code{color.adjustment} input,
this input can be given a function which takes in a vector of values as input and returns a vector of values of the same length as output.

For example, \code{function(x) \{log2(x)\}} or \code{as.factor}.

In order to leave the unedited data available for use in other features, the adjusted data are put in a new column and that new column is used for plotting.}

\item{multivar.split.dir}{"row" or "col", sets the direction of faceting used for 'var' values when: \itemize{
\item \code{var} is given multiple column names
\item AND \code{split.by} is used to provide an additional feature to facet by
}}

\item{split.nrow, split.ncol}{Integers which set the dimensions of faceting/splitting when faceting by a single feature.}

\item{split.adjust}{A named list which allows extra parameters to be pushed through to the faceting function call.
List elements should be valid inputs to the faceting functions, e.g. `list(scales = "free")`.

For options, when giving 1 column to \code{split.by}, see \code{\link[ggplot2]{facet_wrap}},
OR when giving 2 columns to \code{split.by}, see \code{\link[ggplot2]{facet_grid}}.}

\item{min.density, max.density}{Number which sets the min/max values used for the density scale.
Used no matter whether density is represented through opacity or color.}

\item{min.color, max.color}{color for the min/max values of the color scale.}

\item{min.opacity, max.opacity}{Scalar between [0,1] which sets the minimum or maximum opacity used for the density legend (when color is used for \code{color.by} data and density is shown via opacity).}

\item{min, max}{Number which sets the values associated with the minimum or maximum color for \code{color.by} data.}

\item{rename.color.groups}{String vector which sets new names for the identities of \code{color.by} groups.}

\item{xlab, ylab}{Strings which set the labels for the axes. To remove, set to \code{NULL}.}

\item{main}{String, sets the plot title. The default title is either "Density", \code{color.by}, or NULL, depending on the identity of \code{color.by}.
To remove, set to \code{NULL}.}

\item{sub}{String, sets the plot subtitle.}

\item{theme}{A ggplot theme which will be applied before internal adjustments.
Default = \code{theme_bw()}.
See \url{https://ggplot2.tidyverse.org/reference/ggtheme.html} for other options and ideas.}

\item{do.contour}{Logical. Whether density-based contours should be displayed.}

\item{contour.color}{String that sets the color of the \code{do.contour} contours.}

\item{contour.linetype}{String or numeric which sets the type of line used for \code{do.contour} contours.
Defaults to "solid", but see \code{\link[ggplot2]{linetype}} for other options.}

\item{do.ellipse}{Logical. Whether \code{color.by} groups should be surrounded by median-centered ellipses.}

\item{do.label}{Logical. Whether to add text labels near the center (median) of \code{color.by} groups.}

\item{labels.size}{Number which sets the size of labels text when \code{do.label = TRUE}.}

\item{labels.highlight}{Logical. Whether labels should have a box behind them when \code{do.label = TRUE}.}

\item{labels.repel}{Logical, that sets whether the labels' placements will be adjusted with \link{ggrepel} to avoid intersections between labels and plot bounds when \code{do.label = TRUE}.
TRUE by default.}

\item{labels.split.by}{String of one or two column names which controls the facet-split calculations for label placements.
Defaults to \code{split.by}, so generally there is no need to adjust this except when if you plan to apply faceting externally.}

\item{labels.repel.adjust}{A named list which allows extra parameters to be pushed through to ggrepel function calls.
List elements should be valid inputs to the \code{\link[ggrepel]{geom_label_repel}} by default, or \code{\link[ggrepel]{geom_text_repel}} when \code{labels.highlight = FALSE}.}

\item{add.trajectory.by.groups}{List of vectors representing trajectory paths, each from start-group to end-group, where vector contents are the group-names indicated by the \code{trajectory.group.by} column of \code{data_frame}.}

\item{add.trajectory.curves}{List of matrices, each representing coordinates for a trajectory path, from start to end, where matrix columns represent x and y coordinates of the paths.}

\item{trajectory.group.by}{String denoting the name of a column of \code{data_frame} to use for generating trajectories from data point groups.}

\item{trajectory.arrow.size}{Number representing the size of trajectory arrows, in inches.  Default = 0.15.}

\item{legend.show}{Logical. Whether any legend should be displayed. Default = \code{TRUE}.}

\item{legend.density.title, legend.color.title}{Strings which set the title for the legends.}

\item{legend.density.breaks, legend.color.breaks}{Numeric vector which sets the discrete values to label in the density and color.by legends.}

\item{legend.density.breaks.labels, legend.color.breaks.labels}{String vector, with same length as \code{legend.*.breaks}, which sets the labels for the tick marks or hex icons of the associated legend.}

\item{show.grid.lines}{Logical which sets whether grid lines should be shown within the plot space.}

\item{data.out}{Logical. When set to \code{TRUE}, changes the output from the plot alone to a list containing the plot ("plot"),
and data.frame of the underlying data for target observations ("data"),
and the ultimately used mapping of columns to given aesthetic sets, because modification of newly made columns is required for many features ("cols_used").}
}
\value{
A ggplot object where colored hexagonal bins are used to summarize observations in a scatter plot.

Alternatively, if \code{data.out=TRUE}, a list containing three slots is output:
the plot (named 'plot'),
a data.table containing the updated underlying data for target rows (named 'data'),
and a list providing mappings of final column names in 'data' to given plot aesthetics (named 'cols_used'), because modification of newly made columns is required for many features.
}
\description{
scatter plot where observations are grouped into hexagonal bins and then summarized
}
\details{
This function first makes any requested adjustments to data in the given \code{data_frame}, internally only, such as scaling the \code{color.by}-column if \code{color.adjustment} was given \code{"z-score"}.

Next, data_frame is then subset to only target rows based on the \code{rows.use} input.

Finally, a hex plot is created using this dataframe:

If \code{color.by} is not rovided, coloring is based on the density of observations within each hex bin.
When \code{color.by} is provided, density is represented through opacity while coloring is based on a summarization, chosen with the \code{color.method} input, of the target \code{color.by} data.

If \code{split.by} was used, the plot will be split into a matrix of panels based on the associated groupings.
}
\section{Many characteristics of the plot can be adjusted using discrete inputs}{

\itemize{
\item Colors: \code{min.color} and \code{max.color} adjust the colors for continuous data.
\item For discrete \code{color.by} plotting with \code{color.method = "max"}, colors are instead adjusted with \code{color.panel} and/or \code{colors} & the labels of the groupings can be changed using \code{rename.color.groups}.
\item Titles and axes labels can be adjusted with \code{main}, \code{sub}, \code{xlab}, \code{ylab}, and \code{legend.color.title} and \code{legend.density.title} arguments.
\item Legends can also be adjusted in other ways, using variables that all start with "\code{legend.}" for easy tab completion lookup.
}
}

\section{Additional Features}{

Other tweaks and features can be added as well.
Each is accessible through 'tab' autocompletion starting with "\code{do.}"\code{---} or "\code{add.}"\code{---},
and if additional inputs are involved in implementing or tweaking these, the associated inputs will start with the "\code{---.}":
\itemize{
\item If \code{do.contour} is provided, density gradient contour lines will be overlaid with color and linetype adjustable via \code{contour.color} and \code{contour.linetype}.
\item If \code{add.trajectory.by.groups} is provided a list of vectors (each vector being group names from start-group-name to end-group-name), and a column name pointing to the relevant grouping information is provided to \code{trajectory.group.by},
then median centers of the groups will be calculated and arrows will be overlayed to show trajectory inference paths.
\item If \code{add.trajectory.curves} is provided a list of matrices (each matrix containing x, y coordinates from start to end), paths and arrows will be overlayed to show trajectory inference curves.
Arrow size is controlled with the \code{trajectory.arrow.size} input.
}
}

\examples{
example("dittoExampleData", echo = FALSE)

# The minimal inputs for scatterHex are the 'data_frame', and 2 column names,
#   given to 'x.by' and 'y.by', indicating which data to use for the x and y
#   axes, respectively.
scatterHex(
    example_df, x.by = "PC1", y.by = "PC2")

# 'color.by' can also be given a column name in order to represent that
#   column's data in the color of the hexes.
# Note: This capability requires the suggested package 'ggplot.multistats'.
if (requireNamespace("ggplot.multistats", quietly = TRUE)) {
    scatterHex(
        example_df, x.by = "PC1", y.by = "PC2",
        color.by = "groups")
}
if (requireNamespace("ggplot.multistats", quietly = TRUE)) {
    scatterHex(
        example_df, x.by = "PC1", y.by = "PC2",
        color.by = "gene1")
}

# Data can be "split" or faceted by a discrete variable as well.
scatterHex(example_df, x.by = "PC1", y.by = "PC2",
    split.by = "timepoint") # single split.by element
scatterHex(example_df, x.by = "PC1", y.by = "PC2",
    split.by = c("groups","SNP")) # row and col split.by elements

# Modify the look with intuitive inputs
scatterHex(example_df, x.by = "PC1", y.by = "PC2",
    show.grid.lines = FALSE,
    ylab = NULL, xlab = "PC2 by PC1",
    main = "Plot Title",
    sub = "subtitle",
    legend.density.title = "Items")
# 'max.density' is one of these intuitively named inputs that can be
#   extremely useful for saying "I only can for opacity to be decreased
#   in regions with exceptionally low observation numbers."
# (A good value for this in "real" data might be 10 or 50 or higher, but for
#   our sparse example data, we need to do a lot to show this off at all!)
if (requireNamespace("ggplot.multistats", quietly = TRUE)) {
    scatterHex(
        example_df, x.by = "PC1", y.by = "PC2",
        color.by = "gene1", bins = 10,
        sub = "Default density scale")
}
if (requireNamespace("ggplot.multistats", quietly = TRUE)) {
    scatterHex(
        example_df, x.by = "PC1", y.by = "PC2",
        color.by = "gene1", bins = 10,
        sub = "Density capped low for ignoring sparse regions",
        max.density = 2)
}

# You can restrict to only certain data points using the 'rows.use' input.
#   The input can be given rownames, indexes, or a logical vector
scatterHex(example_df, x.by = "PC1", y.by = "PC2",
    sub = "show only first 40 observations, by index",
    rows.use = 1:40)
scatterHex(example_df, x.by = "PC1", y.by = "PC2",
    sub = "show only 3 obs, by name (plotting gets a bit wonky for few points)",
    rows.use = c("obs1", "obs2", "obs25"))
scatterHex(example_df, x.by = "PC1", y.by = "PC2",
    sub = "show groups A,B,D only, by logical",
    rows.use = example_df$groups!="C")

# Many extra features are easy to add as well:
#   Each is started via an input starting with 'do.FEATURE*' or 'add.FEATURE*'
#   And when tweaks for that feature are possible, those inputs will start be
#   named starting with 'FEATURE*'. For example, color.by groups can be labeled
#   with 'do.label = TRUE' and the tweaks for this feature are given with inputs
#   'labels.size', 'labels.highlight', and 'labels.repel':
if (requireNamespace("ggplot.multistats", quietly = TRUE)) {
    scatterHex(example_df, x.by = "PC1", y.by = "PC2", color.by = "groups",
        sub = "default labeling",
        do.label = TRUE)          # Turns on the labeling feature
}
if (requireNamespace("ggplot.multistats", quietly = TRUE)) {
    scatterHex(example_df, x.by = "PC1", y.by = "PC2", color.by = "groups",
        sub = "tweaked labeling",
        do.label = TRUE,          # Turns on the labeling feature
        labels.size = 8,          # Adjust the text size of labels
        labels.highlight = FALSE, # Removes white background behind labels
        labels.repel = FALSE)     # Turns off anti-overlap location adjustments
}

# Faceting can also be used to show multiple continuous variables side-by-side
#   by giving a vector of column names to 'color.by'.
#   This can also be combined with 1 'split.by' variable, with direction then
#   controlled via 'multivar.split.dir':
if (requireNamespace("ggplot.multistats", quietly = TRUE)) {
    scatterHex(example_df, x.by = "PC1", y.by = "PC2", bins = 10,
        color.by = c("gene1", "gene2"))
}
if (requireNamespace("ggplot.multistats", quietly = TRUE)) {
    scatterHex(example_df, x.by = "PC1", y.by = "PC2", bins = 10,
        color.by = c("gene1", "gene2"),
        split.by = "groups")
}
if (requireNamespace("ggplot.multistats", quietly = TRUE)) {
    scatterHex(example_df, x.by = "PC1", y.by = "PC2", bins = 10,
        color.by = c("gene1", "gene2"),
        split.by = "groups",
        multivar.split.dir = "row")
}

# Sometimes, it can be useful for external editing or troubleshooting purposes
#   to see the underlying data that was directly used for plotting.
# 'data.out = TRUE' can be provided in order to obtain not just plot ("plot"),
#   but also the "data" and "cols_used" returned as a list.
out <- scatterHex(example_df, x.by = "PC1", y.by = "PC2",
    rows.use = 1:40,
    data.out = TRUE)
out$plot
summary(out$data)
out$cols_use

}
\seealso{
\code{\link{scatterPlot}} for making non-hex-binned scatter plots showing each individual data point.
It is often best to investigate your data with both the individual and hex-bin methods, then pick whichever is the best representation for your particular goal.
}
\author{
Daniel Bunis with some code adapted from Giuseppe D'Agostino
}
