% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gini.R
\name{ds_gini}
\alias{ds_gini}
\alias{gini}
\title{Compute Gini Index}
\usage{
ds_gini(.data, .cols, .name, .comp = FALSE)

gini(..., .data = dplyr::cur_data_all())
}
\arguments{
\item{.data}{\link[tibble:tibble-package]{tibble}}

\item{.cols}{\href{https://tidyselect.r-lib.org/reference/language.html}{\code{tidy-select}}
Columns to compute the measure with. Must be at least 2 columns. If more than 2, treats
first column as first group and sum of other columns as second.}

\item{.name}{name for column with gini index. Leave missing to return a vector.}

\item{.comp}{Default is FALSE. FALSE returns the sum, TRUE returns the components.}

\item{...}{arguments to forward to ds_gini from gini}
}
\value{
a \link[tibble:tibble-package]{tibble} or numeric vector if .name missing
}
\description{
Compute Gini Index
}
\examples{
data("de_county")
ds_gini(de_county, c(pop_white, starts_with('pop_')))
ds_gini(de_county, starts_with('pop_'), 'gini')
}
\concept{evenness}
