% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conv_funcs.R
\name{attr_eval}
\alias{attr_eval}
\title{Sub-criteria attributes.}
\usage{
attr_eval(x, func = length, simplify = TRUE)
}
\arguments{
\item{x}{\code{[\link{sub_criteria}]}}

\item{func}{\code{[function]}}

\item{simplify}{If \code{TRUE} (default), coerce to a vector.}
}
\value{
\code{vector}; \code{list}
}
\description{
Recursive evaluation of a function (\code{func}) on each attribute (vector) in a \bold{\code{\link{sub_criteria}}}.
}
\examples{
x <- sub_criteria(rep(1, 5), rep(5 * 10, 5))
attr_eval(x)
attr_eval(x, func = max)
attr_eval(x, func = max, simplify = FALSE)
attr_eval(sub_criteria(x, x), func = max, simplify = FALSE)
}
