% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_identifiers.R
\name{merge_identifiers}
\alias{merge_identifiers}
\alias{merge_ids}
\alias{merge_ids.default}
\alias{merge_ids.pid}
\alias{merge_ids.epid}
\alias{merge_ids.pane}
\title{Merge group identifiers}
\usage{
merge_ids(...)

\method{merge_ids}{default}(id1, id2, tie_sort = NULL, ...)

\method{merge_ids}{pid}(id1, id2, tie_sort = NULL, ...)

\method{merge_ids}{epid}(id1, id2, tie_sort = NULL, ...)

\method{merge_ids}{pane}(id1, id2, tie_sort = NULL, ...)
}
\arguments{
\item{...}{Other arguments}

\item{id1}{\code{[\link[=epid-class]{epid}|\link[=pid-class]{pid}|\link[=pane-class]{pane}]}.}

\item{id2}{\code{[\link[=epid-class]{epid}|\link[=pid-class]{pid}|\link[=pane-class]{pane}]}.}

\item{tie_sort}{\code{[atomic]}. Preferential order for breaking tied matches.}
}
\description{
Consolidate two group identifiers.
}
\details{
Groups in \code{id1} are expanded by groups \code{id2}.
}
\examples{
data(missing_staff_id)
dfr <- missing_staff_id
id1 <- links(dfr[[5]])
id2 <- links(dfr[[6]])
id1; id2; merge_ids(id1, id2)
}
\seealso{
\code{\link{links}}; \code{\link{link_records}}; \code{\link{episodes}}; \code{\link{partitions}}
}
