% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_ids.R
\name{make_ids}
\alias{make_ids}
\title{Convert an edge list to record identifiers.}
\usage{
make_ids(x_pos, y_pos, id_length = max(x_pos, y_pos))
}
\arguments{
\item{x_pos}{\code{[integer]}. Index of first half of a record-pair.}

\item{y_pos}{\code{[integer]}. Index of second half of a record-pair.}

\item{id_length}{Length of the record identifier.}
}
\value{
\code{list}
}
\description{
Convert an edge list to record identifiers.
}
\details{
Record groups from non-recursive links have the lowest record ID (\code{sn}) in the set as their group ID.
}
\examples{
make_ids(x_pos = rep(7, 7), y_pos = 1:7)
make_ids(x_pos = c(1, 6), y_pos = 6:7)
make_ids(x_pos = 1:5, y_pos = c(1, 1, 2, 3, 4))
}
