% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pip.R
\name{pip}
\alias{pip}
\title{Calculates posterior inclusion probabilities (PIPs) for modifiers in HDLM & HDLMM}
\usage{
pip(object, type = 1)
}
\arguments{
\item{object}{An object of class dlmtree.}

\item{type}{Type=1 indicates single modifier PIPs. Type=2 indicates joint modifier PIPs for two modifiers.}
}
\value{
A vector (type=1) or data.frame (type=2) of PIPs.
}
\description{
Method for calculating posterior inclusion probabilities (PIPs) for modifiers in HDLM & HDLMM
}
\details{
pip
}
\examples{
\donttest{
# Posterior inclusion probability with HDLM 
D <- sim.hdlmm(sim = "B", n = 1000)
fit <- dlmtree(y ~ ., 
               data = D$dat,
               exposure.data = D$exposures,
               dlm.type = "linear",
               family = "gaussian",
               het = TRUE)
pip(fit)
pip(fit, type = 2)
}

}
