% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target_by.R
\name{relate}
\alias{relate}
\alias{relate.target_df}
\title{Relationship between target variable and variable of interest}
\usage{
relate(.data, predictor)

\method{relate}{target_df}(.data, predictor)
}
\arguments{
\item{.data}{a target_df.}

\item{predictor}{variable of interest. predictor.

See vignette("relate") for an introduction to these concepts.}
}
\value{
An object of the class as relate.
Attributes of relate class is as follows.
\itemize{
\item target : name of target variable
\item predictor : name of predictor
\item model : levels of binned value.
\item raw : table_df with two variables target and predictor.
}
}
\description{
The relationship between the target variable and
the variable of interest (predictor) is briefly analyzed.
}
\details{
Returns the four types of results that correspond to the combination
of the target variable and the data type of the variable of interest.

\itemize{
  \item target variable: categorical variable
  \itemize{
    \item predictor: categorical variable
    \itemize{
      \item contingency table
      \item c("xtabs", "table") class
    }
    \item predictor: numerical variable
    \itemize{
      \item descriptive statistic for each levels and total observation.
    }
  }
  \item target variable: numerical variable
  \itemize{
    \item predictor: categorical variable
    \itemize{
      \item ANOVA test. "lm" class.
    }
    \item predictor: numerical variable
    \itemize{
      \item simple linear model. "lm" class.
    }
  }
}
}
\section{Descriptive statistic information}{

The information derived from the numerical data describe is as follows.

\itemize{
\item mean : arithmetic average
\item sd : standard deviation
\item se_mean : standrd error mean. sd/sqrt(n)
\item IQR : interqurtle range (Q3-Q1)
\item skewness : skewness
\item kurtosis : kurtosis
\item p25 : Q1. 25\% percentile
\item p50 : median. 50\% percentile
\item p75 : Q3. 75\% percentile
\item p01, p05, p10, p20, p30 : 1\%, 5\%, 20\%, 30\% percentiles
\item p40, p60, p70, p80 : 40\%, 60\%, 70\%, 80\% percentiles
\item p90, p95, p99, p100 : 90\%, 95\%, 99\%, 100\% percentiles
}
}

\examples{
# If the target variable is a categorical variable
categ <- target_by(heartfailure, death_event)

# If the variable of interest is a numerical variable
cat_num <- relate(categ, sodium)
cat_num
summary(cat_num)

# plot(cat_num)

# If the variable of interest is a categorical variable
cat_cat <- relate(categ, hblood_pressure)
cat_cat
summary(cat_cat)
 
# plot(cat_cat)

##---------------------------------------------------
# If the target variable is a numerical variable
num <- target_by(heartfailure, creatinine)

# If the variable of interest is a numerical variable
num_num <- relate(num, sodium)
num_num
summary(num_num)

# plot(num_num)

# If the variable of interest is a categorical variable
num_cat <- relate(num, smoking)
num_cat
summary(num_cat)

# plot(num_cat)

# Not allow typographic
# plot(num_cat, typographic = FALSE)

}
\seealso{
\code{\link{print.relate}}, \code{\link{plot.relate}}.
}
