% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R, R/report.character.R,
%   R/report.dmdScheme_validation.R
\name{report}
\alias{report}
\alias{report.character}
\alias{report.dmdScheme_validation}
\title{Generic function for creating a report from an object \code{x}}
\usage{
report(
  x,
  file = tempfile(),
  open = TRUE,
  report = "html",
  report_author = "Myself",
  report_title = "Report of something",
  ...
)

\method{report}{character}(
  x,
  file = tempfile(),
  open = TRUE,
  report = "html",
  report_author = "Tester",
  report_title = "Validation of data against dmdScheme",
  ...
)

\method{report}{dmdScheme_validation}(
  x,
  file = tempfile(),
  open = TRUE,
  report = "html",
  report_author = "Tester",
  report_title = "Validation of data against dmdScheme",
  ...
)
}
\arguments{
\item{x}{object of which the report should be creted used to select a method}

\item{file}{name of the file containing the generated report, including
extension. If missing, ot will be saved as a temporary file in the
temporary folder.}

\item{open}{if \code{TRUE}, open the report. Default: \code{TRUE}}

\item{report}{determines if and in which format a report of the validation
should be generated. Allowed values are:
\itemize{
\item \strong{\code{none}}: no report is generated
\item \strong{\code{html}}: a html (.html) report is generated and opened
\item \strong{\code{pdf}} : a pdf (.pdf) report is generated and opened
\item \strong{\code{word}}: a word (.docx)report is generated and opened
Additional values can be implemented by the different methods and will be
documented in the Details section.
}}

\item{report_author}{name of the author to be included in the report}

\item{report_title}{title of the report to be included in the report}

\item{...}{further arguments passed to or from other methods}
}
\value{
return the path and filename of the report
}
\description{
This generic function creates a report based on the object.
}
\details{
\strong{\code{report.character}} creates a report of the object returnes from a \code{validate()}.

\strong{\code{report.dmdScheme_validation}} creates a report of the object returnes from a \code{validate()}.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: report of a \code{dmdScheme_validation} object.

\item \code{dmdScheme_validation}: report of a \code{dmdScheme_validation} object.
}}

\examples{
## Report of `dmdScheme_validation`
report( scheme_path_xlsx() )

## Report of `dmdScheme_validation`
\dontrun{
# This needs pandoc to run successfully
report( validate(dmdScheme_raw()) )
report(
   x = dmdScheme_raw(),
   report = "html",
   report_author = "The Author I am",
   report_title = "A Nice Report"
)
}
}
