% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dna.R
\name{sort.dnapath_list}
\alias{sort.dnapath_list}
\title{Sort function for 'dnapath_list' object.}
\usage{
\method{sort}{dnapath_list}(x, decreasing = TRUE, by = "dc_score", ...)
}
\arguments{
\item{x}{A 'dnapath_list' object from \code{\link{dnapath}}.}

\item{decreasing}{Logical. If TRUE (the default), results are sorted in
decreasing order.}

\item{by}{The variable to sort the results by. Must be one of: "mean_expr",
the mean expression of each pathway across both groups; "mean_expr1"
or "mean_expr2", the mean expression of each pathway in group
1 or 2, respectively; "dc_score", the differential connectivity score
of the pathway; "p_value", the p-value of the dc score; "n_genes",
the number of genes in each pathway; "pathway", the pathway names; or
"n_dc" the number of significantly differentially conncted genes in each
pathway.}

\item{...}{Additional arguments are ignored.}
}
\value{
The differential network analysis results ordered by DC pathway score.
}
\description{
Sort function for 'dnapath_list' object.
}
\examples{
data(meso)
data(p53_pathways)
set.seed(0)
results <- dnapath(x = meso$gene_expression, pathway_list = p53_pathways,
                   groups = meso$groups, n_perm = 10)
# Filter out pathways that have p-values above 0.2.
results_sig <- filter_pathways(results, 0.2) 
sort(results_sig, by = "dc_score") # Sort by the pathway DC score.
sort(results_sig, by = "n_genes") # Sort by the pathway size.
sort(results_sig, by = "mean_expr") # Sort by the mean expression.
}
