% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redisWorker.R
\name{startLocalWorkers}
\alias{startLocalWorkers}
\title{Start one or more background R worker processes on the local system.}
\usage{
startLocalWorkers(
  n,
  queue,
  host = "localhost",
  port = 6379,
  iter = Inf,
  linger = 30,
  log = stdout(),
  Rbin = paste(R.home(component = "bin"), "R", sep = "/"),
  password,
  ...
)
}
\arguments{
\item{n}{number of workers to start}

\item{queue}{work queue name}

\item{host}{Redis database host name or IP address}

\item{port}{Redis database port number}

\item{iter}{maximum number of tasks to process before exiting the worker loop}

\item{linger}{timeout in seconds after which the work queue is deleted that the worker terminates}

\item{log}{print messages to the specified file connection}

\item{Rbin}{full path to the command-line R program}

\item{password}{optional Redis database password}

\item{...}{optional additional parameters passed to the \code{\link{redisWorker}} function}
}
\value{
NULL is invisibly returned.
}
\description{
Use \code{startLocalWorkers} to start one or more doRedis R worker processes
in the background. The worker processes are started on the local system using
the \code{redisWorker} function.
}
\details{
Running workers self-terminate after a \code{linger} period if their work queues are deleted with the
\code{removeQueue} function, or when network activity with Redis remains
inactive for longer than the \code{timeout} period set in the \code{redisConnect}
function. That value defaults internally to 3600 (one hour) in \code{startLocalWorkers}.
You can increase it by including a {timeout=n} argument value.
}
\examples{
\dontrun{
require('doRedis')
registerDoRedis('jobs')
startLocalWorkers(n=2, queue='jobs', linger=5)
print(getDoParWorkers())
foreach(j=1:10,.combine=sum,.multicombine=TRUE) \\%dopar\\%
          4*sum((runif(1000000)^2 + runif(1000000)^2)<1)/10000000
removeQueue('jobs')
}

}
\seealso{
\code{\link{registerDoRedis}}, \code{\link{redisWorker}}
}
