% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doRedis.R
\name{tasks}
\alias{tasks}
\title{List running doRedis tasks}
\usage{
tasks(queue = "*", id = "*")
}
\arguments{
\item{queue}{List jobs for the specified queue, or set to "*" to list jobs for all queues}

\item{id}{List tasks for the specified job id, or set to "*" to list tasks for all job ids}
}
\value{
a data frame listing jobs by row with variables queue, id, user, master, time, iter, host, pid
}
\description{
List running doRedis tasks
}
\note{
The returned values indicate
\enumerate{
\item \code{queue} the doRedis queue name
\item \code{id} the doRedis job id
\item \code{user} the user running the job
\item \code{master} the host name or I.P. address where the job was submitted (and the master R process runs)
\item \code{time} system time on the worker node when the task was started
\item \code{iter} the loop iterations being run by the task
\item \code{host} the host name or I.P. address where the task is running
\item \code{pid} the process ID of the R worker running the task on \code{host}
}
Tasks are listed until a key associated with them expires in Redis. Thus running tasks
are not explicitly removed from the task list immediately when they terminate, but may
linger on the list for a short while after (a few seconds).
}
