% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpkg_release_gh.R, R/stow.R
\name{stow_gh_release}
\alias{stow_gh_release}
\alias{stow}
\alias{stow_url}
\title{download a github release asset to the \code{stow} R user directory}
\usage{
stow_gh_release(owner, repo, dpkg, overwrite = FALSE)

stow(uri, overwrite = FALSE)

stow_url(url, overwrite = FALSE)
}
\arguments{
\item{owner}{string of repo owner}

\item{repo}{string of repo name}

\item{dpkg}{string of gh release tag (will be the same as the filename without the \code{.parquet} extension)}

\item{overwrite}{logical; re-download the remote file even though
a local file with the same name exists?}

\item{uri}{character string universal resource identifier; currently, must begin
with \verb{http://}, \verb{https://}, or \verb{gh://}}

\item{url}{a URL string starting with \verb{http://} or \verb{https://}}
}
\value{
path to the stowed file or url to github release
}
\description{
Use stow to abstract away the process of downloading a file
or a GitHub release asset to a user's data directory, only
downloading files that have not already been downloaded.
}
\details{
Supported URI prefixes include:
\itemize{
\item \verb{https://}, \verb{http://}: download from a file
\item \verb{gh://}: download a github release asset, formatted as \verb{gh://owner/repo/name}
}

Stow downloads files to the users data directory; see \code{?tools::R_user_dir}.
Specify an alternative download location by setting the \code{R_USER_DATA_DIR}
environment variable.
The stow cache works by name only; that is, if a file with the same URI
has already been downloaded once, it will not be re-downloaded again
(unless \code{overwrite = TRUE}).
}
\examples{
Sys.setenv(R_USER_DATA_DIR = tempfile("stow"))
# get by using URL
stow("https://github.com/geomarker-io/appc/releases/download/v0.1.0/nei_2020.rds",
     overwrite = TRUE) |>
  readRDS()

# will be faster (even in later R sessions) next time
stow("https://github.com/geomarker-io/appc/releases/download/v0.1.0/nei_2020.rds") |>
  readRDS()

# get a data package from a GitHub release
stow("gh://cole-brokamp/dpkg/mtcars-v0.0.0.9000", overwrite = TRUE) |>
  arrow::read_parquet()

stow("gh://cole-brokamp/dpkg/mtcars-v0.0.0.9000") |>
  arrow::read_parquet()

}
