% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dq_space.R
\name{dq_space}
\alias{dq_space}
\title{Create an empty div for spacing}
\usage{
dq_space(height = 30, clear = "both")
}
\arguments{
\item{height}{Height of the space, can be any valid CSS unit,
validation will be done with \code{\link{validateCssUnit}}.}

\item{clear}{Optional, can be one of 'both', 'left', 'right' and 'none'
to specify which elements should be cleared, will be 'both'
if given value is omitted or none of these.}
}
\value{
shiny div for spacing
}
\description{
Creates an empty div with the desired height
clearing the space on the desired sites.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
shinyApp(
  ui = fluidPage(
    fluidRow(
      dq_box(title = "I need space!!", dqSpace(200)),
      dq_box(
      title = "I need more space", collapsible = TRUE, collapsed = TRUE,
            "...but I'm collapsible!", dqSpace("50vh")
            )
    )),
  server = function(input, output) {
  }
)

}
}
\author{
richard.kunze
}
