% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reset_slider_input.R
\name{reset_slider_input}
\alias{reset_slider_input}
\title{Function to reset a slider input}
\usage{
reset_slider_input(id)
}
\arguments{
\item{id}{id of the slider input to reset}
}
\value{
sent message
}
\description{
Function to send a message to js to reset an existing slider
input. Use it ro restore a slider input's initial values.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
shinyApp(
  ui = fluidPage(
    init(),
    sliderInput("mySlider", "Change me", 0, 200, c(90, 117)),
    actionButton("btn1", "Reset slider")
  ),
  server = function(input, output) {
    observeEvent(input$btn1, reset_slider_input("mySlider"))
  }
)

}
}
\author{
richard.kunze
}
