% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dq_infobox.R
\name{dq_infobox}
\alias{dq_infobox}
\title{Creates an info box with given texts}
\usage{
dq_infobox(
  title,
  value = NULL,
  subtitle = NULL,
  icon = NULL,
  bg_color = "#FF8F00",
  color = "white",
  width = 4,
  href = NULL,
  fill = TRUE
)
}
\arguments{
\item{title}{Title of the box.}

\item{value}{Optional, value to show under the title.}

\item{subtitle}{Optional, subtitle to show under the value.}

\item{icon}{Optional, icon to show on the left, can be any string, shiny
icon or just NULL to omit it.}

\item{bg_color}{Optional, sets the background color of the box, can be any
valid html color, standard is dq primary orange.}

\item{color}{Optional, sets the font color of the box, can be any valid html
color, standard is white.}

\item{width}{Optional, width of the box measured in bootstrap columns.}

\item{href}{Optional, link target of the box.}

\item{fill}{Optional, logical, fill the box with background color or
surround it by box-shadow.}
}
\value{
column holding the info box
}
\description{
Creates an info box with given texts
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
shinyApp(
  ui = fluidPage(
    init(),
    fluidRow(
      dq_infobox(
      "hello", 2, "world", shiny::icon("hashtag"),
      bgColor = "black", color = "#D00"
      ),
      dq_infobox("hello", "2", href="https://www.google.com"),
      dq_infobox("hello", 2, "world", "YOU", fill=F)
    )
  ),
  server = function(input, output) {
  }
)

}
}
\author{
richard.kunze
}
