% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.scluminex.R
\name{plot.scluminex}
\alias{plot.scluminex}
\title{Plot method for the scluminex class}
\usage{
\method{plot}{scluminex}(x, type = "scurve", subset.list = NULL,
    psize = 1.8, ncol = NULL, nrow = NULL, out.limit = 2.5,
    size.text = 1.5, size.legend = 2.5, interval = "confidence",
    level = 0.95, color.bkg = "green", ...)
}
\arguments{
\item{x}{an object of class \code{scluminex}}

\item{type}{character describing the type of plot ('scurve','residuals'
or 'qqplot'). Default 'scurve'.}

\item{subset.list}{list of analytes to be plotted. Default all
analytes.}

\item{psize}{numeric point size}

\item{ncol}{number of columns to plot the analytes.}

\item{nrow}{number of rows to plot the analytes.}

\item{out.limit}{value that defines an outlier. Must be positive value.
Only applies for type 'residuals'.}

\item{size.text}{value that defines the size of the well into the residuals
plot. Only applies for type 'residuals'.}

\item{size.legend}{size of the legend. \code{NA} for not showing. Only applies for
type 'scurve'.}

\item{interval}{'confidence' or 'prediction' character in order to plot the
fit and the corresponding bands. If \code{NULL} only observed points
are plotted. Only applies for type 'scurve'.}

\item{level}{confidence level for the interval. Default 0.95, only applies
for type 'scurve'.}

\item{color.bkg}{character specifying the color of the background line.
\code{NA} for not showing background.
Only applies for type 'scurve'.}

\item{...}{other arguments to be passed to \code{ggplot} function}
}
\value{
A \code{ggplot} object
}
\description{
This function takes a \code{scluminex} object and
creates a standard curve, residuals or QQ-plot
using \code{ggplot2} package.
}
\details{
All information in order to generate the plots is extracted
from the \code{scluminex} object.
}
\examples{
# Load data and estimate models
data(ecdata)
data(mfidata)

dat <- mfidata[mfidata$plate=="plate_1" & mfidata$analyte=="FGF",]

sdf <- data_selection(dat, ecdata)[[1]]
sdf_luminex <- scluminex("plate_1",sdf$standard, sdf$background,
"SSl4", bkg="ignore", fmfi="mfi", verbose=FALSE)

# Plot standard curves
plot(sdf_luminex, "sc")

# Plots residuals
plot(sdf_luminex, "res")

# Plot QQplot
plot(sdf_luminex, "qq")
}

