context("file")
source("utils.R")

test_that("as_file, is_file, and is_not_file work", {
  expect_equal(as_file("e"), "'e'")
  expect_true(is_file("'e'"))
  expect_false(is_file("e"))
  expect_false(is_not_file("'e'"))
  expect_true(is_not_file("e"))
})

test_that("change imported file and see changed output", {
  debug_cleanup()
  debug_setup()
  p = example_plan("debug")
  make(p, verbose = F)
  final0 = readd(final)
  imp = read.csv("input")
  imp = imp + 1
  write.csv(imp, "input")
  make(p, output = "'d'", verbose = F)
  expect_equal(built_(), c("'d'", letters[1:4]))
  expect_true(identical(readd(final), final0))
  make(p, verbose = F)
  expect_false(identical(readd(final), final0))
  expect_equal(built_(), c("'e'", "e", "final"))
  debug_cleanup()
})

test_that("change generated file and see output restored", {
  debug_cleanup()
  debug_setup()
  p = example_plan("debug")
  make(p, verbose = F)
  final0 = readd(final)
  e0 = readRDS("e")
  saveRDS(e0+1, "e")
  make(p, verbose = F)
  expect_equal(readd(final), final0)
  expect_equal(final0, e0)
  expect_equal(readd(e), e0)
  debug_cleanup()
})

test_that("refresh imported file and see everything skipped", {
  debug_cleanup()
  debug_setup()
  input1 = read.csv("input")
  mtime1 = file.mtime("input")
  p = example_plan("debug")
  make(p, verbose = F)
  unlink("input")
  Sys.sleep(1)
  matrix(1:25, nrow = 5) %>% write.csv(file="input")
  input2 = read.csv("input")
  mtime2 = file.mtime("input")
  expect_equal(input1, input2)
  expect_true(mtime2 > mtime1)
  final1 = readd(final)
  make(p, verbose = F)
  final2 = readd(final)
  expect_equal(final1, final2)
  expect_equal(built_(), character(0))
  debug_cleanup()
})

test_that("refresh generated file and see everything skipped", {
  debug_cleanup()
  debug_setup()
  p = example_plan("debug")
  make(p, verbose = F)
  input1 = readRDS("e")
  mtime1 = file.mtime("e")
  tmp = readRDS("e")
  unlink("e")
  Sys.sleep(1)
  saveRDS(tmp, file = "e")
  input2 = readRDS("e")
  mtime2 = file.mtime("e")
  expect_equal(input1, input2)
  expect_true(mtime2 > mtime1)
  final1 = readd(final)
  make(p, verbose = F)
  final2 = readd(final)
  expect_equal(final1, final2)
  expect_equal(built_(), character(0))
  debug_cleanup()
})

test_that("delete imported file and see error", {
  debug_cleanup()
  debug_setup()
  p = example_plan("debug")
  make(p, verbose = F)
  expect_true("final" %in% cached())
  unlink("input")
  expect_error(make(p, verbose = F))
  debug_cleanup()
})

test_that("delete generated file and see it restored", {
  debug_cleanup()
  debug_setup()
  p = example_plan("debug")
  make(p, verbose = F)
  unlink("e")
  make(p, verbose = F)
  expect_equal(built_(), "'e'")
  debug_cleanup()
})
