% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{drake_session}
\alias{drake_session}
\title{Return the \code{\link{sessionInfo}()}
of the last call to \code{\link{make}()}.}
\usage{
drake_session(path = getwd(), search = TRUE, cache = drake::get_cache(path
  = path, search = search, verbose = verbose), verbose = TRUE)
}
\arguments{
\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.}

\item{search}{If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.}

\item{cache}{optional drake cache. See code{\link{new_cache}()}.
If \code{cache} is supplied,
the \code{path} and \code{search} arguments are ignored.}

\item{verbose}{whether to print console messages}
}
\value{
\code{\link{sessionInfo}()} of the last
call to \code{\link{make}()}
}
\description{
By default, session info is saved
during \code{\link{make}()} to ensure reproducibility.
Your loaded packages and their versions are recorded, for example.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Get the code with drake_example("basic").
make(my_plan) # Run the project, build the targets.
drake_session() # Retrieve the cached sessionInfo() of the last make().
})
}
}
\seealso{
\code{\link{diagnose}}, \code{\link{built}}, \code{\link{imported}},
\code{\link{readd}}, \code{\link{drake_plan}}, \code{\link{make}}
}
