% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examples.R
\name{drake_example}
\alias{drake_example}
\title{Save the source code files of a drake example.}
\usage{
drake_example(example = drake::drake_examples(), to = getwd(),
  destination = NULL, overwrite = FALSE)
}
\arguments{
\item{example}{name of the example.
To see all the available example names,
run \code{\link[=drake_examples]{drake_examples()}}.}

\item{to}{Character scalar, file path, where
to write the folder containing the code files for the example.}

\item{destination}{Deprecated, use \code{to} instead.}

\item{overwrite}{Logical, whether to overwrite an existing folder
with the same name as the drake example.}
}
\value{
\code{NULL}
}
\description{
Copy a folder of code files for a
drake example to the current working directory.
Call \code{drake_example("mtcars")} to generate the code files from
https://ropenscilabs.github.io/drake-manual/mtcars.html.
To see the names of all the examples, run \code{\link[=drake_examples]{drake_examples()}}.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
drake_examples() # List all the drake examples.
# Sets up the same example as https://ropenscilabs.github.io/drake-manual/mtcars.html # nolint
drake_example("mtcars")
# Sets up the SLURM example.
drake_example("slurm")
})
}
}
\seealso{
\code{\link[=drake_examples]{drake_examples()}}, \code{\link[=make]{make()}},
\code{\link[=shell_file]{shell_file()}}, \code{\link[=drake_hpc_template_file]{drake_hpc_template_file()}}
}
