% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loggompertz.R
\name{loggompertz_fn}
\alias{loggompertz_fn}
\title{log-Gompertz function}
\usage{
loggompertz_fn(x, theta)
}
\arguments{
\item{x}{numeric vector at which the function is to be evaluated.}

\item{theta}{numeric vector with the four parameters in the form
\code{c(alpha, delta, eta, phi)}.}
}
\value{
Numeric vector of the same length of \code{x} with the values of the
log-logistic function.
}
\description{
Evaluate at a particular set of parameters the log-Gompertz function.
}
\details{
The log-Gompertz function \verb{f(x; theta)} is defined here as

\verb{f(x; theta) = alpha + delta exp(-(phi / x)^eta)}

where \code{x >= 0}, \code{theta = c(alpha, delta, eta, phi)}, \code{eta > 0}, and
\code{phi > 0}. By convention we set
\verb{f(0; theta) = lim_\{x -> 0\} f(x; theta) = alpha}.
}
