% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_funs.R
\name{validate_dots}
\alias{validate_dots}
\title{Checks the arguments in dots from methods}
\usage{
validate_dots(
  valid_args = c(),
  suggest_args = c(),
  message,
  warn,
  stop,
  call. = FALSE,
  immediate. = TRUE
)
}
\arguments{
\item{valid_args}{A character vector, default is missing. Arguments that are not in the definition of the function but which are considered as valid. Typically internal arguments that should not be directly accessed by the user.}

\item{suggest_args}{A character vector, default is missing. If the user provides invalid arguments, he might not be aware of the main arguments of the function. Use this argument to inform the user of these main arguments.}

\item{message}{Logical, default is \code{FALSE}. If \code{TRUE}, a standard message is prompted to the user (instead of a warning).}

\item{warn}{Logical, default is \code{TRUE}. If \code{TRUE}, when the user provides invalid arguments, the function will call \code{\link[base]{warning}} (default). If \code{FALSE} (and so are the other arguments \code{stop} and \code{message}), then no message is prompted to the user, rather it is the only output of the function.}

\item{stop}{Logical, default is \code{FALSE}. If \code{TRUE}, when the user provides invalid arguments, the function will call \code{\link[base]{stop}} instead of prompting a warning (default).}

\item{call.}{Logical, default is \code{FALSE}. If \code{TRUE}, when the user provides invalid arguments, then the message will also contain the call to the initial function (by default, only the function name is shown).}

\item{immediate.}{Logical, default is \code{FALSE}. Can be only used with the argument \code{warn = TRUE}: whether the warning is immediately displayed or not.}
}
\value{
This function returns the message to be displayed. If no message is to be displayed because all the arguments are valid, then \code{NULL} is returned.
}
\description{
This function informs the user of arguments passed to a method but which are not used by the method.
}
\examples{

# The typical use of this function is within methods

# Let's create a 'my_class' object and a summary method
my_obj = list()
class(my_obj) = "my_class"

# In the summary method, we add validate_dots
# to inform the user of invalid arguments

summary.my_class = function(object, arg_one, arg_two, ...){

  validate_dots()
  # CODE of summary.my_class
  invisible(NULL)
}

# Now let's test it, we add invalid arguments
summary(my_obj, wrong = 3)
summary(my_obj, wrong = 3, info = 5)

# Now let's :
#   i) inform the user that argument arg_one is the main argument
#  ii) consider 'info' as a valid argument (but not shown to the user)
# iii) show a message instead of a warning

summary.my_class = function(object, arg_one, arg_two, ...){

  validate_dots(valid_args = "info", suggest_args = "arg_one", message = TRUE)
  # CODE of summary.my_class
  invisible(NULL)
}

# Let's retest it
summary(my_obj, wrong = 3) # not OK => suggestions
summary(my_obj, info = 5)  # OK



}
