% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.tauSurface.R
\name{tauPlot3d}
\alias{tauPlot3d}
\title{Plot 3d surface of interaction index estimates}
\usage{
tauPlot3d(tauSurface, logScale = TRUE, continuous = FALSE, funs = NULL,
  addPlane = continuous, colorPoints = TRUE, widget = FALSE)
}
\arguments{
\item{tauSurface}{A \code{tauSurface} object returned by 
\code{\link{getTauSurface}}.}

\item{logScale}{Whether to use log-scale for x and y axes.}

\item{continuous}{Whether continuous type of plot is requested. This is 
automatically detected if used via \code{\link{plot.tauSurface}}, but can be 
overwritten.}

\item{funs}{A list with functions to compute tau surface and confidence 
bands. These are returned by the \code{\link{getTauSurface}} and are 
automatically used when the \code{\link{plot.tauSurface}} is called.}

\item{addPlane}{Whether to add estimated tau plane.}

\item{colorPoints}{Whether to color points by synergy/antagonism. Blue color 
is used for points deemed synergistic (if the confidence interval lies 
entirely below 1), red for points deemed antagostic' (if the confidence 
interval lies entirely above 1). Other points are colored white.}

\item{widget}{Whether to return a "htmlwidget" object instead of plotting on 
3d device.}
}
\value{
A 3d plot is shown or an object of the class "htmlwidget" as returned by 
\code{\link[rgl]{rglwidget}}.
}
\description{
Plot 3d surface of interaction index estimates
}
\details{
The function returns a 3d plot for the interaction index (tau) 
estimates as a function of the doses of the two drugs. Pointwise confidence 
intervals are displayed as error bars.
Although the function can be used 'manually', typically one calls the 
\code{\link{plot.tauSurface}} method, which then calls this function when 
\code{which = "3d"}.
}
\seealso{
\code{\link{plot.tauSurface}}, \code{\link{tauPlot2d}}
}
\author{
Maxim Nazarov
}
