% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chainrule.R
\name{chainrule}
\alias{chainrule}
\title{Chainrule}
\usage{
chainrule(
  f1 = NULL,
  f2 = NULL,
  f3 = NULL,
  f4 = NULL,
  g1 = NULL,
  g2 = NULL,
  g3 = NULL,
  g4 = NULL,
  deriv = 2,
  tri = NULL
)
}
\arguments{
\item{f1}{vector of first derivatives of \eqn{f(\cdot)} evaluated at \eqn{g(\cdot)}.}

\item{f2}{vector of second derivatives of \eqn{f(\cdot)} evaluated at \eqn{g(\cdot)}.}

\item{f3}{vector of third derivatives of \eqn{f(\cdot)} evaluated at \eqn{g(\cdot)}.}

\item{f4}{vector of fourth derivatives of \eqn{f(\cdot)} evaluated at \eqn{g(\cdot)}.}

\item{g1}{matrix of first derivatives of \eqn{g(\cdot)}.}

\item{g2}{matrix of second derivatives of \eqn{g(\cdot)}.}

\item{g3}{matrix of third derivatives of \eqn{g(\cdot)}.}

\item{g4}{matrix of fourth derivatives of \eqn{g(\cdot)}.}

\item{deriv}{derivative of order \code{deriv}. Available are 1,2,3,4.}

\item{tri}{optional, index arrays for upper triangular for g, generated by \code{\link[mgcv:trind.generator]{trind.generator()}}.}
}
\value{
A list with partial derivatives. The index of the list corresponds to a matrix with all partial derivatives of that order.
}
\description{
Calculates the partial derivatives of the function \eqn{h(x_1,x_2,...,x_{K})=f(g(x_1,x_2,...,x_{K}))} up to order four. Here \eqn{K} is the number of inputs for function \eqn{g(\cdot)}.
The function \eqn{f(\cdot)} can only have a single input.
}
\details{
Mostly internal function, which is helpful in calculating the partial derivatives of the loglikelihood.
}
\examples{
x<-1 #For K=1, x_1 value is set to 1.

g<-1/x #g(x_1) = 1/x
g1<-matrix(-1/x^2,ncol=1)
g2<-matrix(2/x^3,ncol=1)
g3<-matrix(-6/x^4,ncol=1)
g4<-matrix(24/x^5,ncol=1)

f<-exp(g) #f(g(x)) = exp(g(x))
f1<-f2<-f3<-f4<-exp(g)

chainrule(f1, f2, f3, f4, g1, g2, g3, g4, deriv=4)

}
