% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsproto.R
\name{dsproto}
\alias{$.dsproto_parent}
\alias{[[.dsproto}
\alias{as.list.dsproto}
\alias{dsproto}
\alias{dsproto_parent}
\alias{format.dsproto}
\alias{format.dsproto_method}
\alias{print.dsproto}
\alias{print.dsproto_method}
\title{Create a new dsproto object}
\usage{
dsproto(`_class` = NULL, `_inherit` = NULL, ...)

dsproto_parent(parent, self)

\method{print}{dsproto}(x, ..., flat = TRUE)

\method{format}{dsproto}(x, ..., flat = TRUE)

\method{print}{dsproto_method}(x, ...)

\method{format}{dsproto_method}(x, ...)
}
\arguments{
\item{_class}{Class name to assign to the object. This is stored as the class
attribute of the object. If \code{NULL} (the default), no class name will
be added to the object.}

\item{_inherit}{dsproto object to inherit from. If \code{NULL}, don't inherit
from any object.}

\item{...}{A list of members in the dsproto object.}

\item{parent, self}{Access parent class \code{parent} of object \code{self}.}

\item{x}{A dsproto object to convert to a list.}

\item{inherit}{If \code{TRUE} (the default), flatten all inherited items into}

\item{...}{Further arguments to pass to \code{as.list.environment}.}
}
\description{
dsproto draws from the prototype implementation in ggplot2, which in turn is inspired by the
ggplot2's implementation, with improvements in inheritance and performance. 
The ggplot2 implementation is copyright by Hadley Wickham and Winston Chang, and released under
GPLv2.

Convert a dsproto object to a list
This will not include the object's \code{super} member.

Format a dsproto object
}
\section{Calling dsproto methods}{


dsproto methods can take an optional \code{self} argument: if it is present,
it is a regular method; if it's absent, it's a "static" method.
}

\section{Calling methods in a parent}{


To explicitly call a methods in a parent, use
\code{dsproto_parent(Parent, self)}.
}
\examples{
#Create a class called "dog"
doggy <- dsproto(`_class` = "dog", `_inherit` = NULL)
#Add children to the parent class "dog". Then add members.
GS <- dsproto(`_class` = "German Shephard", `_inherit` = doggy,
        name = "Pedro",
        color = "Brown",
        personality = "Friendly",
        age = 1,
        parents = list("Spot", "Alfred"),
        birthday = function(self) self$age = self$age + 1)
#Call those members
GS$color
GS$age
#Call a function member
GS$birthday()
#Happy Birthday to Pedro! Your dog is now 2! Let's see what the age returns
GS$age
}
\keyword{internal}

