% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPatterns.R
\name{plotPatterns}
\alias{plotPatterns}
\title{Plotting temporal patterns}
\usage{
plotPatterns(x, labels = NULL, attr, year = 2005)
}
\arguments{
\item{x}{An object of class \code{\link[dtwSat]{twdtwTimeSeries}}, 
\code{\link[zoo]{zoo}}, or list of \code{\link[zoo]{zoo}}.}

\item{labels}{a vector with labels of the time series. If not declared 
the function will plot all time series.}

\item{attr}{An \link[base]{integer} vector or \link[base]{character} vector 
indicating the attribute for plotting. If not declared the function will plot 
all attributes.}

\item{year}{An integer. The base year to shift the dates of the time series to. 
If NULL then it does not shif the time series. Default is 2005.}
}
\value{
A \link[ggplot2]{ggplot} object.
}
\description{
Method for plotting the temporal patterns.
}
\examples{
patt = twdtwTimeSeries(patterns.list)
plotPatterns(patt)
plotPatterns(patt, attr="evi")

}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
\seealso{
\code{\link[dtwSat]{twdtwTimeSeries-class}} and 
\code{\link[dtwSat]{plotTimeSeries}}
}

