//===----------------------------------------------------------------------===//
//                         DuckDB
//
// duckdb/main/settings.hpp
//
//
//===----------------------------------------------------------------------===//

#pragma once

#include "duckdb/main/config.hpp"
#include "duckdb/main/setting_info.hpp"
#include "duckdb/common/enums/access_mode.hpp"
#include "duckdb/common/enums/checkpoint_abort.hpp"
#include "duckdb/common/enums/debug_vector_verification.hpp"
#include "duckdb/common/enums/window_aggregation_mode.hpp"
#include "duckdb/common/enums/order_type.hpp"
#include "duckdb/common/enums/output_type.hpp"
#include "duckdb/common/enums/thread_pin_mode.hpp"
#include "duckdb/common/enums/arrow_format_version.hpp"

namespace duckdb {

//===----------------------------------------------------------------------===//
// This code is autogenerated from 'update_settings_header_file.py'.
// Please do not make any changes directly here, as they will be overwritten.
//
// Start of the auto-generated list of settings structures
//===----------------------------------------------------------------------===//

struct AccessModeSetting {
	using RETURN_TYPE = AccessMode;
	static constexpr const char *Name = "access_mode";
	static constexpr const char *Description = "Access mode of the database (AUTOMATIC, READ_ONLY or READ_WRITE)";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static bool OnGlobalSet(DatabaseInstance *db, DBConfig &config, const Value &input);
	static Value GetSetting(const ClientContext &context);
};

struct AllocatorBackgroundThreadsSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "allocator_background_threads";
	static constexpr const char *Description = "Whether to enable the allocator background thread.";
	static constexpr const char *InputType = "BOOLEAN";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static bool OnGlobalSet(DatabaseInstance *db, DBConfig &config, const Value &input);
	static bool OnGlobalReset(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct AllocatorBulkDeallocationFlushThresholdSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "allocator_bulk_deallocation_flush_threshold";
	static constexpr const char *Description =
	    "If a bulk deallocation larger than this occurs, flush outstanding allocations.";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct AllocatorFlushThresholdSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "allocator_flush_threshold";
	static constexpr const char *Description =
	    "Peak allocation threshold at which to flush the allocator after completing a task.";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct AllowCommunityExtensionsSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "allow_community_extensions";
	static constexpr const char *Description = "Allow to load community built extensions";
	static constexpr const char *InputType = "BOOLEAN";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static bool OnGlobalSet(DatabaseInstance *db, DBConfig &config, const Value &input);
	static bool OnGlobalReset(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct AllowExtensionsMetadataMismatchSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "allow_extensions_metadata_mismatch";
	static constexpr const char *Description = "Allow to load extensions with not compatible metadata";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "false";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
};

struct AllowPersistentSecretsSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "allow_persistent_secrets";
	static constexpr const char *Description =
	    "Allow the creation of persistent secrets, that are stored and loaded on restarts";
	static constexpr const char *InputType = "BOOLEAN";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct AllowUnredactedSecretsSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "allow_unredacted_secrets";
	static constexpr const char *Description = "Allow printing unredacted secrets";
	static constexpr const char *InputType = "BOOLEAN";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static bool OnGlobalSet(DatabaseInstance *db, DBConfig &config, const Value &input);
	static bool OnGlobalReset(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct AllowUnsignedExtensionsSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "allow_unsigned_extensions";
	static constexpr const char *Description = "Allow to load extensions with invalid or missing signatures";
	static constexpr const char *InputType = "BOOLEAN";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static bool OnGlobalSet(DatabaseInstance *db, DBConfig &config, const Value &input);
	static bool OnGlobalReset(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct AllowedDirectoriesSetting {
	using RETURN_TYPE = vector<string>;
	static constexpr const char *Name = "allowed_directories";
	static constexpr const char *Description = "List of directories/prefixes that are ALWAYS allowed to be queried - "
	                                           "even when enable_external_access is false";
	static constexpr const char *InputType = "VARCHAR[]";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct AllowedPathsSetting {
	using RETURN_TYPE = vector<string>;
	static constexpr const char *Name = "allowed_paths";
	static constexpr const char *Description =
	    "List of files that are ALWAYS allowed to be queried - even when enable_external_access is false";
	static constexpr const char *InputType = "VARCHAR[]";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct ArrowLargeBufferSizeSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "arrow_large_buffer_size";
	static constexpr const char *Description =
	    "Whether Arrow buffers for strings, blobs, uuids and bits should be exported using large buffers";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "false";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
};

struct ArrowLosslessConversionSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "arrow_lossless_conversion";
	static constexpr const char *Description =
	    "Whenever a DuckDB type does not have a clear native or canonical extension match in Arrow, export the types "
	    "with a duckdb.type_name extension name.";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "false";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
};

struct ArrowOutputListViewSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "arrow_output_list_view";
	static constexpr const char *Description =
	    "Whether export to Arrow format should use ListView as the physical layout for LIST columns";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "false";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
};

struct ArrowOutputVersionSetting {
	using RETURN_TYPE = ArrowFormatVersion;
	static constexpr const char *Name = "arrow_output_version";
	static constexpr const char *Description =
	    "Whether strings should be produced by DuckDB in Utf8View format instead of Utf8";
	static constexpr const char *InputType = "VARCHAR";
	static constexpr const char *DefaultValue = "1.0";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
	static void OnSet(SettingCallbackInfo &info, Value &input);
};

struct AsofLoopJoinThresholdSetting {
	using RETURN_TYPE = idx_t;
	static constexpr const char *Name = "asof_loop_join_threshold";
	static constexpr const char *Description =
	    "The maximum number of rows we need on the left side of an ASOF join to use a nested loop join";
	static constexpr const char *InputType = "UBIGINT";
	static constexpr const char *DefaultValue = "64";
	static constexpr SetScope DefaultScope = SetScope::SESSION;
};

struct AutoinstallExtensionRepositorySetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "autoinstall_extension_repository";
	static constexpr const char *Description =
	    "Overrides the custom endpoint for extension installation on autoloading";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct AutoinstallKnownExtensionsSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "autoinstall_known_extensions";
	static constexpr const char *Description =
	    "Whether known extensions are allowed to be automatically installed when a query depends on them";
	static constexpr const char *InputType = "BOOLEAN";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct AutoloadKnownExtensionsSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "autoload_known_extensions";
	static constexpr const char *Description =
	    "Whether known extensions are allowed to be automatically loaded when a query depends on them";
	static constexpr const char *InputType = "BOOLEAN";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct CatalogErrorMaxSchemasSetting {
	using RETURN_TYPE = idx_t;
	static constexpr const char *Name = "catalog_error_max_schemas";
	static constexpr const char *Description =
	    "The maximum number of schemas the system will scan for \"did you mean...\" style errors in the catalog";
	static constexpr const char *InputType = "UBIGINT";
	static constexpr const char *DefaultValue = "100";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
};

struct CheckpointThresholdSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "checkpoint_threshold";
	static constexpr const char *Description =
	    "The WAL size threshold at which to automatically trigger a checkpoint (e.g. 1GB)";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct CustomExtensionRepositorySetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "custom_extension_repository";
	static constexpr const char *Description = "Overrides the custom endpoint for remote extension installation";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct CustomProfilingSettingsSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "custom_profiling_settings";
	static constexpr const char *Description = "Accepts a JSON enabling custom metrics";
	static constexpr const char *InputType = "VARCHAR";
	static void SetLocal(ClientContext &context, const Value &parameter);
	static void ResetLocal(ClientContext &context);
	static Value GetSetting(const ClientContext &context);
};

struct CustomUserAgentSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "custom_user_agent";
	static constexpr const char *Description = "Metadata from DuckDB callers";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct DebugAsofIejoinSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "debug_asof_iejoin";
	static constexpr const char *Description = "DEBUG SETTING: force use of IEJoin to implement AsOf joins";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "false";
	static constexpr SetScope DefaultScope = SetScope::SESSION;
};

struct DebugCheckpointAbortSetting {
	using RETURN_TYPE = CheckpointAbort;
	static constexpr const char *Name = "debug_checkpoint_abort";
	static constexpr const char *Description =
	    "DEBUG SETTING: trigger an abort while checkpointing for testing purposes";
	static constexpr const char *InputType = "VARCHAR";
	static constexpr const char *DefaultValue = "NONE";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
	static void OnSet(SettingCallbackInfo &info, Value &input);
};

struct DebugForceExternalSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "debug_force_external";
	static constexpr const char *Description =
	    "DEBUG SETTING: force out-of-core computation for operators that support it, used for testing";
	static constexpr const char *InputType = "BOOLEAN";
	static void SetLocal(ClientContext &context, const Value &parameter);
	static void ResetLocal(ClientContext &context);
	static Value GetSetting(const ClientContext &context);
};

struct DebugForceNoCrossProductSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "debug_force_no_cross_product";
	static constexpr const char *Description =
	    "DEBUG SETTING: Force disable cross product generation when hyper graph isn't connected, used for testing";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "false";
	static constexpr SetScope DefaultScope = SetScope::SESSION;
};

struct DebugSkipCheckpointOnCommitSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "debug_skip_checkpoint_on_commit";
	static constexpr const char *Description = "DEBUG SETTING: skip checkpointing on commit";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "false";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
};

struct DebugVerifyVectorSetting {
	using RETURN_TYPE = DebugVectorVerification;
	static constexpr const char *Name = "debug_verify_vector";
	static constexpr const char *Description = "DEBUG SETTING: enable vector verification";
	static constexpr const char *InputType = "VARCHAR";
	static constexpr const char *DefaultValue = "NONE";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
	static void OnSet(SettingCallbackInfo &info, Value &input);
};

struct DebugWindowModeSetting {
	using RETURN_TYPE = WindowAggregationMode;
	static constexpr const char *Name = "debug_window_mode";
	static constexpr const char *Description = "DEBUG SETTING: switch window mode to use";
	static constexpr const char *InputType = "VARCHAR";
	static constexpr const char *DefaultValue = "WINDOW";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
	static void OnSet(SettingCallbackInfo &info, Value &input);
};

struct DefaultBlockSizeSetting {
	using RETURN_TYPE = idx_t;
	static constexpr const char *Name = "default_block_size";
	static constexpr const char *Description =
	    "The default block size for new duckdb database files (new as-in, they do not yet exist).";
	static constexpr const char *InputType = "UBIGINT";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct DefaultCollationSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "default_collation";
	static constexpr const char *Description = "The collation setting used when none is specified";
	static constexpr const char *InputType = "VARCHAR";
	static constexpr const char *DefaultValue = "";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
	static void OnSet(SettingCallbackInfo &info, Value &input);
};

struct DefaultNullOrderSetting {
	using RETURN_TYPE = DefaultOrderByNullType;
	static constexpr const char *Name = "default_null_order";
	static constexpr const char *Description = "NULL ordering used when none is specified (NULLS_FIRST or NULLS_LAST)";
	static constexpr const char *InputType = "VARCHAR";
	static constexpr const char *DefaultValue = "NULLS_LAST";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
	static void OnSet(SettingCallbackInfo &info, Value &input);
};

struct DefaultOrderSetting {
	using RETURN_TYPE = OrderType;
	static constexpr const char *Name = "default_order";
	static constexpr const char *Description = "The order type used when none is specified (ASC or DESC)";
	static constexpr const char *InputType = "VARCHAR";
	static constexpr const char *DefaultValue = "ASCENDING";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
	static void OnSet(SettingCallbackInfo &info, Value &input);
};

struct DefaultSecretStorageSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "default_secret_storage";
	static constexpr const char *Description = "Allows switching the default storage for secrets";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct DisableDatabaseInvalidationSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "disable_database_invalidation";
	static constexpr const char *Description =
	    "Disables invalidating the database instance when encountering a fatal error. Should be used with great care, "
	    "as DuckDB cannot guarantee correct behavior after a fatal error.";
	static constexpr const char *InputType = "BOOLEAN";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static bool OnGlobalSet(DatabaseInstance *db, DBConfig &config, const Value &input);
	static bool OnGlobalReset(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct DisableTimestamptzCastsSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "disable_timestamptz_casts";
	static constexpr const char *Description = "Disable casting from timestamp to timestamptz ";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "false";
	static constexpr SetScope DefaultScope = SetScope::SESSION;
};

struct DisabledCompressionMethodsSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "disabled_compression_methods";
	static constexpr const char *Description = "Disable a specific set of compression methods (comma separated)";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct DisabledFilesystemsSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "disabled_filesystems";
	static constexpr const char *Description = "Disable specific file systems preventing access (e.g. LocalFileSystem)";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct DisabledLogTypes {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "disabled_log_types";
	static constexpr const char *Description = "Sets the list of disabled loggers";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct DisabledOptimizersSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "disabled_optimizers";
	static constexpr const char *Description = "DEBUG SETTING: disable a specific set of optimizers (comma separated)";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct DuckDBAPISetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "duckdb_api";
	static constexpr const char *Description = "DuckDB API surface";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct DynamicOrFilterThresholdSetting {
	using RETURN_TYPE = idx_t;
	static constexpr const char *Name = "dynamic_or_filter_threshold";
	static constexpr const char *Description =
	    "The maximum amount of OR filters we generate dynamically from a hash join";
	static constexpr const char *InputType = "UBIGINT";
	static constexpr const char *DefaultValue = "50";
	static constexpr SetScope DefaultScope = SetScope::SESSION;
};

struct EnableExternalAccessSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "enable_external_access";
	static constexpr const char *Description =
	    "Allow the database to access external state (through e.g. loading/installing modules, COPY TO/FROM, CSV "
	    "readers, pandas replacement scans, etc)";
	static constexpr const char *InputType = "BOOLEAN";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static bool OnGlobalSet(DatabaseInstance *db, DBConfig &config, const Value &input);
	static bool OnGlobalReset(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct EnableExternalFileCacheSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "enable_external_file_cache";
	static constexpr const char *Description = "Allow the database to cache external files (e.g., Parquet) in memory.";
	static constexpr const char *InputType = "BOOLEAN";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct EnableFSSTVectorsSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "enable_fsst_vectors";
	static constexpr const char *Description =
	    "Allow scans on FSST compressed segments to emit compressed vectors to utilize late decompression";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "false";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
};

struct EnableHTTPLoggingSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "enable_http_logging";
	static constexpr const char *Description = "(deprecated) Enables HTTP logging";
	static constexpr const char *InputType = "BOOLEAN";
	static void SetLocal(ClientContext &context, const Value &parameter);
	static void ResetLocal(ClientContext &context);
	static Value GetSetting(const ClientContext &context);
};

struct EnableHTTPMetadataCacheSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "enable_http_metadata_cache";
	static constexpr const char *Description = "Whether or not the global http metadata is used to cache HTTP metadata";
	static constexpr const char *InputType = "BOOLEAN";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct EnableLogging {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "enable_logging";
	static constexpr const char *Description = "Enables the logger";
	static constexpr const char *InputType = "BOOLEAN";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct EnableMacroDependenciesSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "enable_macro_dependencies";
	static constexpr const char *Description =
	    "Enable created MACROs to create dependencies on the referenced objects (such as tables)";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "false";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
};

struct EnableObjectCacheSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "enable_object_cache";
	static constexpr const char *Description = "[PLACEHOLDER] Legacy setting - does nothing";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "false";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
};

struct EnableProfilingSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "enable_profiling";
	static constexpr const char *Description =
	    "Enables profiling, and sets the output format (JSON, QUERY_TREE, QUERY_TREE_OPTIMIZER)";
	static constexpr const char *InputType = "VARCHAR";
	static void SetLocal(ClientContext &context, const Value &parameter);
	static void ResetLocal(ClientContext &context);
	static Value GetSetting(const ClientContext &context);
};

struct EnableProgressBarSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "enable_progress_bar";
	static constexpr const char *Description =
	    "Enables the progress bar, printing progress to the terminal for long queries";
	static constexpr const char *InputType = "BOOLEAN";
	static void SetLocal(ClientContext &context, const Value &parameter);
	static void ResetLocal(ClientContext &context);
	static bool OnLocalSet(ClientContext &context, const Value &input);
	static bool OnLocalReset(ClientContext &context);
	static Value GetSetting(const ClientContext &context);
};

struct EnableProgressBarPrintSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "enable_progress_bar_print";
	static constexpr const char *Description =
	    "Controls the printing of the progress bar, when 'enable_progress_bar' is true";
	static constexpr const char *InputType = "BOOLEAN";
	static void SetLocal(ClientContext &context, const Value &parameter);
	static void ResetLocal(ClientContext &context);
	static Value GetSetting(const ClientContext &context);
};

struct EnableViewDependenciesSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "enable_view_dependencies";
	static constexpr const char *Description =
	    "Enable created VIEWs to create dependencies on the referenced objects (such as tables)";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "false";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
};

struct EnabledLogTypes {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "enabled_log_types";
	static constexpr const char *Description = "Sets the list of enabled loggers";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct ErrorsAsJSONSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "errors_as_json";
	static constexpr const char *Description = "Output error messages as structured JSON instead of as a raw string";
	static constexpr const char *InputType = "BOOLEAN";
	static void SetLocal(ClientContext &context, const Value &parameter);
	static void ResetLocal(ClientContext &context);
	static Value GetSetting(const ClientContext &context);
};

struct ExperimentalMetadataReuseSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "experimental_metadata_reuse";
	static constexpr const char *Description = "EXPERIMENTAL: Re-use row group and table metadata when checkpointing.";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "false";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
};

struct ExplainOutputSetting {
	using RETURN_TYPE = ExplainOutputType;
	static constexpr const char *Name = "explain_output";
	static constexpr const char *Description = "Output of EXPLAIN statements (ALL, OPTIMIZED_ONLY, PHYSICAL_ONLY)";
	static constexpr const char *InputType = "VARCHAR";
	static void SetLocal(ClientContext &context, const Value &parameter);
	static void ResetLocal(ClientContext &context);
	static Value GetSetting(const ClientContext &context);
};

struct ExtensionDirectorySetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "extension_directory";
	static constexpr const char *Description = "Set the directory to store extensions in";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct ExternalThreadsSetting {
	using RETURN_TYPE = idx_t;
	static constexpr const char *Name = "external_threads";
	static constexpr const char *Description = "The number of external threads that work on DuckDB tasks.";
	static constexpr const char *InputType = "UBIGINT";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static bool OnGlobalSet(DatabaseInstance *db, DBConfig &config, const Value &input);
	static bool OnGlobalReset(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct FileSearchPathSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "file_search_path";
	static constexpr const char *Description = "A comma separated list of directories to search for input files";
	static constexpr const char *InputType = "VARCHAR";
	static void SetLocal(ClientContext &context, const Value &parameter);
	static void ResetLocal(ClientContext &context);
	static Value GetSetting(const ClientContext &context);
};

struct ForceBitpackingModeSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "force_bitpacking_mode";
	static constexpr const char *Description = "DEBUG SETTING: forces a specific bitpacking mode";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct ForceCompressionSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "force_compression";
	static constexpr const char *Description = "DEBUG SETTING: forces a specific compression method to be used";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct HomeDirectorySetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "home_directory";
	static constexpr const char *Description = "Sets the home directory used by the system";
	static constexpr const char *InputType = "VARCHAR";
	static void SetLocal(ClientContext &context, const Value &parameter);
	static void ResetLocal(ClientContext &context);
	static Value GetSetting(const ClientContext &context);
};

struct HTTPLoggingOutputSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "http_logging_output";
	static constexpr const char *Description =
	    "(deprecated) The file to which HTTP logging output should be saved, or empty to print to the terminal";
	static constexpr const char *InputType = "VARCHAR";
	static void SetLocal(ClientContext &context, const Value &parameter);
	static void ResetLocal(ClientContext &context);
	static Value GetSetting(const ClientContext &context);
};

struct HTTPProxySetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "http_proxy";
	static constexpr const char *Description = "HTTP proxy host";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct HTTPProxyPasswordSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "http_proxy_password";
	static constexpr const char *Description = "Password for HTTP proxy";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct HTTPProxyUsernameSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "http_proxy_username";
	static constexpr const char *Description = "Username for HTTP proxy";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct IeeeFloatingPointOpsSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "ieee_floating_point_ops";
	static constexpr const char *Description =
	    "Use IEE754-compliant floating point operations (returning NAN instead of errors/NULL).";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "true";
	static constexpr SetScope DefaultScope = SetScope::SESSION;
};

struct ImmediateTransactionModeSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "immediate_transaction_mode";
	static constexpr const char *Description =
	    "Whether transactions should be started lazily when needed, or immediately when BEGIN TRANSACTION is called";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "false";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
};

struct IndexScanMaxCountSetting {
	using RETURN_TYPE = idx_t;
	static constexpr const char *Name = "index_scan_max_count";
	static constexpr const char *Description =
	    "The maximum index scan count sets a threshold for index scans. If fewer than MAX(index_scan_max_count, "
	    "index_scan_percentage * total_row_count) rows match, we perform an index scan instead of a table scan.";
	static constexpr const char *InputType = "UBIGINT";
	static constexpr const char *DefaultValue = "2048";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
};

struct IndexScanPercentageSetting {
	using RETURN_TYPE = double;
	static constexpr const char *Name = "index_scan_percentage";
	static constexpr const char *Description =
	    "The index scan percentage sets a threshold for index scans. If fewer than MAX(index_scan_max_count, "
	    "index_scan_percentage * total_row_count) rows match, we perform an index scan instead of a table scan.";
	static constexpr const char *InputType = "DOUBLE";
	static constexpr const char *DefaultValue = "0.001";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
	static void OnSet(SettingCallbackInfo &info, Value &input);
};

struct IntegerDivisionSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "integer_division";
	static constexpr const char *Description =
	    "Whether or not the / operator defaults to integer division, or to floating point division";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "false";
	static constexpr SetScope DefaultScope = SetScope::SESSION;
};

struct LambdaSyntaxSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "lambda_syntax";
	static constexpr const char *Description =
	    "Configures the use of the deprecated single arrow operator (->) for lambda functions.";
	static constexpr const char *InputType = "VARCHAR";
	static void SetLocal(ClientContext &context, const Value &parameter);
	static void ResetLocal(ClientContext &context);
	static Value GetSetting(const ClientContext &context);
};

struct LateMaterializationMaxRowsSetting {
	using RETURN_TYPE = idx_t;
	static constexpr const char *Name = "late_materialization_max_rows";
	static constexpr const char *Description =
	    "The maximum amount of rows in the LIMIT/SAMPLE for which we trigger late materialization";
	static constexpr const char *InputType = "UBIGINT";
	static constexpr const char *DefaultValue = "50";
	static constexpr SetScope DefaultScope = SetScope::SESSION;
};

struct LockConfigurationSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "lock_configuration";
	static constexpr const char *Description = "Whether or not the configuration can be altered";
	static constexpr const char *InputType = "BOOLEAN";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct LogQueryPathSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "log_query_path";
	static constexpr const char *Description =
	    "Specifies the path to which queries should be logged (default: NULL, queries are not logged)";
	static constexpr const char *InputType = "VARCHAR";
	static void SetLocal(ClientContext &context, const Value &parameter);
	static void ResetLocal(ClientContext &context);
	static Value GetSetting(const ClientContext &context);
};

struct LoggingLevel {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "logging_level";
	static constexpr const char *Description = "The log level which will be recorded in the log";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct LoggingMode {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "logging_mode";
	static constexpr const char *Description = "Determines which types of log messages are logged";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct LoggingStorage {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "logging_storage";
	static constexpr const char *Description = "Set the logging storage (memory/stdout/file/<custom>)";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct MaxExpressionDepthSetting {
	using RETURN_TYPE = idx_t;
	static constexpr const char *Name = "max_expression_depth";
	static constexpr const char *Description =
	    "The maximum expression depth limit in the parser. WARNING: increasing this setting and using very deep "
	    "expressions might lead to stack overflow errors.";
	static constexpr const char *InputType = "UBIGINT";
	static void SetLocal(ClientContext &context, const Value &parameter);
	static void ResetLocal(ClientContext &context);
	static Value GetSetting(const ClientContext &context);
};

struct MaxMemorySetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "max_memory";
	static constexpr const char *Description = "The maximum memory of the system (e.g. 1GB)";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct MaxTempDirectorySizeSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "max_temp_directory_size";
	static constexpr const char *Description =
	    "The maximum amount of data stored inside the 'temp_directory' (when set) (e.g. 1GB)";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct MaxVacuumTasksSetting {
	using RETURN_TYPE = idx_t;
	static constexpr const char *Name = "max_vacuum_tasks";
	static constexpr const char *Description = "The maximum vacuum tasks to schedule during a checkpoint.";
	static constexpr const char *InputType = "UBIGINT";
	static constexpr const char *DefaultValue = "100";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
};

struct MergeJoinThresholdSetting {
	using RETURN_TYPE = idx_t;
	static constexpr const char *Name = "merge_join_threshold";
	static constexpr const char *Description = "The maximum number of rows on either table to choose a merge join";
	static constexpr const char *InputType = "UBIGINT";
	static constexpr const char *DefaultValue = "1000";
	static constexpr SetScope DefaultScope = SetScope::SESSION;
};

struct NestedLoopJoinThresholdSetting {
	using RETURN_TYPE = idx_t;
	static constexpr const char *Name = "nested_loop_join_threshold";
	static constexpr const char *Description =
	    "The maximum number of rows on either table to choose a nested loop join";
	static constexpr const char *InputType = "UBIGINT";
	static constexpr const char *DefaultValue = "5";
	static constexpr SetScope DefaultScope = SetScope::SESSION;
};

struct OldImplicitCastingSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "old_implicit_casting";
	static constexpr const char *Description = "Allow implicit casting to/from VARCHAR";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "false";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
};

struct OrderByNonIntegerLiteralSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "order_by_non_integer_literal";
	static constexpr const char *Description =
	    "Allow ordering by non-integer literals - ordering by such literals has no effect.";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "false";
	static constexpr SetScope DefaultScope = SetScope::SESSION;
};

struct OrderedAggregateThresholdSetting {
	using RETURN_TYPE = idx_t;
	static constexpr const char *Name = "ordered_aggregate_threshold";
	static constexpr const char *Description = "The number of rows to accumulate before sorting, used for tuning";
	static constexpr const char *InputType = "UBIGINT";
	static constexpr const char *DefaultValue = "262144";
	static constexpr SetScope DefaultScope = SetScope::SESSION;
	static void OnSet(SettingCallbackInfo &info, Value &input);
};

struct PartitionedWriteFlushThresholdSetting {
	using RETURN_TYPE = idx_t;
	static constexpr const char *Name = "partitioned_write_flush_threshold";
	static constexpr const char *Description =
	    "The threshold in number of rows after which we flush a thread state when writing using PARTITION_BY";
	static constexpr const char *InputType = "UBIGINT";
	static constexpr const char *DefaultValue = "524288";
	static constexpr SetScope DefaultScope = SetScope::SESSION;
};

struct PartitionedWriteMaxOpenFilesSetting {
	using RETURN_TYPE = idx_t;
	static constexpr const char *Name = "partitioned_write_max_open_files";
	static constexpr const char *Description =
	    "The maximum amount of files the system can keep open before flushing to disk when writing using PARTITION_BY";
	static constexpr const char *InputType = "UBIGINT";
	static constexpr const char *DefaultValue = "100";
	static constexpr SetScope DefaultScope = SetScope::SESSION;
};

struct PasswordSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "password";
	static constexpr const char *Description = "The password to use. Ignored for legacy compatibility.";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct PerfectHtThresholdSetting {
	using RETURN_TYPE = idx_t;
	static constexpr const char *Name = "perfect_ht_threshold";
	static constexpr const char *Description = "Threshold in bytes for when to use a perfect hash table";
	static constexpr const char *InputType = "UBIGINT";
	static constexpr const char *DefaultValue = "12";
	static constexpr SetScope DefaultScope = SetScope::SESSION;
	static void OnSet(SettingCallbackInfo &info, Value &input);
};

struct PinThreadsSetting {
	using RETURN_TYPE = ThreadPinMode;
	static constexpr const char *Name = "pin_threads";
	static constexpr const char *Description =
	    "Whether to pin threads to cores (Linux only, default AUTO: on when there are more than 64 cores)";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct PivotFilterThresholdSetting {
	using RETURN_TYPE = idx_t;
	static constexpr const char *Name = "pivot_filter_threshold";
	static constexpr const char *Description =
	    "The threshold to switch from using filtered aggregates to LIST with a dedicated pivot operator";
	static constexpr const char *InputType = "UBIGINT";
	static constexpr const char *DefaultValue = "20";
	static constexpr SetScope DefaultScope = SetScope::SESSION;
};

struct PivotLimitSetting {
	using RETURN_TYPE = idx_t;
	static constexpr const char *Name = "pivot_limit";
	static constexpr const char *Description = "The maximum number of pivot columns in a pivot statement";
	static constexpr const char *InputType = "UBIGINT";
	static constexpr const char *DefaultValue = "100000";
	static constexpr SetScope DefaultScope = SetScope::SESSION;
};

struct PreferRangeJoinsSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "prefer_range_joins";
	static constexpr const char *Description = "Force use of range joins with mixed predicates";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "false";
	static constexpr SetScope DefaultScope = SetScope::SESSION;
};

struct PreserveIdentifierCaseSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "preserve_identifier_case";
	static constexpr const char *Description =
	    "Whether or not to preserve the identifier case, instead of always lowercasing all non-quoted identifiers";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "true";
	static constexpr SetScope DefaultScope = SetScope::SESSION;
};

struct PreserveInsertionOrderSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "preserve_insertion_order";
	static constexpr const char *Description =
	    "Whether or not to preserve insertion order. If set to false the system is allowed to re-order any results "
	    "that do not contain ORDER BY clauses.";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "true";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
};

struct ProduceArrowStringViewSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "produce_arrow_string_view";
	static constexpr const char *Description =
	    "Whether Arrow strings should be produced by DuckDB in Utf8View format instead of Utf8";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "false";
	static constexpr SetScope DefaultScope = SetScope::GLOBAL;
};

struct ProfileOutputSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "profile_output";
	static constexpr const char *Description =
	    "The file to which profile output should be saved, or empty to print to the terminal";
	static constexpr const char *InputType = "VARCHAR";
	static void SetLocal(ClientContext &context, const Value &parameter);
	static void ResetLocal(ClientContext &context);
	static Value GetSetting(const ClientContext &context);
};

struct ProfilingCoverageSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "profiling_coverage";
	static constexpr const char *Description = "The profiling coverage (SELECT or ALL)";
	static constexpr const char *InputType = "VARCHAR";
	static void SetLocal(ClientContext &context, const Value &parameter);
	static void ResetLocal(ClientContext &context);
	static Value GetSetting(const ClientContext &context);
};

struct ProfilingModeSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "profiling_mode";
	static constexpr const char *Description = "The profiling mode (STANDARD or DETAILED)";
	static constexpr const char *InputType = "VARCHAR";
	static void SetLocal(ClientContext &context, const Value &parameter);
	static void ResetLocal(ClientContext &context);
	static Value GetSetting(const ClientContext &context);
};

struct ProgressBarTimeSetting {
	using RETURN_TYPE = int64_t;
	static constexpr const char *Name = "progress_bar_time";
	static constexpr const char *Description =
	    "Sets the time (in milliseconds) how long a query needs to take before we start printing a progress bar";
	static constexpr const char *InputType = "BIGINT";
	static void SetLocal(ClientContext &context, const Value &parameter);
	static void ResetLocal(ClientContext &context);
	static Value GetSetting(const ClientContext &context);
};

struct ScalarSubqueryErrorOnMultipleRowsSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "scalar_subquery_error_on_multiple_rows";
	static constexpr const char *Description =
	    "When a scalar subquery returns multiple rows - return a random row instead of returning an error.";
	static constexpr const char *InputType = "BOOLEAN";
	static constexpr const char *DefaultValue = "true";
	static constexpr SetScope DefaultScope = SetScope::SESSION;
};

struct SchedulerProcessPartialSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "scheduler_process_partial";
	static constexpr const char *Description =
	    "Partially process tasks before rescheduling - allows for more scheduler fairness between separate queries";
	static constexpr const char *InputType = "BOOLEAN";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct SchemaSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "schema";
	static constexpr const char *Description =
	    "Sets the default search schema. Equivalent to setting search_path to a single value.";
	static constexpr const char *InputType = "VARCHAR";
	static void SetLocal(ClientContext &context, const Value &parameter);
	static void ResetLocal(ClientContext &context);
	static Value GetSetting(const ClientContext &context);
};

struct SearchPathSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "search_path";
	static constexpr const char *Description =
	    "Sets the default catalog search path as a comma-separated list of values";
	static constexpr const char *InputType = "VARCHAR";
	static void SetLocal(ClientContext &context, const Value &parameter);
	static void ResetLocal(ClientContext &context);
	static Value GetSetting(const ClientContext &context);
};

struct SecretDirectorySetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "secret_directory";
	static constexpr const char *Description = "Set the directory to which persistent secrets are stored";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct StorageCompatibilityVersionSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "storage_compatibility_version";
	static constexpr const char *Description = "Serialize on checkpoint with compatibility for a given duckdb version";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct StreamingBufferSizeSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "streaming_buffer_size";
	static constexpr const char *Description =
	    "The maximum memory to buffer between fetching from a streaming result (e.g. 1GB)";
	static constexpr const char *InputType = "VARCHAR";
	static void SetLocal(ClientContext &context, const Value &parameter);
	static void ResetLocal(ClientContext &context);
	static Value GetSetting(const ClientContext &context);
};

struct TempDirectorySetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "temp_directory";
	static constexpr const char *Description = "Set the directory to which to write temp files";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct TempFileEncryptionSetting {
	using RETURN_TYPE = bool;
	static constexpr const char *Name = "temp_file_encryption";
	static constexpr const char *Description = "Encrypt all temporary files if database is encrypted";
	static constexpr const char *InputType = "BOOLEAN";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct ThreadsSetting {
	using RETURN_TYPE = int64_t;
	static constexpr const char *Name = "threads";
	static constexpr const char *Description = "The number of total threads used by the system.";
	static constexpr const char *InputType = "BIGINT";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct UsernameSetting {
	using RETURN_TYPE = string;
	static constexpr const char *Name = "username";
	static constexpr const char *Description = "The username to use. Ignored for legacy compatibility.";
	static constexpr const char *InputType = "VARCHAR";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

struct ZstdMinStringLengthSetting {
	using RETURN_TYPE = idx_t;
	static constexpr const char *Name = "zstd_min_string_length";
	static constexpr const char *Description =
	    "The (average) length at which to enable ZSTD compression, defaults to 4096";
	static constexpr const char *InputType = "UBIGINT";
	static void SetGlobal(DatabaseInstance *db, DBConfig &config, const Value &parameter);
	static void ResetGlobal(DatabaseInstance *db, DBConfig &config);
	static Value GetSetting(const ClientContext &context);
};

//===----------------------------------------------------------------------===//
// End of the auto-generated list of settings structures
//===--------------------------------------------------------------------===//

} // namespace duckdb
