# Generated by 02-duckplyr_df-methods.R
#' @export
sample_n.duckplyr_df <- function(tbl, size, replace = FALSE, weight = NULL, .env = NULL, ...) {
  # Our implementation
  rel_try(
    "No relational implementation for sample_n()" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  sample_n <- dplyr$sample_n.data.frame
  out <- sample_n(tbl, {{ size }}, replace, {{ weight }}, .env, ...)
  return(out)

  # dplyr implementation
  if (!is_null(.env)) {
    inform("`sample_n() argument `.env` is deprecated and no longer has any effect.")
  }

  size <- enquo(size)
  weight <- enquo(weight)

  dplyr_local_error_call()
  slice(tbl, local({
    size <- check_size(!!size, n(), replace = replace)
    sample.int(n(), size, replace = replace, prob = !!weight)
  }))
}

duckplyr_sample_n <- function(tbl, ...) {
  try_fetch(
    tbl <- as_duckplyr_df(tbl),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- sample_n(tbl, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
