# Generated by 03-tests.R

withr::local_envvar(DUCKPLYR_FORCE = "TRUE")

meta <- testthat::is_parallel() # Slow!
# meta <- TRUE

test_that("as_duckplyr_df() and add_count()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% add_count() %>% as.data.frame()
  post <- test_df %>% add_count()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and anti_join(join_by(a))", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% anti_join(test_df_y, join_by(a)) %>% as.data.frame()
  post <- test_df_x %>% anti_join(test_df_y, join_by(a))

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and arrange()", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% arrange() %>% as.data.frame()
  post <- test_df %>% arrange()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and arrange(a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% arrange(a) %>% as.data.frame()
  post <- test_df %>% arrange(a)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and arrange(g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% arrange(g) %>% as.data.frame()
  post <- test_df %>% arrange(g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and arrange(g, a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% arrange(g, a) %>% as.data.frame()
  post <- test_df %>% arrange(g, a)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and arrange(a, g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% arrange(a, g) %>% as.data.frame()
  post <- test_df %>% arrange(a, g)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and auto_copy()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% auto_copy(test_df_y)
  post <- test_df_x %>% auto_copy(test_df_y)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and collapse()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% collapse() %>% as.data.frame()
  post <- test_df %>% collapse()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and collect()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% collect() %>% as.data.frame()
  post <- test_df %>% collect()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and compute()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% compute() %>% as.data.frame()
  post <- test_df %>% compute()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and count()", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% count() %>% as.data.frame()
  post <- test_df %>% count()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and count(a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% count(a) %>% as.data.frame()
  post <- test_df %>% count(a)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and count(b)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% count(b) %>% as.data.frame()
  post <- test_df %>% count(b)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and count(g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% count(g) %>% as.data.frame()
  post <- test_df %>% count(g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and count(g, a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% count(g, a) %>% as.data.frame()
  post <- test_df %>% count(g, a)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and count(b, g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% count(b, g) %>% as.data.frame()
  post <- test_df %>% count(b, g)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and cross_join()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% cross_join(test_df_y) %>% as.data.frame()
  post <- test_df_x %>% cross_join(test_df_y)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and distinct()", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% distinct() %>% as.data.frame()
  post <- test_df %>% distinct()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and distinct(a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% distinct(a) %>% as.data.frame()
  post <- test_df %>% distinct(a)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and distinct(a, b)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% distinct(a, b) %>% as.data.frame()
  post <- test_df %>% distinct(a, b)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and distinct(b, b)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% distinct(b, b) %>% as.data.frame()
  post <- test_df %>% distinct(b, b)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and distinct(g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% distinct(g) %>% as.data.frame()
  post <- test_df %>% distinct(g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and union_all(data.frame(a = 1L, b = 3, g = 2L)) %>% distinct(g)", {
  skip_if_not_installed("duckdb", "0.8.1-9000")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% union_all(data.frame(a = 1L, b = 3, g = 2L)) %>% distinct(g) %>% as.data.frame()
  post <- test_df %>% union_all(data.frame(a = 1L, b = 3, g = 2L)) %>% distinct(g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and union_all(data.frame(a = 1L, b = 4, g = 2L)) %>% distinct(g)", {
  skip_if_not_installed("duckdb", "0.8.1-9000")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% union_all(data.frame(a = 1L, b = 4, g = 2L)) %>% distinct(g) %>% as.data.frame()
  post <- test_df %>% union_all(data.frame(a = 1L, b = 4, g = 2L)) %>% distinct(g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and union_all(data.frame(a = 1L, b = 5, g = 2L)) %>% distinct(g)", {
  skip_if_not_installed("duckdb", "0.8.1-9000")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% union_all(data.frame(a = 1L, b = 5, g = 2L)) %>% distinct(g) %>% as.data.frame()
  post <- test_df %>% union_all(data.frame(a = 1L, b = 5, g = 2L)) %>% distinct(g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and union_all(data.frame(a = 1L, b = 6, g = 2L)) %>% distinct(g)", {
  skip_if_not_installed("duckdb", "0.8.1-9000")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% union_all(data.frame(a = 1L, b = 6, g = 2L)) %>% distinct(g) %>% as.data.frame()
  post <- test_df %>% union_all(data.frame(a = 1L, b = 6, g = 2L)) %>% distinct(g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and union_all(data.frame(a = 1L, b = 7, g = 2L)) %>% distinct(g)", {
  skip_if_not_installed("duckdb", "0.8.1-9000")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% union_all(data.frame(a = 1L, b = 7, g = 2L)) %>% distinct(g) %>% as.data.frame()
  post <- test_df %>% union_all(data.frame(a = 1L, b = 7, g = 2L)) %>% distinct(g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and distinct(g, .keep_all = TRUE)", {
  skip_if_not_installed("duckdb", "0.8.1-9000")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% distinct(g, .keep_all = TRUE) %>% as.data.frame()
  post <- test_df %>% distinct(g, .keep_all = TRUE)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and do(data.frame(c = 1))", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% do(data.frame(c = 1))
  post <- test_df %>% do(data.frame(c = 1))

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and dplyr_reconstruct(test_df)", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("Hack")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% dplyr_reconstruct(test_df)
  post <- test_df %>% dplyr_reconstruct(test_df)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and filter(a == 1)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% filter(a == 1) %>% as.data.frame()
  post <- test_df %>% filter(a == 1)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and filter(a %in% 2:3, g == 2)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% filter(a %in% 2:3, g == 2) %>% as.data.frame()
  post <- test_df %>% filter(a %in% 2:3, g == 2)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and filter(a %in% 2:3 & g == 2)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% filter(a %in% 2:3 & g == 2) %>% as.data.frame()
  post <- test_df %>% filter(a %in% 2:3 & g == 2)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and full_join(join_by(a))", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% full_join(test_df_y, join_by(a)) %>% as.data.frame()
  post <- test_df_x %>% full_join(test_df_y, join_by(a))

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and group_vars()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% group_vars()
  post <- test_df %>% group_vars()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and inner_join(join_by(a))", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% inner_join(test_df_y, join_by(a)) %>% as.data.frame()
  post <- test_df_x %>% inner_join(test_df_y, join_by(a))

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and intersect()", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% intersect(test_df_y) %>% as.data.frame()
  post <- test_df_x %>% intersect(test_df_y)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and left_join(join_by(a))", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% left_join(test_df_y, join_by(a)) %>% as.data.frame()
  post <- test_df_x %>% left_join(test_df_y, join_by(a))

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and mutate()", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate() %>% as.data.frame()
  post <- test_df %>% mutate()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(a + 1)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(a + 1) %>% as.data.frame()
  post <- test_df %>% mutate(a + 1)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(a + 1, .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(a + 1, .by = g) %>% as.data.frame()
  post <- test_df %>% mutate(a + 1, .by = g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(c = a + 1)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(c = a + 1) %>% as.data.frame()
  post <- test_df %>% mutate(c = a + 1)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(`if` = a + 1)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(`if` = a + 1) %>% as.data.frame()
  post <- test_df %>% mutate(`if` = a + 1)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(sum(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(sum(a)) %>% as.data.frame()
  post <- test_df %>% mutate(sum(a))

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(sum(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(sum(a), .by = g) %>% as.data.frame()
  post <- test_df %>% mutate(sum(a), .by = g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(mean(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(mean(a)) %>% as.data.frame()
  post <- test_df %>% mutate(mean(a))

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(mean(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(mean(a), .by = g) %>% as.data.frame()
  post <- test_df %>% mutate(mean(a), .by = g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(sd(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(sd(a)) %>% as.data.frame()
  post <- test_df %>% mutate(sd(a))

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(sd(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(sd(a), .by = g) %>% as.data.frame()
  post <- test_df %>% mutate(sd(a), .by = g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lag(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lag(a)) %>% as.data.frame()
  post <- test_df %>% mutate(lag(a))

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lag(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lag(a), .by = g) %>% as.data.frame()
  post <- test_df %>% mutate(lag(a), .by = g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lead(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lead(a)) %>% as.data.frame()
  post <- test_df %>% mutate(lead(a))

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lead(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lead(a), .by = g) %>% as.data.frame()
  post <- test_df %>% mutate(lead(a), .by = g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lag(a, 2))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lag(a, 2)) %>% as.data.frame()
  post <- test_df %>% mutate(lag(a, 2))

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lag(a, 2), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lag(a, 2), .by = g) %>% as.data.frame()
  post <- test_df %>% mutate(lag(a, 2), .by = g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lead(a, 2))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lead(a, 2)) %>% as.data.frame()
  post <- test_df %>% mutate(lead(a, 2))

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lead(a, 2), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lead(a, 2), .by = g) %>% as.data.frame()
  post <- test_df %>% mutate(lead(a, 2), .by = g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lag(a, 4))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lag(a, 4)) %>% as.data.frame()
  post <- test_df %>% mutate(lag(a, 4))

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lag(a, 4), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lag(a, 4), .by = g) %>% as.data.frame()
  post <- test_df %>% mutate(lag(a, 4), .by = g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lead(a, 4))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lead(a, 4)) %>% as.data.frame()
  post <- test_df %>% mutate(lead(a, 4))

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lead(a, 4), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lead(a, 4), .by = g) %>% as.data.frame()
  post <- test_df %>% mutate(lead(a, 4), .by = g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lag(a, default = 0))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lag(a, default = 0)) %>% as.data.frame()
  post <- test_df %>% mutate(lag(a, default = 0))

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lag(a, default = 0), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lag(a, default = 0), .by = g) %>% as.data.frame()
  post <- test_df %>% mutate(lag(a, default = 0), .by = g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lead(a, default = 1000))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lead(a, default = 1000)) %>% as.data.frame()
  post <- test_df %>% mutate(lead(a, default = 1000))

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lead(a, default = 1000), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lead(a, default = 1000), .by = g) %>% as.data.frame()
  post <- test_df %>% mutate(lead(a, default = 1000), .by = g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(min(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(min(a)) %>% as.data.frame()
  post <- test_df %>% mutate(min(a))

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(min(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(min(a), .by = g) %>% as.data.frame()
  post <- test_df %>% mutate(min(a), .by = g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(max(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(max(a)) %>% as.data.frame()
  post <- test_df %>% mutate(max(a))

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(max(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(max(a), .by = g) %>% as.data.frame()
  post <- test_df %>% mutate(max(a), .by = g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(first(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(first(a)) %>% as.data.frame()
  post <- test_df %>% mutate(first(a))

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(first(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(first(a), .by = g) %>% as.data.frame()
  post <- test_df %>% mutate(first(a), .by = g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(last(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(last(a)) %>% as.data.frame()
  post <- test_df %>% mutate(last(a))

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(last(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(last(a), .by = g) %>% as.data.frame()
  post <- test_df %>% mutate(last(a), .by = g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(nth(a, 2))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(nth(a, 2)) %>% as.data.frame()
  post <- test_df %>% mutate(nth(a, 2))

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(nth(a, 2), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(nth(a, 2), .by = g) %>% as.data.frame()
  post <- test_df %>% mutate(nth(a, 2), .by = g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(a / b)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(a / b) %>% as.data.frame()
  post <- test_df %>% mutate(a / b)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(c = 0, d = 0, e = c / d)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(c = 0, d = 0, e = c / d) %>% as.data.frame()
  post <- test_df %>% mutate(c = 0, d = 0, e = c / d)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and nest_by()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("WAT")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% nest_by() %>% as.data.frame()
  post <- test_df %>% nest_by()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and nest_join(join_by(a))", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% nest_join(test_df_y, join_by(a)) %>% as.data.frame()
  post <- test_df_x %>% nest_join(test_df_y, join_by(a))

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and pull()", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% pull()
  post <- test_df %>% pull()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and reframe()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% reframe()
  post <- test_df %>% reframe()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and relocate(g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% relocate(g) %>% as.data.frame()
  post <- test_df %>% relocate(g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and relocate(a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% relocate(a) %>% as.data.frame()
  post <- test_df %>% relocate(a)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and relocate(g, .before = b)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% relocate(g, .before = b) %>% as.data.frame()
  post <- test_df %>% relocate(g, .before = b)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and relocate(a:b, .after = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% relocate(a:b, .after = g) %>% as.data.frame()
  post <- test_df %>% relocate(a:b, .after = g)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and rename()", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% rename() %>% as.data.frame()
  post <- test_df %>% rename()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and rename(c = a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% rename(c = a) %>% as.data.frame()
  post <- test_df %>% rename(c = a)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and rename_with(identity)", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% rename_with(identity) %>% as.data.frame()
  post <- test_df %>% rename_with(identity)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and right_join(join_by(a))", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% right_join(test_df_y, join_by(a)) %>% as.data.frame()
  post <- test_df_x %>% right_join(test_df_y, join_by(a))

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and rows_append()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% rows_append(test_df_y) %>% as.data.frame()
  post <- test_df_x %>% rows_append(test_df_y)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and rows_delete(by = c(\"a\", \"b\"), unmatched = \"ignore\")", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% rows_delete(test_df_y, by = c("a", "b"), unmatched = "ignore") %>% as.data.frame()
  post <- test_df_x %>% rows_delete(test_df_y, by = c("a", "b"), unmatched = "ignore")

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and rows_insert(by = \"a\", conflict = \"ignore\")", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% rows_insert(test_df_y, by = "a", conflict = "ignore") %>% as.data.frame()
  post <- test_df_x %>% rows_insert(test_df_y, by = "a", conflict = "ignore")

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and rows_patch(by = \"a\", unmatched = \"ignore\")", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% rows_patch(test_df_y, by = "a", unmatched = "ignore") %>% as.data.frame()
  post <- test_df_x %>% rows_patch(test_df_y, by = "a", unmatched = "ignore")

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and rows_update(by = \"a\", unmatched = \"ignore\")", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% rows_update(test_df_y, by = "a", unmatched = "ignore") %>% as.data.frame()
  post <- test_df_x %>% rows_update(test_df_y, by = "a", unmatched = "ignore")

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and rows_upsert(by = \"a\")", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% rows_upsert(test_df_y, by = "a") %>% as.data.frame()
  post <- test_df_x %>% rows_upsert(test_df_y, by = "a")

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and sample_frac()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("Random seed")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% sample_frac() %>% as.data.frame()
  post <- test_df %>% sample_frac()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and sample_n(size = 1)", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("Random seed")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% sample_n(size = 1) %>% as.data.frame()
  post <- test_df %>% sample_n(size = 1)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and select(a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% select(a) %>% as.data.frame()
  post <- test_df %>% select(a)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and select(-g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% select(-g) %>% as.data.frame()
  post <- test_df %>% select(-g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and select(everything())", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% select(everything()) %>% as.data.frame()
  post <- test_df %>% select(everything())

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and semi_join(join_by(a))", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% semi_join(test_df_y, join_by(a)) %>% as.data.frame()
  post <- test_df_x %>% semi_join(test_df_y, join_by(a))

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and setdiff()", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% setdiff(test_df_y) %>% as.data.frame()
  post <- test_df_x %>% setdiff(test_df_y)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and setequal()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% setequal(test_df_y)
  post <- test_df_x %>% setequal(test_df_y)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and slice()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% slice() %>% as.data.frame()
  post <- test_df %>% slice()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and slice_head()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("External vector?")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% slice_head() %>% as.data.frame()
  post <- test_df %>% slice_head()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and slice_max(a)", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("External vector?")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% slice_max(a) %>% as.data.frame()
  post <- test_df %>% slice_max(a)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and slice_min(a)", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("External vector?")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% slice_min(a) %>% as.data.frame()
  post <- test_df %>% slice_min(a)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and slice_sample()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("External vector?")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% slice_sample() %>% as.data.frame()
  post <- test_df %>% slice_sample()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and slice_tail()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("External vector?")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% slice_tail() %>% as.data.frame()
  post <- test_df %>% slice_tail()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and summarise(c = mean(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% summarise(c = mean(a)) %>% as.data.frame()
  post <- test_df %>% summarise(c = mean(a))

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and summarise(c = mean(a), .by = b)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% summarise(c = mean(a), .by = b) %>% as.data.frame()
  post <- test_df %>% summarise(c = mean(a), .by = b)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and summarise(c = mean(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% summarise(c = mean(a), .by = g) %>% as.data.frame()
  post <- test_df %>% summarise(c = mean(a), .by = g)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and summarise(c = 1)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% summarise(c = 1) %>% as.data.frame()
  post <- test_df %>% summarise(c = 1)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and summarise(c = 1, .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% summarise(c = 1, .by = g) %>% as.data.frame()
  post <- test_df %>% summarise(c = 1, .by = g)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and symdiff()", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% symdiff(test_df_y) %>% as.data.frame()
  post <- test_df_x %>% symdiff(test_df_y)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and tally()", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% tally() %>% as.data.frame()
  post <- test_df %>% tally()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and tbl_vars()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% tbl_vars()
  post <- test_df %>% tbl_vars()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and transmute(c = a + 1)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% transmute(c = a + 1) %>% as.data.frame()
  post <- test_df %>% transmute(c = a + 1)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and transmute(row = a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% transmute(row = a) %>% as.data.frame()
  post <- test_df %>% transmute(row = a)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and ungroup()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("Grouped")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% ungroup() %>% as.data.frame()
  post <- test_df %>% ungroup()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and union()", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% union(test_df_y) %>% as.data.frame()
  post <- test_df_x %>% union(test_df_y)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and union_all()", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% union_all(test_df_y) %>% as.data.frame()
  post <- test_df_x %>% union_all(test_df_y)

  # Compare
  expect_equal(pre, post)
})
