# Generated by 02-duckplyr_df-methods.R
#' @export
groups.duckplyr_df <- function(x) {
  # Our implementation
  rel_try(
    # Always fall back to dplyr
    "No relational implementation for groups()" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  groups <- dplyr$groups.data.frame
  out <- groups(x)
  return(out)

  # dplyr implementation
  syms(group_vars(x))
}

duckplyr_groups <- function(x, ...) {
  try_fetch(
    x <- as_duckplyr_df(x),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- groups(x, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
